# テスト方針書

## 概要

本ドキュメントは、stdVBAプロジェクトにおけるテスト戦略、テストツール、テスト環境、およびCI/CD連携について記載したテスト方針書です。stdVBAは、VBA（Visual Basic for Applications）向けの標準ライブラリコレクションであり、Excel、Word、PowerPoint、Access等の複数のMicrosoft Officeアプリケーションで利用可能な汎用ライブラリを提供しています。

## テスト戦略

### テストレベル

| レベル | 目的 | 担当 |
| --- | --- | --- |
| 単体テスト | 各stdクラス（stdArray, stdLambda, stdCallback等）の個別機能の検証 | 開発者 |
| 結合テスト | 複数のstdクラス間の連携動作の検証（例：stdArray + stdLambda） | 開発者 |
| システムテスト | VBAランタイム環境（Excel、Word等）での動作確認 | 開発者/QA |
| 受入テスト | 実際のVBAプロジェクトでの利用シナリオ検証 | エンドユーザー |

### テスト種別

| 種別 | 概要 | 実施タイミング |
| --- | --- | --- |
| 機能テスト | 各stdクラスのAPI機能が仕様通りに動作することを確認 | 開発時・PR作成時 |
| 性能テスト | stdLambdaのパフォーマンスキャッシュ等の性能検証（FullTestモードで実施） | 定期的・リリース前 |
| セキュリティテスト | Win32 API呼び出しやCOM連携における安全性確認 | 設計時・リリース前 |

## テスト環境

| 環境 | 用途 | 構成 |
| --- | --- | --- |
| 開発環境 | 開発者によるローカルテスト | Excel VBA IDE（testBuilder.xlsm） |
| ビルド環境 | フルビルドとテスト実行 | Excel VBA IDE（fullBuild.xlsm） |
| CI環境 | 静的解析・Linting | GitHub Actions（Ubuntu） + VBA Precompiler + VBA Lint |

## テストツール

| ツール | 用途 | バージョン |
| --- | --- | --- |
| Test.cls | カスタムVBAテストフレームワーク（アサーション・結果表示） | 独自実装 |
| vba_precompiler | VBAコードの前処理・条件付きコンパイル | git+https://github.com/Beakerboy/VBA-Precompiler |
| Vba-actions/lint-vba | VBAコードの静的解析・Linting | dev |
| GetTickCount | テスト実行時間計測（Win32 API） | kernel32.dll |

### Test.cls テストフレームワークの特徴

- **Test.Refresh**: テストスプレッドシートの初期化
- **Test.Topic(sName)**: テストトピックの追加（テストグループ化）
- **Test.Assert(sName, result)**: アサーション実行と結果記録
- **Test.FullTest**: フルテストモード（性能テスト含む）とクイックテストモードの切り替え
- **実行時間計測**: GetTickCount APIによる各テストの実行時間追跡
- **結果の可視化**: Excel ListObjectとConditional Formattingによるテスト結果の視覚的表示

## カバレッジ目標

| 対象 | 目標値 |
| --- | --- |
| 行カバレッジ | 明示的な目標値なし（VBA特性上、自動計測が困難） |
| 分岐カバレッジ | 明示的な目標値なし（VBA特性上、自動計測が困難） |
| クラスカバレッジ | 主要なREADY状態のクラスに対するテスト実装（現在13クラス中13クラスにテスト有） |

### テスト対象クラスと対応テストファイル

| クラス | テストファイル | 状態 |
| --- | --- | --- |
| stdArray | stdArrayTests.bas | 実装済 |
| stdLambda | stdLambdaTests.bas | 実装済 |
| stdCallback | stdCallbackTests.bas | 実装済 |
| stdAcc | stdAccTests.bas | 実装済 |
| stdEnumerator | stdEnumeratorTests.bas | 実装済 |
| stdClipboard | stdClipboardTests.bas | 実装済 |
| stdRegex | stdRegexTests.bas | 実装済 |
| stdWindow | stdWindowTests.bas | 実装済 |
| stdProcess | stdProcessTests.bas | 実装済 |
| stdWebSocket | stdWebSocketTests.bas | 実装済 |
| stdPerformance | stdPerformanceTests.bas | 実装済 |
| stdStringBuilder | stdStringBuilderTests.bas | 実装済 |
| stdSentry | stdSentryTests.bas | 実装済 |

## テストデータ

### テストデータの準備方針

1. **インラインデータ**: 多くのテストケースでは、テストコード内で直接データを生成
   - `stdArray.Create(1,2,3,4,5)` 形式でのデータ作成
   - `CreateObject("Scripting.Dictionary")` を用いた辞書データ生成

2. **コレクションデータ**: stdEnumeratorテストではVBA Collectionを使用
   - Lorem ipsum等の文字列コレクション
   - 数値コレクション

3. **外部API連携テスト**: stdHTTPテストではpostman-echo.comを利用
   - GET/POST リクエストテスト
   - 認証テスト
   - クッキーテスト

4. **Excelワークシートデータ**: Test.Rangeプロパティを使用したテストゾーン
   - ListObjectのテスト用データ

## 不具合管理

### 不具合の管理方法

1. **GitHub Issues**: 不具合報告と追跡はGitHub Issuesで管理
   - 新規不具合の報告
   - 機能リクエストの管理
   - ステータス管理（READY/WIP/HOLD/UNK）

2. **Pull Request**: コード修正はPRベースで管理
   - PRでの不具合修正
   - コードレビュープロセス

3. **Changelog**: 破壊的変更・バグ修正はchangelog.mdに記録
   - バージョン履歴の管理
   - 主要変更点の追跡

## CI/CD連携

### GitHub Actions ワークフロー

| ワークフロー | トリガー | 目的 |
| --- | --- | --- |
| lint_vba.yml | push (linting branch) | VBAコードの静的解析・Linting |
| enforce_crlf.yml | push/PR (master branch) | .bas/.frm/.cls ファイルのCRLF改行コード強制 |
| vba_docs_gen.yml | push (全ブランチ) | ドキュメント自動生成（docs.json更新） |
| stdError_wrap.yml | push (master)/manual | stdErrorラッパーの自動適用 |

### CI/CDパイプラインでのテスト実行

1. **静的解析（lint_vba.yml）**
   - VBA Precompilerによる前処理（Win64環境向け）
   - lint-vbaアクションによる静的解析
   - WIPディレクトリは解析対象から除外

2. **コード品質チェック（enforce_crlf.yml）**
   - VBAファイルの改行コード（CRLF）の自動修正
   - 対象拡張子: .bas, .frm, .cls
   - 自動コミット・プッシュ機能

3. **ドキュメント生成（vba_docs_gen.yml）**
   - Node.js 20によるドキュメント生成
   - docs.jsonの自動更新

4. **stdErrorラッピング（stdError_wrap.yml）**
   - stdErrorセントリーの自動ラッピング
   - stdError-Wrappedブランチへのforce-push

### 手動テスト実行手順

1. testBuilder.xlsm または fullBuild.xlsm を開く
2. VBA IDEでMain.basモジュールを開く
3. `MainTestAll` サブルーチンを実行
4. "Test" シートで結果を確認（緑=Pass、赤=Fail）

## 備考

### VBA特有の制約事項

1. **自動テスト実行の制約**: VBAはExcel等のホストアプリケーション内で実行されるため、完全な自動化が困難
2. **クロスプラットフォーム対応**: Mac版とWindows版でAPI宣言が異なる（#If Mac Then ディレクティブで対応）
3. **32bit/64bit対応**: VBA7とそれ以前のバージョンで関数宣言が異なる（PtrSafe キーワード対応）

### テストモード

- **QuickTest（FullTest = False）**: 高速なテスト実行、性能テストをスキップ
- **FullTest（FullTest = True）**: 全テスト実行、性能テスト含む

### 貢献者向けテストガイドライン

1. 新機能追加時は対応するテストを実装すること
2. テストはTest.Assertを使用してアサーションを記述
3. Test.Topicでテストをグループ化
4. 時間のかかるテストはTest.FullTestフラグでガード
