# ER図

## 概要

本ドキュメントは、stdVBAプロジェクトのデータ構造をER図形式で表現したものです。

stdVBAプロジェクトはリレーショナルデータベースを使用していないため、従来のER図は存在しません。代わりに、プロジェクト内で使用されている主要なデータ構造間の関係を図示します。

## データ構造関係図

```mermaid
erDiagram
    stdJSON ||--o{ stdJSON : "contains (children)"
    stdJSON {
        EStdJsonType iType
        Object children
        TParser parserProps
    }

    stdArray ||--o{ Variant : "contains (elements)"
    stdArray {
        Variant BaseArray
        Long Length
        Long Chunking
    }

    stdDictionary ||--o{ Bucket : "contains"
    stdDictionary {
        Long pHashSize
        Long pListSize
        Long pIndex
    }

    Bucket {
        Boolean bIsRoot
        Variant vKey
        Variant vValue
        Long iNextItem
    }

    stdTable ||--|| Worksheet : "belongs to"
    stdTable ||--|| ListObject : "wraps"
    stdTable {
        Boolean pIsSelected
        Collection pSelectedRows
    }

    Worksheet {
        String Name
        Range UsedRange
    }

    ListObject {
        String Name
        Range Range
        ListColumns ListColumns
        ListRows ListRows
    }

    stdEnumerator ||--o{ Variant : "iterates over"
    stdEnumerator {
        Object pEnumerable
        Long pIndex
    }
```

## クラス関係図

```mermaid
classDiagram
    class stdICallable {
        <<interface>>
        +Run(args) Variant
    }

    class stdLambda {
        +Create(expression) stdLambda
        +Run(args) Variant
    }

    class stdCallback {
        +Create(module, method) stdCallback
        +Run(args) Variant
    }

    stdICallable <|.. stdLambda : implements
    stdICallable <|.. stdCallback : implements

    class stdArray {
        +Create(items) stdArray
        +Map(callback) stdArray
        +Filter(callback) stdArray
        +Reduce(callback) Variant
        +join(delimiter) String
    }

    class stdEnumerator {
        +Create(enumerable) stdEnumerator
        +Map(callback) stdEnumerator
        +Filter(callback) stdEnumerator
        +forEach(callback) void
    }

    stdArray ..> stdICallable : uses
    stdEnumerator ..> stdICallable : uses

    class stdJSON {
        +Create(type) stdJSON
        +CreateFromString(json) stdJSON
        +Add(key, value) stdJSON
        +ToString() String
    }

    class stdDictionary {
        +Create(keyItems) stdDictionary
        +Add(key, value) void
        +Remove(key) void
        +Item(key) Variant
    }

    class stdIHashable {
        <<interface>>
        +hash() Variant
        +isEqual(other) Boolean
    }

    stdDictionary ..> stdIHashable : uses
```

## データフロー概念図

```mermaid
flowchart LR
    subgraph External["外部データソース"]
        FILE[ファイル]
        WEB[Web API]
        EXCEL[Excel範囲]
    end

    subgraph stdVBA["stdVBA ライブラリ"]
        JSON[stdJSON]
        ARRAY[stdArray]
        ENUM[stdEnumerator]
        HTTP[stdHTTP]
        TABLE[stdTable]
    end

    subgraph Memory["メモリ内データ"]
        DICT[Dictionary]
        COLL[Collection]
        ARR[VBA Array]
    end

    FILE -->|読み込み| JSON
    JSON -->|ToVBObject| DICT
    JSON -->|ToVBObject| COLL

    WEB -->|HTTPリクエスト| HTTP
    HTTP -->|レスポンス| JSON

    EXCEL -->|ListObject| TABLE
    TABLE -->|イベント| ARRAY

    DICT -->|CreateFromVariant| JSON
    COLL -->|CreateFromVariant| JSON
    ARR -->|CreateFromArray| ARRAY

    ARRAY -->|Enumerate| ENUM
    COLL -->|CreateFromIEnumVARIANT| ENUM
```

## 備考

1. **ERモデルの適用限界**: stdVBAはユーティリティライブラリであり、従来のリレーショナルデータベースのER図とは異なる表現となっています。

2. **データの永続化**: 本プロジェクトではデータの永続化にJSONファイルやExcelファイルを使用しており、RDBMSは使用されていません。

3. **WIPモジュール**: stdDictionary、stdTableは開発中（Work In Progress）であり、最終的な構造は変更される可能性があります。

4. **インターフェース**: stdICallable、stdIHashableはVBAのインターフェースとして定義されており、ポリモーフィズムを実現しています。
