# データベース設計書

## 概要

本ドキュメントは、stdVBAプロジェクトにおけるデータベース設計についてまとめたものです。

stdVBAは、VBA（Visual Basic for Applications）のための汎用ライブラリコレクションであり、配列操作、正規表現、HTTP通信、JSON処理、ウィンドウ操作、プロセス管理などの機能を提供しています。

## データベース使用状況

### 分析結果

本プロジェクトのソースコード解析の結果、以下の点が判明しました：

1. **外部データベース接続なし**: ADODB、DAO、その他のデータベース接続ライブラリの使用は確認されませんでした。

2. **SQLクエリなし**: INSERT、UPDATE、DELETE、SELECT等のSQLステートメントはデータベース操作目的では使用されていません。

3. **永続化層なし**: データの永続化はファイルベース（JSON、INI等）またはメモリ内で行われています。

### データ管理方式

本プロジェクトでは、以下のデータ管理方式が採用されています：

| 方式 | 対応クラス | 説明 |
| --- | --- | --- |
| メモリ内配列 | stdArray | JavaScript風の動的配列実装 |
| メモリ内辞書 | stdDictionary（WIP） | キー・バリュー形式のハッシュテーブル |
| JSONシリアライゼーション | stdJSON | JSONファイルの読み書き |
| INIファイル | stdIni（WIP） | INI形式の設定ファイル |
| Excelテーブル | stdTable（WIP） | Excel ListObjectのラッパー |

## テーブル一覧

本プロジェクトには、リレーショナルデータベースのテーブル定義は存在しません。

| テーブル名 | 対応エンティティ | 説明 |
| --- | --- | --- |
| （該当なし） | - | 本プロジェクトはRDBMSを使用していません |

## 各テーブル定義

該当なし（本プロジェクトはデータベーステーブルを定義していません）

## データ構造（参考情報）

本プロジェクトで使用されている主要なデータ構造を参考情報として記載します。

### stdDictionary 内部構造（WIP）

stdDictionaryクラスは、ハッシュテーブルを実装するためのバケット構造を使用しています。

| フィールド名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| bIsRoot | Boolean | No | ルートバケットかどうか |
| vKey | Variant | Yes | キー値 |
| vValue | Variant | Yes | 格納値 |
| iNextItem | Long | No | 次のアイテムへのインデックス（0の場合は末尾） |

### stdJSON 内部構造

stdJSONクラスは、JSONオブジェクトまたはJSONアレイを表現します。

| フィールド名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| iType | EStdJsonType | No | JSONタイプ（eJSONObject または eJSONArray） |
| children | Object | No | 子要素（Dictionary または Collection） |
| parserProps | TParser | No | パーサー設定 |

### stdTable 内部構造（WIP）

stdTableクラスは、Excel ListObjectをラップするための構造を持っています。

| フィールド名 | データ型 | NULL | 説明 |
| --- | --- | --- | --- |
| pSheet | Worksheet | No | 親ワークシート |
| pLO | ListObject | No | ラップ対象のListObject |
| pIsSelected | Boolean | No | 選択状態 |
| pSelectedRows | Collection | Yes | 選択行のコレクション |

## 備考

1. **ライブラリの性質**: stdVBAはユーティリティライブラリであり、データベース機能を主目的としていません。

2. **データ永続化**: 永続化が必要な場合は、stdJSONを使用したJSONファイルへの保存、またはExcelシート（stdTableを使用）への保存が想定されています。

3. **WIPモジュール**: stdDictionary、stdTable、stdIniは「Work In Progress」（開発中）の状態です。

4. **拡張性**: 将来的にデータベース接続が必要になった場合は、stdDBやstdADOなどの新規クラスとして実装されることが予想されます。
