# バッチ設計書 1-enforce_crlf.yml

## 概要

本ドキュメントは、VBAソースファイルの改行コードをCRLFに強制変換するGitHub Actionsワークフロー「enforce_crlf.yml」の設計仕様を記載するものである。

### 本バッチの処理概要

このバッチは、リポジトリ内のVBAソースファイル（.bas, .frm, .cls）の改行コードを自動的にCRLF（Carriage Return + Line Feed）形式に変換し、一貫した改行コードを維持する。

**業務上の目的・背景**：VBAソースコードはWindowsのVBE（Visual Basic Editor）で編集されることが多く、CRLFの改行コードが標準となっている。GitやGitHubを使用する際、異なるOS間での改行コードの不整合が発生し、差分表示が正しく行われない、またはVBEでのインポート時に問題が生じる可能性がある。本バッチにより、これらの問題を自動的に解決し、チーム開発における品質を維持する。

**バッチの実行タイミング**：masterブランチへのpushまたはプルリクエスト時に自動実行される。継続的インテグレーション（CI）の一環として、コードの品質ゲートとして機能する。

**主要な処理内容**：
1. リポジトリのチェックアウト
2. 対象ファイル（.bas, .frm, .cls）の検出
3. 改行コードのCRLFへの変換
4. 変更がある場合、自動コミットおよびプッシュ

**前後の処理との関連**：本バッチは他のCI/CDワークフローと並行して実行される。特にlint_vba.ymlやvba_docs_gen.ymlの前提として、ファイル形式の一貫性を担保する役割を持つ。

**影響範囲**：src/ディレクトリ配下のVBAソースファイル全体に影響し、masterブランチのコミット履歴に自動修正コミットが追加される可能性がある。

## バッチ種別

データクレンジング / ファイル形式標準化

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（イベント駆動） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | push（masterブランチ）、pull_request（masterブランチ） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ブランチ | masterブランチへのpushまたはPR |
| ファイル存在 | .bas, .frm, .cls拡張子のファイルが存在すること |
| GitHub Actions | GitHub Actionsが有効であること |

### 実行可否判定

- masterブランチへのpushまたはプルリクエストイベントが発生した場合に実行
- 対象ファイル（.bas, .frm, .cls）が存在しない場合も実行されるが、変更は発生しない

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| extensions | string | Yes | .bas, .frm, .cls | 対象ファイル拡張子 |
| do-checkout | boolean | Yes | true | リポジトリのチェックアウト実行有無 |
| do-push | boolean | Yes | true | 変更の自動プッシュ実行有無 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/*.bas | VBAソースファイル | 標準モジュールファイル |
| src/*.frm | VBAソースファイル | ユーザーフォームファイル |
| src/*.cls | VBAソースファイル | クラスモジュールファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| src/*.bas | VBAソースファイル | CRLF変換済み標準モジュール |
| src/*.frm | VBAソースファイル | CRLF変換済みユーザーフォーム |
| src/*.cls | VBAソースファイル | CRLF変換済みクラスモジュール |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 入力ファイルと同名（上書き） |
| 出力先 | 元のファイルパス |
| 文字コード | 変更なし（元のエンコーディングを維持） |
| 改行コード | CRLF（\r\n） |

## 処理フロー

### 処理シーケンス

```
1. ワークフロー起動
   └─ masterブランチへのpushまたはPRイベントを検知
2. リポジトリチェックアウト
   └─ Enforce-CRLFアクションが内部でチェックアウトを実行
3. 対象ファイル検出
   └─ .bas, .frm, .cls拡張子のファイルを走査
4. 改行コード変換
   └─ LFをCRLFに変換
5. 変更コミット・プッシュ
   └─ 変更がある場合、自動でコミットしてmasterブランチにプッシュ
```

### フローチャート

```mermaid
flowchart TD
    A[ワークフロー開始] --> B[リポジトリチェックアウト]
    B --> C[対象ファイル検出]
    C --> D{対象ファイル存在?}
    D -->|あり| E[改行コード変換処理]
    D -->|なし| H[ワークフロー終了]
    E --> F{変更あり?}
    F -->|あり| G[コミット・プッシュ]
    F -->|なし| H
    G --> H
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | チェックアウト失敗 | ネットワーク障害、認証エラー | ワークフローを再実行 |
| - | プッシュ失敗 | 権限不足、ブランチ保護ルール | permissionsの確認、ブランチ保護設定の確認 |
| - | ファイル変換失敗 | 不正なファイル形式 | 対象ファイルの手動確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | GitHub Actions標準（自動リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | 手動での再実行が必要 |

### 障害時対応

1. GitHub Actionsのログを確認してエラー原因を特定
2. ローカル環境で対象ファイルの改行コードを手動確認
3. 必要に応じて手動でCRLF変換を実施
4. ワークフローを再実行

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | Gitコミット単位 |
| コミットタイミング | 全ファイル変換完了後 |
| ロールバック条件 | プッシュ失敗時はコミットは取り消されない |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 50-100ファイル程度 |
| 目標処理時間 | 1分以内 |
| メモリ使用量上限 | GitHub Actionsランナーの標準制限内 |

## 排他制御

- 同一ブランチへの同時プッシュは発生しうるが、Gitの競合解決メカニズムに依存
- プルリクエストとpushが同時に発生した場合、それぞれ独立して実行される

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ワークフロー開始時 | ワークフロー名、トリガーイベント |
| 進捗ログ | ファイル処理中 | 変換対象ファイル一覧 |
| 終了ログ | ワークフロー終了時 | 成功/失敗ステータス、変換ファイル数 |
| エラーログ | エラー発生時 | エラーメッセージ、スタックトレース |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ワークフロー失敗 | 1回 | GitHubリポジトリの通知設定に依存 |
| 処理時間 | 5分 | GitHub Actions標準のタイムアウト |

## 備考

- 使用アクション: DecimalTurn/Enforce-CRLF@v1.1.3
- ubuntu-latestランナーで実行
- permissions設定によりcontents: writeが必要
