# バッチ設計書 2-lint_vba.yml

## 概要

本ドキュメントは、VBAコードの静的解析（リント）を実行するGitHub Actionsワークフロー「lint_vba.yml」の設計仕様を記載するものである。

### 本バッチの処理概要

このバッチは、VBAソースコードに対して静的解析（リント）を実行し、コーディング規約違反やポテンシャルなバグを検出する。VBA Precompilerによる前処理を行った後、Vba-actions/lint-vbaアクションによるリントを実行する。

**業務上の目的・背景**：VBAコードの品質を維持するため、自動的にコーディング規約のチェックや潜在的なバグの検出を行う。手動レビューでは見落としがちな問題を早期に発見し、コードの保守性と信頼性を向上させる。継続的インテグレーションの一環として、コード品質ゲートの役割を果たす。

**バッチの実行タイミング**：lintingブランチへのpush時に自動実行される。本番ブランチ（master）ではなく専用のlintingブランチで実行されることで、実験的なリント機能のテストが可能となっている。

**主要な処理内容**：
1. リポジトリのチェックアウト
2. Python環境のセットアップとVBA Precompilerのインストール
3. WIP（Work In Progress）ディレクトリの除外
4. VBA Precompilerによるプリコンパイル（Win64プラットフォーム、VBA7対応）
5. Vba-actions/lint-vbaによる静的解析実行

**前後の処理との関連**：本バッチは独立して実行されるが、enforce_crlf.ymlによる改行コードの標準化が前提となる。リント結果はプルリクエストのマージ判断に影響を与える可能性がある。

**影響範囲**：src/ディレクトリ配下のVBAソースファイル全体を対象とし、WIPディレクトリは除外される。リント結果はGitHub Actionsのログおよびプルリクエストのチェックステータスに反映される。

## バッチ種別

静的解析 / コード品質チェック

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（イベント駆動） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | push（lintingブランチ） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ブランチ | lintingブランチへのpush |
| Python | Python 3.x環境が利用可能であること |
| pip | pipコマンドが利用可能であること |
| ファイル存在 | src/ディレクトリ配下にVBAファイルが存在すること |

### 実行可否判定

- lintingブランチへのpushイベントが発生した場合のみ実行
- src/WIPディレクトリは処理対象から除外される

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -v7 | フラグ | Yes | - | VBA7互換モードでプリコンパイル |
| -sWin64 | フラグ | Yes | - | Win64プラットフォーム向けプリコンパイル |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/*.bas | VBAソースファイル | 標準モジュールファイル |
| src/*.cls | VBAソースファイル | クラスモジュールファイル |
| src/*.frm | VBAソースファイル | ユーザーフォームファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| GitHub Actions Log | テキスト | リント結果、警告、エラー |
| Check Status | ステータス | 成功/失敗のチェックマーク |

### 出力ファイル仕様

本バッチはファイル出力を行わない。処理結果はGitHub Actionsのログに出力される。

## 処理フロー

### 処理シーケンス

```
1. ワークフロー起動
   └─ lintingブランチへのpushイベントを検知
2. リポジトリチェックアウト
   └─ actions/checkout@v3を使用
3. Python環境セットアップ
   └─ pipのアップグレード
4. VBA Precompilerインストール
   └─ GitHub上のVBA-Precompilerリポジトリからインストール
5. WIPディレクトリ除外
   └─ rm -rf ./src/WIP
6. プリコンパイル実行
   └─ python -m vba_precompiler -v7 -sWin64 ./src
7. srcディレクトリ削除（プリコンパイル後）
   └─ rm -rf ./src
8. リント実行
   └─ Vba-actions/lint-vba@devを使用
```

### フローチャート

```mermaid
flowchart TD
    A[ワークフロー開始] --> B[リポジトリチェックアウト]
    B --> C[pip upgrade]
    C --> D[VBA Precompilerインストール]
    D --> E[WIPディレクトリ削除]
    E --> F[プリコンパイル実行]
    F --> G[srcディレクトリ削除]
    G --> H[リント実行]
    H --> I{リント結果}
    I -->|成功| J[ワークフロー成功]
    I -->|失敗| K[ワークフロー失敗]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | インストール失敗 | VBA Precompilerのインストールエラー | ネットワーク確認、リポジトリURL確認 |
| - | プリコンパイル失敗 | VBAコードの構文エラー | 対象ファイルの構文確認 |
| - | リント失敗 | コーディング規約違反 | 指摘された問題の修正 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | GitHub Actions標準（自動リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | 手動での再実行が必要 |

### 障害時対応

1. GitHub Actionsのログを確認してエラー原因を特定
2. プリコンパイルエラーの場合、対象VBAファイルの構文を確認
3. リントエラーの場合、指摘された問題を修正してプッシュ
4. 依存関係のインストールエラーの場合、VBA-Precompilerリポジトリのステータスを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイル変更なし） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 50-100ファイル程度 |
| 目標処理時間 | 5分以内 |
| メモリ使用量上限 | GitHub Actionsランナーの標準制限内 |

## 排他制御

- 同一ブランチへの複数プッシュは順次処理される
- 他ブランチのワークフローとは独立して実行

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ワークフロー開始時 | ワークフロー名、トリガーブランチ |
| インストールログ | 依存関係インストール時 | pipインストール結果 |
| プリコンパイルログ | プリコンパイル実行時 | プリコンパイル結果 |
| リントログ | リント実行時 | リント結果、警告、エラー |
| 終了ログ | ワークフロー終了時 | 成功/失敗ステータス |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ワークフロー失敗 | 1回 | GitHubリポジトリの通知設定に依存 |
| 処理時間 | 10分 | GitHub Actions標準のタイムアウト |

## 備考

- 使用アクション: actions/checkout@v3, Vba-actions/lint-vba@dev
- 使用パッケージ: vba_precompiler（Beakerboy/VBA-Precompiler）
- ubuntu-latestランナーで実行
- VBA7 + Win64プラットフォーム向けにプリコンパイル
- WIPディレクトリは開発中のコードとして除外される
