# バッチ設計書 3-stdError_wrap.yml

## 概要

本ドキュメントは、全VBAソースファイルにstdErrorラッパーを適用するGitHub Actionsワークフロー「stdError_wrap.yml」の設計仕様を記載するものである。

### 本バッチの処理概要

このバッチは、VBAソースコード内のすべてのPublic/Private/Friend関数、サブルーチン、プロパティに対してstdErrorラッパーを自動的に注入し、統一されたエラーハンドリング機構を提供する。処理結果は専用のstdError-Wrappedブランチにforce-pushされる。

**業務上の目的・背景**：VBAにおけるエラーハンドリングは手動で記述する必要があり、記述漏れや不統一な実装が発生しやすい。stdErrorラッパーを自動注入することで、すべての関数にエラーキャッチ機構を追加し、エラー発生時のスタックトレース取得やデバッグを容易にする。これにより、本番環境での障害対応時間を短縮し、コード品質を向上させる。

**バッチの実行タイミング**：masterブランチへのpush時、またはworkflow_dispatch（手動トリガー）で実行される。自動実行により、masterブランチの最新コードに対して常にエラーラッパー適用版が利用可能となる。

**主要な処理内容**：
1. リポジトリのチェックアウト（全履歴取得）
2. Node.js 20環境のセットアップ
3. VBA-stdError-Wrapper/main.jsの実行（ソースコード変換）
4. 変更のコミット
5. stdError-Wrappedブランチへのforce-push

**前後の処理との関連**：本バッチはmasterブランチの変更を元にstdError-Wrappedブランチを更新する。VBA-stdError-Wrapper/main.js（No.6）に依存しており、当該スクリプトの処理結果をGit経由で公開する役割を持つ。

**影響範囲**：src/ディレクトリ配下のすべてのVBAソースファイルが対象。stdError-Wrappedブランチの全コンテンツが上書きされるため、当該ブランチを直接編集している場合は注意が必要。

## バッチ種別

コード変換 / エラーハンドリング注入

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（イベント駆動） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | push（masterブランチ）、workflow_dispatch（手動） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ブランチ | masterブランチへのpushまたは手動トリガー |
| Node.js | Node.js 20が利用可能であること |
| VBA-stdError-Wrapper | Tools/VBA-stdError-Wrapper/main.jsが存在すること |
| Git権限 | contents: write権限が付与されていること |

### 実行可否判定

- masterブランチへのpushまたはworkflow_dispatchイベントで実行
- src/ディレクトリにVBAファイルが存在する場合に処理を実行

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| fetch-depth | number | No | 0 | Gitの取得履歴深度（0=全履歴） |
| node-version | string | No | 20 | Node.jsバージョン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/*.bas | VBAソースファイル | 標準モジュールファイル |
| src/*.cls | VBAソースファイル | クラスモジュールファイル |
| src/*.frm | VBAソースファイル | ユーザーフォームファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| src/*.bas | VBAソースファイル | stdErrorラッパー適用済み標準モジュール |
| src/*.cls | VBAソースファイル | stdErrorラッパー適用済みクラスモジュール |
| src/*.frm | VBAソースファイル | stdErrorラッパー適用済みユーザーフォーム |
| stdError-Wrappedブランチ | Git branch | 変換後のソースコードを格納するブランチ |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | 入力ファイルと同名（上書き） |
| 出力先 | stdError-Wrappedブランチ |
| 文字コード | UTF-8 |
| 追加内容 | stdError.getSentry呼び出し、Err_Raise関数 |

## 処理フロー

### 処理シーケンス

```
1. ワークフロー起動
   └─ masterブランチへのpushまたは手動トリガーを検知
2. リポジトリチェックアウト
   └─ fetch-depth: 0で全履歴取得（push用）
3. Node.js環境セットアップ
   └─ Node.js 20をセットアップ
4. stdErrorラッパー実行
   └─ node ./Tools/VBA-stdError-Wrapper/main.js
5. Git設定
   └─ user.name, user.emailを設定
6. 変更のステージング・コミット
   └─ git add -A && git commit
7. stdError-Wrappedブランチへforce-push
   └─ git push --verbose origin +HEAD:stdError-Wrapped
```

### フローチャート

```mermaid
flowchart TD
    A[ワークフロー開始] --> B[リポジトリチェックアウト]
    B --> C[Node.js 20セットアップ]
    C --> D[stdErrorラッパー実行]
    D --> E[Git設定]
    E --> F[git status確認]
    F --> G[git add -A]
    G --> H{変更あり?}
    H -->|あり| I[git commit]
    H -->|なし| J[コミットスキップ]
    I --> K[force-push to stdError-Wrapped]
    J --> K
    K --> L[ワークフロー終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Node.js実行エラー | main.jsの構文エラー、ランタイムエラー | main.jsのデバッグ、ログ確認 |
| - | Git操作エラー | 認証エラー、ブランチ保護 | permissions確認、ブランチ保護設定確認 |
| - | force-push失敗 | ネットワーク障害、権限不足 | 再実行、権限確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | GitHub Actions標準（自動リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | 手動での再実行が必要 |

### 障害時対応

1. GitHub Actionsのログを確認してエラー原因を特定
2. main.js実行エラーの場合、対象VBAファイルの構文を確認
3. Git操作エラーの場合、permissionsとブランチ保護設定を確認
4. 必要に応じてローカルで手動実行してテスト

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | Gitコミット単位 |
| コミットタイミング | 全ファイル変換完了後 |
| ロールバック条件 | force-push失敗時は前の状態が維持される |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 50-100ファイル程度 |
| 目標処理時間 | 2分以内 |
| メモリ使用量上限 | GitHub Actionsランナーの標準制限内 |

## 排他制御

- 同一ワークフローの同時実行は発生しうるが、force-pushにより最後の実行結果が反映される
- stdError-Wrappedブランチは自動生成されるため、手動編集は非推奨

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ワークフロー開始時 | ワークフロー名、トリガーイベント |
| Node.js実行ログ | main.js実行時 | 変換処理の進捗、ファイル一覧 |
| Gitステータス | コミット前 | git status -sの出力 |
| コミットログ | コミット時 | コミットメッセージ、git log -1 |
| push結果 | push時 | git push --verboseの出力 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ワークフロー失敗 | 1回 | GitHubリポジトリの通知設定に依存 |
| 処理時間 | 10分 | GitHub Actions標準のタイムアウト |

## 備考

- 使用アクション: actions/checkout@v3, actions/setup-node@v4
- 依存スクリプト: Tools/VBA-stdError-Wrapper/main.js
- ubuntu-latestランナーで実行
- force-pushを使用するため、stdError-Wrappedブランチの履歴は保持されない
- コミットメッセージ: "Wrapped latest changes in stdError sentries"
- Git設定: user.name="GitHub Actions Bot", user.email="actions@github.com"
