# バッチ設計書 4-vba_docs_gen.yml

## 概要

本ドキュメントは、VBAソースコードからAPIドキュメント（docs.json）を自動生成するGitHub Actionsワークフロー「vba_docs_gen.yml」の設計仕様を記載するものである。

### 本バッチの処理概要

このバッチは、VBAソースコード内のコメントブロックを解析し、モジュール、クラス、メソッド、プロパティ、イベントの情報を抽出してdocs.jsonとしてJSON形式のAPIドキュメントを生成する。これにより、VBAコードの自動ドキュメント化を実現する。

**業務上の目的・背景**：VBAプロジェクトは従来、ドキュメントの手動作成が必要であり、コードとドキュメントの乖離が発生しやすかった。ソースコード内のコメントから自動的にAPIドキュメントを生成することで、常に最新のドキュメントを維持し、開発者の生産性向上と知識共有を促進する。JSDoc風のアノテーションにより、型情報やパラメータ説明も機械可読形式で出力される。

**バッチの実行タイミング**：すべてのブランチへのpush時に自動実行される。これにより、開発ブランチでもドキュメントの最新状態を確認でき、レビュー時の参照資料として活用できる。

**主要な処理内容**：
1. リポジトリのチェックアウト
2. Node.js 20環境のセットアップ
3. VBDocsGen/main.jsの実行（ドキュメント生成）
4. docs.jsonのコミットとプッシュ

**前後の処理との関連**：本バッチはVBDocsGen/main.js（No.5）に依存しており、当該スクリプトの処理結果をGit経由で公開する。enforce_crlf.ymlによる改行コードの標準化が前提となり、正しくパースされるためにはCRLF形式のファイルが必要。

**影響範囲**：src/ディレクトリ配下のすべてのVBAソースファイルを解析対象とし、ルートディレクトリにdocs.jsonを出力する。生成されたdocs.jsonは外部ツールやWebサイトから参照される可能性がある。

## バッチ種別

ドキュメント生成 / APIリファレンス自動化

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（イベント駆動） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | push（全ブランチ） |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| ブランチ | すべてのブランチへのpush |
| Node.js | Node.js 20が利用可能であること |
| VBDocsGen | Tools/VBDocsGen/main.jsが存在すること |
| ソースファイル | src/ディレクトリにVBAファイルが存在すること |

### 実行可否判定

- すべてのブランチへのpushイベントで実行
- src/ディレクトリにVBAファイルが存在しない場合、空のdocs.jsonが生成される

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| node-version | string | No | 20 | Node.jsバージョン |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/*.bas | VBAソースファイル | 標準モジュールファイル |
| src/*.cls | VBAソースファイル | クラスモジュールファイル |
| src/*.frm | VBAソースファイル | ユーザーフォームファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| docs.json | JSONファイル | APIドキュメント |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | docs.json |
| 出力先 | リポジトリルート |
| 文字コード | UTF-8 |
| フォーマット | JSON（インデント付き） |

### JSON構造

```json
[
  {
    "name": "モジュール名",
    "fileName": "ファイル名",
    "description": "モジュール説明",
    "remarks": ["備考"],
    "examples": ["使用例"],
    "methods": [
      {
        "name": "メソッド名",
        "description": "説明",
        "params": [
          {
            "name": "パラメータ名",
            "type": "型",
            "description": "説明",
            "optional": false,
            "defaultValue": null
          }
        ],
        "returns": {
          "type": "戻り値型",
          "description": "説明"
        }
      }
    ],
    "properties": [...],
    "constructors": [...],
    "events": [...]
  }
]
```

## 処理フロー

### 処理シーケンス

```
1. ワークフロー起動
   └─ 任意のブランチへのpushイベントを検知
2. リポジトリチェックアウト
   └─ actions/checkout@v3を使用
3. Node.js環境セットアップ
   └─ Node.js 20をセットアップ
4. ドキュメント生成実行
   └─ node ./Tools/VBDocsGen/main.js
5. Git設定・コミット
   └─ user.name, user.emailを設定
   └─ docs.jsonをステージング・コミット
6. プッシュ
   └─ 現在のブランチにpush
```

### フローチャート

```mermaid
flowchart TD
    A[ワークフロー開始] --> B[リポジトリチェックアウト]
    B --> C[Node.js 20セットアップ]
    C --> D[VBDocsGen main.js実行]
    D --> E[Git設定]
    E --> F[git add docs.json]
    F --> G{変更あり?}
    G -->|あり| H[git commit]
    G -->|なし| I[コミットスキップ]
    H --> J[git push origin HEAD]
    I --> J
    J --> K[ワークフロー終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | Node.js実行エラー | main.jsの構文エラー、ランタイムエラー | main.jsのデバッグ、ログ確認 |
| - | パースエラー | VBAファイルの不正なコメント形式 | 対象ファイルのコメント確認 |
| - | Git操作エラー | 認証エラー、競合 | permissions確認、再実行 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | GitHub Actions標準（自動リトライなし） |
| リトライ間隔 | - |
| リトライ対象エラー | 手動での再実行が必要 |

### 障害時対応

1. GitHub Actionsのログを確認してエラー原因を特定
2. パースエラーの場合、対象VBAファイルのコメント形式を確認
3. JSDoc形式のアノテーション（@param, @returns等）が正しいか検証
4. 必要に応じてローカルで手動実行してテスト

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | Gitコミット単位 |
| コミットタイミング | ドキュメント生成完了後 |
| ロールバック条件 | push失敗時は前の状態が維持される |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 50-100ファイル程度 |
| 目標処理時間 | 1分以内 |
| メモリ使用量上限 | GitHub Actionsランナーの標準制限内 |

## 排他制御

- 同一ブランチへの複数プッシュは順次処理される
- 異なるブランチでは独立してdocs.jsonが生成される

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 開始ログ | ワークフロー開始時 | ワークフロー名、トリガーブランチ |
| パースログ | main.js実行時 | 解析中のモジュール名、警告 |
| 終了ログ | ワークフロー終了時 | 成功/失敗ステータス |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| ワークフロー失敗 | 1回 | GitHubリポジトリの通知設定に依存 |
| 処理時間 | 10分 | GitHub Actions標準のタイムアウト |

## 備考

- 使用アクション: actions/checkout@v3, actions/setup-node@v4
- 依存スクリプト: Tools/VBDocsGen/main.js
- ubuntu-latestランナーで実行
- コミットメッセージ: "Documentation update"
- Git設定: user.name="GitHub Actions Bot", user.email="actions@github.com"
- サポートするアノテーション: @param, @returns, @example, @remark, @constructor, @protected, @deprecated, @throws, @requires, @static
