# バッチ設計書 5-VBDocsGen/main.js

## 概要

本ドキュメントは、src/配下のVBAソースファイルを解析し、docs.jsonとしてAPIドキュメントを生成するNode.jsスクリプト「VBDocsGen/main.js」の設計仕様を記載するものである。

### 本バッチの処理概要

このバッチは、VBAソースコード内のコメントブロック（JSDoc風アノテーション）を解析し、モジュール情報、メソッド、プロパティ、イベント、コンストラクタの情報を抽出してJSON形式のドキュメントを生成する。TypeScript（main.ts）からビルドされたJavaScriptファイルとして実行される。

**業務上の目的・背景**：VBAライブラリのAPIドキュメントを自動生成することで、ライブラリ利用者への情報提供を効率化する。手動でのドキュメント作成・更新の手間を削減し、ソースコードとドキュメントの一貫性を保証する。生成されるJSONは機械可読形式であり、Webサイトやエディタのインテリセンス機能など、様々な用途に活用可能。

**バッチの実行タイミング**：vba_docs_gen.ymlワークフローから自動実行される。また、ローカル環境で手動実行することも可能。

**主要な処理内容**：
1. src/ディレクトリ内のファイル一覧取得
2. 各VBAファイルの読み込み
3. モジュール/クラス判定
4. コメントブロックのパース（@param, @returns, @example等）
5. Public関数/プロパティ/イベントの抽出
6. JSON形式でdocs.jsonに出力

**前後の処理との関連**：本スクリプトはvba_docs_gen.yml（No.4）から呼び出される。VBDocsGen/build.bat（No.8）でTypeScriptからビルドされる必要がある。

**影響範囲**：src/ディレクトリ配下のVBAソースファイルを読み取り専用で参照し、ルートディレクトリにdocs.jsonを出力する。

## バッチ種別

ドキュメント生成 / コード解析

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（ワークフロー/手動） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | vba_docs_gen.ymlワークフロー / 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Node.js | Node.js環境が利用可能であること |
| ビルド済み | build.batでmain.jsがビルドされていること |
| ソースファイル | src/ディレクトリにVBAファイルが存在すること |

### 実行可否判定

- src/ディレクトリが存在し、ファイルが含まれている場合に処理を実行
- ディレクトリが空の場合、空の配列をdocs.jsonに出力

## 入力仕様

### 入力パラメータ

本スクリプトはコマンドライン引数を受け取らない。

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| src/*.bas | VBAソースファイル | 標準モジュールファイル |
| src/*.cls | VBAソースファイル | クラスモジュールファイル |
| src/*.frm | VBAソースファイル | ユーザーフォームファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| docs.json | JSONファイル | APIドキュメント |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | docs.json |
| 出力先 | リポジトリルート（__dirname + "/../../docs.json"） |
| 文字コード | UTF-8 |
| フォーマット | JSON（2スペースインデント） |

### 解析対象アノテーション

| アノテーション | 説明 |
|---------------|------|
| @module | モジュールレベルのドキュメント開始 |
| @description | 説明文 |
| @param | パラメータ（名前、型、説明） |
| @returns | 戻り値（型、説明） |
| @example | 使用例（Markdownコードブロック） |
| @remark | 備考・補足情報 |
| @devNote | 開発者向けメモ |
| @TODO | 未実装・改善予定事項 |
| @constructor | コンストラクタであることを示す |
| @protected | 保護されたメンバーであることを示す |
| @deprecated | 非推奨であることを示す（メッセージ付き） |
| @throws | スローする例外（エラー番号、エラーテキスト） |
| @requires | 依存モジュール |
| @static | 静的メンバーであることを示す |

## 処理フロー

### 処理シーケンス

```
1. src/ディレクトリのファイル一覧取得
   └─ fs.readdirSync使用、ファイルのみフィルタリング
2. 各ファイルのパース
   └─ parseModuleOrClass関数を呼び出し
3. モジュール/クラス判定
   └─ "VERSION 1.0 CLASS"ヘッダーの有無で判定
4. 条件付きコンパイルの除去
   └─ #If...#End Ifブロックを解析
5. モジュール名取得
   └─ VB_Name属性から取得、なければファイル名
6. モジュールドキュメント解析
   └─ '@module以降のコメントをパース
7. メンバードキュメント解析
   └─ Public宣言の前のコメントをパース
8. プロパティアクセス判定
   └─ Get/Let/Setを統合してReadOnly/WriteOnly/ReadWrite判定
9. docs.json出力
   └─ JSON.stringifyで整形出力
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[src/ディレクトリ読み込み]
    B --> C[ファイル一覧フィルタリング]
    C --> D{ファイルあり?}
    D -->|なし| E[空配列出力]
    D -->|あり| F[各ファイルをパース]
    F --> G[モジュール/クラス判定]
    G --> H[条件付きコンパイル除去]
    H --> I[モジュールドキュメント解析]
    I --> J[メンバードキュメント解析]
    J --> K[プロパティアクセス判定]
    K --> L{次のファイル?}
    L -->|あり| F
    L -->|なし| M[docs.json出力]
    E --> N[スクリプト終了]
    M --> N
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプトはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイル読み込みエラー | ファイルが存在しない、権限不足 | ファイルパス・権限確認 |
| - | パースエラー | 不正なVBA構文 | 対象ファイルの構文確認 |
| - | 書き込みエラー | 出力先への書き込み権限不足 | 権限確認 |
| - | 未知のタグ警告 | サポートされていないアノテーション | 警告ログを確認、必要に応じてタグ追加 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし（同期処理） |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. コンソールログでエラー内容を確認
2. 対象VBAファイルの構文・コメント形式を確認
3. 未知のタグ警告の場合、タグの追加を検討
4. 正規表現のマッチング問題の場合、parseToTagLines関数を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイルI/O） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 50-100ファイル程度 |
| 目標処理時間 | 10秒以内 |
| メモリ使用量上限 | Node.js標準制限内 |

## 排他制御

- 同時実行は想定しない
- ファイル書き込みは上書きモード

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | モジュールパース時 | "Parsing module {モジュール名}" |
| 警告ログ | 未知のタグ検出時 | "Unknown tag {タグ名}" |
| 成功ログ | 正常完了時 | Success message |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行時間 | 60秒 | コンソール出力 |
| 警告件数 | 多数 | コンソール出力 |

## 備考

- TypeScript（main.ts）からesbuildでビルド
- ソースマップ（main.js.map）も生成
- VBA7の条件付きコンパイルに対応
- implements文からインターフェース実装を抽出
- デフォルトメンバー（VB_UserMemId = 0）を検出
- プロパティのGet/Let/Setを統合して単一のプロパティとして出力
