# バッチ設計書 7-VBALibraries Extract/VBALibraries.ahk

## 概要

本ドキュメントは、Excel VBE（Visual Basic Editor）からライブラリ情報を抽出しJSONファイルに出力するAutoHotkeyスクリプト「VBALibraries.ahk」の設計仕様を記載するものである。

### 本バッチの処理概要

このバッチは、Excel VBEのオブジェクトブラウザーからライブラリ情報（型、メンバー、メソッド、プロパティ等）を自動抽出し、VBALibraries.jsonとして出力する。AutoHotkeyを使用してVBE画面の各コントロール（ComboBox、ListBox、RichEdit）から情報を取得する。

**業務上の目的・背景**：VBAライブラリの型情報やメンバー情報を機械可読な形式で取得することで、インテリセンス機能の実装やAPIリファレンスの自動生成に活用できる。手動でのライブラリ情報収集は非常に手間がかかるため、本スクリプトにより効率化を図る。取得した情報はVBAコード補完やドキュメント生成に利用可能。

**バッチの実行タイミング**：手動実行のみ。Excel VBEのオブジェクトブラウザーが開いている状態で実行する必要がある。自動実行は想定されていない。

**主要な処理内容**：
1. Excel VBEウィンドウの各コントロールハンドル取得
2. ライブラリ選択ComboBoxからライブラリ一覧取得
3. 各ライブラリを選択し、ライブラリ情報をパース
4. 各親オブジェクト（クラス、モジュール等）を選択し、情報をパース
5. 各メンバー（メソッド、プロパティ等）を選択し、情報をパース
6. JSON形式でVBALibraries.jsonに出力

**前後の処理との関連**：本スクリプトは独立して実行され、他のバッチとの直接的な依存関係はない。出力されたVBALibraries.jsonは他のツールやプロジェクトで参照される可能性がある。

**影響範囲**：Excel VBEのオブジェクトブラウザーの状態を変更（ライブラリ選択、オブジェクト選択）する。スクリプト実行中はExcelの操作が制限される。

## バッチ種別

データ抽出 / ライブラリ情報取得

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（手動） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| OS | Windows |
| AutoHotkey | AutoHotkey 1.1.30.00以上がインストールされていること |
| Excel | Microsoft Excelがインストールされていること |
| VBE | Excel VBEが起動し、オブジェクトブラウザーが開いていること |
| ウィンドウ | VBEウィンドウがアクティブでコントロールにアクセス可能であること |

### 実行可否判定

- Excel VBEウィンドウ（wndclass_desked_gsk）が存在すること
- ListBox1, ListBox2, RichEdit20A1, ComboBox1の各コントロールが存在すること

## 入力仕様

### 入力パラメータ

本スクリプトはコマンドライン引数を受け取らない。

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| VBEオブジェクトブラウザー | GUI | ライブラリ、オブジェクト、メンバー情報 |
| ComboBox1 | コントロール | ライブラリ選択ドロップダウン |
| ListBox1 | コントロール | オブジェクト（クラス、モジュール）一覧 |
| ListBox2 | コントロール | メンバー（メソッド、プロパティ）一覧 |
| RichEdit20A1 | コントロール | 選択項目の詳細説明 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| VBALibraries.json | JSONファイル | ライブラリ情報 |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | VBALibraries.json |
| 出力先 | スクリプトと同じディレクトリ（A_ScriptDir） |
| 文字コード | デフォルト |
| フォーマット | JSON |

### JSON構造

```json
{
  "type": "Libraries",
  "zChildren": [
    {
      "LibType": "ライブラリ種別",
      "LibName": "ライブラリ名",
      "LibPath": "パス",
      "LibDescription": "説明",
      "zChildren": [
        {
          "type": "オブジェクト種別",
          "name": "オブジェクト名",
          "parent": "親ライブラリ",
          "typeDescription": "詳細説明",
          "members": [
            {
              "MemberType": "メンバー種別",
              "MemberName": "メンバー名",
              "ParamString": "パラメータ文字列",
              "RetType": "戻り値型",
              "Parent": "親オブジェクト",
              "isDefault": false,
              "isReadOnly": false,
              "typeDescription": "詳細説明"
            }
          ]
        }
      ]
    }
  ]
}
```

## 処理フロー

### 処理シーケンス

```
1. VBEウィンドウのコントロールハンドル取得
   └─ ControlGet, hwndでListBox1, ListBox2, RichEdit20A1, ComboBox1を取得
2. ライブラリComboBoxの項目数取得
   └─ ControlGet, listでアイテム一覧を取得
3. 各ライブラリをループ
   └─ Control, Chooseでライブラリを選択
   └─ parseLibrary()でライブラリ情報をパース
4. 各親オブジェクトをループ
   └─ Control, ChooseでListBox1の項目を選択
   └─ parseParent()でオブジェクト情報をパース
5. 各メンバーをループ
   └─ Control, ChooseでListBox2の項目を選択
   └─ parseMember()でメンバー情報をパース
6. JSON出力
   └─ JSON.stringify()でシリアライズ
   └─ FileAppendで出力
7. 完了メッセージ表示
   └─ msgboxで通知
```

### フローチャート

```mermaid
flowchart TD
    A[スクリプト開始] --> B[VBEコントロールハンドル取得]
    B --> C[ライブラリ一覧取得]
    C --> D{ライブラリあり?}
    D -->|なし| M[完了メッセージ]
    D -->|あり| E[ライブラリ選択]
    E --> F[parseLibrary実行]
    F --> G{親オブジェクトあり?}
    G -->|なし| L{次のライブラリ?}
    G -->|あり| H[親オブジェクト選択]
    H --> I[parseParent実行]
    I --> J{メンバーあり?}
    J -->|なし| K{次の親?}
    J -->|あり| J1[メンバー選択]
    J1 --> J2[parseMember実行]
    J2 --> J
    K -->|あり| H
    K -->|なし| L
    L -->|あり| E
    L -->|なし| N[JSON出力]
    N --> M
    M --> O[スクリプト終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本スクリプトはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | コントロール取得失敗 | VBEウィンドウが存在しない | Excelを起動し、VBEを開く |
| - | 項目選択失敗 | コントロールが非アクティブ | VBEウィンドウをアクティブにする |
| - | パースエラー | 予期しない説明文形式 | 正規表現の確認、手動確認 |
| - | ファイル書き込みエラー | 権限不足、ディスク容量 | 権限・容量確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. VBEウィンドウが正しく表示されているか確認
2. オブジェクトブラウザーが開いているか確認
3. スクリプトを再実行
4. 部分的な出力の場合、JSON構文を確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 数十〜数百ライブラリ |
| 目標処理時間 | 数分〜数十分（ライブラリ数に依存） |
| メモリ使用量上限 | AutoHotkey標準制限内 |

## 排他制御

- #SingleInstance, Forceにより、スクリプトの多重実行を防止
- 実行中はExcel VBEの手動操作を避けること

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 完了メッセージ | 処理完了時 | "Exporting VBALibraries has complete" |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行時間 | 60分 | なし（手動監視） |

## 備考

- AutoHotkey 1.1.30.00で動作確認済み
- libs/JSON.ahkに依存（JSONシリアライズ用）
- <AllLibraries>項目（k=0）はスキップ
- ドロップダウンの表示/非表示操作で説明フィールドを更新
- グローバル変数（<globals>）の特別処理あり
- 出力ファイルは上書きモード（FileDeleteで既存ファイル削除）
- VBALibraries.min.jsonは別途生成される圧縮版
