# バッチ設計書 8-VBDocsGen/build.bat

## 概要

本ドキュメントは、VBDocsGenツールのTypeScriptソースコードをJavaScriptにビルドするバッチファイル「VBDocsGen/build.bat」の設計仕様を記載するものである。

### 本バッチの処理概要

このバッチは、VBDocsGenツールのTypeScriptソースファイル（main.ts）をJavaScriptファイル（main.js）にトランスパイルおよびバンドルする。esbuildを使用して高速なビルドを実現し、ソースマップも同時に生成する。

**業務上の目的・背景**：VBDocsGenツールはTypeScriptで開発されており、Node.jsで実行するためにはJavaScriptへの変換が必要となる。本ビルドスクリプトにより、開発者はTypeScriptの型安全性を享受しながら、実行可能なJavaScriptを生成できる。esbuildの使用により、tscよりも高速なビルドが可能。

**バッチの実行タイミング**：開発時にTypeScriptソースコードを変更した後、手動で実行する。CI/CDパイプラインでは、ビルド済みのmain.jsがリポジトリにコミットされているため、通常は実行不要。

**主要な処理内容**：
1. esbuildコマンドの実行
2. main.tsをmain.jsにトランスパイル
3. 依存モジュールのバンドル
4. ソースマップ（main.js.map）の生成

**前後の処理との関連**：本ビルドスクリプトはVBDocsGen/main.js（No.5）の生成元となる。ビルド後のmain.jsはvba_docs_gen.yml（No.4）から実行される。

**影響範囲**：Tools/VBDocsGen/ディレクトリ内のmain.jsとmain.js.mapを上書き生成する。

## バッチ種別

ビルド / トランスパイル

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（開発時） |
| 実行時刻 | - |
| 実行曜日 | - |
| 実行日 | - |
| トリガー | 手動実行 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| OS | Windows |
| Node.js | Node.jsがインストールされていること |
| esbuild | esbuildがグローバルまたはローカルにインストールされていること |
| ソースファイル | main.tsが存在すること |

### 実行可否判定

- カレントディレクトリがTools/VBDocsGen/であること
- main.tsファイルが存在すること

## 入力仕様

### 入力パラメータ

本バッチはコマンドライン引数を受け取らない。

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| main.ts | TypeScriptファイル | ソースコード |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| main.js | JavaScriptファイル | トランスパイル済みコード |
| main.js.map | ソースマップ | デバッグ用マッピングファイル |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | main.js, main.js.map |
| 出力先 | Tools/VBDocsGen/ |
| モジュール形式 | CommonJS (cjs) |
| ターゲット | esnext |
| バンドル | 有効（依存モジュール含む） |
| ソースマップ | 有効 |

## 処理フロー

### 処理シーケンス

```
1. esbuildコマンド実行
   └─ main.tsを入力として指定
2. トランスパイル
   └─ TypeScriptをJavaScriptに変換
3. バンドル
   └─ 依存モジュールを単一ファイルに結合
4. 出力
   └─ main.jsとmain.js.mapを生成
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[esbuild実行]
    B --> C[main.ts読み込み]
    C --> D[TypeScriptトランスパイル]
    D --> E[依存モジュールバンドル]
    E --> F[main.js出力]
    F --> G[main.js.map出力]
    G --> H[バッチ終了]
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しない。

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | esbuild未インストール | esbuildコマンドが見つからない | npm install esbuildでインストール |
| - | TypeScript構文エラー | main.tsに構文エラーがある | エラーメッセージを確認し修正 |
| - | ファイル未発見 | main.tsが存在しない | ファイルパスを確認 |
| - | 書き込みエラー | 出力先への書き込み権限不足 | 権限確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | なし |
| リトライ間隔 | - |
| リトライ対象エラー | - |

### 障害時対応

1. エラーメッセージを確認
2. TypeScript構文エラーの場合、main.tsを修正
3. esbuild未インストールの場合、npm install esbuildを実行
4. 必要に応じてNode.jsのバージョンを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1ファイル |
| 目標処理時間 | 5秒以内 |
| メモリ使用量上限 | Node.js標準制限内 |

## 排他制御

- 同時実行は想定しない
- 出力ファイルは上書きモード

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| ビルドログ | ビルド完了時 | esbuildの出力（バンドルサイズ等） |
| エラーログ | エラー発生時 | エラーメッセージ、行番号 |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 実行時間 | 30秒 | コンソール出力 |

## 備考

- esbuildを使用（tscより高速）
- オプション:
  - --outfile=main.js: 出力ファイル名
  - --bundle: 依存モジュールをバンドル
  - --platform=node: Node.js向けビルド
  - --target=esnext: 最新のECMAScript仕様
  - --format=cjs: CommonJSモジュール形式
  - --sourcemap: ソースマップ生成
- package.jsonのdependenciesはバンドルに含まれる（fs等の組み込みモジュールは除く）
