---
generated_at: 2026-01-15 10:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-stdError_wrap.yml バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.github/workflows/stdError_wrap.yml`（ワークフロー定義ファイル）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義）
- E-03: `Tools/VBA-stdError-Wrapper/main.ts`（ラッパースクリプトソース）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | masterブランチへのpushでトリガーされる | E-01 line 2-4: `push: branches: - master` | ○ |
| C-02 | workflow_dispatch（手動トリガー）をサポート | E-01 line 5: `workflow_dispatch:` | ○ |
| C-03 | permissions: contents: write | E-01 line 7-8: `permissions: contents: write` | ○ |
| C-04 | ジョブ名がerror-enwrap | E-01 line 11: `error-enwrap:` | ○ |
| C-05 | ubuntu-latestで実行 | E-01 line 12: `runs-on: ubuntu-latest` | ○ |
| C-06 | fetch-depth: 0で全履歴取得 | E-01 line 16-17: `with: fetch-depth: 0` | ○ |
| C-07 | Node.js 20をセットアップ | E-01 line 19-22: `uses: actions/setup-node@v4 with: node-version: "20"` | ○ |
| C-08 | main.jsを実行 | E-01 line 25: `run: node ./Tools/VBA-stdError-Wrapper/main.js` | ○ |
| C-09 | Git user.nameを設定 | E-01 line 33: `git config --global user.name "GitHub Actions Bot"` | ○ |
| C-10 | Git user.emailを設定 | E-01 line 34: `git config --global user.email "actions@github.com"` | ○ |
| C-11 | git status -sを実行 | E-01 line 37: `git status -s` | ○ |
| C-12 | git add -Aを実行 | E-01 line 40: `git add -A` | ○ |
| C-13 | コミットメッセージ | E-01 line 41: `git commit -m "Wrapped latest changes in stdError sentries"` | ○ |
| C-14 | stdError-Wrappedブランチへforce-push | E-01 line 45: `git push --verbose origin +HEAD:stdError-Wrapped` | ○ |
| C-15 | バッチカテゴリがCI/CD | E-02: `"3","CI/CD","stdError_wrap.yml"` | ○ |
| C-16 | stdError-Wrappedブランチへforce-push（備考） | E-02: `"masterブランチへのpush時に実行、stdError-Wrappedブランチへforce-push"` | ○ |
| C-17 | Err.RaiseをErr_Raiseに置換 | E-03 line 127: `content = content.replace(/Err\.Raise/g, "Err_Raise")` | ○ |
| C-18 | stdError.getSentryを注入 | E-03 line 198-199: `With stdError.getSentry("${callstackName}"${paramsString})` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全項目にソースコードまたはバッチ一覧からの根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ワークフロー定義ファイルから直接確認可能な項目
- 1: 中リスク - force-pushを使用するため、stdError-Wrappedブランチの履歴が失われる
- 1: 中リスク - stdErrorライブラリへの依存があり、当該ライブラリの存在が前提

## 6) レビュアーチェックリスト（最小）
- [ ] stdError-Wrappedブランチをforce-pushで上書きすることの影響を理解しているか確認
- [ ] stdErrorライブラリがプロジェクトに含まれているか確認
- [ ] UDT（ユーザー定義型）、ParamArray、配列パラメータがラッパー処理から除外されていることを認識
