---
generated_at: 2026-01-15 10:25:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-VBA-stdError-Wrapper/main.js バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Tools/VBA-stdError-Wrapper/main.ts`（ソースコード）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義）
- E-03: `Tools/VBA-stdError-Wrapper/build.bat`（ビルドスクリプト）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | src/ディレクトリからファイル読み込み | E-01 line 111: `fs.readdirSync(__dirname + "/../../src")` | ○ |
| C-02 | ファイルのみをフィルタリング | E-01 line 112-114: `files.filter((f) => fs.lstatSync(...).isFile())` | ○ |
| C-03 | Err.RaiseをErr_Raiseに置換 | E-01 line 127: `content = content.replace(/Err\.Raise/g, "Err_Raise")` | ○ |
| C-04 | On Error GoTo 0をstdErrorWrapper_ErrorOccurredに置換 | E-01 line 128-131: `replace(/On Error GoTo 0/g, "On Error GoTo stdErrorWrapper_ErrorOccurred")` | ○ |
| C-05 | VB_Name属性からモジュール名取得 | E-01 line 122-124: `moduleNameFinder` | ○ |
| C-06 | UDT情報を抽出 | E-01 line 134-141: `udtFinder`正規表現 | ○ |
| C-07 | Public/Private/Friend関数を検出 | E-01 line 144-145: `functionFinder`正規表現 | ○ |
| C-08 | 条件付きコンパイル対応 | E-01 line 163-180: `conditionalCompilation`処理 | ○ |
| C-09 | コールスタック名生成 | E-01 line 183-184: `callstackName = moduleName + "#" + name + (!!access ? "[" + access + "]" : "")` | ○ |
| C-10 | UDTパラメータを除外 | E-01 line 192-193: `filter((p) => !p.isUDTParamType && !p.isParamArray && !p.isArray)` | ○ |
| C-11 | ParamArrayパラメータを除外 | E-01 line 192-193: `filter((p) => !p.isUDTParamType && !p.isParamArray && !p.isArray)` | ○ |
| C-12 | 配列パラメータを除外 | E-01 line 192-193: `filter((p) => !p.isUDTParamType && !p.isParamArray && !p.isArray)` | ○ |
| C-13 | stdError.getSentry注入 | E-01 line 198-199: `With stdError.getSentry("${callstackName}"${paramsString})` | ○ |
| C-14 | エラーハンドラ注入 | E-01 line 203-207: `injectorFooter`定義 | ○ |
| C-15 | Err_Raise関数をファイル末尾に追加 | E-01 line 221-225: `content += ...Err_Raise...` | ○ |
| C-16 | ファイル上書き保存 | E-01 line 228: `fs.writeFileSync(__dirname + "/../../src/" + file, content, "utf8")` | ○ |
| C-17 | バッチ一覧の説明と一致 | E-02: `"VBAソースコードにstdErrorラッパー処理を適用するNode.jsスクリプト"` | ○ |
| C-18 | parseParametersでパラメータ解析 | E-01 line 76-105: `parseParameters`関数定義 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全項目にソースコードまたはバッチ一覧からの根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - ソースファイルを直接上書きするため、バックアップなしでの実行に注意
- 1: 中リスク - stdErrorライブラリへの依存があり、当該ライブラリが必須
- 1: 中リスク - UDT、ParamArray、配列パラメータはラッパーから除外されるため、一部のパラメータがログに含まれない

## 6) レビュアーチェックリスト（最小）
- [ ] 変換後のVBAコードがstdErrorライブラリを参照可能な環境で実行されることを確認
- [ ] UDT、ParamArray、配列パラメータがラッパーから除外されることを認識
- [ ] 条件付きコンパイル（#If...#End If）の処理が意図通りか確認
