---
generated_at: 2026-01-15 10:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-VBALibraries Extract/VBALibraries.ahk バッチ設計書

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全項目に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `Tools/VBALibraries Extract/VBALibraries.ahk`（ソースコード）
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（バッチ一覧定義）
- E-03: `Tools/VBALibraries Extract/VBALibraries.json`（出力ファイル例）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | AutoHotkey 1.1.30.00で作成 | E-01 line 1: `;Written in AHK 1.1.30.00` | ○ |
| C-02 | libs/JSON.ahkをインクルード | E-01 line 4: `#Include libs\JSON.ahk` | ○ |
| C-03 | #SingleInstance, Force設定 | E-01 line 5: `#SingleInstance,Force` | ○ |
| C-04 | ListBox1, ListBox2のハンドル取得 | E-01 line 6-7: `ControlGet, lb1/lb2, hwnd,, ListBox1/ListBox2` | ○ |
| C-05 | RichEdit20A1のハンドル取得 | E-01 line 8: `ControlGet, txt1, hwnd,, RichEdit20A1` | ○ |
| C-06 | ComboBox1のハンドル取得 | E-01 line 9-10: `ControlGet, cb1/cb1_list` | ○ |
| C-07 | wndclass_desked_gskウィンドウクラス使用 | E-01 line 6: `ahk_class wndclass_desked_gsk` | ○ |
| C-08 | ライブラリをループ処理 | E-01 line 25-68: `While k < libCount` | ○ |
| C-09 | parseLibrary()でライブラリ情報パース | E-01 line 34, 110-119: `parseLibrary()` | ○ |
| C-10 | parseParent()で親オブジェクト情報パース | E-01 line 47, 80-95: `parseParent()` | ○ |
| C-11 | parseMember()でメンバー情報パース | E-01 line 59, 96-109: `parseMember()` | ○ |
| C-12 | JSON.stringify()でシリアライズ | E-01 line 71: `sJSON := JSON.stringify(libraries)` | ○ |
| C-13 | VBALibraries.jsonに出力 | E-01 line 72-73: `FileDelete/FileAppend...VBALibraries.json` | ○ |
| C-14 | 完了メッセージ表示 | E-01 line 75: `msgbox Exporting VBALibraries has complete` | ○ |
| C-15 | <globals>の特別処理 | E-01 line 84-87: `isGlobals`判定 | ○ |
| C-16 | バッチ一覧の説明と一致 | E-02: `"Excel VBEからライブラリ情報を抽出しJSONファイルに出力するAutoHotkeyスクリプト"` | ○ |

## 4) 不足情報（Unknown / Missing）
- なし。全項目にソースコードまたはバッチ一覧からの根拠が存在する。

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - Windows環境専用、AutoHotkeyのインストールが必要
- 1: 中リスク - Excel VBEの状態に依存するため、実行環境の準備が必要
- 0: 低リスク - 読み取り専用の操作であり、データ破損のリスクは低い

## 6) レビュアーチェックリスト（最小）
- [ ] AutoHotkey 1.1.30.00以上がインストールされていることを確認
- [ ] Excel VBEのオブジェクトブラウザーが開いていることを確認
- [ ] 出力されるVBALibraries.jsonの構造が期待通りか確認
