---
generated_at: 2026-01-15 19:00:00
metrics:
  claims_total: 190
  claims_with_evidence: 185
  claims_without_evidence: 5
confidence_derived: 0.97
---

# 根拠レポート：core.csv（単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：185 / 190、根拠なし：5
- 優先レビュー（高）
  1. **UT-CORE-098, UT-CORE-099**：stdLambdaのループ構文（for-next, do-while）の詳細実装確認が必要
  2. **UT-CORE-188, UT-CORE-189**：stdSentryの依存クラス（stdError）の存在前提確認が必要
  3. **UT-CORE-062**：CreateFromPointerのプラットフォーム依存性（Macでは未対応）の確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/route06/stdVBA-master/src/stdArray.cls` - stdArrayクラスの実装
- E-02: `/Users/tomokababa/Work/route06/stdVBA-master/src/stdCallback.cls` - stdCallbackクラスの実装
- E-03: `/Users/tomokababa/Work/route06/stdVBA-master/src/stdICallable.cls` - stdICallableインターフェースの定義
- E-04: `/Users/tomokababa/Work/route06/stdVBA-master/src/stdLambda.cls` - stdLambdaクラスの実装
- E-05: `/Users/tomokababa/Work/route06/stdVBA-master/src/stdEnumerator.cls` - stdEnumeratorクラスの実装
- E-06: `/Users/tomokababa/Work/route06/stdVBA-master/src/stdRegex.cls` - stdRegexクラスの実装
- E-07: `/Users/tomokababa/Work/route06/stdVBA-master/src/stdJSON.cls` - stdJSONクラスの実装
- E-08: `/Users/tomokababa/Work/route06/stdVBA-master/src/stdPerformance.cls` - stdPerformanceクラスの実装
- E-09: `/Users/tomokababa/Work/route06/stdVBA-master/src/stdSentry.cls` - stdSentryクラスの実装
- E-10: `/Users/tomokababa/Work/route06/stdVBA-master/tests/stdArrayTests.bas` - stdArrayの既存テスト
- E-11: `/Users/tomokababa/Work/route06/stdVBA-master/tests/stdCallbackTests.bas` - stdCallbackの既存テスト
- E-12: `/Users/tomokababa/Work/route06/stdVBA-master/tests/stdLambdaTests.bas` - stdLambdaの既存テスト
- E-13: `/Users/tomokababa/Work/route06/stdVBA-master/tests/stdEnumeratorTests.bas` - stdEnumeratorの既存テスト
- E-14: `/Users/tomokababa/Work/route06/stdVBA-master/tests/stdRegexTests.bas` - stdRegexの既存テスト

## 3) Claims と根拠の対応（レビューの主戦場）

### stdArray（UT-CORE-001 〜 UT-CORE-058）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Create関数でパラメータから配列が作成される | E-01 (line 148-163), E-10 | ○ |
| C-02 | CreateFromArray関数でVBA配列から変換される | E-01 (line 191-205), E-10 | ○ |
| C-03 | CreateFromCollection関数でCollectionから変換される | E-01 (line 211-218) | ○ |
| C-04 | CreateFromString関数で文字列分割される | E-01 (line 226-228) | ○ |
| C-05 | Push関数で要素が末尾に追加される | E-01 (line 428-450), E-10 | ○ |
| C-06 | Pop関数で末尾要素が削除・返却される | E-01 (line 454-473), E-10 | ○ |
| C-07 | Remove関数で指定インデックスの要素が削除される | E-01 (line 478-513) | ○ |
| C-08 | Shift関数で先頭要素が削除・返却される | E-01 (line 518-527) | ○ |
| C-09 | Unshift関数で要素が先頭に追加される | E-01 (line 532-558) | ○ |
| C-10 | Slice関数で指定範囲のスライスが取得できる | E-01 (line 564-587) | ○ |
| C-11 | Clone関数で配列が複製される | E-01 (line 653-673) | ○ |
| C-12 | Reverse関数で配列が逆順になる | E-01 (line 677-686) | ○ |
| C-13 | Concat関数で2つの配列が連結される | E-01 (line 691-703) | ○ |
| C-14 | Join関数で要素が区切り文字で連結される | E-01 (line 708-725), E-10 | ○ |
| C-15 | indexOf関数で要素のインデックスが返る | E-01 (line 752-783), E-10 | ○ |
| C-16 | lastIndexOf関数で最後の出現インデックスが返る | E-01 (line 788-819) | ○ |
| C-17 | includes関数で包含判定ができる | E-01 (line 825-827) | ○ |
| C-18 | Sort関数で配列がソートされる | E-01 (line 304-344), E-10 | ○ |
| C-19 | Map関数で全要素に関数が適用される | E-01 (line 904-923), E-10 | ○ |
| C-20 | Filter関数で条件に合う要素のみ抽出される | E-01 (line 1003-1021), E-10 | ○ |
| C-21 | Reduce関数で累積処理が行われる | E-01 (line 966-998), E-10 | ○ |
| C-22 | IsEvery関数で全一致判定ができる | E-01 (line 839-856), E-10 | ○ |
| C-23 | IsSome関数で部分一致判定ができる | E-01 (line 864-880), E-10 | ○ |
| C-24 | ForEach関数で反復処理ができる | E-01 (line 887-896), E-10 | ○ |
| C-25 | Unique関数で重複が除去される | E-01 (line 932-955) | ○ |
| C-26 | GroupBy関数でグループ化される | E-01 (line 1044-1065) | ○ |
| C-27 | Max関数で最大値要素が返る | E-01 (line 1071-1097) | ○ |
| C-28 | Min関数で最小値要素が返る | E-01 (line 1103-1129) | ○ |
| C-29 | Count関数で条件カウントが返る | E-01 (line 1026-1039) | ○ |
| C-30 | SplitToChunks関数でチャンク分割される | E-01 (line 596-603) | ○ |
| C-31 | Splice関数で要素の削除と挿入が行われる | E-01 (line 610-649) | ○ |
| C-32 | item プロパティで要素アクセスできる | E-01 (line 730-739) | ○ |
| C-33 | arr プロパティでVBA配列として取得できる | E-01 (line 398-422) | ○ |
| C-34 | AsCollection関数でCollectionに変換できる | E-01 (line 246-252) | ○ |
| C-35 | NewEnumプロパティでFor Each構文をサポート | E-01 (line 261-265) | ○ |
| C-36 | イベント（BeforeAdd, AfterAdd等）が発火する | E-01 (line 104-143) | ○ |

### stdCallback（UT-CORE-059 〜 UT-CORE-071）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-37 | CreateFromModule関数でモジュール関数からコールバック作成 | E-02 (line 205-209), E-11 | ○ |
| C-38 | CreateFromObjectMethod関数でオブジェクトメソッドからコールバック作成 | E-02 (line 228-232), E-11 | ○ |
| C-39 | CreateFromObjectProperty関数でオブジェクトプロパティからコールバック作成 | E-02 (line 240-244) | ○ |
| C-40 | CreateFromPointer関数で関数ポインタからコールバック作成 | E-02 (line 252-259) | ○ |
| C-41 | CreateFromWorkbookModule関数で外部ワークブックからコールバック作成 | E-02 (line 217-221) | ○ |
| C-42 | Run関数でコールバックが実行される | E-02 (line 367-371), E-11 | ○ |
| C-43 | RunEx関数で配列パラメータで実行できる | E-02 (line 376-519) | ○ |
| C-44 | Bind関数で引数をバインドした新しいコールバックが返る | E-02 (line 333-344), E-11 | ○ |
| C-45 | イベント（BeforeRun, AfterRun）が発火する | E-02 (line 169-174) | ○ |

### stdICallable（UT-CORE-072 〜 UT-CORE-076）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-46 | Runインターフェースメソッドが定義されている | E-03 (line 53) | ○ |
| C-47 | RunExインターフェースメソッドが定義されている | E-03 (line 58) | ○ |
| C-48 | Bindインターフェースメソッドが定義されている | E-03 (line 63) | ○ |
| C-49 | SendMessageインターフェースメソッドが定義されている | E-03 (line 72) | ○ |

### stdLambda（UT-CORE-077 〜 UT-CORE-099）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | Create関数で文字列式からLambdaが作成される | E-04 (line 226-237), E-12 | ○ |
| C-51 | CreateMultiline関数で複数行式からLambdaが作成される | E-04 (line 251-253) | ○ |
| C-52 | Run関数でLambdaが実行される | E-04 (line 301-309), E-12 | ○ |
| C-53 | 算術演算（+, -, *, /, ^, mod）がサポートされている | E-04 (line 114-120) | ○ |
| C-54 | 論理演算（and, or, not, xor）がサポートされている | E-04 (line 122-126) | ○ |
| C-55 | 比較演算（=, <>, >, >=, <, <=, like, is）がサポートされている | E-04 (line 132-140) | ○ |
| C-56 | プロパティアクセス・メソッド呼び出しがサポートされている | E-04 (line 154-158) | ○ |
| C-57 | 条件式（if-then-else-end）がサポートされている | E-04 (line 470-473) | ○ |
| C-58 | let式で変数定義がサポートされている | E-04 (line 465) | ○ |
| C-59 | Bind関数で引数バインドされたLambdaが返る | E-04 (line 330-341), E-12 | ○ |
| C-60 | BindGlobal関数でグローバル変数がバインドされる | E-04 (line 347-359) | ○ |
| C-61 | for-nextループがサポートされている | E-04 (line 481-486) | △ |
| C-62 | do-whileループがサポートされている | E-04 (line 476-480) | △ |

### stdEnumerator（UT-CORE-100 〜 UT-CORE-134）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | CreateFromIEnumVariant関数でIEnumVariantからEnumerator作成 | E-05 (line 294-297), E-13 | ○ |
| C-64 | CreateFromArray関数で配列からEnumerator作成 | E-05 (line 284-287), E-13 | ○ |
| C-65 | CreateFromCallable関数でCallableから動的Enumerator作成 | E-05 (line 263-266) | ○ |
| C-66 | CreateFromListObject関数でListObjectからEnumerator作成 | E-05 (line 314-351) | ○ |
| C-67 | CreateFromTree関数でツリー構造がフラット化される | E-05 (line 357-373) | ○ |
| C-68 | AsArray関数で配列に変換できる | E-05, E-13 | ○ |
| C-69 | AsCollection関数でCollectionに変換できる | E-05, E-13 | ○ |
| C-70 | Map関数で全要素に関数が適用される | E-05, E-13 | ○ |
| C-71 | Filter関数で条件に合う要素のみ抽出される | E-05, E-13 | ○ |
| C-72 | Reduce関数で累積処理が行われる | E-05, E-13 | ○ |
| C-73 | 各種集計関数（Max, Min, Sum, GroupBy等）がサポートされている | E-05 | ○ |
| C-74 | NewEnumプロパティでFor Each構文をサポート | E-05 (line 470-474) | ○ |

### stdRegex（UT-CORE-135 〜 UT-CORE-151）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | Create関数でパターンからRegexが作成される | E-06 (line 109-130), E-14 | ○ |
| C-76 | Test関数でマッチ判定ができる | E-06 (line 286-293), E-14 | ○ |
| C-77 | Match関数で最初のマッチが取得できる | E-06 (line 297+), E-14 | ○ |
| C-78 | 名前付きキャプチャ（?<name>）がサポートされている | E-06 (line 152-168) | ○ |
| C-79 | MatchAll関数で全マッチが取得できる | E-06, E-14 | ○ |
| C-80 | Replace関数でマッチ箇所が置換される | E-06, E-14 | ○ |
| C-81 | List関数でテンプレート展開されたリストが返る | E-06 | ○ |
| C-82 | フラグ（i, g, m, x, s）がサポートされている | E-06 (line 206-222) | ○ |

### stdJSON（UT-CORE-152 〜 UT-CORE-170）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | Create関数で空のJSONオブジェクト/配列が作成される | E-07 (line 106-109) | ○ |
| C-84 | CreateFromString関数でJSON文字列からオブジェクト作成 | E-07 (line 126-141) | ○ |
| C-85 | CreateFromFile関数でファイルからJSON読み込み | E-07 (line 148-155) | ○ |
| C-86 | CreateFromVariant関数でVBA配列/DictionaryからJSON作成 | E-07 (line 161-164) | ○ |
| C-87 | Add関数でキーと値が追加される | E-07 (line 266-275) | ○ |
| C-88 | AddObject/AddArray関数でネスト構造が追加される | E-07 (line 284-300) | ○ |
| C-89 | ToString関数でJSON文字列に変換される | E-07 | ○ |

### stdPerformance（UT-CORE-171 〜 UT-CORE-178）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-90 | CreateMeasure関数で測定オブジェクトが作成される | E-08 (line 158-160) | ○ |
| C-91 | Withブロック終了時に測定が記録される | E-08 (line 267-272) | ○ |
| C-92 | CreateOptimiser関数で最適化オブジェクトが作成される | E-08 (line 175-177) | ○ |
| C-93 | Withブロック終了時に設定が復元される | E-08 (line 273-287) | ○ |
| C-94 | Measurementプロパティで測定値が取得できる | E-08 (line 196-205) | ○ |

### stdSentry（UT-CORE-179 〜 UT-CORE-190）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | Create関数でSentryファクトリが作成される | E-09 (line 118-121) | ○ |
| C-96 | Run関数でSentryが実行される | E-09 (line 269-286) | ○ |
| C-97 | Withブロック終了時にOnDestroyが実行される | E-09 | ○ |
| C-98 | CreateOptimiser関数で最適化Sentryが作成される | E-09 (line 135-163) | ○ |
| C-99 | CreateFromObjectProperty関数でプロパティSentryが作成される | E-09 (line 177-189) | ○ |
| C-100 | CreateFromObjectMethod関数でメソッドSentryが作成される | E-09 (line 203-208) | ○ |
| C-101 | CreateErrorStack関数でエラースタックSentryが作成される | E-09 (line 222-225) | △ |
| C-102 | CreateFromAutomationSecurity関数でセキュリティSentryが作成される | E-09 (line 237-239) | △ |
| C-103 | Bind関数で引数がバインドされる | E-09 (line 291-300) | ○ |

## 4) 不足情報（Unknown / Missing）

### 根拠なしの理由
1. **UT-CORE-098, UT-CORE-099（for-next, do-whileループ）**
   - stdLambdaにループ構文のサポートは記述されているが、詳細な動作確認のための既存テストが見つからない
   - 候補：stdLambdaTests.bas内の追加テスト確認 / docs.jsonのドキュメント確認

2. **UT-CORE-188（CreateErrorStack）**
   - stdErrorクラスの存在が前提だが、srcディレクトリにはWIP版のみ存在
   - 候補：/src/WIP/stdError.cls または /src/WIP/stdError/stdError.cls

3. **UT-CORE-189（CreateFromAutomationSecurity）**
   - MsoAutomationSecurity列挙型はMicrosoft Office固有であり、他の環境での動作は未確認
   - 候補：Office以外のホスト環境での動作確認

4. **UT-CORE-062（CreateFromPointer）**
   - Macプラットフォームでは関数ポインタ呼び出しが未対応（ソースコード内にコメントあり）
   - 候補：Mac環境でのテストスキップまたは代替実装

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 2: 高リスク | stdLambdaのループ構文 | 複雑な制御フローで予期しない動作の可能性 |
| 1: 中リスク | stdSentryの依存クラス | stdError, stdCallbackへの依存があり、環境によっては動作しない |
| 1: 中リスク | プラットフォーム依存機能 | CreateFromPointer等、Windows専用機能が存在 |
| 0: 低リスク | 基本的な配列操作（stdArray） | 十分なテストカバレッジと実績あり |
| 0: 低リスク | 基本的なコールバック（stdCallback） | 十分なテストカバレッジと実績あり |

## 6) レビュアーチェックリスト（最小）

- [ ] stdArrayの基本操作（Push, Pop, Map, Filter, Reduce）のテストケースが網羅されているか
- [ ] stdCallbackの各種Create関数のテストケースが適切か
- [ ] stdLambdaの演算子・制御構文のテストケースが十分か
- [ ] stdEnumeratorの遅延評価（Callable）パターンのテストケースが適切か
- [ ] stdRegexの名前付きキャプチャのテストケースが適切か
- [ ] stdJSONのネスト構造のパース/シリアライズのテストケースが十分か
- [ ] stdPerformance/stdSentryのWithブロック終了時の動作確認が含まれているか
- [ ] プラットフォーム依存機能（Mac/Windows）の注記が適切か
- [ ] 既存テストファイル（tests/*.bas）との整合性が取れているか
