---
generated_at: 2026-01-15 20:15:00
metrics:
  claims_total: 130
  claims_with_evidence: 125
  claims_without_evidence: 5
confidence_derived: 0.96
---

# 根拠レポート：単体テストケース一覧 (io)

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード上のメソッド・プロパティ定義が存在するか
2. **根拠との整合性**：テストケースの入力値・期待結果がソースコードの実装と整合しているか
3. **網羅性**：クラスの公開メソッド・プロパティが適切にカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：125 / 130、根拠なし：5
- 優先レビュー（高）
  1. **stdImage::ToClipboard**：Excel依存の実装のため環境によって動作が異なる可能性
  2. **stdSentry::BindEx**：TODO コメントがあり未実装
  3. **stdImage::ToDataUrl**：未実装（Err.Raise 1, , "Not implemented"）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/stdClipboard.cls` - クリップボード操作クラス（999行）
- E-02: `src/stdReg.cls` - レジストリ操作クラス（576行）
- E-03: `src/stdImage.cls` - 画像処理クラス（1444行）
- E-04: `src/stdSentry.cls` - センチネルパターン実装クラス（370行）
- E-05: `tests/stdClipboardTests.bas` - 既存テストコード（74行）
- E-06: `tests/stdSentryTests.bas` - 既存テストコード（77行）

## 3) Claims と根拠の対応（レビューの主戦場）

### stdClipboard (UT-IO-001 〜 UT-IO-032)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ClipboardID プロパティが存在する | E-01 (L219-221) | ○ |
| C-02 | value プロパティ [GET] が存在する | E-01 (L226-262) | ○ |
| C-03 | value プロパティ [LET] が存在する | E-01 (L263-313) | ○ |
| C-04 | Await メソッドが存在する | E-01 (L316-321) | ○ |
| C-05 | Clear メソッドが存在する | E-01 (L324-328) | ○ |
| C-06 | text プロパティ [GET/LET] が存在する | E-01 (L335-340) | ○ |
| C-07 | IsFormatAvailable メソッドが存在する | E-01 (L346-358) | ○ |
| C-08 | FormatSize メソッドが存在する | E-01 (L364-372) | ○ |
| C-09 | RegisterFormat メソッドが存在する | E-01 (L398-400) | ○ |
| C-10 | formats プロパティが存在する | E-01 (L405-421) | ○ |
| C-11 | formatIDs プロパティが存在する | E-01 (L426-442) | ○ |
| C-12 | Picture プロパティが存在する | E-01 (L446-472) | ○ |
| C-13 | files プロパティが存在する | E-01 (L503-517) | ○ |
| C-14 | SetFilesArr メソッドが存在する | E-01 (L521-528) | ○ |
| C-15 | protGetFilesArr メソッドが存在する | E-01 (L581-610) | ○ |
| C-16 | SendPaste メソッドが存在する | E-01 (L616-622) | ○ |
| C-17 | SendCopy メソッドが存在する | E-01 (L627-633) | ○ |
| C-18 | GetClipFormatFromCopyPictureFormat メソッドが存在する | E-01 (L644-653) | ○ |
| C-19 | CriticalRaise によるエラーハンドリング | E-01 (L690-699) | ○ |
| C-20 | Win32 API を使用したクリップボード操作 | E-01 (L93-168) | ○ |

### stdReg (UT-IO-033 〜 UT-IO-062)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | Create コンストラクタが存在する | E-02 (L177-180) | ○ |
| C-22 | CreateFromKey コンストラクタが存在する | E-02 (L188-191) | ○ |
| C-23 | CreateFromItem コンストラクタが存在する | E-02 (L199-202) | ○ |
| C-24 | protInit による初期化処理 | E-02 (L210-294) | ○ |
| C-25 | name プロパティが存在する | E-02 (L303-309) | ○ |
| C-26 | RegType プロパティが存在する | E-02 (L313-315) | ○ |
| C-27 | isRoot プロパティが存在する | E-02 (L319-321) | ○ |
| C-28 | path プロパティが存在する | E-02 (L325-327) | ○ |
| C-29 | Parent プロパティが存在する | E-02 (L331-339) | ○ |
| C-30 | children プロパティが存在する | E-02 (L349-356) | ○ |
| C-31 | Keys プロパティが存在する | E-02 (L361-379) | ○ |
| C-32 | Items プロパティが存在する | E-02 (L384-402) | ○ |
| C-33 | ItemType プロパティが存在する | E-02 (L411-417) | ○ |
| C-34 | value プロパティ [GET] が存在する | E-02 (L424-492) | ○ |
| C-35 | value プロパティ [LET] が存在する | E-02 (L493-495) | ○ |
| C-36 | SetValue メソッドが存在する | E-02 (L500-537) | ○ |
| C-37 | 各レジストリ値型のサポート | E-02 (L86-98) | ○ |
| C-38 | Class_Terminate によるリソース解放 | E-02 (L573-575) | ○ |

### stdImage (UT-IO-063 〜 UT-IO-107)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | CreateFromFile コンストラクタが存在する | E-03 (L542-587) | ○ |
| C-40 | CreateFromBinary コンストラクタが存在する | E-03 (L425-486) | ○ |
| C-41 | CreateFromDataURL コンストラクタが存在する | E-03 (L497-532) | ○ |
| C-42 | CreateFromUrl コンストラクタが存在する | E-03 (L598-613) | ○ |
| C-43 | CreateFromHBitmap コンストラクタが存在する | E-03 (L622-630) | ○ |
| C-44 | CreateFromClipboard コンストラクタが存在する | E-03 (L638-653) | ○ |
| C-45 | CreateFromIPictureDisp コンストラクタが存在する | E-03 (L660-662) | ○ |
| C-46 | CreateFromStdPicture コンストラクタが存在する | E-03 (L671-673) | ○ |
| C-47 | CreateFromScreen コンストラクタが存在する | E-03 (L733-746) | ○ |
| C-48 | CreateFromWindow コンストラクタが存在する | E-03 (L759-817) | ○ |
| C-49 | CreateFromHICON コンストラクタが存在する | E-03 (L828-865) | ○ |
| C-50 | CreateFromShape コンストラクタが存在する | E-03 (L701-708) | ○ |
| C-51 | CreateFromChart コンストラクタが存在する | E-03 (L717-724) | ○ |
| C-52 | Crop メソッドが存在する | E-03 (L871-915) | ○ |
| C-53 | hBitmap プロパティが存在する | E-03 (L929-931) | ○ |
| C-54 | HICON プロパティが存在する | E-03 (L934-943) | ○ |
| C-55 | Colors プロパティが存在する | E-03 (L947-979) | ○ |
| C-56 | width/height プロパティが存在する | E-03 (L984-985) | ○ |
| C-57 | ToFile メソッドが存在する | E-03 (L1008-1089) | ○ |
| C-58 | ToClipboard メソッドが存在する | E-03 (L1093-1109) | ○ |
| C-59 | ToTempFile メソッドが存在する | E-03 (L1115-1127) | ○ |
| C-60 | ToStdPicture メソッドが存在する | E-03 (L1171-1187) | ○ |
| C-61 | FindFirst メソッドが存在する | E-03 (L1336-1378) | ○ |
| C-62 | FindAll メソッドが存在する | E-03 (L1389-1432) | ○ |
| C-63 | ToDataUrl が未実装 | E-03 (L1151-1154) | ○ |
| C-64 | GDI+ API を使用した画像処理 | E-03 (L185-212) | ○ |

### stdSentry (UT-IO-108 〜 UT-IO-130)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-65 | Create コンストラクタが存在する | E-04 (L118-121) | ○ |
| C-66 | CreateOptimiser コンストラクタが存在する | E-04 (L135-163) | ○ |
| C-67 | CreateFromObjectProperty コンストラクタが存在する | E-04 (L177-189) | ○ |
| C-68 | CreateFromObjectMethod コンストラクタが存在する | E-04 (L203-208) | ○ |
| C-69 | CreateErrorStack コンストラクタが存在する | E-04 (L222-225) | ○ |
| C-70 | CreateFromAutomationSecurity コンストラクタが存在する | E-04 (L237-239) | ○ |
| C-71 | Run メソッドが存在する | E-04 (L269-273) | ○ |
| C-72 | RunEx メソッドが存在する | E-04 (L278-286) | ○ |
| C-73 | Bind メソッドが存在する | E-04 (L291-294) | ○ |
| C-74 | BindEx メソッドが TODO | E-04 (L299-302) | △ |
| C-75 | SendMessage メソッドが存在する | E-04 (L311-328) | ○ |
| C-76 | Class_Terminate による OnDestroy 呼び出し | E-04 (L331-341) | ○ |
| C-77 | stdICallable インターフェース実装 | E-04 (L355-367) | ○ |
| C-78 | 既存テストで動作確認済み | E-06 | ○ |

### 未実装・制限事項に関する主張

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-79 | stdClipboard::protSetFilesText は Win64 で未実装 | E-01 (L534-537) | △ |
| C-80 | stdImage::ToDataUrl は未実装 | E-03 (L1151-1154) | △ |
| C-81 | stdSentry::BindEx は TODO | E-04 (L301) | △ |
| C-82 | stdReg の Value_DWORD_BE は TODO | E-02 (L440-442) | △ |

## 4) 不足情報（Unknown / Missing）
- **stdImage::ToClipboard** の実装詳細が Excel 固有のため、他の Office アプリケーションでの動作が不明
  - 候補：Word / PowerPoint / Access での動作確認が必要
- **stdReg** の書き込みテストは実際のレジストリを変更するため、テスト環境の考慮が必要
  - 候補：モック / サンドボックス環境 / 仮想レジストリの使用

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 大部分のテストケースはソースコード上の公開メソッド/プロパティに基づいており、根拠が明確
- **1 (中リスク)**: 一部の機能（Win64対応、未実装機能）については制限事項の確認が必要
- **2 (高リスク)**: レジストリ操作のテストは実環境への影響を考慮する必要あり

## 6) レビュアーチェックリスト（最小）
- [ ] stdClipboard のクリップボード操作テストがテスト環境で実行可能か確認
- [ ] stdReg のテストケースがテスト用レジストリキーを使用しているか確認
- [ ] stdImage の画像形式テストに必要なサンプル画像が用意されているか確認
- [ ] stdSentry のネストテストが正しい順序で復元されることを確認
- [ ] Win64 環境での制限事項（stdClipboard::protSetFilesText）が適切にスキップされるか確認
- [ ] 未実装機能（ToDataUrl, BindEx, Value_DWORD_BE）のテストケースが適切にスキップまたはエラーハンドリングされるか確認

## 付録：クラス別メソッド・プロパティ一覧

### stdClipboard
| 種別 | 名前 | テストケース数 |
|------|------|---------------|
| Property | ClipboardID | 2 |
| Property | value | 7 |
| Sub | Await | 1 |
| Sub | Clear | 1 |
| Property | text | 2 |
| Function | IsFormatAvailable | 3 |
| Function | FormatSize | 2 |
| Function | RegisterFormat | 1 |
| Property | formats | 1 |
| Property | formatIDs | 1 |
| Property | Picture | 3 |
| Property | files | 2 |
| Sub | SetFilesArr | 1 |
| Function | protGetFilesArr | 1 |
| Sub | SendPaste | 1 |
| Sub | SendCopy | 1 |
| Function | GetClipFormatFromCopyPictureFormat | 2 |

### stdReg
| 種別 | 名前 | テストケース数 |
|------|------|---------------|
| Function | Create | 4 |
| Function | CreateFromKey | 1 |
| Function | CreateFromItem | 1 |
| Property | name | 2 |
| Property | RegType | 1 |
| Property | isRoot | 2 |
| Property | path | 1 |
| Property | Parent | 2 |
| Property | children | 1 |
| Property | Keys | 2 |
| Property | Items | 2 |
| Property | ItemType | 2 |
| Property | value | 7 |
| Sub | SetValue | 1 |

### stdImage
| 種別 | 名前 | テストケース数 |
|------|------|---------------|
| Function | CreateFromFile | 7 |
| Function | CreateFromBinary | 2 |
| Function | CreateFromDataURL | 2 |
| Function | CreateFromUrl | 2 |
| Function | CreateFromHBitmap | 2 |
| Function | CreateFromClipboard | 2 |
| Function | CreateFromIPictureDisp | 1 |
| Function | CreateFromStdPicture | 1 |
| Function | CreateFromScreen | 1 |
| Function | CreateFromWindow | 3 |
| Function | CreateFromHICON | 1 |
| Function | CreateFromShape | 1 |
| Function | CreateFromChart | 1 |
| Function | Crop | 1 |
| Property | hBitmap | 1 |
| Property | HICON | 2 |
| Property | Colors | 1 |
| Property | width | 1 |
| Property | height | 1 |
| Sub | ToFile | 4 |
| Sub | ToClipboard | 1 |
| Function | ToTempFile | 1 |
| Function | ToStdPicture | 1 |
| Function | FindFirst | 3 |
| Function | FindAll | 2 |

### stdSentry
| 種別 | 名前 | テストケース数 |
|------|------|---------------|
| Function | Create | 3 |
| Function | CreateOptimiser | 6 |
| Function | CreateFromObjectProperty | 2 |
| Function | CreateFromObjectMethod | 1 |
| Function | CreateErrorStack | 2 |
| Function | CreateFromAutomationSecurity | 1 |
| Function | Run | 1 |
| Function | RunEx | 1 |
| Function | Bind | 1 |
| Function | SendMessage | 3 |
| Sub | Class_Terminate | 1 |
| その他 | ネスト動作 | 1 |
