---
generated_at: 2026-01-15 19:30:00
metrics:
  claims_total: 98
  claims_with_evidence: 95
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート: network モジュール 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim: 主張）を検証しています:

1. **根拠の有無確認**: 各テストケースに対して、ソースコード内のメソッド・プロパティ定義などの根拠（Evidence）が存在するか
2. **根拠との整合性**: テストケースの内容が根拠と矛盾していないか
3. **網羅性**: 参照すべきメソッド・プロパティを適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」: 根拠あり、「△」: 根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）: **0.97**
  - 根拠あり: 95 / 98、根拠なし: 3
- 優先レビュー（高）
  1. **UT-NET-057/058**: WinRT活性化テスト - 実行環境依存のため実際のテスト可否要確認
  2. **UT-NET-039-052**: WebSocket関連 - Internet Explorer依存のため動作環境に制約あり
  3. **UT-NET-061/062**: PropertyStore関連 - ファイルシステム依存のテスト

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/route06/stdVBA-master/src/stdHTTP.cls` (769行)
- E-02: `/Users/tomokababa/Work/route06/stdVBA-master/src/stdWebSocket.cls` (169行)
- E-03: `/Users/tomokababa/Work/route06/stdVBA-master/src/stdCOM.cls` (1294行)
- E-04: `/Users/tomokababa/Work/route06/stdVBA-master/docs/code-to-docs/単体テストケース一覧/plan.md` (plan.md内グループ7定義)

## 3) Claims と根拠の対応（レビューの主戦場）

### stdHTTP クラス (UT-NET-001 - UT-NET-038)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Create メソッドでHTTPリクエストが作成できる | E-01 L289-292 | ○ |
| C-02 | CreateHeaders でヘッダーDictionaryが作成できる | E-01 L298-309 | ○ |
| C-03 | CreateOptions でオプションDictionaryが作成できる | E-01 L322-355 | ○ |
| C-04 | CreateProxy でプロキシ設定が作成できる | E-01 L365-387 | ○ |
| C-05 | Await で非同期リクエストを待機できる | E-01 L391-402 | ○ |
| C-06 | isFinished でリクエスト完了状態を確認できる | E-01 L406-418 | ○ |
| C-07 | ResponseStatus でステータスコードを取得できる | E-01 L422-428 | ○ |
| C-08 | ResponseStatusText でステータステキストを取得できる | E-01 L432-442 | ○ |
| C-09 | ResponseText でレスポンステキストを取得できる | E-01 L446-448 | ○ |
| C-10 | ResponseBody でレスポンスボディを取得できる | E-01 L452-454 | ○ |
| C-11 | ResponseHeader で特定ヘッダーを取得できる | E-01 L459-465 | ○ |
| C-12 | ResponseHeaders で全ヘッダーを取得できる | E-01 L469-471 | ○ |
| C-13 | ResponseMapped でマッピング結果を取得できる | E-01 L474-478 | ○ |
| C-14 | ResponseMapper プロパティでマッパーを設定/取得できる | E-01 L481-486 | ○ |
| C-15 | URIEncode でURI文字列をエンコードできる | E-01 L566-585 | ○ |
| C-16 | URIDecode でURI文字列をデコードできる | E-01 L590-603 | ○ |
| C-17 | protInit で内部初期化が行われる | E-01 L495-545 | ○ |
| C-18 | EHTTPSynchronisity enum が定義されている | E-01 L79-82 | ○ |
| C-19 | EHTTPContentType enum が定義されている | E-01 L83-91 | ○ |
| C-20 | EHTTPProxyType enum が定義されている | E-01 L92-96 | ○ |
| C-21 | タイムアウト処理が実装されている | E-01 L394-398 | ○ |

### stdWebSocket クラス (UT-NET-039 - UT-NET-052)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 | Create でWebSocketオブジェクトが作成できる | E-02 L67-70 | ○ |
| C-23 | protInit で内部初期化が行われる | E-02 L78-119 | ○ |
| C-24 | url プロパティでURLを取得できる | E-02 L123-125 | ○ |
| C-25 | Send でデータを送信できる | E-02 L129-131 | ○ |
| C-26 | CloseSocket で接続を閉じられる | E-02 L136-138 | ○ |
| C-27 | Disconnect で完全に切断できる | E-02 L141-145 | ○ |
| C-28 | handleEvent でイベントを処理できる | E-02 L152-167 | ○ |
| C-29 | OnOpen イベントが定義されている | E-02 L43 | ○ |
| C-30 | OnClose イベントが定義されている | E-02 L46 | ○ |
| C-31 | OnError イベントが定義されている | E-02 L50 | ○ |
| C-32 | OnMessage イベントが定義されている | E-02 L55 | ○ |
| C-33 | EventRaised イベントが定義されている | E-02 L39 | ○ |
| C-34 | Listeners コレクションが定義されている | E-02 L60 | ○ |

### stdCOM クラス (UT-NET-053 - UT-NET-098)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | Create でオブジェクトからstdCOMが作成できる | E-03 L577-580 | ○ |
| C-36 | CreateFromPtr でポインタからstdCOMが作成できる | E-03 L589-596 | ○ |
| C-37 | CreateFromActiveObjects でROTからオブジェクトを取得できる | E-03 L603-655 | ○ |
| C-38 | CreateFromWinRTClassID でWinRTクラスを活性化できる | E-03 L664-677 | ○ |
| C-39 | CreateFromClassAndIID でCLSID/IIDからオブジェクトを作成できる | E-03 L688-697 | ○ |
| C-40 | CreatePropertyStoreFromFile でPropertyStoreを取得できる | E-03 L708-717 | ○ |
| C-41 | Object プロパティでIUnknownを取得できる | E-03 L731-737 | ○ |
| C-42 | AsObject プロパティでIDispatchを取得できる | E-03 L748-754 | ○ |
| C-43 | Pointer プロパティでポインタを取得できる | E-03 L758-768 | ○ |
| C-44 | unkQueryInterface でインターフェースを取得できる | E-03 L780-801 | ○ |
| C-45 | unkAddRef で参照カウントを増加できる | E-03 L804-806 | ○ |
| C-46 | unkRelease で参照カウントを減少できる | E-03 L809-811 | ○ |
| C-47 | QueryKnownInterface で既知インターフェースを取得できる | E-03 L817-826 | ○ |
| C-48 | TypeInfo で型情報を取得できる | E-03 L834-851 | ○ |
| C-49 | InterfaceInfo でインターフェース情報を取得できる | E-03 L855-914 | ○ |
| C-50 | Methods でメソッド一覧を取得できる | E-03 L918-930 | ○ |
| C-51 | Properties でプロパティ一覧を取得できる | E-03 L940-966 | ○ |
| C-52 | RegisterActiveObject でROTに登録できる | E-03 L971-973 | ○ |
| C-53 | RevokeActiveObject でROT登録を解除できる | E-03 L976-978 | ○ |
| C-54 | PropertyStore_GetCount でプロパティ数を取得できる | E-03 L983-985 | ○ |
| C-55 | PropertyStore_GetAt でプロパティを取得できる | E-03 L991-993 | ○ |
| C-56 | PropertyStore_GetValue でプロパティ値を取得できる | E-03 L1000-1005 | ○ |
| C-57 | PropertyStore_SetValue でプロパティ値を設定できる | E-03 L1012-1017 | ○ |
| C-58 | PropertyStore_Commit で変更をコミットできる | E-03 L1021-1023 | ○ |
| C-59 | CallVT でVTableメソッドを呼び出せる | E-03 L1040-1075 | ○ |
| C-60 | protInitFromObject でオブジェクトから初期化できる | E-03 L1083-1086 | ○ |
| C-61 | protInitFromPtr でポインタから初期化できる | E-03 L1092-1095 | ○ |
| C-62 | Class_Terminate でリソースが解放される | E-03 L1099-1106 | ○ |
| C-63 | EKnownInterfaces enum が定義されている | E-03 L238-302 | ○ |
| C-64 | EIUnknown enum が定義されている | E-03 L316-320 | ○ |
| C-65 | EIDispatch enum が定義されている | E-03 L330-338 | ○ |
| C-66 | WinRT関連テストの実行環境依存性 | **根拠なし** | △ |
| C-67 | PropertyStore関連テストのファイルシステム依存性 | **根拠なし** | △ |
| C-68 | ROT列挙テストの環境依存性 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **実行環境依存性**: WinRT、PropertyStore、ROT関連のテストは実行環境に依存するため、すべての環境で実行可能とは限らない
  - 候補: 環境チェックをテスト前提条件に追加 / モック化 / 統合テストとして分離
- **Internet Explorer依存**: stdWebSocketはInternetExplorer.Applicationを使用しているため、IE非対応環境では動作しない
  - 候補: 代替WebSocketライブラリの検討 / テストスキップ条件の追加

## 5) リスクフラグ（レビュー観点）
- **2（高リスク）**: stdWebSocket - Internet Explorer依存のため、Windows 11以降でのサポート終了に注意
- **1（中リスク）**: stdCOM WinRT関連 - Windows 10以降でのみ動作、バージョン依存性あり
- **1（中リスク）**: stdHTTP プロキシ関連 - ネットワーク環境に依存したテスト
- **0（低リスク）**: stdHTTP URI encode/decode - 純粋な文字列処理のためリスク低い

## 6) レビュアーチェックリスト（最小）
- [ ] stdHTTP: Create メソッドの各オプション（同期/非同期、メソッド、タイムアウト）が網羅されているか
- [ ] stdHTTP: URIEncode/Decodeの境界値テストが十分か（空文字、マルチバイト文字等）
- [ ] stdWebSocket: IE依存の記述がテスト前提条件に明記されているか
- [ ] stdWebSocket: 各イベント（Open/Close/Error/Message）のテストが網羅されているか
- [ ] stdCOM: QueryInterface関連のエラーケースが十分にカバーされているか
- [ ] stdCOM: PropertyStore関連のテストが実行可能な環境要件が明記されているか
- [ ] 全体: 優先度「高」のテストケースが重要なビジネスロジックをカバーしているか

## 7) 解析対象ファイル一覧

| ファイル | 行数 | 主な機能 |
|---------|------|----------|
| stdHTTP.cls | 769行 | HTTP通信（WinHTTP）、URI encode/decode、プロキシ設定 |
| stdWebSocket.cls | 169行 | WebSocket通信（IE経由）、イベント処理 |
| stdCOM.cls | 1294行 | COMオブジェクトラッパー、VTable呼び出し、ROT操作、PropertyStore |

## 8) テストケース分類

### stdHTTP.cls (38件)
- 正常系: 25件
- 異常系: 6件
- 境界値: 3件
- Enum確認: 4件

### stdWebSocket.cls (14件)
- 正常系: 14件
- 異常系: 0件
- 境界値: 0件

### stdCOM.cls (46件)
- 正常系: 38件
- 異常系: 5件
- 境界値: 0件
- Enum確認: 3件

## 9) 備考

1. **VBAの制約**: VBAには標準的なテストフレームワークがないため、テスト実行には別途テストハーネスの構築が必要
2. **Win32 API依存**: stdHTTPおよびstdCOMはWin32 APIに強く依存しているため、Macでは動作しない（`#If Mac Then`による条件分岐あり）
3. **64bit/32bit対応**: コードは`#If Win64 Then`による条件分岐で両アーキテクチャに対応しているが、テストは両環境で実施することを推奨
