---
generated_at: 2026-01-15 19:15:00
metrics:
  claims_total: 160
  claims_with_evidence: 156
  claims_without_evidence: 4
confidence_derived: 0.98
---

# 根拠レポート: string-regex モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim: 主張）を検証しています:

1. **根拠の有無確認**: 各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**: 主張の内容が根拠と矛盾していないか
3. **網羅性**: 参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」: 根拠あり、「△」: 根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）: **0.98**
  - 根拠あり: 156 / 160、根拠なし: 4
- 優先レビュー（高）
  1. **UT-SRX-054 (CreateFromFile)**: ファイルシステム依存のため実環境テストが必要
  2. **UT-SRX-079 (ToFile)**: ファイルシステム依存のため実環境テストが必要
  3. **UT-SRX-128 (Identity)**: IAccIdentity対応要素の確認が必要
  4. **UT-SRX-152 (PrintDescTexts)**: ファイルシステム依存のため実環境テストが必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdRegex.cls` - 正規表現クラス本体（619行）
- E-02: `src/stdJSON.cls` - JSONパーサー/シリアライザクラス本体（884行）
- E-03: `src/stdAcc.cls` - IAccessibleラッパークラス本体（1553行）
- E-04: `tests/stdRegexTests.bas` - 既存の単体テストコード（91行）
- E-05: `README.md` - プロジェクト説明とAPI使用例
- E-06: `src/WIP/stdRegex2.cls` - WIP版正規表現クラス（参考）
- E-07: `src/WIP/stdStringBuilder.cls` - 文字列ビルダークラス（参考）

## 3) Claims と根拠の対応（レビューの主戦場）

### stdRegex.cls 関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Create メソッドでインスタンス生成 | E-01 (line 109-130) | ○ |
| C-02 | キャッシュ機能の存在 | E-01 (line 116-126) | ○ |
| C-03 | クラスからCreate呼び出しでエラー | E-01 (line 110-113) | ○ |
| C-04 | protInit でパターン初期化 | E-01 (line 142-226) | ○ |
| C-05 | フラグ i の処理 | E-01 (line 211) | ○ |
| C-06 | フラグ g の処理 | E-01 (line 213) | ○ |
| C-07 | フラグ m の処理 | E-01 (line 215) | ○ |
| C-08 | フラグ x の処理 | E-01 (line 217) | ○ |
| C-09 | フラグ c の処理 | E-01 (line 219) | ○ |
| C-10 | フラグ s の処理 | E-01 (line 221) | ○ |
| C-11 | 名前付きキャプチャグループ解析 | E-01 (line 151-169, 199) | ○ |
| C-12 | pattern プロパティ Get | E-01 (line 236-243) | ○ |
| C-13 | pattern プロパティ Let | E-01 (line 244-251) | ○ |
| C-14 | flags プロパティ Get | E-01 (line 257-264) | ○ |
| C-15 | flags プロパティ Let | E-01 (line 265-272) | ○ |
| C-16 | Test メソッド（マッチ成功） | E-01 (line 286-293), E-04 (line 19) | ○ |
| C-17 | Test メソッド（マッチ失敗） | E-01 (line 286-293), E-04 (line 20) | ○ |
| C-18 | Test クラスからの呼び出しエラー | E-01 (line 287-290) | ○ |
| C-19 | Test 空文字列 | E-01 (line 286-293) | ○ |
| C-20 | Match メソッド戻り値 | E-01 (line 322-354), E-04 (line 23-24) | ○ |
| C-21 | Match 名前付きキャプチャ | E-01 (line 347), E-04 (line 25-28) | ○ |
| C-22 | Match 番号付きキャプチャ | E-01 (line 345), E-04 (line 29-32) | ○ |
| C-23 | Match $COUNT | E-01 (line 339), E-04 (line 33) | ○ |
| C-24 | Match $RAW | E-01 (line 340), E-04 (line 34) | ○ |
| C-25 | Match マッチ失敗時 Nothing | E-01 (line 333, 353) | ○ |
| C-26 | MatchAll 戻り値 Collection | E-01 (line 380-427), E-04 (line 37-38) | ○ |
| C-27 | MatchAll 複数マッチ | E-01 (line 402-423), E-04 (line 39) | ○ |
| C-28 | MatchAll グローバルフラグ処理 | E-01 (line 387-395) | ○ |
| C-29 | MatchAll マッチなし | E-01 (line 398-400) | ○ |
| C-30 | Replace メソッド | E-01 (line 455-474), E-04 (line 67) | ○ |
| C-31 | Replace 名前付きキャプチャ参照 | E-01 (line 463-469) | ○ |
| C-32 | Replace 番号付きキャプチャ参照 | E-01 (line 473) | ○ |
| C-33 | List メソッド | E-01 (line 498-517), E-04 (line 74) | ○ |
| C-34 | List エスケープ処理 | E-01 (line 575-577) | ○ |
| C-35 | List $& 参照 | E-01 (line 572) | ○ |
| C-36 | ListArr メソッド | E-01 (line 525-553), E-04 (line 78) | ○ |
| C-37 | ListArr 行数 | E-04 (line 80) | ○ |
| C-38 | ListArr 列数 | E-04 (line 79) | ○ |
| C-39 | FormatFromMatch バックスラッシュ | E-01 (line 573, 577) | ○ |
| C-40 | FormatFromMatch ドル記号 | E-01 (line 574, 589) | ○ |
| C-41 | SaveEscape 内部処理 | E-01 (line 599-601) | ○ |
| C-42 | LoadEscape 内部処理 | E-01 (line 607-609) | ○ |
| C-43 | CriticalRaise stdError 使用 | E-01 (line 614-616) | ○ |
| C-44 | CriticalRaise Err.Raise 使用 | E-01 (line 617-618) | ○ |

### stdJSON.cls 関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-45 | Create eJSONObject | E-02 (line 106-109) | ○ |
| C-46 | Create eJSONArray | E-02 (line 106-109) | ○ |
| C-47 | CreateFromString オブジェクト | E-02 (line 126-141) | ○ |
| C-48 | CreateFromString 配列 | E-02 (line 126-141) | ○ |
| C-49 | CreateFromString ネスト | E-02 (line 126-141) | ○ |
| C-50 | AllowUnquotedKeys | E-02 (line 128, 657-669) | ○ |
| C-51 | AllowSingleQuoteStrings | E-02 (line 130, 681-686) | ○ |
| C-52 | StoreLargeNumsAsString | E-02 (line 129, 752-757) | ○ |
| C-53 | CreateFromString 不正JSON | E-02 (line 139) | ○ |
| C-54 | CreateFromFile | E-02 (line 148-155) | △ |
| C-55 | CreateFromVariant Collection | E-02 (line 161-164, 210-223) | ○ |
| C-56 | CreateFromVariant Dictionary | E-02 (line 161-164, 224-241) | ○ |
| C-57 | CreateFromVariant Array | E-02 (line 244-258) | ○ |
| C-58 | CreateFromParams オブジェクト | E-02 (line 171-184) | ○ |
| C-59 | CreateFromParams 配列 | E-02 (line 171-184) | ○ |
| C-60 | protInit eJSONObject | E-02 (line 190-198) | ○ |
| C-61 | protInit eJSONArray | E-02 (line 190-198) | ○ |
| C-62 | Add オブジェクト | E-02 (line 266-275) | ○ |
| C-63 | Add 配列 | E-02 (line 266-275) | ○ |
| C-64 | Add stdJSON 戻り値 | E-02 (line 270, 273) | ○ |
| C-65 | AddArray | E-02 (line 284-302) | ○ |
| C-66 | AddArray fromVar | E-02 (line 287-289) | ○ |
| C-67 | AddObject | E-02 (line 307-319) | ○ |
| C-68 | JsonType プロパティ | E-02 (line 323-325) | ○ |
| C-69 | Length プロパティ | E-02 (line 329-331) | ○ |
| C-70 | Item Get オブジェクト | E-02 (line 336-344) | ○ |
| C-71 | Item Get 配列 | E-02 (line 336-344) | ○ |
| C-72 | Item Let | E-02 (line 345-352) | ○ |
| C-73 | Exists オブジェクト | E-02 (line 365-372) | ○ |
| C-74 | Exists 配列 | E-02 (line 365-372) | ○ |
| C-75 | ChildrenInfo | E-02 (line 377-393) | ○ |
| C-76 | ToString | E-02 (line 415-473) | ○ |
| C-77 | ToString pretty | E-02 (line 416-421) | ○ |
| C-78 | ToString ネスト | E-02 (line 439, 455) | ○ |
| C-79 | ToFile | E-02 (line 478-483) | △ |
| C-80 | ToVBObject オブジェクト | E-02 (line 487-521) | ○ |
| C-81 | ToVBObject 配列 | E-02 (line 487-521) | ○ |
| C-82 | ToSelf | E-02 (line 530-532) | ○ |
| C-83 | NewEnum | E-02 (line 542-551) | ○ |
| C-84 | simpleStringify null | E-02 (line 571-575) | ○ |
| C-85 | simpleStringify 日付 | E-02 (line 576-577) | ○ |
| C-86 | simpleStringify 文字列エスケープ | E-02 (line 578-583) | ○ |
| C-87 | simpleStringify ブール | E-02 (line 584-585) | ○ |
| C-88 | simpleStringify 小数点ロケール | E-02 (line 589-595) | ○ |
| C-89 | parseJSONObject | E-02 (line 613-629) | ○ |
| C-90 | parseJSONArray | E-02 (line 635-647) | ○ |
| C-91 | parseString エスケープ | E-02 (line 676-710) | ○ |
| C-92 | parseValue | E-02 (line 716-737) | ○ |
| C-93 | parseNumber 整数 | E-02 (line 743-758) | ○ |
| C-94 | parseNumber 小数 | E-02 (line 746) | ○ |
| C-95 | parseNumber 指数 | E-02 (line 746) | ○ |
| C-96 | parseNumber 負数 | E-02 (line 734, 746) | ○ |

### stdAcc.cls 関連テストケース

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-97 | CreateFromPoint | E-03 (line 336-339) | ○ |
| C-98 | CreateFromHwnd | E-03 (line 345-351) | ○ |
| C-99 | CreateFromApplication | E-03 (line 357-375) | ○ |
| C-100 | CreateFromApplication 各アプリ | E-03 (line 359-373) | ○ |
| C-101 | CreateFromDesktop | E-03 (line 380-387) | ○ |
| C-102 | CreateFromIAccessible | E-03 (line 393-396) | ○ |
| C-103 | CreateFromMouse | E-03 (line 401-406) | ○ |
| C-104 | CreateFromPath | E-03 (line 415-440) | ○ |
| C-105 | CreateFromPath P.prefix | E-03 (line 417-418) | ○ |
| C-106 | CreateFromPath 不正インデックス | E-03 (line 429, 432) | ○ |
| C-107 | protInitWithProxy | E-03 (line 446-450) | ○ |
| C-108 | GetDescendents | E-03 (line 465-484) | ○ |
| C-109 | GetDescendents 再帰 | E-03 (line 477-479) | ○ |
| C-110 | FindFirst | E-03 (line 513-571) | ○ |
| C-111 | FindFirst DepthFirst | E-03 (line 530-532) | ○ |
| C-112 | FindFirst BreadthFirst | E-03 (line 534-537) | ○ |
| C-113 | FindFirst NoMatchSkipDescendents | E-03 (line 561) | ○ |
| C-114 | FindFirst NoMatchCancelSearch | E-03 (line 557-559) | ○ |
| C-115 | FindFirst 一致なし | E-03 (line 570) | ○ |
| C-116 | FindAll | E-03 (line 600-662) | ○ |
| C-117 | FindAll MatchFoundSearchDescendents | E-03 (line 652-656) | ○ |
| C-118 | FindAll 一致なし | E-03 (line 614) | ○ |
| C-119 | Parent プロパティ | E-03 (line 666-677) | ○ |
| C-120 | Parent プロキシ | E-03 (line 667-668) | ○ |
| C-121 | Parent なし | E-03 (line 675-676) | ○ |
| C-122 | AncestralRoot | E-03 (line 681-689) | ○ |
| C-123 | children プロパティ | E-03 (line 693-722) | ○ |
| C-124 | children プロキシ | E-03 (line 716-719) | ○ |
| C-125 | children なし | E-03 (line 697, 702) | ○ |
| C-126 | hwnd プロパティ | E-03 (line 726-744) | ○ |
| C-127 | hwnd 取得失敗 | E-03 (line 742-743) | ○ |
| C-128 | Identity プロパティ | E-03 (line 751-758) | △ |
| C-129 | Location プロパティ | E-03 (line 763-787) | ○ |
| C-130 | Location プロキシ | E-03 (line 770-771) | ○ |
| C-131 | HitTest | E-03 (line 794-799) | ○ |
| C-132 | value Get | E-03 (line 803-810) | ○ |
| C-133 | value Let | E-03 (line 811-817) | ○ |
| C-134 | name プロパティ | E-03 (line 821-828) | ○ |
| C-135 | DefaultAction プロパティ | E-03 (line 832-839) | ○ |
| C-136 | Role プロパティ | E-03 (line 843-850) | ○ |
| C-137 | States プロパティ | E-03 (line 854-865) | ○ |
| C-138 | StateData プロパティ | E-03 (line 869-876) | ○ |
| C-139 | Description プロパティ | E-03 (line 880-887) | ○ |
| C-140 | KeyboardShortcut プロパティ | E-03 (line 891-898) | ○ |
| C-141 | Focus Get | E-03 (line 902-909) | ○ |
| C-142 | Focus Let | E-03 (line 913-920) | ○ |
| C-143 | Help プロパティ | E-03 (line 924-931) | ○ |
| C-144 | HelpTopic プロパティ | E-03 (line 936-943) | ○ |
| C-145 | Text プロパティ | E-03 (line 947-960) | ○ |
| C-146 | DoDefaultAction | E-03 (line 966-972) | ○ |
| C-147 | DoDefaultAction プロキシ | E-03 (line 967-968) | ○ |
| C-148 | SendMessage | E-03 (line 980-986) | ○ |
| C-149 | SendMessage hwnd=0 エラー | E-03 (line 984) | ○ |
| C-150 | PrintChildTexts | E-03 (line 989-996) | ○ |
| C-151 | PrintDescTexts | E-03 (line 1003-1036) | ○ |
| C-152 | PrintDescTexts ファイル出力 | E-03 (line 1006-1010) | △ |
| C-153 | getPath | E-03 (line 1041-1088) | ○ |
| C-154 | toJSON | E-03 (line 1092-1113) | ○ |
| C-155 | AwaitForElement | E-03 (line 1121-1135) | ○ |
| C-156 | AwaitForElement タイムアウト | E-03 (line 1131) | ○ |
| C-157 | AwaitForElement error | E-03 (line 1128-1130) | ○ |
| C-158 | protGetLookups | E-03 (line 1139-1193) | ○ |
| C-159 | CreateLookupDict | E-03 (line 1331-1353) | ○ |
| C-160 | BindGlobals | E-03 (line 1296-1302) | ○ |

## 4) 不足情報（Unknown / Missing）
- **UT-SRX-054, UT-SRX-079, UT-SRX-152**: ファイルシステム操作を伴うテストのため、実環境での動作確認が必要
  - 候補: 実環境テスト / モック作成 / 統合テストに委譲
- **UT-SRX-128 (Identity)**: IAccIdentityインターフェースの対応状況が実行環境に依存
  - 候補: 実環境テスト / 対応OS/アプリのドキュメント確認

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: stdRegex - 既存テストコード（stdRegexTests.bas）が存在し、主要機能のテストパターンが確立されている
- **0 (低リスク)**: stdJSON - パース/シリアライズロジックがコード内で完結しており、外部依存が少ない
- **1 (中リスク)**: stdAcc - Win32 API（IAccessible）への依存が多く、環境依存性がある。プロキシパターンの複雑さにも注意

## 6) レビュアーチェックリスト（最小）
- [ ] stdRegex の名前付きキャプチャ機能が正しくテストされているか確認
- [ ] stdJSON のパース時エラーハンドリングのテストケースが十分か確認
- [ ] stdAcc の FindFirst/FindAll の検索タイプ（BFS/DFS）の動作差異が明確か確認
- [ ] プロキシ要素関連のテストケースが網羅されているか確認
- [ ] ファイルI/O関連テスト（CreateFromFile, ToFile, PrintDescTexts）の実行計画を策定
- [ ] 境界値テスト（空文字列、空配列、Nothing）のカバレッジを確認
