---
generated_at: 2026-01-15 20:15:00
metrics:
  claims_total: 95
  claims_with_evidence: 92
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：system.csv（単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内の実装が根拠として存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：publicメソッド、プロパティ、重要なprivateメソッドをカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 92 / 95 = 0.97
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：92 / 95、根拠なし：3
- 優先レビュー（高）
  1. **UT-SYS-058 StepDuration**：時間計測の精度は実行環境依存
  2. **UT-SYS-059 TotalDuration**：実装にバグの可能性（startTimeの参照が最終ステップ）
  3. **UT-SYS-086 DEBUG_MODE**：コンパイル定数による分岐のため実行時確認困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/route06/stdVBA-master/src/stdProcess.cls`（667行）
- E-02: `/Users/tomokababa/Work/route06/stdVBA-master/src/stdFiber.cls`（449行）
- E-03: `/Users/tomokababa/Work/route06/stdVBA-master/src/stdTimer.cls`（183行）

## 3) Claims と根拠の対応（レビューの主戦場）

### stdProcess（35件）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UT-SYS-001: Createでプロセス作成 | E-01: L259-262 `Public Function Create` | ○ |
| C-02 | UT-SYS-002: vbHideウィンドウスタイル | E-01: L259 `Optional ByVal winStyle As VbAppWinStyle = VbAppWinStyle.vbHide` | ○ |
| C-03 | UT-SYS-003: 不正コマンドでエラー | E-01: L261 `Shell(sCmd, winStyle)` Shell関数の仕様 | ○ |
| C-04 | UT-SYS-004: CreateFromProcessIdでプロセス取得 | E-01: L268-271 `Public Function CreateFromProcessId` | ○ |
| C-05 | UT-SYS-005: 存在しないPIDの処理 | E-01: L356-358 `getProcessNameById`, `getProcessImageName` | ○ |
| C-06 | UT-SYS-006: CreateFromQueryでクエリ検索 | E-01: L277-295 `Public Function CreateFromQuery` | ○ |
| C-07 | UT-SYS-007: 該当なしでNothing返却 | E-01: L277-295 関数末尾でNothing返却 | ○ |
| C-08 | UT-SYS-008: CreateManyFromQueryで複数取得 | E-01: L301-319 `Public Function CreateManyFromQuery` | ○ |
| C-09 | UT-SYS-009: 該当なしで空Collection | E-01: L305 `Set ret = New Collection` | ○ |
| C-10 | UT-SYS-010: CreateAllで全プロセス取得 | E-01: L324-338 `Public Function CreateAll` | ○ |
| C-11 | UT-SYS-011: idプロパティ | E-01: L372-374 `Public Property Get id()` | ○ |
| C-12 | UT-SYS-012: nameプロパティ | E-01: L388-390 `Public Property Get name()` | ○ |
| C-13 | UT-SYS-013: pathプロパティ | E-01: L394-396 `Public Property Get path()` | ○ |
| C-14 | UT-SYS-014: isRunning=True | E-01: L414-416 `GetProcessVersion(This.ProcessId) > 0` | ○ |
| C-15 | UT-SYS-015: isRunning=False | E-01: L414-416 同上 | ○ |
| C-16 | UT-SYS-016: isCritical=True | E-01: L420-426 `Public Property Get isCritical()` | ○ |
| C-17 | UT-SYS-017: isCritical=False | E-01: L420-426 同上 | ○ |
| C-18 | UT-SYS-018: Priorityプロパティ | E-01: L430-432 `Public Property Get Priority()` | ○ |
| C-19 | UT-SYS-019: TimeCreatedプロパティ | E-01: L438-446 `Public Property Get TimeCreated()` | ○ |
| C-20 | UT-SYS-020: QueryInfoHandle=0での早期リターン | E-01: L440 `if This.QueryInfoHandle = 0 then exit property` | ○ |
| C-21 | UT-SYS-021: TimeQuitプロパティ | E-01: L451-463 `Public Property Get TimeQuit()` | ○ |
| C-22 | UT-SYS-022: 実行中プロセスでTimeQuitエラー | E-01: L461 `Err.Raise 1, "stdProcess.TimeQuit"` | ○ |
| C-23 | UT-SYS-023: TimeKernelプロパティ | E-01: L468-476 `Public Property Get TimeKernel()` | ○ |
| C-24 | UT-SYS-024: TimeUserプロパティ | E-01: L481-489 `Public Property Get TimeUser()` | ○ |
| C-25 | UT-SYS-025: ExitCodeプロパティ | E-01: L493-499 `Public Property Get ExitCode()` | ○ |
| C-26 | UT-SYS-026: Winmgmtプロパティ | E-01: L400-404 `Public Property Get Winmgmt()` | ○ |
| C-27 | UT-SYS-027: CommandLineプロパティ | E-01: L408-409 `Public Property Get CommandLine()` | ○ |
| C-28 | UT-SYS-028: forceQuitメソッド | E-01: L507-517 `Public Sub forceQuit` | ○ |
| C-29 | UT-SYS-029: 終了コード指定 | E-01: L507 `Optional ByVal ExitCode As Long = 0` | ○ |
| C-30 | UT-SYS-030: ProcessHandle取得失敗時の早期リターン | E-01: L509 `If This.ProcessHandle = 0 Then Exit Sub` | ○ |
| C-31 | UT-SYS-031: waitTilCloseメソッド | E-01: L520-524 `Public Sub waitTilClose()` | ○ |
| C-32 | UT-SYS-032: protProcessHandleCreate | E-01: L549-555 `Friend Sub protProcessHandleCreate` | ○ |
| C-33 | UT-SYS-033: 二重オープン時エラー | E-01: L553 `Err.Raise 1, "", "Process already open."` | ○ |
| C-34 | UT-SYS-034: protProcessHandleRelease | E-01: L559-562 `Friend Sub protProcessHandleRelease` | ○ |
| C-35 | UT-SYS-035: Class_Terminate | E-01: L362-364 `Private Sub Class_Terminate()` | ○ |

### stdFiber（39件）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | UT-SYS-036: Createでファイバー作成 | E-02: L121-124 `Public Function Create` | ○ |
| C-37 | UT-SYS-037: protInit初期化 | E-02: L130-134 `Friend Sub protInit` | ○ |
| C-38 | UT-SYS-038: addでステップ追加 | E-02: L140-148 `Public Function add` | ○ |
| C-39 | UT-SYS-039: メソッドチェーン | E-02: L147 `Set add = Me` | ○ |
| C-40 | UT-SYS-040: addErrorHandler | E-02: L153-156 `Public Function addErrorHandler` | ○ |
| C-41 | UT-SYS-041: addStepChangeHandler | E-02: L161-164 `Public Function addStepChangeHandler` | ○ |
| C-42 | UT-SYS-042: protStepでステップ進行 | E-02: L176-178 `This.procStep = This.procStep + 1` | ○ |
| C-43 | UT-SYS-043: False時はステップ維持 | E-02: L176 `If This.procs(This.procStep).proc.Run(oMe) Then` | ○ |
| C-44 | UT-SYS-044: 完了判定 | E-02: L178 `This.isFinished = This.procStep > This.procsCount` | ○ |
| C-45 | UT-SYS-045: エラーハンドリング | E-02: L188-194 ErrorHandler部分 | ○ |
| C-46 | UT-SYS-046: stepChangeHandler発火 | E-02: L182 `Call This.stepChangeHandler.Run(oMe)` | ○ |
| C-47 | UT-SYS-047: Resolveで結果設定 | E-02: L199-203 `Public Sub Resolve` | ○ |
| C-48 | UT-SYS-048: オブジェクト結果設定 | E-02: L202 `Call CopyVariant(This.result, vResult)` | ○ |
| C-49 | UT-SYS-049: Reset引数なし | E-02: L221-223 `This.procStep = 1` | ○ |
| C-50 | UT-SYS-050: Reset名前指定 | E-02: L209-218 名前検索ロジック | ○ |
| C-51 | UT-SYS-051: resetCountインクリメント | E-02: L208 `This.resetCount = This.resetCount + 1` | ○ |
| C-52 | UT-SYS-052: ResetCountプロパティ | E-02: L228-230 `Public Property Get ResetCount()` | ○ |
| C-53 | UT-SYS-053: Resultプロパティ | E-02: L234-236 `Public Property Get Result()` | ○ |
| C-54 | UT-SYS-054: ErrorTextプロパティ | E-02: L240-242 `Public Property Get ErrorText()` | ○ |
| C-55 | UT-SYS-055: Metaプロパティ | E-02: L246-248 `Public Property Get Meta()` | ○ |
| C-56 | UT-SYS-056: Stepプロパティ | E-02: L252-254 `Public Property Get Step()` | ○ |
| C-57 | UT-SYS-057: StepNameプロパティ | E-02: L258-260 `Public Property Get StepName()` | ○ |
| C-58 | UT-SYS-058: StepDurationプロパティ | E-02: L264-266 `Public Property Get StepDuration()` | △ |
| C-59 | UT-SYS-059: TotalDurationプロパティ | E-02: L270-272 `Public Property Get TotalDuration()` | △ |
| C-60 | UT-SYS-060: isFinished=False | E-02: L276-278 `Public Property Get isFinished()` | ○ |
| C-61 | UT-SYS-061: isFinished=True | E-02: L276-278 同上 | ○ |
| C-62 | UT-SYS-062: Nameプロパティ | E-02: L282-284 `Public Property Get Name()` | ○ |
| C-63 | UT-SYS-063: Agentプロパティ | E-02: L288-290 `Public Property Get Agent()` | ○ |
| C-64 | UT-SYS-064: runFibersで並行実行 | E-02: L301-367 `Public Function runFibers` | ○ |
| C-65 | UT-SYS-065: agentInitCBコールバック | E-02: L310 `If Not agentInitCB Is Nothing Then Call agentInitCB.Run` | ○ |
| C-66 | UT-SYS-066: agentDestroyCBコールバック | E-02: L356 `If Not agentDestroyCB Is Nothing Then Call agentDestroyCB.Run` | ○ |
| C-67 | UT-SYS-067: runtimeUpdateCBコールバック | E-02: L346-349 `If Not runtimeUpdateCB Is Nothing Then` | ○ |
| C-68 | UT-SYS-068: 空リストで空Collection | E-02: L361-364 `Set results = New Collection` | ○ |
| C-69 | UT-SYS-069: stdArray対応 | E-02: L412-417 `Case "stdArray"` | ○ |
| C-70 | UT-SYS-070: 配列対応 | E-02: L425-431 `Case Is > vbArray` | ○ |
| C-71 | UT-SYS-071: Cancelメソッド | E-02: L371-379 `Public Sub Cancel` | ○ |
| C-72 | UT-SYS-072: Cancelでエラーハンドラ | E-02: L375-378 `If Not This.errorHandler Is Nothing` | ○ |
| C-73 | UT-SYS-073: CopyVariantプリミティブ | E-02: L392 `Let vDest = vSrc` | ○ |
| C-74 | UT-SYS-074: CopyVariantオブジェクト | E-02: L390 `Set vDest = vSrc` | ○ |

### stdTimer（21件）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-75 | UT-SYS-075: Createでタイマー作成 | E-03: L56-59 `Public Function Create` | ○ |
| C-76 | UT-SYS-076: コールバック付きCreate | E-03: L56 `Optional ByVal callback As Object = Nothing` | ○ |
| C-77 | UT-SYS-077: VBOM有効化 | E-03: L67 `If Not getVBOM Then Call setVBOM(True)` | ○ |
| C-78 | UT-SYS-078: リモートワークブック作成 | E-03: L68 `Set xlRemoteWorkbook = createRemoteWorkbook()` | ○ |
| C-79 | UT-SYS-079: コードインジェクション | E-03: L70 `Call injectCode(xlRemoteWorkbook, "TimerMain", getTimerCode(iTimerResolution))` | ○ |
| C-80 | UT-SYS-080: Tickイベント | E-03: L45 `Public Event Tick()` | ○ |
| C-81 | UT-SYS-081: SheetChangeでTick発火 | E-03: L180 `RaiseEvent Tick` | ○ |
| C-82 | UT-SYS-082: コールバック実行 | E-03: L181 `If Not pCallback Is Nothing Then pCallback.Run` | ○ |
| C-83 | UT-SYS-083: Class_TerminateでStopTimer | E-03: L172 `Call xlRemoteWorkbook.Application.Run("TimerMain.StopTimer")` | ○ |
| C-84 | UT-SYS-084: xlRemoteWorkbook=Nothing | E-03: L173 `Set xlRemoteWorkbook = Nothing` | ○ |
| C-85 | UT-SYS-085: createRemoteWorkbook | E-03: L76-90 `Private Function createRemoteWorkbook` | ○ |
| C-86 | UT-SYS-086: DEBUG_MODEでVisible=True | E-03: L83-85 `#If Not DEBUG_MODE Then` | △ |
| C-87 | UT-SYS-087: injectCodeでコード追加 | E-03: L97-103 `Public Sub injectCode` | ○ |
| C-88 | UT-SYS-088: クラスモジュール作成 | E-03: L96 `Optional ByVal iModuleType As Long = 1` | ○ |
| C-89 | UT-SYS-089: getVBOM=True | E-03: L107-110 `Private Function getVBOM()` | ○ |
| C-90 | UT-SYS-090: getVBOM=False | E-03: L107-110 同上 | ○ |
| C-91 | UT-SYS-091: setVBOM有効化 | E-03: L116-131 `Private Function setVBOM` | ○ |
| C-92 | UT-SYS-092: setVBOM無効化 | E-03: L116-131 同上 | ○ |
| C-93 | UT-SYS-093: getTimerCodeでコード生成 | E-03: L136-168 `Private Function getTimerCode` | ○ |
| C-94 | UT-SYS-094: 0ミリ秒でのコード生成 | E-03: L155 `"    sleep " & iTimerResolution` | ○ |
| C-95 | UT-SYS-095: Mac用コード | E-03: L138-150 `#If Mac Then` | ○ |

## 4) 不足情報（Unknown / Missing）

### 根拠不足の項目

1. **UT-SYS-058 StepDuration（C-58）**
   - 理由：`DateDiff("s", ...)` の精度は実行環境に依存するため、期待値の正確性を保証できない
   - 候補：実行環境でのタイミングテスト / モック使用

2. **UT-SYS-059 TotalDuration（C-59）**
   - 理由：実装では `This.procs(This.procsCount).startTime` を使用しており、最終ステップの開始時刻から終了時刻を計算している。これが意図通りの「総実行時間」を返すか要確認（最初のステップ開始時刻ではない）
   - 候補：仕様確認 / 実装修正の検討

3. **UT-SYS-086 DEBUG_MODE（C-86）**
   - 理由：`#Const DEBUG_MODE = False` はコンパイル時定数のため、テスト実行時に動的に変更できない
   - 候補：条件付きコンパイルを使用したテスト構成

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 説明 |
|---|---|---|
| 2（高） | プロセス操作（stdProcess） | forceQuit、TerminateProcessなどシステムに影響を与える操作。誤用によりシステム不安定化のリスク |
| 2（高） | VBOM操作（stdTimer） | setVBOMによるレジストリ変更。セキュリティ設定に影響 |
| 1（中） | リモートワークブック作成（stdTimer） | 新規Excelインスタンス作成。リソース消費とクリーンアップ漏れのリスク |
| 1（中） | ファイバー並行実行（stdFiber） | runFibersでの複数エージェント管理。デッドロックや無限ループのリスク |
| 0（低） | プロパティ取得 | 各クラスのゲッタープロパティ。読み取り専用で副作用なし |

## 6) レビュアーチェックリスト（最小）

- [ ] stdProcess.forceQuitのテストは実際に終了可能なテスト用プロセスで行うこと
- [ ] stdProcess.isCriticalのテストではシステムクリティカルプロセス（csrss.exe等）を使用しないこと
- [ ] stdTimer関連テストはVBOM設定の復元を確実に行うこと
- [ ] stdTimer.Class_Terminateテスト後にExcelインスタンスが残存していないか確認すること
- [ ] stdFiber.runFibersのテストではタイムアウト機構を設けること
- [ ] TotalDurationプロパティの実装が意図通りか仕様を確認すること（L270-272）
- [ ] Mac環境でのsetVBOM、getTimerCodeの動作確認を行うこと
