---
generated_at: 2026-01-15 21:00:00
metrics:
  claims_total: 140
  claims_with_evidence: 138
  claims_without_evidence: 2
confidence_derived: 0.99
---

# 根拠レポート：ui.csv（単体テストケース一覧）

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.99**
  - 根拠あり：138 / 140、根拠なし：2
- 優先レビュー（高）
  1. **UT-UI-125 (AsAcc)**: stdAccの存在確認が必要
  2. **UT-UI-128-130 (TokeniseKeys)**: 内部関数のため詳細仕様確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/route06/stdVBA-master/src/stdUIElement.cls` - UIElementクラス本体
- E-02: `/Users/tomokababa/Work/route06/stdVBA-master/src/stdWindow.cls` - Windowクラス本体
- E-03: `/Users/tomokababa/Work/route06/stdVBA-master/src/stdRibbon.cls` - Ribbonクラス本体
- E-04: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdUIAutomationElement.cls` - UIAutomationElement（WIP）
- E-05: `/Users/tomokababa/Work/route06/stdVBA-master/docs/stdWindow.md` - stdWindowドキュメント

## 3) Claims と根拠の対応（レビューの主戦場）

### stdUIElement クラス（UT-UI-001 ～ UT-UI-039）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreateFromControl コンストラクタの存在 | E-01 (行89-93) | ○ |
| C-02 | CreateFromType コンストラクタの存在 | E-01 (行107-142) | ○ |
| C-03 | EUIElementType列挙型（15種類のコントロール） | E-01 (行28-51) | ○ |
| C-04 | EUIElementEvent列挙型（14種類のイベント） | E-01 (行12-27) | ○ |
| C-05 | Value プロパティの実装 | E-01 (行180-201) | ○ |
| C-06 | Caption プロパティの実装 | E-01 (行206-218) | ○ |
| C-07 | Left/Top/Width/Height プロパティの実装 | E-01 (行222-266) | ○ |
| C-08 | id プロパティ（GUID）の実装 | E-01 (行270-272, 364-370) | ○ |
| C-09 | protInit による型判定処理 | E-01 (行281-360) | ○ |
| C-10 | イベントハンドラ（Click, Change, KeyDown等） | E-01 (行423-577) | ○ |
| C-11 | callEventCB によるコールバック呼び出し | E-01 (行573-577) | ○ |
| C-12 | CheckBox の特殊位置計算（Left setter） | E-01 (行231) | ○ |

### stdWindow クラス（UT-UI-040 ～ UT-UI-130）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-13 | CreateFromDesktop コンストラクタ | E-02 (行681-683) | ○ |
| C-14 | CreateFromHwnd コンストラクタ | E-02 (行643-650) | ○ |
| C-15 | CreateFromPoint コンストラクタ | E-02 (行691-694) | ○ |
| C-16 | CreateFromIUnknown コンストラクタ | E-02 (行707-719) | ○ |
| C-17 | CreateFromApplication コンストラクタ | E-02 (行658-676) | ○ |
| C-18 | CreateFromContextMenu コンストラクタ | E-02 (行737-745) | ○ |
| C-19 | Create（新規ウィンドウ作成）コンストラクタ | E-02 (行594-603) | ○ |
| C-20 | CreateHighlightRect コンストラクタ | E-02 (行615-630) | ○ |
| C-21 | handle プロパティ | E-02 (行846-851) | ○ |
| C-22 | hDC/hDCClient プロパティ | E-02 (行856-871) | ○ |
| C-23 | Exists プロパティ | E-02 (行875-877) | ○ |
| C-24 | IsFrozen プロパティ | E-02 (行881-887) | ○ |
| C-25 | Caption Get/Let プロパティ | E-02 (行891-909) | ○ |
| C-26 | Class プロパティ | E-02 (行913-922) | ○ |
| C-27 | Visible Get/Let プロパティ | E-02 (行926-943) | ○ |
| C-28 | State Get/Let プロパティ | E-02 (行947-977) | ○ |
| C-29 | children プロパティ | E-02 (行981-1017) | ○ |
| C-30 | RectClient/RectWindow プロパティ | E-02 (行1019-1094) | ○ |
| C-31 | x/y/width/height プロパティ | E-02 (行1099-1170) | ○ |
| C-32 | ProcessID/ProcessName プロパティ | E-02 (行1174-1193) | ○ |
| C-33 | parent Get/Set プロパティ | E-02 (行1197-1213) | ○ |
| C-34 | owner Get/Set プロパティ | E-02 (行1217-1237) | ○ |
| C-35 | AncestralRoot プロパティ | E-02 (行1265-1271) | ○ |
| C-36 | Style/StyleEx Get/Let プロパティ | E-02 (行1275-1347) | ○ |
| C-37 | isResizable プロパティ | E-02 (行1422-1428) | ○ |
| C-38 | isAlwaysOnTop プロパティ | E-02 (行1514-1523) | ○ |
| C-39 | TransparentColor/Opacity プロパティ | E-02 (行1597-1629) | ○ |
| C-40 | FindFirst メソッド | E-02 (行1695-1755) | ○ |
| C-41 | FindAll メソッド | E-02 (行1785-1852) | ○ |
| C-42 | GetDescendents メソッド | E-02 (行1903-1921) | ○ |
| C-43 | getAllText メソッド | E-02 (行1856-1863) | ○ |
| C-44 | Quit/ForceQuit メソッド | E-02 (行1871-1888) | ○ |
| C-45 | Activate メソッド | E-02 (行1891-1899) | ○ |
| C-46 | Redraw メソッド | E-02 (行1924-1927) | ○ |
| C-47 | SendMessage/PostMessage メソッド | E-02 (行1934-1958) | ○ |
| C-48 | ClickMessage メソッド | E-02 (行2014-2057) | ○ |
| C-49 | SendKeysInput メソッド | E-02 (行2067-2107) | ○ |
| C-50 | SendKeysEvent メソッド | E-02 (行2116-2153) | ○ |
| C-51 | SendKeysMessage メソッド | E-02 (行2163-2196) | ○ |
| C-52 | AwaitForWindow メソッド | E-02 (行2204-2216) | ○ |
| C-53 | AsAcc メソッド | E-02 (行781-791) | △ |
| C-54 | AsIAccessible メソッド | E-02 (行795-798) | ○ |
| C-55 | AsNativeObject メソッド | E-02 (行805-809) | ○ |
| C-56 | TokeniseKeys 内部関数 | E-02 (行2486以降) | △ |

### stdRibbon クラス（UT-UI-131 ～ UT-UI-140）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | ERibbonState 列挙型 | E-03 (行13-24) | ○ |
| C-58 | State Get プロパティ | E-03 (行33-94) | ○ |
| C-59 | State Let プロパティ | E-03 (行95-177) | ○ |
| C-60 | Excel/Word/Mac固有の処理分岐 | E-03 (行47-71, 101-176) | ○ |
| C-61 | ProtectedViewMode のエラー処理 | E-03 (行149) | ○ |

## 4) 不足情報（Unknown / Missing）

### 根拠不足項目

1. **AsAcc メソッド（C-53）**
   - stdAccクラスの存在が前提
   - 現在のプロジェクトにstdAcc.clsが存在するか確認が必要
   - 候補：`src/WIP/` ディレクトリを確認 / `docs/stdAcc.md` が存在するため実装はあると推定

2. **TokeniseKeys 内部関数（C-56）**
   - 詳細な実装はファイル後半（2486行以降）にあり、読み込み範囲外
   - キー構文パーサーの詳細仕様は実際のコードを確認推奨
   - 候補：stdWindow.cls の完全読み込み / テスト実行による検証

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 説明 |
|---|---|---|
| 0 | stdUIElement全般 | コード解析で明確に確認済み |
| 0 | stdWindow大部分 | コード解析で明確に確認済み |
| 1 | AsAcc/stdAcc依存 | 外部依存クラスの存在確認が必要 |
| 1 | TokeniseKeys詳細 | 内部関数の詳細テストケース |
| 0 | stdRibbon全般 | コード解析で明確に確認済み |

**リスクレベル凡例**:
- 0: 低リスク（根拠が明確）
- 1: 中リスク（追加確認推奨）
- 2: 高リスク（必須確認）

## 6) レビュアーチェックリスト（最小）

- [ ] stdUIElementの15種類のコントロールタイプが全て網羅されているか
- [ ] stdWindowの各コンストラクタのエラーケースが適切か
- [ ] イベントハンドリング（Click, Change, KeyDown等）のテストケースが十分か
- [ ] Win32 API呼び出しのエラーハンドリングが網羅されているか
- [ ] stdRibbonのExcel/Word固有機能の分岐が正しいか
- [ ] AsAccメソッドのstdAcc依存が問題ないか確認
- [ ] SendKeys系メソッドの特殊キー（Ctrl, Shift, Alt等）の組み合わせテストが十分か

---

## 補足：ソースコード解析サマリー

### stdUIElement.cls
- **行数**: 578行
- **主要機能**: MSFormsコントロールのラッパークラス
- **コンストラクタ**: CreateFromControl, CreateFromType
- **対応コントロール**: UserForm, Frame, MultiPage, Label, Image, TabStrip, TextBox, ComboBox, ListBox, CheckBox, OptionButton, ToggleButton, ScrollBar, SpinButton, CommandButton
- **イベント**: Change, Move, Resize, MouseClick, MouseDblClick, MouseFocus, MouseMove, MouseDown, MouseUp, TabSelected, AddChild, KeyDown, KeyUp, KeyPress

### stdWindow.cls
- **行数**: 2500行以上
- **主要機能**: Win32ウィンドウ管理クラス
- **コンストラクタ**: Create, CreateFromDesktop, CreateFromHwnd, CreateFromPoint, CreateFromIUnknown, CreateFromApplication, CreateFromContextMenu, CreateHighlightRect, CreateManyFromProcessId, CreateManyFromShellWindows
- **プロパティ**: handle, hDC, Exists, IsFrozen, Caption, Class, Visible, State, children, RectClient, RectWindow, x, y, width, height, ProcessID, ProcessName, parent, owner, AncestralRoot, Style, StyleEx, UserData, WndProc, isResizable, isAlwaysOnTop, TransparentColor, Opacity等
- **メソッド**: FindFirst, FindAll, GetDescendents, getAllText, Quit, ForceQuit, Activate, Redraw, SendMessage, PostMessage, ClickMessage, SendKeysInput, SendKeysEvent, SendKeysMessage, AwaitForWindow, AsAcc, AsIAccessible, AsNativeObject

### stdRibbon.cls
- **行数**: 178行
- **主要機能**: Officeリボン状態管理
- **対応状態**: RibbonNullState, RibbonFullScreenMode, RibbonShowTabsOnly, RibbonAlwaysShowRibbon, RibbonNotVisible, RibbonProtectedViewMode, ExcelApplicationDisplayFullScreenMode, WordViewFullScreenMode, WordViewReadMode
- **対応アプリ**: Excel, Word（一部Mac対応）
