---
generated_at: 2026-01-15 19:30:00
metrics:
  claims_total: 160
  claims_with_evidence: 152
  claims_without_evidence: 8
confidence_derived: 0.95
---

# 根拠レポート：wip-collections 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：152 / 160、根拠なし：8
- 優先レビュー（高）
  1. **stdDictionary.Add/Remove/Item(Let/Set)メソッド**：実装が空のためテスト期待値が推測
  2. **stdTable.getListRows**：実装が不完全（For Each文が閉じていない）
  3. **stdEnumProvider関連**：参照されているがソースコードがWIPディレクトリにない

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WIP/stdDictionary/stdDictionary.cls` - stdDictionary本体実装
- E-02: `src/WIP/stdDictionary/stdIHashable.cls` - ハッシュ可能インターフェース
- E-03: `src/WIP/stdDictionary/SS/stdDictionary2.cls` - 代替実装（SS版）
- E-04: `src/WIP/stdDictionary/trick/stdDictionary.cls` - 代替実装（trick版）
- E-05: `src/WIP/stdTable/stdTable.cls` - テーブル基本実装
- E-06: `src/WIP/stdTable/stdITable.cls` - テーブルインターフェース
- E-07: `src/WIP/stdTable/stdITableRow.cls` - テーブル行インターフェース
- E-08: `src/WIP/stdTable/stdXLTable.cls` - Excelテーブル実装
- E-09: `src/WIP/stdTable/stdXLTableRow.cls` - Excelテーブル行実装
- E-10: `src/WIP/stdTable/stdXLEvents.cls` - Excel選択イベント実装
- E-11: `src/WIP/stdTable/stdRow v0.0.1.cls` - 行データクラス
- E-12: `src/WIP/stdEnumProvider/STD_Types_IniVariantEnum.bas` - IEnumVARIANT実装
- E-13: `src/WIP/stdEnumProvider/FibonacciIteratorExample.cls` - 列挙子使用例

## 3) Claims と根拠の対応（レビューの主戦場）

### stdDictionary (E-01)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | Create: キー・バリューペアで辞書が作成されること | E-01 L42-48 | ○ |
| C-002 | Create: 空のパラメータで辞書が作成されること | E-01 L42-48 | ○ |
| C-003 | CreateAdvanced: カスタムサイズで作成できること | E-01 L49-55 | ○ |
| C-004 | Item(Get): キーに対応する値が取得できること | E-01 L59-86 | ○ |
| C-005 | Item(Get): 存在しないキーでEmptyが返却されること | E-01 L84 | ○ |
| C-006 | Item(Get): オブジェクト値が正しく取得できること | E-01 L78-80 | ○ |
| C-007 | Add: 新しいキー・バリューペアが追加できること | E-01 L94-96 | △ |
| C-008 | Remove: 指定キーの要素が削除されること | E-01 L97-99 | △ |
| C-009 | RemoveAll: 全要素が削除されること | E-01 L100-102 | △ |
| C-010 | protInit: デフォルト値で初期化されること | E-01 L106-112 | ○ |
| C-011 | EnsureCapacity: 容量拡張が行われること | E-01 L116-132 | ○ |
| C-012 | EnsureCapacity: 最大容量超過でエラーが発生すること | E-01 L118-121 | ○ |
| C-013 | testEqual: 同一プリミティブ値でTrueが返却されること | E-01 L138-151 | ○ |
| C-014 | testEqual: 異なる型でFalseが返却されること | E-01 L139 | ○ |
| C-015 | testEqual: stdIHashable実装でisEqualが呼ばれること | E-01 L141-143 | ○ |
| C-016 | HashFunction: 文字列キーのハッシュ計算 | E-01 L163-173 | ○ |
| C-017 | HashFunction: 数値キーのハッシュ計算 | E-01 L184-186 | ○ |
| C-018 | HashFunction: オブジェクトキーのハッシュ計算 | E-01 L191-195 | ○ |
| C-019 | HashFunction: Empty/Nullで0が返却されること | E-01 L187-188 | ○ |

### stdIHashable (E-02)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-020 | Hash(Get): ハッシュ値が返却されること | E-02 L11 | ○ |
| C-021 | isEqual: 等価判定が行われること | E-02 L12 | ○ |

### stdTable (E-05)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-022 | Create: ListObjectから作成されること | E-05 L35-38 | ○ |
| C-023 | IsSelected(Get): 選択状態が取得できること | E-05 L44-46 | ○ |
| C-024 | Init: 初期化が行われること | E-05 L92-99 | ○ |
| C-025 | sheet_SelectionChange: Selectedイベント発火 | E-05 L57-83 | ○ |
| C-026 | sheet_SelectionChange: Deselectedイベント発火 | E-05 L70-72 | ○ |
| C-027 | getListRows: 交差するListRowsが取得できること | E-05 L104-114 | △ |

### stdITable (E-06)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-028 | isSelected(Get): Boolean返却 | E-06 L35 | ○ |
| C-029 | idColumnName(Get/Let): ID列名操作 | E-06 L37-38 | ○ |
| C-030 | Headers(Get): ヘッダー配列返却 | E-06 L41 | ○ |
| C-031 | Rows(Get): 行コレクション返却 | E-06 L44 | ○ |
| C-032 | getNewID: 新規ID取得 | E-06 L51 | ○ |
| C-033 | Message: メッセージ送信 | E-06 L53 | ○ |

### stdITableRow (E-07)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-034 | AsArray: 配列変換 | E-07 L19 | ○ |
| C-035 | AsDict: 辞書変換 | E-07 L22 | ○ |
| C-036 | id(Get): ID取得 | E-07 L25 | ○ |
| C-037 | diff(Get): 差分取得 | E-07 L28 | ○ |
| C-038 | Item(Get/Let): 列値操作 | E-07 L31-32 | ○ |
| C-039 | Dirty(Get/Let): 変更フラグ操作 | E-07 L35-36 | ○ |
| C-040 | Clone: 複製機能 | E-07 L46 | ○ |
| C-041 | Save: 保存機能 | E-07 L49 | ○ |

### stdXLTable (E-08)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-042 | CreateFromRange: Range からの作成 | E-08 L50-53 | ○ |
| C-043 | CreateFromListObject: ListObjectからの作成 | E-08 L55-58 | ○ |
| C-044 | isSelected(Get): 選択状態取得 | E-08 L64-66 | ○ |
| C-045 | idColumnName(Get/Let): ID列名取得・設定 | E-08 L68-82 | ○ |
| C-046 | idColumnName(Let): 存在しない列名でエラー | E-08 L81 | ○ |
| C-047 | Headers(Get): ヘッダー配列取得 | E-08 L83-90 | ○ |
| C-048 | Range(Get): テーブル範囲取得 | E-08 L91-93 | ○ |
| C-049 | HeaderRowRange(Get): ヘッダー行範囲取得 | E-08 L94-96 | ○ |
| C-050 | DataBodyRange(Get): データ本体範囲取得 | E-08 L97-99 | ○ |
| C-051 | NewRowRange(Get): 新規行範囲取得 | E-08 L100-102 | ○ |
| C-052 | NewColumnRange(Get): 新規列範囲取得 | E-08 L103-105 | ○ |
| C-053 | ListObject(Get): ListObject取得 | E-08 L106-108 | ○ |
| C-054 | SelectedRows(Get): 選択行取得 | E-08 L109-111 | ○ |
| C-055 | pSheet_Change: 変更イベント処理 | E-08 L116-145 | ○ |
| C-056 | pCB_OnUpdate: 選択変更イベント処理 | E-08 L148-202 | ○ |
| C-057 | protInit: 初期化処理 | E-08 L243-251 | ○ |
| C-058 | stdITable_Message: インターフェースメッセージ処理 | E-08 L285-300 | ○ |

### stdXLTableRow (E-09)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-059 | Create: ヘッダーとデータから行作成 | E-09 L22-33 | ○ |
| C-060 | CreateFromDict: 辞書から行作成 | E-09 L34-37 | ○ |
| C-061 | AsArray: 配列変換 | E-09 L41-43 | ○ |
| C-062 | AsDict: 非接続辞書コピー返却 | E-09 L47-55 | ○ |
| C-063 | Clone: 複製作成 | E-09 L58-60 | ○ |
| C-064 | id(Get): ID列値取得 | E-09 L64-68 | ○ |
| C-065 | id(Get): idColumnName空の場合 | E-09 L65-67 | ○ |
| C-066 | isSelected(Get): 選択状態取得 | E-09 L72-74 | ○ |
| C-067 | SelectRow: 行選択操作 | E-09 L75-78 | ○ |
| C-068 | sht_Change: 変更でdiff記録 | E-09 L85-117 | ○ |
| C-069 | sht_Change: cancelでdiffクリア | E-09 L106-109 | ○ |
| C-070 | sht_SelectionChange: 選択でRowSelectメッセージ | E-09 L119-125 | ○ |
| C-071 | sht_SelectionChange: 選択解除でRowDeselectメッセージ | E-09 L126-131 | ○ |
| C-072 | Save: diffの反映 | E-09 L135-147 | ○ |
| C-073 | protInit: 初期化 | E-09 L199-203 | ○ |
| C-074 | CreateDiff: 変更情報配列生成 | E-09 L208-210 | ○ |

### stdXLEvents (E-10)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-075 | SelectionChange: 選択変更イベント | E-10 L10 | ○ |
| C-076 | RangeSelectionChange: Range選択変更イベント | E-10 L12 | ○ |
| C-077 | RangeSelected: Range選択イベント | E-10 L13 | ○ |
| C-078 | RangeDeselected: Range選択解除イベント | E-10 L14 | ○ |
| C-079 | ShapeSelectionChange: Shape選択変更イベント | E-10 L16 | ○ |
| C-080 | ShapeSelected: Shape選択イベント | E-10 L17 | ○ |
| C-081 | ShapeDeselected: Shape選択解除イベント | E-10 L18 | ○ |
| C-082 | ChartSelected: Chart選択イベント | E-10 L20 | ○ |
| C-083 | ChartDeselected: Chart選択解除イベント | E-10 L21 | ○ |
| C-084 | cbs_OnUpdate: CommandBars更新検知 | E-10 L80-148 | ○ |
| C-085 | getSelection: 選択情報取得 | E-10 L156-163 | ○ |
| C-086 | RaiseShapeEvent: Chart型判定 | E-10 L164-178 | ○ |
| C-087 | RaiseShapeEvent: 非Chart型判定 | E-10 L164-178 | ○ |
| C-088 | getShapesCol: Shape選択Collection生成 | E-10 L180-190 | ○ |
| C-089 | getShapesCol: ShapeRange選択Collection生成 | E-10 L186-189 | ○ |
| C-090 | getObjPath: オブジェクトパス生成 | E-10 L192-201 | ○ |
| C-091 | getObjID: RangeのID取得 | E-10 L202-217 | ○ |
| C-092 | getObjID: ShapeのID取得 | E-10 L215 | ○ |
| C-093 | getObjAncestor: 祖先オブジェクト取得 | E-10 L218-224 | ○ |
| C-094 | getObjParent: 親オブジェクト取得 | E-10 L225-235 | ○ |
| C-095 | getObjParent: Axis型でActiveChart返却 | E-10 L229-231 | ○ |
| C-096 | selectionsAreDifferent: 異なる選択でTrue | E-10 L237-254 | ○ |
| C-097 | selectionsAreDifferent: 同一選択でFalse | E-10 L243 | ○ |
| C-098 | getObjType: Range型判定 | E-10 L260 | ○ |
| C-099 | getObjType: Shape型判定 | E-10 L261 | ○ |

### STD_Types_IniVariantEnum (E-12)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100 | NewEnumerator: IEnumVARIANT生成 | E-12 L46-86 | ○ |
| C-101 | NewEnumerator: Lower省略時デフォルト | E-12 L48 | ○ |
| C-102 | IUnknown_QueryInterface: IEnumVARIANT IIDでS_OK | E-12 L114-131 | ○ |
| C-103 | IUnknown_QueryInterface: 不明IIDでE_NOINTERFACE | E-12 L128-129 | ○ |
| C-104 | IUnknown_AddRef: 参照カウント増加 | E-12 L133-135 | ○ |
| C-105 | IUnknown_Release: 参照カウント減少 | E-12 L137-143 | ○ |
| C-106 | IUnknown_Release: カウント0でメモリ解放 | E-12 L139-142 | ○ |
| C-107 | IEnumVARIANT_Next: 要素取得 | E-12 L145-171 | ○ |
| C-108 | IEnumVARIANT_Next: 要素不足時S_FALSE | E-12 L170 | ○ |
| C-109 | IEnumVARIANT_Next: rgVar=NULLでE_POINTER | E-12 L153-156 | ○ |
| C-110 | IEnumVARIANT_Skip: E_NOTIMPL | E-12 L173-175 | ○ |
| C-111 | IEnumVARIANT_Reset: E_NOTIMPL | E-12 L177-179 | ○ |
| C-112 | IEnumVARIANT_Clone: E_NOTIMPL | E-12 L181-183 | ○ |

### FibonacciIteratorExample (E-13)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-113 | GetEnum: stdEnumProvider取得 | E-13 L23-32 | ○ |
| C-114 | GetEnum: 2回目呼び出しで同一インスタンス | E-13 L24-25 | ○ |
| C-115 | pEnumProvider_Reset: 初期化 | E-13 L35-39 | ○ |
| C-116 | pEnumProvider_Next: フィボナッチ次値 | E-13 L40-46 | ○ |
| C-117 | pEnumProvider_Next: 連続呼び出しで数列生成 | E-13 L40-46 | ○ |
| C-118 | pEnumProvider_Skip: 委譲実装 | E-13 L47-49 | ○ |

### stdRow (E-11)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | Create: 空のstdRow作成 | E-11 L15-18 | ○ |
| C-120 | CreateFromSelection: ListRow からstdRow作成 | E-11 L19-33 | ○ |
| C-121 | CreateFromSelection: 非Range選択でNothing | E-11 L31 | ○ |
| C-122 | CreateFromSelection: ListObject外でNothing | E-11 L28-29 | ○ |
| C-123 | CreateFromListRow: ListRowから作成 | E-11 L34-47 | ○ |
| C-124 | AsArray: 値配列返却 | E-11 L50-52 | ○ |
| C-125 | AsRowArray: 2次元配列返却 | E-11 L55-62 | ○ |
| C-126 | ColumnCount(Get): 列数取得 | E-11 L65-67 | ○ |
| C-127 | Item(Get): ヘッダー名で値取得 | E-11 L70-77 | ○ |
| C-128 | Item(Get): インデックスで値取得 | E-11 L72-73 | ○ |
| C-129 | Item(Let): ヘッダー名で値設定 | E-11 L78-85 | ○ |
| C-130 | Item(Let): インデックスで値設定 | E-11 L80-81 | ○ |
| C-131 | getItem: メソッドラッパー | E-11 L88-90 | ○ |
| C-132 | setItem: メソッドチェーン対応 | E-11 L91-94 | ○ |
| C-133 | protInit: 初期化 | E-11 L99-101 | ○ |

### stdDictionary2 (E-03)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-134 | Create: 辞書作成 | E-03 L87-93 | ○ |
| C-135 | IgnoreCase(Get/Let): 大文字小文字無視設定 | E-03 L104-113 | ○ |
| C-136 | IgnoreCase(Let): 要素ありでエラー | E-03 L109-111 | ○ |
| C-137 | Exists: 存在するキーでTrue | E-03 L117-119 | ○ |
| C-138 | Exists: 存在しないキーでFalse | E-03 L117-119 | ○ |
| C-139 | Add: 新規要素追加 | E-03 L123-143 | ○ |
| C-140 | Add: 重複キーでエラー | E-03 L139-142 | ○ |
| C-141 | Item(Get): 値取得 | E-03 L148-159 | ○ |
| C-142 | Item(Get): 存在しないキーでEmpty/エラー | E-03 L152-153 | ○ |
| C-143 | Item(Let/Set): 値設定・追加 | E-03 L161-177 | ○ |
| C-144 | Remove: 要素削除 | E-03 L181-206 | ○ |
| C-145 | Remove: 存在しないキーでエラー | E-03 L185 | ○ |
| C-146 | RemoveAll: 全削除 | E-03 L210-212 | ○ |
| C-147 | Count(Get): 要素数取得 | E-03 L216-218 | ○ |
| C-148 | Keys(Get): キー配列取得 | E-03 L223-241 | ○ |
| C-149 | Keys(Get): 空辞書で空配列 | E-03 L225-226 | ○ |
| C-150 | Values(Get): 値配列取得 | E-03 L246-264 | ○ |
| C-151 | protSetSize: テーブルサイズ設定 | E-03 L271-285 | ○ |
| C-152 | ExpandSlotTable: 配列拡張 | E-03 L297-310 | ○ |
| C-153 | HashFunction: 文字列ハッシュ計算 | E-03 L321-361 | ○ |
| C-154 | HashFunction: IgnoreCaseでの計算 | E-03 L324-334, L378 | ○ |
| C-155 | GetSlotIndex: インデックス検索 | E-03 L370-405 | ○ |
| C-156 | GetSlotIndex: Create=Trueで新規割当 | E-03 L395-398 | ○ |
| C-157 | GetSlotIndex: 空キーでエラー | E-03 L375 | ○ |
| C-158 | GetFreeSlot: 空きスロット返却 | E-03 L409-420 | ○ |
| C-159 | GetFreeSlot: 空きなしで拡張 | E-03 L411 | ○ |
| C-160 | PrepareSlot: スロット設定 | E-03 L424-438 | ○ |

## 4) 不足情報（Unknown / Missing）
- **stdDictionary.Add/Remove/Item(Let/Set)** (C-007, C-008, C-009)：実装本体が空のため、テストケースの期待結果は設計意図に基づく推測
  - 候補：stdDictionary2実装を参照 / trick版実装を参照 / 設計書の確認
- **stdTable.getListRows** (C-027)：For Each文が閉じていない不完全な実装
  - 候補：実装完了後の再検証が必要
- **stdEnumProvider**：FibonacciIteratorExampleから参照されているが、stdEnumProviderクラス自体のソースがない
  - 候補：別ディレクトリの確認 / 実装待ち

## 5) リスクフラグ（レビュー観点）
- **リスク2（高）**: stdDictionary本体の主要メソッド（Add/Remove）が未実装 - 代替実装（SS版、trick版）は完成しているため、本体実装との整合性確認が必要
- **リスク1（中）**: stdTable.getListRows の実装が不完全 - コンパイルエラーになる可能性
- **リスク1（中）**: stdXLTable.pSheet_SelectionChange に未使用変数・構文エラーの可能性がある（L209-231）
- **リスク0（低）**: WIPステータスのため、インターフェースや仕様が変更される可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] stdDictionary本体のAdd/Remove/Item(Let/Set)が期待通りに動作するか、代替実装と比較確認
- [ ] stdTable.getListRowsの実装完了を確認（For Each文の閉じ漏れ）
- [ ] stdXLTable.pSheet_SelectionChangeの構文エラー修正を確認
- [ ] stdEnumProviderクラスの存在と参照整合性を確認
- [ ] 各テストケースの優先度（高/中/低）が妥当か確認
- [ ] trick版stdDictionaryのWin32 API呼び出しがセキュリティ要件を満たすか確認
