---
generated_at: 2026-01-15 20:15:00
metrics:
  claims_total: 129
  claims_with_evidence: 125
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：wip-core モジュール単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：125 / 129、根拠なし：4
- 優先レビュー（高）
  1. **stdCStruct.typedef**：仕様のみでコード未実装
  2. **stdCStruct.item**：仕様のみでコード未実装
  3. **stdMath.fit**：関数本体が空で未実装
  4. **STD_Runtimes_CLR.StopDomain**：関数本体が空で未実装

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `src/WIP/stdCallback2.cls` - stdCallback2クラスの実装
- E-02: `src/WIP/stdError.cls` - stdError（WIP版改良）クラスの実装
- E-03: `src/WIP/stdErrorWIP.cls` - stdError（旧WIP版）クラスの実装
- E-04: `src/WIP/stdError/stdDebug.cls` - STD_Debugクラスの実装
- E-05: `src/WIP/stdError/stdError.cls` - stdError（イベント版）クラスの実装
- E-06: `src/WIP/stdMath.cls` - stdMathクラスの実装
- E-07: `src/WIP/stdStruct.cls` - stdCStructクラスの仕様コメント
- E-08: `src/WIP/STD_Runtimes_CLR.cls` - STD_Runtimes_CLRクラスの実装
- E-09: `docs/code-to-docs/単体テストケース一覧/plan.md` - モジュール構成定義

## 3) Claims と根拠の対応（レビューの主戦場）

### stdCallback2 (UT-WPC-001 〜 UT-WPC-020)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreateFromRunCommandメソッドが存在する | E-01 (170-173行) | ○ |
| C-02 | CreateFromObjectMemberメソッドが存在する | E-01 (175-178行) | ○ |
| C-03 | CreateFromObjectOffsetメソッドが存在する | E-01 (180-183行) | ○ |
| C-04 | Cloneメソッドが存在する | E-01 (185-201行) | ○ |
| C-05 | Bindメソッドが存在する | E-01 (203-206行) | ○ |
| C-06 | CreateFromModuleMemberメソッドが存在する | E-01 (212-223行) | ○ |
| C-07 | CreateFromPointerメソッドが存在する | E-01 (231-233行) | ○ |
| C-08 | RunメソッドがVB_UserMemId=0で定義 | E-01 (308-312行) | ○ |
| C-09 | RunExメソッドが存在する | E-01 (313-315行) | ○ |
| C-10 | CallbackTypeプロパティが存在する | E-01 (302-304行) | ○ |
| C-11 | ExecuteCallbackメソッドが存在する | E-01 (325-342行) | ○ |
| C-12 | ConcatArrメソッドが存在する | E-01 (353-371行) | ○ |
| C-13 | CopyVariantメソッドが存在する | E-01 (373-379行) | ○ |
| C-14 | ConvertToDispParamsメソッドが存在する | E-01 (345-351行) | ○ |
| C-15 | ECallbackType列挙型が定義されている | E-01 (94-98行) | ○ |
| C-16 | DispCallFunc API宣言がある | E-01 (46行, 53行) | ○ |
| C-17 | IDispatch関連の型定義がある | E-01 (57-92行) | ○ |

### stdError WIP版 (UT-WPC-021 〜 UT-WPC-056)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-18 | getSentryメソッドが存在する | E-02 (30-36行) | ○ |
| C-19 | Class_Terminateでスタックをポップする | E-02 (38-45行) | ○ |
| C-20 | RaiseClientプロパティが存在する | E-02 (47-52行) | ○ |
| C-21 | stackプロパティが存在する | E-02 (54-59行) | ○ |
| C-22 | RefreshStackメソッドが存在する | E-02 (61-66行) | ○ |
| C-23 | AddStackメソッドが存在する | E-02 (69-77行) | ○ |
| C-24 | PopStackメソッドが存在する | E-02 (79-87行) | ○ |
| C-25 | Raiseメソッドが存在する | E-02 (90-125行) | ○ |
| C-26 | GetTraceメソッドが存在する | E-02 (129-142行) | ○ |
| C-27 | SerializeArgsメソッドが存在する | E-02 (202-214行) | ○ |
| C-28 | Serializeメソッドが存在する | E-02 (219-249行) | ○ |
| C-29 | TStack_Createが存在する | E-02 (253-259行) | ○ |
| C-30 | TStack_Pushが存在する | E-02 (264-280行) | ○ |
| C-31 | TStack_PopNoReturnが存在する | E-02 (286-308行) | ○ |
| C-32 | TStack構造体にinitialised, index, arr()がある | E-02 (11-15行) | ○ |

### stdErrorWIP (UT-WPC-057 〜 UT-WPC-065)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | getSentryメソッドがstdSentry連携 | E-03 (26-31行) | ○ |
| C-34 | RefreshStackがstdArrayを使用 | E-03 (33-35行) | ○ |
| C-35 | AddStackがstdArray.Pushを呼ぶ | E-03 (38-41行) | ○ |
| C-36 | PopStackがstdArray.Popを呼ぶ | E-03 (42-48行) | ○ |
| C-37 | RaiseがMsgBoxまたはRaiseClientを使用 | E-03 (51-85行) | ○ |
| C-38 | GetTraceがstack.itemでアクセス | E-03 (89-102行) | ○ |

### stdError/stdError イベント版 (UT-WPC-066 〜 UT-WPC-072)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-39 | OnStackAddイベントが定義されている | E-05 (12行) | ○ |
| C-40 | OnStackPopイベントが定義されている | E-05 (13行) | ○ |
| C-41 | AddStackでDictionaryオブジェクトを作成 | E-05 (36-41行) | ○ |
| C-42 | CreateDictメソッドが存在する | E-05 (106-123行) | ○ |
| C-43 | GetTraceで(""Name"")プロパティにアクセス | E-05 (99行) | ○ |

### STD_Debug (UT-WPC-073 〜 UT-WPC-092)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | warningsプロパティが存在する | E-04 (20-25行) | ○ |
| C-45 | errorsプロパティが存在する | E-04 (29-35行) | ○ |
| C-46 | FilePathプロパティが存在する | E-04 (40-45行) | ○ |
| C-47 | RAWUseプロパティが存在する | E-04 (50-55行) | ○ |
| C-48 | RAWプロパティが存在する | E-04 (57-62行) | ○ |
| C-49 | printtメソッドが存在する | E-04 (66-70行) | ○ |
| C-50 | logメソッドが存在する | E-04 (71-94行) | ○ |
| C-51 | reportメソッドが存在する | E-04 (95-117行) | ○ |
| C-52 | createReportメソッドが存在する | E-04 (119-156行) | ○ |
| C-53 | getStringsメソッドが存在する | E-04 (159-207行) | ○ |
| C-54 | getStringsで3次元配列エラー | E-04 (198行) | ○ |

### stdMath (UT-WPC-093 〜 UT-WPC-106)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-55 | interpolateメソッドが存在する | E-06 (24-74行) | ○ |
| C-56 | 線形補間（Linear）が実装されている | E-06 (30-38行) | ○ |
| C-57 | 対数補間（Logarithmic）が実装されている | E-06 (39-49行) | ○ |
| C-58 | 双曲線補間（Hyperbolic）が実装されている | E-06 (50-70行) | ○ |
| C-59 | GetLinearInterpolateStructが存在する | E-06 (76-82行) | ○ |
| C-60 | fitメソッドが存在するが本体が空 | E-06 (86-88行) | ○ |
| C-61 | Ceilingメソッドが存在する | E-06 (90-92行) | ○ |
| C-62 | Floorメソッドが存在する | E-06 (94-96行) | ○ |

### stdCStruct (UT-WPC-107 〜 UT-WPC-113)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-63 | typedefメソッドの仕様コメントがある | E-07 (18-19行) | △ |
| C-64 | linesプロパティの仕様がある | E-07 (21行) | △ |
| C-65 | pointerプロパティの仕様がある | E-07 (22行) | △ |
| C-66 | dataプロパティの仕様がある | E-07 (23行) | △ |
| C-67 | itemプロパティの仕様がある | E-07 (24-25行) | △ |

### STD_Runtimes_CLR (UT-WPC-114 〜 UT-WPC-129)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-68 | CreateInstanceメソッドが存在する | E-08 (33-35行) | ○ |
| C-69 | Class_Initializeが存在する | E-08 (49-52行) | ○ |
| C-70 | GetHostメソッドが存在する | E-08 (54-61行) | ○ |
| C-71 | GetDefaultDomainメソッドが存在する | E-08 (63-70行) | ○ |
| C-72 | StartDomainメソッドが存在する | E-08 (72-74行) | ○ |
| C-73 | StopDomainメソッドが存在するが本体が空 | E-08 (76-79行) | ○ |
| C-74 | NETLoadLibraryメソッドが存在する | E-08 (81-99行) | ○ |
| C-75 | CompileAssemblyメソッドが存在する | E-08 (101-146行) | ○ |
| C-76 | CompileCSメソッドが存在する | E-08 (148-150行) | ○ |
| C-77 | CompileVBメソッドが存在する | E-08 (152-154行) | ○ |
| C-78 | CorBindToRuntimeEx API宣言がある | E-08 (20-26行) | ○ |

## 4) 不足情報（Unknown / Missing）
- **stdCStruct**: 仕様コメントのみで実装コードがない（52行で終了）
  - テストケースは仕様から推測して作成
  - 候補：実装コード追加 / 仕様明確化 / WIP除外
- **stdMath.fit**: 関数シグネチャのみで本体が空
  - 候補：実装完了待ち / テストケース除外
- **STD_Runtimes_CLR.StopDomain**: メソッド本体が空
  - 候補：実装完了待ち / テストケース除外
- **STD_Runtimes_CLR.LoadLibrary**: 関数本体が不完全（39-40行で終了）
  - テストケース対象外とした

## 5) リスクフラグ（レビュー観点）
- **リスク2（高）**: stdCStructは仕様のみで実装がないため、テストケースが実際の動作と異なる可能性がある
- **リスク1（中）**: STD_Runtimes_CLRはCOM/CLR統合のため、環境依存性が高い
- **リスク1（中）**: stdCallback2はDispCallFunc等の低レベルAPI使用のため、アーキテクチャ（x86/x64）依存
- **リスク0（低）**: stdError系は比較的シンプルなスタック操作のため低リスク
- **リスク0（低）**: stdMathは数学計算のため環境非依存

## 6) レビュアーチェックリスト（最小）
- [ ] stdCStructのテストケース（UT-WPC-107〜113）は実装完了後に再確認
- [ ] stdMath.fitのテストケース（UT-WPC-100）は実装完了後に再確認
- [ ] STD_Runtimes_CLR.StopDomainのテストケース（UT-WPC-120）は実装完了後に再確認
- [ ] stdCallback2のx86/x64両環境でのテスト実行を確認
- [ ] STD_Runtimes_CLRは.NET Framework v4.0.30319がインストールされた環境でテスト
- [ ] stdError系の各バージョン（WIP版、旧WIP版、イベント版）の使い分けを確認
- [ ] テストIDの命名規則（UT-WPC-xxx）がプロジェクト全体で一貫しているか確認
