---
generated_at: 2026-01-15 20:30:00
metrics:
  claims_total: 128
  claims_with_evidence: 120
  claims_without_evidence: 8
confidence_derived: 0.94
---

# 根拠レポート: wip-io 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：120 / 128、根拠なし：8
- 優先レビュー（高）
  1. **stdXML クラス**：スタブ実装のみで詳細な実装コードが存在しない
  2. **stdSettings Export/Import**：未実装メソッド
  3. **stdResource stdIResource_Children**：実装が不完全

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WIP/stdIni.cls` - INIファイル操作クラス（195行）
- E-02: `src/WIP/stdResource.cls` - リソース操作クラス（454行）
- E-03: `src/WIP/stdIResource.cls` - リソースインターフェース（102行）
- E-04: `src/WIP/stdSettings.cls` - 設定管理クラス（235行）
- E-05: `src/WIP/stdXML.cls` - XML操作クラス（94行、スタブ実装）
- E-06: `src/WIP/stdHTML.cls` - HTML生成クラス（245行）
- E-07: `docs/code-to-docs/単体テストケース一覧/plan.md` - テストケース生成プラン

## 3) Claims と根拠の対応（レビューの主戦場）

### stdIni クラス（UT-WIO-001〜UT-WIO-019）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | From ファクトリメソッドの正常系テスト | E-01 L33-38 | ○ |
| C-02 | 存在しないファイルでNoFileエラーハンドリング | E-01 L187-189 | ○ |
| C-03 | init でInitialisedフラグ設定 | E-01 L39-43 | ○ |
| C-04 | Puts でデータ格納 | E-01 L45-47 | ○ |
| C-05 | Gets でデータ取得 | E-01 L48-50 | ○ |
| C-06 | Save でファイル保存 | E-01 L52-107 | ○ |
| C-07 | Save でオブジェクトエラー発生 | E-01 L92-106 | ○ |
| C-08 | Read でINI解析 | E-01 L110-190 | ○ |
| C-09 | Read でParseError発生 | E-01 L174-178 | ○ |
| C-10 | AutoSave時のClass_Terminate | E-01 L192-194 | ○ |

### stdResource クラス（UT-WIO-020〜UT-WIO-055）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | CreateFromFile ファクトリメソッド | E-02 L29-31 | ○ |
| C-12 | CreateFromDir ファクトリメソッド | E-02 L37-39 | ○ |
| C-13 | CreateDir ディレクトリ作成 | E-02 L46-77 | ○ |
| C-14 | CreateFile ファイル作成 | E-02 L83-94 | ○ |
| C-15 | protInit 初期化処理 | E-02 L113-120 | ○ |
| C-16 | Hidden/ReadOnly 属性操作 | E-02 L127-140 | ○ |
| C-17 | ExistsChild 存在確認 | E-02 L142-148 | ○ |
| C-18 | stdIResource_Hash ハッシュ計算 | E-02 L272-322 | ○ |
| C-19 | stdIResource_Size サイズ取得 | E-02 L326-328 | ○ |
| C-20 | stdIResource_Contents コンテンツ取得 | E-02 L356-368 | ○ |
| C-21 | stdIResource_Children 子要素取得 | E-02 L375-378 | △ |
| C-22 | stdIResource_CopyTo コピー機能 | E-02 L383-402 | ○ |
| C-23 | stdIResource_MoveTo 移動機能 | E-02 L407-410 | ○ |
| C-24 | stdIResource_Delete 削除機能 | E-02 L414-425 | ○ |
| C-25 | stdIResource_CreateChild 子作成 | E-02 L431-445 | ○ |

### stdIResource インターフェース（UT-WIO-056〜UT-WIO-068）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-26 | Name プロパティ定義 | E-03 L25 | ○ |
| C-27 | Path プロパティ定義 | E-03 L29 | ○ |
| C-28 | LocalPaths プロパティ定義 | E-03 L35 | ○ |
| C-29 | isContainer プロパティ定義 | E-03 L39 | ○ |
| C-30 | isContentSupported プロパティ定義 | E-03 L43 | ○ |
| C-31 | Contents プロパティ定義 | E-03 L50-51 | ○ |
| C-32 | Size プロパティ定義 | E-03 L55 | ○ |
| C-33 | Hash プロパティ定義 | E-03 L59 | ○ |
| C-34 | Children プロパティ定義 | E-03 L63 | ○ |
| C-35 | CopyTo メソッド定義 | E-03 L68 | ○ |
| C-36 | MoveTo メソッド定義 | E-03 L85 | ○ |
| C-37 | Delete メソッド定義 | E-03 L89 | ○ |
| C-38 | CreateChild メソッド定義 | E-03 L95 | ○ |
| C-39 | Identify メソッド定義 | E-03 L102 | ○ |

### stdSettings クラス（UT-WIO-069〜UT-WIO-086）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | Create ファクトリメソッド | E-04 L40-119 | ○ |
| C-41 | キャッシュ機能 | E-04 L47-59, L111-115 | ○ |
| C-42 | シート/テーブル新規作成 | E-04 L76-99 | ○ |
| C-43 | Init 初期化処理 | E-04 L138-143 | ○ |
| C-44 | Export 機能 | E-04 L145-151 | △ |
| C-45 | Import 機能 | E-04 L153-159 | △ |
| C-46 | system プロパティ Get/Let | E-04 L162-188 | ○ |
| C-47 | user プロパティ Get/Let | E-04 L170-198 | ○ |
| C-48 | OnChange イベント発火 | E-04 L183, L193 | ○ |
| C-49 | GetIdentity 関数 | E-04 L201-211 | ○ |
| C-50 | GetSettingsRange 関数 | E-04 L213-233 | ○ |
| C-51 | MACKeyExists ヘルパー | E-04 L123-135 | ○ |

### stdXML クラス（UT-WIO-087〜UT-WIO-093）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-52 | Create ファクトリメソッド | E-05 L72-74 | △ |
| C-53 | CreateTextNode メソッド | E-05 L75-77 | △ |
| C-54 | CreateFromString メソッド | E-05 L78-80 | △ |
| C-55 | CreateFromFile メソッド | E-05 L81-83 | △ |
| C-56 | ToString メソッド | E-05 L84-86 | △ |
| C-57 | pushChild メソッド | E-05 L89-91 | △ |
| C-58 | pushChildEx メソッド | E-05 L92-94 | △ |

### stdHTML クラス（UT-WIO-094〜UT-WIO-128）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-59 | Create ファクトリメソッド | E-06 L35-38 | ○ |
| C-60 | CreateChild メソッド | E-06 L44-56 | ○ |
| C-61 | CreateLiteral メソッド | E-06 L60-72 | ○ |
| C-62 | protInitElement 初期化 | E-06 L79-84 | ○ |
| C-63 | protInitLiteral 初期化 | E-06 L88-91 | ○ |
| C-64 | TagName プロパティ | E-06 L95-104 | ○ |
| C-65 | Attr プロパティ Get/Let | E-06 L106-130 | ○ |
| C-66 | Id/Title ショートカット | E-06 L133-145 | ○ |
| C-67 | Children プロパティ | E-06 L147-150 | ○ |
| C-68 | AddClasses メソッド | E-06 L154-169 | ○ |
| C-69 | RemoveClasses メソッド | E-06 L173-187 | ○ |
| C-70 | ToString メソッド | E-06 L191-218 | ○ |
| C-71 | serializeAttribute 関数 | E-06 L223-244 | ○ |

## 4) 不足情報（Unknown / Missing）
- **stdXML クラス**: スタブ実装のみで、メソッド本体が空（`End Function` のみ）
  - 候補：実装完了後の再解析 / コメントからの仕様推測 / 別プロジェクトでの参照実装確認
- **stdSettings Export/Import**: `If pInitialised Then` ブロック内が空
  - 候補：要件定義書 / 設計ドキュメント / 開発者への確認
- **stdResource stdIResource_Children**: `Dim res as stdIResource:` 後に実装がない（行378で途切れ）
  - 候補：WIPステータスのため未完成 / 別バージョンでの実装確認

## 5) リスクフラグ（レビュー観点）
- **リスクレベル 2（高リスク）**: stdXML クラス全体
  - スタブ実装のためテストケースは推測に基づく
  - コメント（L1-71）から期待される動作を推定
- **リスクレベル 1（中リスク）**: stdSettings Export/Import
  - 未実装メソッドに対するテストケースは動作確認不可
- **リスクレベル 1（中リスク）**: stdResource Children
  - 実装が不完全で実際の動作が不明
- **リスクレベル 0（低リスク）**: stdIni, stdHTML
  - 完全な実装が存在し、コードから動作を確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] stdXML のテストケース（UT-WIO-087〜UT-WIO-093）は実装完了後に再確認が必要
- [ ] stdSettings の Export/Import テストケースは実装後に有効化
- [ ] stdResource の Children 関連テストケース（UT-WIO-021 の子要素操作）を実装完了後に検証
- [ ] stdIni の Save 処理でファイルシステム操作（Kill, Name）のエラーハンドリング追加を検討
- [ ] stdHTML の AddClasses/RemoveClasses で変数名 `classes` の重複使用を確認（E-06 L154-157, L173-176）
- [ ] VBA の Mac/Windows 条件分岐（#If Mac Then）のテスト環境を両方確保
- [ ] ハッシュ計算（stdResource.stdIResource_Hash）のパフォーマンステストを追加検討
