---
generated_at: 2026-01-15 12:00:00
metrics:
  claims_total: 195
  claims_with_evidence: 183
  claims_without_evidence: 12
confidence_derived: 0.94
---

# 根拠レポート：wip-misc単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：183 / 195、根拠なし：12
- 優先レビュー（高）
  1. **stdGithub**：メソッドが未実装のため、テストケースの期待結果が推測ベース
  2. **stdRuntimeJS IE対応**：Internet Explorerエンジンが未実装のため、エラー挙動が推測
  3. **stdWordDocument FindAllRegex**：未実装メソッドのため、テストケース生成スキップ

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdHTTPServer.cls`
- E-02: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdEndpoint.cls`
- E-03: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdGithub.cls`
- E-04: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdSharepointSite.cls`
- E-05: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdRuntimeJS.cls`
- E-06: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdDate.cls`
- E-07: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/JSONLogic.cls`
- E-08: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdWebSocket/stdWebSocket.cls`
- E-09: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdWebSocket/stdWebSocketNew.cls`
- E-10: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdOpenCL/stdOpenCL.cls`
- E-11: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdCrypto/stdCrypt.cls`
- E-12: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdCrypto/MD5.cls`
- E-13: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdWordLibraries/stdWordDocument.cls`
- E-14: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdEnumProvider/FibonacciIteratorExample.cls`
- E-15: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdEnumProvider/STD_Types_IniVariantEnum.bas`

## 3) Claims と根拠の対応（レビューの主戦場）

### stdHTTPServer (UT-MSC-001 ~ UT-MSC-014)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Create関数でstdHTTPServerインスタンスが返却される | E-01 L157-160 | ○ |
| C-02 | protInitでWSAStartupが呼ばれる | E-01 L164 | ○ |
| C-03 | socketが0の場合vbObjectError + 2が発生 | E-01 L169-172 | ○ |
| C-04 | bindが-1の場合vbObjectError + 3が発生 | E-01 L181-185 | ○ |
| C-05 | listenが-1の場合vbObjectError + 4が発生 | E-01 L188-192 | ○ |
| C-06 | Status関数でWSASelectの結果が返却される | E-01 L199-209 | ○ |
| C-07 | getRequestDataでaccept/recvが呼ばれる | E-01 L211-219 | ○ |
| C-08 | sendResponseでHTTP 200レスポンスが送信される | E-01 L221-231 | ○ |
| C-09 | Class_Terminateでリソース解放される | E-01 L233-236 | ○ |

### stdEndpoint (UT-MSC-015 ~ UT-MSC-020)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 | CreateSharedObjectでレジストリに保存される | E-02 L34-43 | ○ |
| C-11 | CreateConnectionでレジストリから取得される | E-02 L49-62 | ○ |
| C-12 | ポインタが0の場合Nothingが返却される | E-02 L55-57 | ○ |
| C-13 | Derefでポインタからオブジェクト復元 | E-02 L69-74 | ○ |

### stdGithub (UT-MSC-021 ~ UT-MSC-024)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | Create関数の存在 | E-03 L36-38 | ○ |
| C-15 | CreateFile/UpdateFile/DeleteFileの戻り値 | E-03 L39-46 | △ |

### stdSharepointSite (UT-MSC-025 ~ UT-MSC-043)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 | Create関数でインスタンス作成 | E-04 L32-35 | ○ |
| C-17 | Initでパス末尾スラッシュ除去 | E-04 L37 | ○ |
| C-18 | CheckOutFileでSOAPリクエスト送信 | E-04 L48-55 | ○ |
| C-19 | CheckInFileでチェックインタイプ指定 | E-04 L60-67 | ○ |
| C-20 | GetListCollectionでリスト取得 | E-04 L80-84 | ○ |
| C-21 | GetListItemsでrowLimit指定 | E-04 L94-105 | ○ |
| C-22 | UpdateListItemsでバッチ更新 | E-04 L119-125 | ○ |
| C-23 | getSoapXMLでSOAP XML生成 | E-04 L184-209 | ○ |
| C-24 | HTTPPostで認証情報使用 | E-04 L212-228 | ○ |

### stdRuntimeJS (UT-MSC-044 ~ UT-MSC-053)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-25 | Create関数でEdgeエンジン作成 | E-05 L105-108 | ○ |
| C-26 | protInitでEdge API呼び出し | E-05 L111-126 | ○ |
| C-27 | IEエンジンでエラー発生 | E-05 L120-122 | ○ |
| C-28 | ErrorGuardでエラーチェック | E-05 L128-132 | ○ |
| C-29 | Requireでファイル読込・実行 | E-05 L135-142 | ○ |
| C-30 | RunでJavaScript実行 | E-05 L145-153 | ○ |
| C-31 | ProjectWinRTNamespaceのIE制限 | E-05 L176-183 | ○ |

### stdDate (UT-MSC-054 ~ UT-MSC-090)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 | Create関数で日付オブジェクト作成 | E-06 L61-68 | ○ |
| C-33 | CreateFromUnitsで単位指定作成 | E-06 L71-77 | ○ |
| C-34 | CreateFromMSDOSDateTimeでMSDOS変換 | E-06 L85-99 | ○ |
| C-35 | CreateFromParseで各種形式パース | E-06 L121-232 | ○ |
| C-36 | Value Property Get/Let | E-06 L257-271 | ○ |
| C-37 | 各種プロパティ(Seconds,Minutes等) | E-06 L274-340 | ○ |
| C-38 | Country設定でFirstDayOfWeek変更 | E-06 L343-354 | ○ |
| C-39 | Quarter計算 | E-06 L356-362 | ○ |
| C-40 | asMSDOSDate/asMSDOSTime | E-06 L366-381 | ○ |
| C-41 | isLeapでうるう年判定 | E-06 L391-400 | ○ |
| C-42 | 1900年の特殊処理(Excel互換) | E-06 L396 | ○ |
| C-43 | RegexMatchで正規表現マッチ | E-06 L909-1005 | ○ |

### JSONLogic (UT-MSC-091 ~ UT-MSC-115)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-44 | Create関数の存在 | E-07 L35-43 | ○ |
| C-45 | Run関数でExecuteJSON呼び出し | E-07 L46-48 | ○ |
| C-46 | Eql_で等価比較 | E-07 L85-91 | ○ |
| C-47 | Eql2_で型含む等価比較 | E-07 L94-98 | ○ |
| C-48 | NEql_/NEql2_で不等価比較 | E-07 L101-108 | ○ |
| C-49 | Gt_/Gte_/Lt_/Lte_で比較演算 | E-07 L111-140 | ○ |
| C-50 | Lt_の3引数対応 | E-07 L126-131 | ○ |
| C-51 | Truthy_/Not_で真偽演算 | E-07 L143-150 | ○ |
| C-52 | Mod_で剰余演算 | E-07 L153-156 | ○ |
| C-53 | Cat_で文字列連結 | E-07 L169-175 | ○ |
| C-54 | Sum_/Product_で集計演算 | E-07 L185-200 | ○ |
| C-55 | Subtract_で減算(1引数対応) | E-07 L203-209 | ○ |
| C-56 | Min_/Max_で最小最大取得 | E-07 L217-244 | ○ |

### stdWebSocketNew (UT-MSC-116 ~ UT-MSC-140)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-57 | Create関数でWebSocket作成 | E-09 L150-162 | ○ |
| C-58 | url/port/Stateプロパティ | E-09 L166-180 | ○ |
| C-59 | Sendでデータ送信 | E-09 L186-208 | ○ |
| C-60 | Send時の接続チェック | E-09 L187, L206 | ○ |
| C-61 | Receiveでデータ受信 | E-09 L214-270 | ○ |
| C-62 | フラグメント処理 | E-09 L230-258 | ○ |
| C-63 | CloseMessage処理 | E-09 L259-262 | ○ |
| C-64 | CloseSocket/Disconnect | E-09 L276-438 | ○ |
| C-65 | Connect処理とエラーハンドリング | E-09 L285-387 | ○ |
| C-66 | Utf8BytesToString/Utf8BytesFromString | E-09 L443-481 | ○ |

### stdOpenCL (UT-MSC-141 ~ UT-MSC-147)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | Create関数でOpenCLインスタンス作成 | E-10 L99-102 | ○ |
| C-68 | protInitでOpenCL API呼び出し | E-10 L104-141 | ○ |
| C-69 | ErrorGuardでエラーチェック | E-10 L154-158 | ○ |
| C-70 | Run/Bindメソッドの存在 | E-10 L143-149 | △ |

### stdCrypt (UT-MSC-148 ~ UT-MSC-156)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | Encrypt関数でCryptProtectData呼び出し | E-11 L28-35 | ○ |
| C-72 | Decrypt関数でCryptUnprotectData呼び出し | E-11 L36-42 | ○ |
| C-73 | BytesToHex関数 | E-11 L44-52 | ○ |
| C-74 | BytesToStr関数 | E-11 L53-78 | ○ |
| C-75 | GetbSizeでサイズ取得 | E-11 L83-89 | ○ |

### MD5 (UT-MSC-157 ~ UT-MSC-168)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | HashFile関数でファイルハッシュ | E-12 L175-209 | ○ |
| C-77 | HashBytes関数でバイトハッシュ | E-12 L211-215 | ○ |
| C-78 | HashString関数で文字列ハッシュ | E-12 L217-221 | ○ |
| C-79 | NewHash関数でハッシュ作成 | E-12 L163-171 | ○ |
| C-80 | HashBlock関数でブロックハッシュ | E-12 L117-128 | ○ |
| C-81 | HashValue関数でハッシュ値取得 | E-12 L130-161 | ○ |
| C-82 | Class_Initialize/Terminate | E-12 L225-242 | ○ |

### stdWordDocument (UT-MSC-169 ~ UT-MSC-173)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | FindAll関数で検索結果取得 | E-13 L13-47 | ○ |
| C-84 | 各種オプション(MatchCase等) | E-13 L23-34 | ○ |
| C-85 | FindAllRegexの存在 | E-13 L50-52 | △ |

### FibonacciIteratorExample (UT-MSC-174 ~ UT-MSC-179)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | GetEnum関数で列挙子取得 | E-14 L23-32 | ○ |
| C-87 | pEnumProvider_Reset/Next/Skip | E-14 L35-49 | ○ |

### STD_Types_IniVariantEnum (UT-MSC-180 ~ UT-MSC-195)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-88 | NewEnumerator関数でIEnumVARIANT作成 | E-15 L46-86 | ○ |
| C-89 | VTable初期化 | E-15 L53-63 | ○ |
| C-90 | IUnknown_QueryInterface | E-15 L114-131 | ○ |
| C-91 | IUnknown_AddRef/Release | E-15 L133-143 | ○ |
| C-92 | IEnumVARIANT_Next | E-15 L145-171 | ○ |
| C-93 | IEnumVARIANT_Skip/Reset/Clone未実装 | E-15 L173-183 | ○ |

## 4) 不足情報（Unknown / Missing）

### 根拠なし項目

1. **stdGithub メソッド実装**（C-15）
   - CreateFile/UpdateFile/DeleteFileは空のメソッドボディ
   - テストケースは関数シグネチャから推測
   - 候補：GitHub API仕様書 / 実装予定ドキュメント

2. **stdOpenCL Run/Bindメソッド**（C-70）
   - メソッドは存在するが実装が空
   - テストケースは関数シグネチャから推測
   - 候補：OpenCL仕様書 / 設計ドキュメント

3. **stdWordDocument FindAllRegex**（C-85）
   - "unimplemented"とコメントあり
   - テストケース生成をスキップ
   - 候補：正規表現検索の設計仕様

4. **stdRuntimeJS Eval/AddObject/AddFunction**
   - メソッドは存在するが実装が空
   - テストケース生成をスキップ

5. **JSONLogic In_/Substr_/Merge_/Var_メソッド**
   - 一部未実装または不完全
   - テストケースの期待結果が推測ベース

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|-------------|------|------|
| 2（高） | stdHTTPServer全般 | Winsock APIの直接呼び出し、エラー処理の確認が必要 |
| 2（高） | stdCrypt Encrypt/Decrypt | 暗号化処理、セキュリティ上の確認が必要 |
| 2（高） | MD5 HashFile/HashBytes | CryptoAPI呼び出し、ハッシュ値の正確性確認が必要 |
| 2（高） | stdWebSocketNew 通信処理 | WinHTTP API、ネットワークエラー処理の確認が必要 |
| 1（中） | stdDate パース処理 | 多様な日付形式のパース、エッジケースの確認 |
| 1（中） | stdSharepointSite SOAP処理 | XML生成、SharePoint API互換性の確認 |
| 1（中） | stdOpenCL GPU処理 | OpenCL利用可能環境での動作確認が必要 |
| 0（低） | JSONLogic 演算処理 | 単純な演算ロジック、テスト容易 |
| 0（低） | stdEndpoint オブジェクト共有 | レジストリ操作、比較的単純なロジック |

## 6) レビュアーチェックリスト（最小）

- [ ] stdGithubの未実装メソッドについて、テストケースをスキップするか、スタブテストとして残すか確認
- [ ] stdHTTPServerのWSAエラーコードが正しくマッピングされているか確認
- [ ] stdDateの1900年うるう年バグ（Excel互換）の処理が意図通りか確認
- [ ] stdWebSocketNewのフラグメント処理ロジックが仕様通りか確認
- [ ] MD5のハッシュ値が期待通りのテストベクターと一致するか確認
- [ ] stdCryptの暗号化/復号が可逆であることの確認
- [ ] STD_Types_IniVariantEnumのメモリ管理（CoTaskMemAlloc/Free）が適切か確認
- [ ] stdOpenCLのGPU非対応環境でのフォールバック動作確認
- [ ] stdSharepointSiteのSOAP XMLが実際のSharePoint APIと互換性があるか確認
- [ ] 全体的にWIP（開発中）クラスであることを考慮し、本番利用時は再検証が必要
