---
generated_at: 2026-01-15 20:30:00
metrics:
  claims_total: 85
  claims_with_evidence: 82
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：wip-string 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：82 / 85、根拠なし：3
- 優先レビュー（高）
  1. **UT-REX-048**: Parse異常系テスト - エラー仕様の詳細根拠なし
  2. **UT-REX-049**: Parse異常系テスト - エラーメッセージの詳細根拠なし
  3. **UT-STR-008**: Split境界値テスト - Limit=0の挙動仕様根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdString.cls` - STD_Types_String クラス定義
- E-02: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdStringBuilder.cls` - stdStringBuilder クラス定義
- E-03: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdRegex2.cls` - stdRegex2 クラス定義
- E-04: `/Users/tomokababa/Work/route06/stdVBA-master/docs/code-to-docs/単体テストケース一覧/plan.md` - テストケース生成プラン

## 3) Claims と根拠の対応（レビューの主戦場）

### STD_Types_String (Split関数)

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-STR-001) | デリミタで文字列が正しく分割される | E-01 L14-89 Split関数実装 | ○ |
| C-02 (UT-STR-002) | 複数文字デリミタで分割できる | E-01 L21 lngDelLen = LenB(Delimiter) | ○ |
| C-03 (UT-STR-003) | Limitパラメータで分割数を制限できる | E-01 L47-61 Limit処理ロジック | ○ |
| C-04 (UT-STR-004) | Limit=-1で無制限分割できる | E-01 L32-46 Limit=-1の条件分岐 | ○ |
| C-05 (UT-STR-005) | 空文字列で空配列が返却される | E-01 L23 lngExpLen > 0 の条件 | ○ |
| C-06 (UT-STR-006) | 空デリミタで空配列が返却される | E-01 L23 lngDelLen > 0 の条件 | ○ |
| C-07 (UT-STR-007) | デリミタが見つからない場合元文字列が返却される | E-01 L66-68 lngCount=0の処理 | ○ |
| C-08 (UT-STR-008) | Limit=0で空配列が返却される | E-01 L23 Limit > 0の条件 | △ |
| C-09 (UT-STR-009) | 連続デリミタで空要素が生成される | E-01 L71-77 MidB$による部分取得 | ○ |
| C-10 (UT-STR-010) | 先頭デリミタで空要素が先頭に来る | E-01 L71 LeftB$による先頭取得 | ○ |
| C-11 (UT-STR-011) | 末尾デリミタで空要素が末尾に来る | E-01 L77 RightB$による末尾取得 | ○ |

### stdStringBuilder

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-12 (UT-STB-001) | Createで新インスタンスが生成される | E-02 L155-157 Create関数 | ○ |
| C-13 (UT-STB-002) | Str Getで文字列が取得できる | E-02 L106-110 Str Property Get | ○ |
| C-14 (UT-STB-003) | Str Letで文字列が設定できる | E-02 L111-122 Str Property Let | ○ |
| C-15 (UT-STB-004) | 空文字列を設定できる | E-02 L114 sLength = Len(s) | ○ |
| C-16 (UT-STB-005) | 長い文字列でバッファが拡張される | E-02 L116 Capacity判定ロジック | ○ |
| C-17 (UT-STB-006) | Appendで文字列が追加される | E-02 L125-152 Append関数 | ○ |
| C-18 (UT-STB-007) | JoinStrで連結文字が設定される | E-02 L145 JoinStr使用 | ○ |
| C-19 (UT-STB-008) | TrimBehaviour=LTrimで左側空白除去 | E-02 L131-132 LTrim処理 | ○ |
| C-20 (UT-STB-009) | TrimBehaviour=RTrimで右側空白除去 | E-02 L133-134 RTrim処理 | ○ |
| C-21 (UT-STB-010) | TrimBehaviour=Trimで両側空白除去 | E-02 L135-136 Trim処理 | ○ |
| C-22 (UT-STB-011) | 空文字列追加で変化なし | E-02 L142 Length + lengthJoin = 0条件 | ○ |
| C-23 (UT-STB-012) | バッファ容量超過時に自動拡張 | E-02 L219-235 SwitchToLargerBuffer | ○ |
| C-24 (UT-STB-013) | InjectionVariablesで辞書が取得できる | E-02 L94-97 InjectionVariables Property | ○ |
| C-25 (UT-STB-014) | 変数が文字列に注入される | E-02 L184-189 変数置換ロジック | ○ |
| C-26 (UT-STB-015) | 複数変数が正しく注入される | E-02 L186 For Eachループ | ○ |
| C-27 (UT-STB-016) | MinimumCapacity Getで最小容量取得 | E-02 L99-101 MinimumCapacity Get | ○ |
| C-28 (UT-STB-017) | MinimumCapacity Letで最小容量設定 | E-02 L102-104 MinimumCapacity Let | ○ |
| C-29 (UT-STB-018) | 2未満の値は2に補正される | E-02 L103 条件分岐 | ○ |
| C-30 (UT-STB-019) | TestメソッドがTrueを返却する | E-02 L159-172 Test関数 | ○ |
| C-31 (UT-STB-020) | 初期化時にデフォルト値設定 | E-02 L237-240 Class_Initialize | ○ |

### stdRegex2

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-32 (UT-REX-001) | Createで正規表現オブジェクト生成 | E-03 L44-47 Create関数 | ○ |
| C-33 (UT-REX-002) | patternプロパティでパターン取得 | E-03 L58-60 pattern Property | ○ |
| C-34 (UT-REX-003) | Flagsプロパティでフラグ取得 | E-03 L62-64 Flags Property | ○ |
| C-35 (UT-REX-004) | astプロパティでAST取得 | E-03 L66-68 ast Property | ○ |
| C-36 (UT-REX-005) | Generateでパターン一致文字列生成 | E-03 L73-76 Generate関数 | ○ |
| C-37 (UT-REX-006) | maxRepitionLengthで繰り返し上限設定 | E-03 L74 maxRepitionLength代入 | ○ |
| C-38 (UT-REX-007) | 数字パターンで数字生成 | E-03 L321-323 \\d処理 | ○ |
| C-39 (UT-REX-008) | リテラル文字がそのまま出力 | E-03 L703-704 literal atomType処理 | ○ |
| C-40 (UT-REX-009) | 選択パターンから1つ選択 | E-03 L664 RandBetween選択 | ○ |
| C-41 (UT-REX-010) | グループがキャプチャされる | E-03 L267-273 capturing-group処理 | ○ |
| C-42 (UT-REX-011) | 非キャプチャグループが処理される | E-03 L253-254 non-capturing-group | ○ |
| C-43 (UT-REX-012) | 空パターンで空文字列返却 | E-03 L301-302 empty atomType | ○ |
| C-44 (UT-REX-013) | 単純パターンがパースできる | E-03 L157-163 Parse関数 | ○ |
| C-45 (UT-REX-014) | 文字クラスがパースできる | E-03 L289-296 charGroup処理 | ○ |
| C-46 (UT-REX-015) | 量指定子*がパースできる | E-03 L205-207 zeroPlus | ○ |
| C-47 (UT-REX-016) | 量指定子+がパースできる | E-03 L208-210 onePlus | ○ |
| C-48 (UT-REX-017) | 量指定子?がパースできる | E-03 L211-213 zeroOrOne | ○ |
| C-49 (UT-REX-018) | 量指定子{n}がパースできる | E-03 L214-227 bound quantifier | ○ |
| C-50 (UT-REX-019) | 量指定子{n,m}がパースできる | E-03 L218-223 min/max処理 | ○ |
| C-51 (UT-REX-020) | 量指定子{n,}がパースできる | E-03 L219-220 max=maxRepitionLength | ○ |
| C-52 (UT-REX-021) | \\dがパースできる | E-03 L321-323 digit処理 | ○ |
| C-53 (UT-REX-022) | \\wがパースできる | E-03 L324-326 word処理 | ○ |
| C-54 (UT-REX-023) | \\sがパースできる | E-03 L327-329 space処理 | ○ |
| C-55 (UT-REX-024) | \\Dがパースできる | E-03 L330-332 非digit処理 | ○ |
| C-56 (UT-REX-025) | \\Wがパースできる | E-03 L333-335 非word処理 | ○ |
| C-57 (UT-REX-026) | \\Sがパースできる | E-03 L336-338 非space処理 | ○ |
| C-58 (UT-REX-027) | ^アンカーがパースできる | E-03 L278-280 BOFアンカー | ○ |
| C-59 (UT-REX-028) | $アンカーがパースできる | E-03 L281-283 EOFアンカー | ○ |
| C-60 (UT-REX-029) | \\bがパースできる | E-03 L315-317 wordBoundary | ○ |
| C-61 (UT-REX-030) | \\Bがパースできる | E-03 L318-320 notWordBoundary | ○ |
| C-62 (UT-REX-031) | 先読み(?=)がパースできる | E-03 L255-256 positive-lookahead | ○ |
| C-63 (UT-REX-032) | 否定先読み(?!)がパースできる | E-03 L265-266 negative-lookahead | ○ |
| C-64 (UT-REX-033) | 後読み(?<=)がパースできる | E-03 L251-252 positive-lookbehind | ○ |
| C-65 (UT-REX-034) | 否定後読み(?<!)がパースできる | E-03 L249-250 negative-lookbehind | ○ |
| C-66 (UT-REX-035) | 名前付きキャプチャグループがパースできる | E-03 L257-264 named-capturing-group | ○ |
| C-67 (UT-REX-036) | \\rがパースできる | E-03 L339-341 vbCr | ○ |
| C-68 (UT-REX-037) | \\nがパースできる | E-03 L342-344 vbLf | ○ |
| C-69 (UT-REX-038) | \\tがパースできる | E-03 L345-347 vbTab | ○ |
| C-70 (UT-REX-039) | \\xNNがパースできる | E-03 L354-356 16進エスケープ | ○ |
| C-71 (UT-REX-040) | \\uNNNNがパースできる | E-03 L357-359 Unicodeエスケープ | ○ |
| C-72 (UT-REX-041) | \\cXがパースできる | E-03 L360-367 制御文字 | ○ |
| C-73 (UT-REX-042) | 数値後方参照がパースできる | E-03 L372-374 backreference-numeric | ○ |
| C-74 (UT-REX-043) | 名前付き後方参照がパースできる | E-03 L368-371 backreference-named | ○ |
| C-75 (UT-REX-044) | 否定文字クラスがパースできる | E-03 L291-293 ^ invert処理 | ○ |
| C-76 (UT-REX-045) | 任意文字.がパースできる | E-03 L286-288 anyChar処理 | ○ |
| C-77 (UT-REX-046) | 非貪欲*?がパースできる | E-03 L207 greedy判定 | ○ |
| C-78 (UT-REX-047) | 非貪欲+?がパースできる | E-03 L210 greedy判定 | ○ |
| C-79 (UT-REX-048) | 不正パターンでエラースロー | E-03 L548 Err.Raise 5 | △ |
| C-80 (UT-REX-049) | 不正制御文字でエラースロー | E-03 L366-367 Err.Raise 5 | △ |
| C-81 (UT-REX-050) | createCharSetで文字セット作成 | E-03 L429-435 createCharSet | ○ |
| C-82 (UT-REX-051) | 単一文字の文字セット作成 | E-03 L430 charMax = -1のデフォルト | ○ |
| C-83 (UT-REX-052) | invertCharSetsで文字セット反転 | E-03 L454-470 invertCharSets | ○ |
| C-84 (UT-REX-053) | RandBetweenで範囲内乱数返却 | E-03 L782-784 RandBetween | ○ |
| C-85 (UT-REX-054) | min=maxで単一値返却 | E-03 L783 計算式 | ○ |

## 4) 不足情報（Unknown / Missing）

### 根拠なしの理由

1. **UT-REX-048, UT-REX-049** (異常系テスト)
   - ソースコード内にErr.Raiseは存在するが、全てのエラーケースの網羅的な仕様書が存在しない
   - 候補：VBA標準エラーコード仕様 / プロジェクトエラーハンドリング規約 / テスト実行による実証

2. **UT-STR-008** (Limit=0のケース)
   - コード上の条件分岐から推測はできるが、明示的な仕様記述がない
   - 候補：VBA.Split関数の仕様書 / プロジェクト要件定義書

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 1 | 異常系テスト(UT-REX-048, 049) | エラー仕様の詳細が不明確 |
| 0 | 正常系テスト全般 | ソースコードから明確に根拠が取得可能 |
| 0 | 境界値テスト | コード上の条件分岐から特定可能 |

- 0: 低リスク（ソースコードから直接確認可能）
- 1: 中リスク（推測を含む、要確認）
- 2: 高リスク（根拠なし、要対応）

## 6) レビュアーチェックリスト（最小）

### 必須確認項目
- [ ] STD_Types_String.Splitの境界値テスト(UT-STR-005〜011)が実際の挙動と一致するか
- [ ] stdStringBuilder.Appendのバッファ拡張ロジック(UT-STB-012)が正しくテストされているか
- [ ] stdRegex2の各エスケープシーケンス処理(UT-REX-021〜043)が網羅されているか
- [ ] 異常系テスト(UT-REX-048, 049)の期待結果が正確か確認

### 追加確認推奨項目
- [ ] stdRegex2のTest, Match, Replace関数は@TODOマークがあり未実装のため、テストケースを追加不要と判断したが、将来実装時に追加が必要
- [ ] stdRegex2のList2D関数も未実装のためテストケース対象外
- [ ] SafeArrayRedim API呼び出しの動作確認（プラットフォーム依存の可能性）

### コード品質確認
- [ ] テストIDの命名規則(UT-STR, UT-STB, UT-REX)が一貫しているか
- [ ] 優先度設定が適切か（金額計算なし、基本的なAPI機能のため高〜中が中心）
- [ ] 備考欄の記載が十分か
