---
generated_at: 2026-01-15 20:30:00
metrics:
  claims_total: 161
  claims_with_evidence: 158
  claims_without_evidence: 3
confidence_derived: 0.98
---

# 根拠レポート：wip-system単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：158 / 161、根拠なし：3
- 優先レビュー（高）
  1. **C-071 ExifProperty**: WIA.ImageFileオブジェクトの詳細仕様が未確認
  2. **C-093 Tick Event コールバック**: 非同期処理のタイミング検証が困難
  3. **C-112 5分タイムアウト**: タイムアウト値がハードコードされているが仕様根拠が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WIP/stdShell.cls` - stdShellクラス実装（約2100行）
- E-02: `src/WIP/stdShellMTP.cls` - stdShellMTPクラス実装（129行）
- E-03: `src/WIP/stdIShellExtension.cls` - stdIShellExtensionインターフェース定義（65行）
- E-04: `src/WIP/stdTimer.cls` - stdTimerクラス実装（280行）
- E-05: `src/WIP/stdCallableScheduler.bas` - stdCallableSchedulerモジュール（32行）
- E-06: `src/WIP/stdICallableScheduler.bas` - stdICallableScheduler（エラーハンドリング版）モジュール（39行）
- E-07: `src/WIP/stdTimerServerWIP.bas` - stdTimerServerWIPモジュール（198行）
- E-08: `src/WIP/stdCOMDispatch.cls` - stdCOMDispatch（IDispatchラッパー）クラス（164行）
- E-09: `src/WIP/stdDLL/stdDLLFunc.cls` - stdDLLFuncクラス実装（266行）
- E-10: `src/WIP/Pointers/stdPointer.cls` - stdPointerクラス実装（135行）
- E-11: `src/WIP/Pointers/stdPointer v2.cls` - stdPointer v2クラス実装（303行）
- E-12: `docs/code-to-docs/単体テストケース一覧/plan.md` - テストケース生成プラン

## 3) Claims と根拠の対応（レビューの主戦場）

### stdShellクラス（C-001 ~ C-072）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | Create: ファイルパスからオブジェクト生成 | E-01 L1092-1100 | ○ |
| C-002 | Create: フォルダパスからオブジェクト生成 | E-01 L1092-1100 | ○ |
| C-003 | Create: 仮想オブジェクト生成 | E-01 L1096-1100 | ○ |
| C-004 | CreateFile: ファイルタイプ固定 | E-01 L1106-1109 | ○ |
| C-005 | CreateFolder: フォルダタイプ固定 | E-01 L1115-1118 | ○ |
| C-006 | CreateRoot: ルートオブジェクト | E-01 L1125-1132 | ○ |
| C-007 | CreateTemporaryItem: 一時ファイル | E-01 L1138-1143 | ○ |
| C-008 | Exists: ファイル存在確認True | E-01 L1446-1461 | ○ |
| C-009 | Exists: ファイル存在確認False | E-01 L1446-1461 | ○ |
| C-010 | Exists: Root常にTrue | E-01 L1447-1450 | ○ |
| C-011 | Ensure: ファイル作成 | E-01 L1471-1519 | ○ |
| C-012 | Ensure: フォルダ作成 | E-01 L1499-1516 | ○ |
| C-013 | Ensure: 親再帰作成 | E-01 L1483-1488, 1501-1506 | ○ |
| C-014 | Ensure: 既存で冪等 | E-01 L1480 | ○ |
| C-015 | Touch: 新規作成 | E-01 L1523-1541 | ○ |
| C-016 | Touch: タイムスタンプ更新 | E-01 L1530-1532 | ○ |
| C-017 | Touch: ファイル以外False | E-01 L1524 | ○ |
| C-018 | Parent: 親取得 | E-01 L1548-1552 | ○ |
| C-019 | Parent: Root Nothing | E-01 L1549 | ○ |
| C-020 | Name: 拡張子なし | E-01 L1273-1277 | ○ |
| C-021 | Name: 拡張子付き | E-01 L1273-1277 | ○ |
| C-022 | Extension: 拡張子取得 | E-01 L1284-1287 | ○ |
| C-023 | Extension: フォルダ空 | E-01 L1285 | ○ |
| C-024 | FullPath: パス取得 | E-01 L1264-1266 | ○ |
| C-025 | IsFile: タイプ判定 | E-01 L1067-1069 | ○ |
| C-026 | IsFolder: タイプ判定 | E-01 L1076-1078 | ○ |
| C-027 | IsVirtual: 仮想判定 | E-01 L1085-1087 | ○ |
| C-028 | Size: ファイルサイズ | E-01 L1560-1575 | ○ |
| C-029 | Size: ファイル以外エラー | E-01 L1572-1574 | ○ |
| C-030 | GetSize: 再帰サイズ | E-01 L1583-1596 | ○ |
| C-031 | Read: バイト配列 | E-01 L1696-1723 | ○ |
| C-032 | Read: ファイル以外エラー | E-01 L1720-1722 | ○ |
| C-033 | ReadText: 文字列読み込み | E-01 L1727-1738 | ○ |
| C-034 | Overwrite: 上書き | E-01 L1782-1809 | ○ |
| C-035 | Overwrite: バイト配列 | E-01 L1791-1792 | ○ |
| C-036 | Append: データ追加 | E-01 L1743-1766 | ○ |
| C-037 | AppendLine: 行追加 | E-01 L1771-1777 | ○ |
| C-038 | Clear: クリア | E-01 L1813-1828 | ○ |
| C-039 | Delete: ファイル削除 | E-01 L2006-2010 | ○ |
| C-040 | Delete: 再帰削除 | E-01 L1997-2005 | ○ |
| C-041 | Delete: Root保護 | E-01 L1995-1996 | ○ |
| C-042 | CopyTo: ファイルコピー | E-01 L2090-2093 | ○ |
| C-043 | CopyTo: 再帰コピー | E-01 L2095-2099 | ○ |
| C-044 | CopyToAsync: 非同期コピー | E-01 L2030-2054 | ○ |
| C-045 | CopyToAsyncHasCompleted: 完了検出 | E-01 L2067-2078 | ○ |
| C-046 | Hash: MD5 | E-01 L1835-1930, L1839-1844 | ○ |
| C-047 | Hash: SHA1 | E-01 L1845-1848 | ○ |
| C-048 | Hash: SHA256 | E-01 L1849-1853 | ○ |
| C-049 | Hash: SHA384 | E-01 L1854-1858 | ○ |
| C-050 | Hash: SHA512 | E-01 L1859-1863 | ○ |
| C-051 | Children: 子要素 | E-01 L1659-1692 | ○ |
| C-052 | ChildrenRaw: 生子要素 | E-01 L1600-1640 | ○ |
| C-053 | DescendentsRaw: 子孫 | E-01 L1644-1654 | ○ |
| C-054 | Find: 条件検索 | E-01 L1939-1957 | ○ |
| C-055 | FindAll: 全件検索 | E-01 L1965-1984 | ○ |
| C-056 | DateModified: 更新日時 | E-01 L1291-1304 | ○ |
| C-057 | DateAccessed: アクセス日時 | E-01 L1308-1321 | ○ |
| C-058 | DateCreated: 作成日時 | E-01 L1325-1338 | ○ |
| C-059 | IsReadOnly: 取得 | E-01 L1342-1344 | ○ |
| C-060 | IsReadOnly: 設定 | E-01 L1345-1347 | ○ |
| C-061 | IsHidden: 取得 | E-01 L1351-1354 | ○ |
| C-062 | IsSystemFile: 取得 | E-01 L1361-1363 | ○ |
| C-063 | IsArchive: 取得 | E-01 L1370-1372 | ○ |
| C-064 | AsFile: タイプ変換 | E-01 L1177-1179 | ○ |
| C-065 | AsFolder: タイプ変換 | E-01 L1185-1188 | ○ |
| C-066 | ToLegalItem: サニタイズ | E-01 L1193-1205 | ○ |
| C-067 | ToFSO: FSO変換 | E-01 L1213-1222 | ○ |
| C-068 | ToIStream: Stream変換 | E-01 L1229-1238 | ○ |
| C-069 | SaveAsShortcut: ショートカット | E-01 L1246-1256 | ○ |
| C-070 | PropertyFromString: 拡張プロパティ | E-01 L1380-1384 | ○ |
| C-071 | ExifProperty: EXIF取得 | E-01 L1398-1407 | △ |
| C-072 | BindExtension: 拡張登録 | E-01 L1160-1163 | ○ |

### stdShellMTPクラス（C-073 ~ C-082）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-073 | CreateFromDeviceName: 正常 | E-02 L22-35 | ○ |
| C-074 | CreateFromDeviceName: 異常 | E-02 L34 | ○ |
| C-075 | CreateFromShellFolder: 正常 | E-02 L43-46 | ○ |
| C-076 | CreateAllPortableDevices: 全取得 | E-02 L53-62 | ○ |
| C-077 | Children: 子要素 | E-02 L76-83 | ○ |
| C-078 | Parent: 親取得 | E-02 L90-96 | ○ |
| C-079 | Parent: ルートNothing | E-02 L91-94 | ○ |
| C-080 | Path: MTPパス | E-02 L103-110 | ○ |
| C-081 | Name: アイテム名 | E-02 L117-120 | ○ |
| C-082 | Exists: 存在確認 | E-02 L127-129 | ○ |

### stdIShellExtensionインターフェース（C-083 ~ C-086）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-083 | IsExtensionOf: 判定 | E-03 L22 | ○ |
| C-084 | CreateExtension: 生成 | E-03 L36 | ○ |
| C-085 | Object: 生オブジェクト | E-03 L50 | ○ |
| C-086 | DescendentsRaw: 子孫 | E-03 L65 | ○ |

### stdTimerクラス（C-087 ~ C-099）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-087 | Create: タイマー生成 | E-04 L93-96 | ○ |
| C-088 | Create: コールバック付き | E-04 L93-96 | ○ |
| C-089 | CreateFromExisting: 復元 | E-04 L103-106 | ○ |
| C-090 | ID: ID取得 | E-04 L142-148 | ○ |
| C-091 | ID: predefinedエラー | E-04 L143-144 | ○ |
| C-092 | Tick Event: イベント発生 | E-04 L83, L273-278 | ○ |
| C-093 | Tick Event: コールバック実行 | E-04 L276 | △ |
| C-094 | Class_Terminate: 停止 | E-04 L267-270 | ○ |
| C-095 | getRemoteWorkbookInstance: WB取得 | E-04 L123-140 | ○ |
| C-096 | getRemoteWorkbookInstance: キャッシュ | E-04 L124-125 | ○ |
| C-097 | getVBOM: 状態取得 | E-04 L203-206 | ○ |
| C-098 | setVBOM: 設定変更 | E-04 L212-227 | ○ |
| C-099 | injectCode: コード注入 | E-04 L193-199 | ○ |

### stdCallableScheduler（C-100 ~ C-104）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-100 | ScheduleCallback: スケジュール | E-05 L8-14 | ○ |
| C-101 | ScheduleCallback: 初期化 | E-05 L9 | ○ |
| C-102 | protCallScheduledCallbacks: 実行 | E-05 L22-31 | ○ |
| C-103 | protCallScheduledCallbacks: 再スケジュール | E-05 L28-29 | ○ |
| C-104 | stdICallableScheduler: エラーハンドリング | E-06 L9-18 | ○ |

### stdTimerServerWIP（C-105 ~ C-118）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-105 | AddTimer: タイマー追加 | E-07 L57-72 | ○ |
| C-106 | AddTimer: 最小値制限 | E-07 L60 | ○ |
| C-107 | AddTimer: 最大値制限 | E-07 L59 | ○ |
| C-108 | AddTimer: MainLoop開始 | E-07 L71 | ○ |
| C-109 | StopTimer: 停止 | E-07 L76-83 | ○ |
| C-110 | MainLoop: アクティブ処理 | E-07 L86-139 | ○ |
| C-111 | MainLoop: イベント発火 | E-07 L107 | ○ |
| C-112 | MainLoop: 5分タイムアウト | E-07 L118-120 | △ |
| C-113 | getGUID: GUID生成 | E-07 L143-150 | ○ |
| C-114 | getTickDiff: ティック差計算 | E-07 L158-165 | ○ |
| C-115 | getTickDiff: オーバーフロー | E-07 L160-161 | ○ |
| C-116 | BitwiseSubtract: ビット減算 | E-07 L171-178 | ○ |
| C-117 | shl: 左シフト | E-07 L183-196 | ○ |
| C-118 | shl: オーバーフロー | E-07 L189-192 | ○ |

### stdCOMDispatch（C-119 ~ C-125）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | Create: ディスパッチ生成 | E-08 L86-89 | ○ |
| C-120 | dispInvoke: メソッド呼び出し | E-08 L100-120 | ○ |
| C-121 | dispInvoke: プロパティ取得 | E-08 L100-120 | ○ |
| C-122 | dispInvoke: エラー | E-08 L117-119 | ○ |
| C-123 | dispGetIDsOfNames: 名前解決 | E-08 L126-146 | ○ |
| C-124 | dispGetIDsOfNames: エラー | E-08 L143-145 | ○ |
| C-125 | dispGetIEnumVARIANT: 列挙子 | E-08 L148-158 | ○ |

### stdDLLFunc（C-126 ~ C-144）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-126 | CreateStdCallA: 生成 | E-09 L77-80 | ○ |
| C-127 | CreateCDeclA: 生成 | E-09 L89-92 | ○ |
| C-128 | CreateStdCallW: 生成 | E-09 L101-104 | ○ |
| C-129 | CreateCDeclW: 生成 | E-09 L113-116 | ○ |
| C-130 | Create: カスタム | E-09 L127-130 | ○ |
| C-131 | protInit: DLLロード | E-09 L151-154 | ○ |
| C-132 | protInit: 関数アドレス | E-09 L155 | ○ |
| C-133 | protInit: DLL未検出 | E-09 L157 | ○ |
| C-134 | protInit: 関数未検出 | E-09 L158 | ○ |
| C-135 | Run: 関数実行 | E-09 L164-168 | ○ |
| C-136 | RunEx: 配列パラメータ | E-09 L173-222 | ○ |
| C-137 | RunEx: 文字列変換 | E-09 L183-207 | ○ |
| C-138 | RunEx: ANSI変換 | E-09 L197-203 | ○ |
| C-139 | RunEx: 呼び出しエラー | E-09 L219-221 | ○ |
| C-140 | PointerToStringA: 変換 | E-09 L228-238 | ○ |
| C-141 | PointerToStringA: NULL | E-09 L230 | ○ |
| C-142 | PointerToStringW: 変換 | E-09 L244-253 | ○ |
| C-143 | PointerToStringW: NULL | E-09 L246 | ○ |
| C-144 | Class_Terminate: アンロード | E-09 L259-263 | ○ |

### stdPointer（C-145 ~ C-161）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-145 | Size: サイズ取得 | E-10 L44-57 | ○ |
| C-146 | Size: デフォルト | E-10 L45-47 | ○ |
| C-147 | FromPtr: ポインタから生成 | E-10 L65-69 | ○ |
| C-148 | init: 初期化 | E-10 L72-79 | ○ |
| C-149 | init: 二重初期化 | E-10 L73-78 | ○ |
| C-150 | DeRef: 参照解決 | E-10 L81-87 | ○ |
| C-151 | DeRef: タイプエラー | E-10 L85-86 | ○ |
| C-152 | DeRefAsObject: オブジェクト解決 | E-10 L99-108 | ○ |
| C-153 | DeRefAsObject: 参照カウント | E-10 L102-108 | ○ |
| C-154 | GetLastPrivateMethod: アドレス取得 | E-10 L115-134 | ○ |
| C-155 | GetAddressOfEx: メソッドアドレス | E-11 L148-300 | ○ |
| C-156 | GetAddressOfEx: メソッド数 | E-11 L294 | ○ |
| C-157 | GetAddressOfEx: 範囲外 | E-11 L298-300 | ○ |
| C-158 | GetAddressOfEx: Nothing | E-11 L158 | ○ |
| C-159 | GetAddressOfEx: 無効順序 | E-11 L157 | ○ |
| C-160 | GetAddressOfEx: クラスオフセット | E-11 L226 | ○ |
| C-161 | GetAddressOfEx: フォームオフセット | E-11 L228 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-071 ExifProperty**: WIA.ImageFileオブジェクトの振る舞いの詳細仕様がコードコメントのみで確認
  - 候補：Microsoft WIA SDK ドキュメント / EXIF仕様書
- **C-093 Tick Event コールバック**: 非同期イベントのタイミング検証が実行時のみで確認可能
  - 候補：実行時テスト / タイミング計測ログ
- **C-112 5分タイムアウト**: DateDiff("n", ...) > 5 がハードコードされているが設計根拠が不明
  - 候補：要件定義書 / 設計メモ

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: 大部分のテストケースはソースコードから直接導出されており、信頼性が高い
- **1: 中リスク**: stdTimerおよび関連モジュールは複雑な非同期処理を含み、タイミング依存のバグが発生しやすい
- **1: 中リスク**: stdDLLFuncはネイティブDLL呼び出しを含み、メモリ安全性に注意が必要
- **1: 中リスク**: stdPointerは低レベルメモリ操作を行い、GPF（General Protection Fault）のリスクがある

## 6) レビュアーチェックリスト（最小）
- [ ] stdShellのファイル操作メソッド（Read/Overwrite/Append/Delete/CopyTo）が実際のファイルシステムで正しく動作するか
- [ ] stdTimerの非同期イベント発火が期待通りのタイミングで発生するか
- [ ] stdDLLFuncの文字列パラメータ変換（ANSI/Unicode）がメモリリークを起こさないか
- [ ] stdPointerのDeRefAsObjectが参照カウントを正しく管理し、メモリリークやGPFを起こさないか
- [ ] stdShellのHash関数がCryptoAPIを正しく使用し、異なるファイルで衝突しないか
- [ ] stdShellMTPがMTPデバイス未接続時に適切なエラーハンドリングを行うか
- [ ] stdTimerServerWIPの49日オーバーフロー処理（getTickDiff）が正しく動作するか
- [ ] WIP（Work In Progress）モジュールであることを考慮し、本番利用前に追加テストが必要か確認
