---
generated_at: 2026-01-15 12:00:00
metrics:
  claims_total: 92
  claims_with_evidence: 89
  claims_without_evidence: 3
confidence_derived: 0.97
---

# 根拠レポート：wip-ui 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：89 / 92、根拠なし：3
- 優先レビュー（高）
  1. **stdUIAutomationElement（UT-WUI-039）**：実装が未完成（WIP状態）
  2. **stdExcelWorksheet.ValueRange（UT-WUI-085〜087）**：変数名shtが未定義の可能性
  3. **stdExcelWorkbook.CreateFromFile（UT-WUI-089）**：stdFile依存が存在

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdCanvas.cls` (696行)
- E-02: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdUIAutomationElement.cls` (252行、未完成)
- E-03: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdRibbon.cls` (87行)
- E-04: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdExcelLibraries/stdXLEvents.cls` (302行)
- E-05: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdExcelLibraries/stdShapeEvents.cls` (227行)
- E-06: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdExcelLibraries/stdExcelWorksheet.cls` (100行)
- E-07: `/Users/tomokababa/Work/route06/stdVBA-master/src/WIP/stdExcelLibraries/stdExcelWorkbook.cls` (45行)
- E-08: `/Users/tomokababa/Work/route06/stdVBA-master/docs/code-to-docs/単体テストケース一覧/plan.md` (モジュール構成)

## 3) Claims と根拠の対応（レビューの主戦場）

### stdCanvas（38テストケース）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 (UT-WUI-001〜008) | CreateFromControl/Frame/Hwnd/protInitのファクトリ・初期化テスト | E-01: 196-256行 | ○ |
| C-02 (UT-WUI-009〜013) | DrawRectangleの描画・スタイル・境界値テスト | E-01: 280-296行 | ○ |
| C-03 (UT-WUI-014〜016) | DrawArcの描画・bbox・境界値テスト | E-01: 309-334行 | ○ |
| C-04 (UT-WUI-017〜020) | DrawEllipse/Circleの描画テスト | E-01: 345-381行 | ○ |
| C-05 (UT-WUI-021〜024) | DrawPolygonの描画・バリデーション・bboxテスト | E-01: 390-432行 | ○ |
| C-06 (UT-WUI-025〜030) | Data/Styleプロパティのget/set・連動更新テスト | E-01: 435-491行 | ○ |
| C-07 (UT-WUI-031〜033) | Redraw/DoubleBufferedのテスト | E-01: 494-543行 | ○ |
| C-08 (UT-WUI-034〜037) | argb/getAlphaの色変換テスト | E-01: 562-585行 | ○ |
| C-09 (UT-WUI-038) | Class_Terminateリソース解放テスト | E-01: 259-272行 | ○ |

### stdUIAutomationElement（1テストケース）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-10 (UT-WUI-039) | CreateFromHwndのテスト | E-02: 244-247行 | △ |

### stdRibbon（10テストケース）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 (UT-WUI-040〜042) | Invalidate/InvalidateControlのテスト | E-03: 31-46行 | ○ |
| C-12 (UT-WUI-043) | Ribbon_Loadのテスト | E-03: 48-57行 | ○ |
| C-13 (UT-WUI-044〜045) | Tab_GetVisibleの権限制御テスト | E-03: 59-65行 | ○ |
| C-14 (UT-WUI-046〜047) | ToggleButton状態取得・保存テスト | E-03: 67-81行 | ○ |
| C-15 (UT-WUI-048〜049) | CheckSettings/CheckRibbonのテスト | E-03: 22-29行 | ○ |

### stdXLEvents（16テストケース）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-16 (UT-WUI-050) | Class_Initializeのテスト | E-04: 150-152行 | ○ |
| C-17 (UT-WUI-051〜055) | cbs_OnUpdateイベント発火テスト | E-04: 80-148行 | ○ |
| C-18 (UT-WUI-056) | getSelectionのテスト | E-04: 156-163行 | ○ |
| C-19 (UT-WUI-057〜060) | getObjPath/ID/Ancestor/Parentユーティリティテスト | E-04: 192-235行 | ○ |
| C-20 (UT-WUI-061〜062) | selectionsAreDifferent比較テスト | E-04: 237-254行 | ○ |
| C-21 (UT-WUI-063〜065) | getObjType型判定テスト | E-04: 257-301行 | ○ |

### stdShapeEvents（16テストケース）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-22 (UT-WUI-066〜068) | Create/HookSheetのテスト | E-05: 159-169行 | ○ |
| C-23 (UT-WUI-069〜074) | bars_OnUpdateイベント発火テスト | E-05: 64-157行 | ○ |
| C-24 (UT-WUI-075〜076) | getShapeByNameのテスト | E-05: 171-180行 | ○ |
| C-25 (UT-WUI-077〜080) | DetectShape/isShapeのテスト | E-05: 187-200行 | ○ |
| C-26 (UT-WUI-081) | ShapeDataのテスト | E-05: 202-223行 | ○ |

### stdExcelWorksheet（7テストケース）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-27 (UT-WUI-082〜084) | Create/Valueのテスト | E-06: 14-24行 | ○ |
| C-28 (UT-WUI-085〜087) | ValueRangeのテスト | E-06: 26-99行 | △ |

### stdExcelWorkbook（5テストケース）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 (UT-WUI-088〜092) | CreateFromFileのテスト | E-07: 12-42行 | ○ |

## 4) 不足情報（Unknown / Missing）

### stdUIAutomationElement（C-10）
- **状況**: クラスが未完成状態（WIP）。CreateFromHwndメソッドは定義されているが、中身が空
- **根拠不足の理由**: 実装が不完全なため、テストケースの期待結果が推測に基づく
- **候補**: UIAutomation API仕様書 / Windows SDK ドキュメント / 類似実装（stdAcc.cls）

### stdExcelWorksheet.ValueRange（C-28）
- **状況**: コード内で変数`sht`が未定義のまま使用されている（26行目以降）
- **根拠不足の理由**: コードにバグの可能性があり、実際の動作が不明
- **候補**: 実行時テスト / pWorksheetを使用するように修正

### stdExcelWorkbook.CreateFromFile依存（C-29の一部）
- **状況**: `stdFile.exists`への依存があるが、stdFileクラスの存在が未確認
- **根拠不足の理由**: 外部依存が解決できない場合の動作が不明
- **候補**: stdFileクラスの確認 / 依存注入パターンの検討

## 5) リスクフラグ（レビュー観点）

| リスク | 内容 | レベル |
|--------|------|--------|
| WIPモジュール | stdUIAutomationElementは実装未完了 | 2: 高リスク |
| コードバグ疑惑 | stdExcelWorksheet.ValueRangeでshtが未定義 | 2: 高リスク |
| 外部依存 | stdExcelWorkbook.CreateFromFileがstdFileに依存 | 1: 中リスク |
| メモリリーク | stdCanvasでGDI+リソース解放漏れの可能性 | 1: 中リスク |
| VBA7/32bit互換 | 条件付きコンパイルで両対応しているが要確認 | 0: 低リスク |

## 6) レビュアーチェックリスト（最小）

- [ ] stdUIAutomationElement（UT-WUI-039）: WIP状態のため、実装完了後に再テストケース作成が必要
- [ ] stdExcelWorksheet.ValueRange: 変数`sht`が`pWorksheet`の誤りでないか確認
- [ ] stdExcelWorkbook.CreateFromFile: stdFile.existsメソッドの存在と動作を確認
- [ ] stdCanvas.Class_Terminate: GDI+リソースが確実に解放されることを実行時に確認
- [ ] stdRibbon.CheckRibbon: CopyMemoryによるポインタ復元が安全に動作することを確認
- [ ] stdXLEvents/stdShapeEvents: CommandBarsイベントの発火タイミングが期待通りか確認
- [ ] 全クラス: VBA7（64bit）と非VBA7（32bit）の両環境でのテスト実行

---

## 補足：解析したファイル一覧

| ファイル | 行数 | 主要機能 |
|----------|------|----------|
| stdCanvas.cls | 696 | GDI+を使用したキャンバス描画、ダブルバッファリング |
| stdUIAutomationElement.cls | 252 | UIAutomation APIラッパー（WIP/未完成） |
| stdRibbon.cls | 87 | リボンUI制御、VBA状態喪失後の復元 |
| stdXLEvents.cls | 302 | Excel選択変更イベントのフック |
| stdShapeEvents.cls | 227 | Shapeオブジェクトのイベント監視 |
| stdExcelWorksheet.cls | 100 | Worksheetラッパー、値範囲取得 |
| stdExcelWorkbook.cls | 45 | Workbookファクトリ、ファイルオープン |
