---
generated_at: 2026-01-15 19:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **stdXML.ToString()**: WIPステータスで実装未完了の可能性
  2. **stdCanvas描画機能**: WIPステータスで機能が限定的な可能性
  3. **stdHTML.ToString()**: WIPステータスで一部機能未実装の可能性

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdImage.cls` - ToFile(), ToTempFile(), ToSheet(), ToUIControl(), ToShapeFill(), ToClipboard() メソッド定義
- E-02: `src/stdJSON.cls` - ToString() メソッド定義、JSON出力機能
- E-03: `src/WIP/stdHTML.cls` - ToString() メソッド定義、HTML要素出力機能
- E-04: `src/WIP/stdXML.cls` - ToString() 関数宣言（実装未完了）
- E-05: `src/stdClipboard.cls` - Text, Files プロパティ、Picture 出力機能
- E-06: `src/WIP/stdCanvas.cls` - GDI+ベースのグラフィック描画機能
- E-07: `README.md` - プロジェクト概要、ライブラリ一覧とステータス

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PNG画像ファイル出力 | E-01 (stdImage.cls 1008-1081行) | ○ |
| C-02 | BMP画像ファイル出力 | E-01 (stdImage.cls 1070-1072行) | ○ |
| C-03 | JPEG画像ファイル出力（品質設定可能） | E-01 (stdImage.cls 1035-1044行) | ○ |
| C-04 | GIF画像ファイル出力 | E-01 (stdImage.cls 1050-1051行) | ○ |
| C-05 | TIFF画像ファイル出力（色深度・圧縮設定可能） | E-01 (stdImage.cls 1053-1068行) | ○ |
| C-06 | 一時画像ファイル出力 | E-01 (stdImage.cls 1115-1127行) | ○ |
| C-07 | JSON文字列出力 | E-02 (stdJSON.cls 21行, ToString()メソッド) | ○ |
| C-08 | HTML文字列出力 | E-03 (stdHTML.cls 191-218行) | ○ |
| C-09 | XML文字列出力 | E-04 (stdXML.cls 84-86行) | △ |
| C-10 | テキストクリップボード出力 | E-05 (stdClipboard.cls 20-24行) | ○ |
| C-11 | ファイルリストクリップボード出力 | E-05 (stdClipboard.cls コメント例91-95行) | ○ |
| C-12 | 画像クリップボード出力 | E-01 (stdImage.cls 1091-1109行) | ○ |
| C-13 | シートへの画像追加 | E-01 (stdImage.cls 1135-1137行) | ○ |
| C-14 | 図形への画像設定 | E-01 (stdImage.cls 1161-1167行) | ○ |
| C-15 | UIコントロールへの画像設定 | E-01 (stdImage.cls 1144-1146行) | ○ |
| C-16 | キャンバス描画機能 | E-06 (stdCanvas.cls) | △ |

## 4) 不足情報（Unknown / Missing）
- **stdXML.ToString()**: 関数宣言のみで実装本体が空のため、実際に動作するかは不明
  - 候補：WIPフォルダ内の他のファイル / 将来の実装予定
- **stdCanvas描画機能**: WIPステータスのため機能の完成度が不明
  - 候補：テストコード / 使用例ドキュメント

## 5) リスクフラグ（レビュー観点）
- **リスク1（中）**: stdXML.cls は WIP ステータスであり、ToString() メソッドの実装が空のため、実際には使用できない可能性がある
- **リスク1（中）**: stdCanvas.cls は WIP ステータスであり、全機能が動作するか確認が必要
- **リスク0（低）**: stdHTML.cls は WIP ステータスだが、ToString() メソッドの実装は完了している
- **リスク0（低）**: stdImage.cls の画像出力機能は READY ステータスで十分にテストされている可能性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] stdXML.cls の ToString() メソッドが実際に動作するか確認
- [ ] stdCanvas.cls のグラフィック描画機能が期待通り動作するか確認
- [ ] WIPステータスのクラスを帳票一覧に含めることの妥当性確認
- [ ] stdImage.cls のサポートフォーマット（WEBP、SVG非対応）の記載漏れがないか確認
- [ ] 帳票出力に関連する他のWIPクラス（stdStringBuilder等）の含める必要性確認
