# 帳票設計書 1-PNG画像ファイル

## 概要

本ドキュメントは、stdImageクラスのToFile()メソッドを使用したPNG形式での画像出力機能について記述した帳票設計書である。

### 本帳票の処理概要

stdImage.ToFile()メソッドによりPNG形式で画像ファイルを出力する機能を提供する。この機能により、VBAアプリケーション内で処理された画像データを、可搬性の高いPNG形式のファイルとして保存できる。

**業務上の目的・背景**：VBAアプリケーションで画面キャプチャ、クリップボード画像、Excel図形などから取得した画像データを、汎用的なPNG形式で保存する必要がある。PNG形式は可逆圧縮であり、透過情報を保持でき、Web表示やドキュメント埋め込みに適している。

**帳票の利用シーン**：
- スクリーンショットの保存
- Excelシート上の図形・チャートの画像化
- ウィンドウキャプチャの保存
- ユーザーフォーム上の画像コントロールの内容保存
- 自動レポート生成時の画像出力

**主要な出力内容**：
1. PNG形式の画像データ（GDI+エンコーディング使用）
2. 32ビット色深度対応
3. 透過情報の保持

**帳票の出力タイミング**：stdImageオブジェクト生成後、ToFile()メソッドを.pngファイルパスで呼び出した時点で出力される。

**帳票の利用者**：VBA開発者、Excel/Word/Accessアプリケーションのエンドユーザー

## 帳票種別

画像ファイル出力

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | VBAモジュール | - | stdImage.ToFile("path.png")メソッド呼び出し |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | PNG (Portable Network Graphics) |
| 用紙サイズ | N/A（画像サイズは元画像に依存） |
| 向き | N/A |
| ファイル名 | 任意（拡張子.pngで自動判定） |
| 出力方法 | ファイルシステムへの直接書き込み |
| 文字コード | N/A（バイナリファイル） |

### 画像固有設定

| 項目 | 内容 |
|-----|------|
| エンコーダGUID | {557CF406-1A04-11D3-9A73-0000F81EF32E} |
| 色深度 | 32ビット |
| 圧縮方式 | 可逆圧縮（PNG標準） |
| 透過対応 | 対応 |

## 帳票レイアウト

### レイアウト概要

PNG画像ファイルは元のビットマップ画像のピクセルデータをそのまま保持する。

```
┌─────────────────────────────────────┐
│         PNG File Header             │
├─────────────────────────────────────┤
│         Image Header (IHDR)         │
├─────────────────────────────────────┤
│         Image Data (IDAT)           │
│   [ピクセルデータ - 圧縮済み]       │
├─────────────────────────────────────┤
│         Image End (IEND)            │
└─────────────────────────────────────┘
```

### 画像データ部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Width | 画像幅 | This.HBITMAPTYPE.bmWidth | ピクセル |
| 2 | Height | 画像高さ | This.HBITMAPTYPE.bmHeight | ピクセル |
| 3 | BitsPixel | ビット深度 | This.HBITMAPTYPE.bmBitsPixel | ビット |
| 4 | PixelData | 画素データ | hBitmap経由 | ARGB |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 有効なstdImageオブジェクト | hBitmapが設定済みであること | Yes |
| 出力パス | 書き込み可能なファイルパス | Yes |
| フォーマット指定 | 拡張子.pngまたはstdImgFormatPNG | Yes |

### ソート順

N/A（単一画像出力）

### 改ページ条件

N/A

## データベース参照仕様

### 参照テーブル一覧

N/A（データベース非依存）

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 画像サイズ | bmWidth * bmHeight * (bmBitsPixel / 8) | N/A | 非圧縮時の概算 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[ToFile呼び出し] --> B{フォーマット判定}
    B -->|拡張子.png| C[stdImgFormatPNG設定]
    B -->|明示指定| C
    C --> D[GdiplusStartup]
    D --> E[GdipCreateBitmapFromHBITMAP]
    E --> F[エンコーダGUID設定]
    F --> G[GdipSaveImageToFile]
    G --> H[GdipDisposeImage]
    H --> I[GdiplusShutdown]
    I --> J[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| GDI+起動失敗 | GDI+初期化エラー | "Could not start GDI+" | GDI+ライブラリの確認 |
| HBITMAP変換失敗 | 無効なビットマップ | "Could not convert HBITMAP to GDI+ image" | 元画像の有効性確認 |
| ファイル保存失敗 | パス無効/権限不足 | "Could not save image to file" | 出力パスの確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1画像/呼び出し |
| 目標出力時間 | 1920x1080サイズで1秒以内 |
| 同時出力数上限 | シングルスレッド処理 |

## セキュリティ考慮事項

- ファイルパスインジェクションの防止：ユーザー入力パスの検証推奨
- 一時ファイル使用時の削除確認
- 機密画像の場合は保存先のアクセス制御確認

## 備考

- GDI+ (gdiplus.dll) への依存あり
- Mac環境では動作不可（Windows専用API使用）
- 64ビット/32ビット両対応

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、stdImageクラスの内部データ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdImage.cls | `src/stdImage.cls` | 396-408行目: TThis型定義でhBitmap、HBITMAPTYPE構造を確認 |
| 1-2 | stdImage.cls | `src/stdImage.cls` | 288-329行目: BITMAP、BITMAPINFO等の構造体定義 |

**読解のコツ**: VBAでは構造体定義がPrivate Typeで行われる。Win32 APIとの連携のためC言語の構造体と同等の定義が必要。

#### Step 2: エントリーポイントを理解する

処理の起点となるToFileメソッドを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdImage.cls | `src/stdImage.cls` | 1008-1089行目: ToFile()メソッドがエントリーポイント |

**主要処理フロー**:
1. **1008-1022行目**: フォーマット判定 - 拡張子からstdImgFormatを決定
2. **1024-1028行目**: GDI+初期化 - GdiplusStartup呼び出し
3. **1030-1031行目**: HBITMAP→GDI+Bitmap変換
4. **1047-1048行目**: PNGエンコーダGUID設定
5. **1076-1080行目**: GdipSaveImageToFile実行
6. **1083-1087行目**: リソース解放

#### Step 3: GDI+ API連携を理解する

Windows GDI+ APIとの連携部分を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdImage.cls | `src/stdImage.cls` | 185-191行目: GDI+ API宣言（64ビット版） |
| 3-2 | stdImage.cls | `src/stdImage.cls` | 252-259行目: GDI+ API宣言（32ビット版） |

**主要処理フロー**:
- **185行目**: GdiplusStartup - GDI+ライブラリ初期化
- **188行目**: GdipCreateBitmapFromHBITMAP - HBITMAP→GDI+Bitmap変換
- **191行目**: GdipSaveImageToFile - ファイル保存

### プログラム呼び出し階層図

```
stdImage.ToFile(FileName, format)
    │
    ├─ フォーマット判定 (1009-1022行目)
    │      └─ 拡張子からstdImgFormat決定
    │
    ├─ GdiplusStartup (1028行目)
    │      └─ GDI+ライブラリ初期化
    │
    ├─ GdipCreateBitmapFromHBITMAP (1031行目)
    │      └─ HBITMAP→GDI+Bitmap変換
    │
    ├─ IIDFromString (1048行目)
    │      └─ PNGエンコーダGUID取得
    │
    ├─ GdipSaveImageToFile (1077/1079行目)
    │      └─ ファイル書き込み実行
    │
    ├─ GdipDisposeImage (1083行目)
    │      └─ GDI+画像リソース解放
    │
    └─ GdiplusShutdown (1087行目)
           └─ GDI+ライブラリ終了
```

### データフロー図

```
[入力]               [処理]                    [出力]

hBitmap         GdipCreateBitmapFromHBITMAP    GDI+ Bitmap
(メモリ内)  ────────────▶  ────────────────────▶
                                                   │
                                                   ▼
                        GdipSaveImageToFile
                   ─────────────────────────▶  PNG File
                        (PNGエンコーダ)         (ディスク)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdImage.cls | `src/stdImage.cls` | ソース | 画像処理メインクラス |
| gdiplus.dll | Windows System | システムDLL | GDI+ライブラリ |
