# 帳票設計書 10-テキストデータ（クリップボード出力）

## 概要

本ドキュメントは、stdClipboardクラスのtextプロパティを使用したテキストデータのクリップボード出力機能について記述した帳票設計書である。

### 本帳票の処理概要

stdClipboard.textプロパティにより、テキストデータをWindowsクリップボードに設定する機能を提供する。この機能により、VBAアプリケーションから他のアプリケーションへテキストデータを簡単に転送できる。

**業務上の目的・背景**：VBAアプリケーションで生成したデータを、他のアプリケーション（メモ帳、Excel、Word等）に貼り付けるために、クリップボードへのテキスト出力が必要となる。これにより、アプリケーション間のデータ連携がシームレスに行える。

**帳票の利用シーン**：
- 処理結果のクリップボードへのコピー
- データのエクスポート（貼り付け用）
- アプリケーション間のテキスト転送
- ユーザーへの結果提供
- 自動化処理の中間出力

**主要な出力内容**：
1. Unicode形式テキスト（CF_UNICODETEXT）
2. クリップボードへの直接書き込み

**帳票の出力タイミング**：stdClipboard.textプロパティへの値設定時に即座にクリップボードに反映される。

**帳票の利用者**：VBA開発者、エンドユーザー（貼り付け操作を通じて間接利用）

## 帳票種別

クリップボードテキスト出力

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | VBAモジュール | - | stdClipboard.text = "文字列" |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| 出力先 | Windowsクリップボード |
| フォーマット | CF_UNICODETEXT (13) |
| 文字コード | UTF-16LE（Unicode） |
| サイズ制限 | システムメモリに依存 |

### クリップボードフォーマット

| フォーマットID | 名称 | 説明 |
|--------------|------|------|
| 13 | CF_UNICODETEXT | Unicode形式テキスト（標準） |
| 1 | CF_TEXT | ANSI形式テキスト |

## 帳票レイアウト

### レイアウト概要

クリップボードにはテキストデータがそのまま格納される。

```
┌─────────────────────────────────────┐
│      Windows Clipboard              │
├─────────────────────────────────────┤
│  CF_UNICODETEXT:                    │
│  [Unicode文字列データ + NUL終端]    │
└─────────────────────────────────────┘
```

### データ構造

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | TextData | テキスト内容 | textプロパティ引数 | UTF-16LE文字列 |
| 2 | NullTerminator | 終端文字 | 自動追加 | 0x0000 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| クリップボードアクセス可能 | OpenClipboard成功 | Yes |
| メモリ確保可能 | GlobalAlloc成功 | Yes |

### ソート順

N/A（単一テキスト出力）

### 改ページ条件

N/A

## データベース参照仕様

### 参照テーブル一覧

N/A（データベース非依存）

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 必要メモリサイズ | LenB(s) + 2 | N/A | NUL終端分の+2 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[textプロパティ設定] --> B[value Property Let呼び出し]
    B --> C[サイズ計算]
    C --> D[GlobalAlloc]
    D --> E[GlobalLock]
    E --> F[lstrcpyW]
    F --> G[GlobalUnlock]
    G --> H[OpenClipboard]
    H --> I[EmptyClipboard]
    I --> J[SetClipboardData]
    J --> K[CloseClipboard]
    K --> L[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| メモリ確保失敗 | GlobalAlloc失敗 | "Unable to allocate global memory" | システムメモリ確認 |
| メモリロック失敗 | GlobalLock失敗 | "Unable to lock global memory" | リソース確認 |
| コピー失敗 | lstrcpyW失敗 | "Unable to copy string to global memory" | 文字列確認 |
| クリップボードオープン失敗 | OpenClipboard失敗 | "Unable to open clipboard" | タイムアウト待機 |
| クリップボード空化失敗 | EmptyClipboard失敗 | "Cannot empty clipboard" | 権限確認 |
| データ設定失敗 | SetClipboardData失敗 | "Unable to set clipboard data" | フォーマット確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1テキスト/呼び出し |
| 目標出力時間 | 1MB以下で100ms以内 |
| タイムアウト | 5秒（OpenClipboard） |

## セキュリティ考慮事項

- クリップボードは他アプリケーションからもアクセス可能
- 機密データの場合は使用後にクリップボードをクリアすることを推奨
- パスワード等の機密情報は長時間保持しない

## 備考

- CF_UNICODETEXTを使用（Unicode対応）
- VBA7/VBA6両対応（条件付きコンパイル）
- 64ビット/32ビット両対応
- stdClipboardはPredeclaredId=Trueでシングルトン的使用

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、クリップボードフォーマットの定義を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdClipboard.cls | `src/stdClipboard.cls` | 61-90行目: CLIPFORMAT列挙型 |

**読解のコツ**: CF_UNICODETEXT (13) がUnicode形式テキストの標準フォーマット。

#### Step 2: エントリーポイントを理解する

処理の起点となるtextプロパティを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdClipboard.cls | `src/stdClipboard.cls` | 335-340行目: textプロパティ |

**主要処理フロー**:
1. **336行目**: text [GET] - value(CF_UNICODETEXT)呼び出し
2. **338-339行目**: text [LET] - value(CF_UNICODETEXT) = s

#### Step 3: 内部実装を理解する

value Property Letの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdClipboard.cls | `src/stdClipboard.cls` | 263-313行目: value Property Let |

**主要処理フロー**:
- **274-278行目**: サイズ計算（UNICODETEXT: LenB + 2）
- **286行目**: GlobalAlloc呼び出し
- **290行目**: GlobalLock呼び出し
- **297-299行目**: lstrcpyW呼び出し（Unicode）
- **306行目**: OpenClipboardTimeout呼び出し
- **307行目**: EmptyClipboard呼び出し
- **308行目**: SetClipboardData呼び出し
- **309行目**: CloseClipboard呼び出し

### プログラム呼び出し階層図

```
stdClipboard.text = "テキスト"
    │
    └─ value Property Let (263行目)
           │
           ├─ サイズ計算 (277行目)
           │      └─ LenB(v) + 2（NUL終端分）
           │
           ├─ GlobalAlloc (286行目)
           │      └─ GAlloc.GHND, sizeバイト
           │
           ├─ GlobalLock (290行目)
           │      └─ メモリポインタ取得
           │
           ├─ lstrcpyW (298行目)
           │      └─ Unicode文字列コピー
           │
           ├─ GlobalUnlock (303行目)
           │      └─ メモリ解放
           │
           ├─ OpenClipboardTimeout (306行目)
           │      │
           │      ├─ GetTickCount (957行目)
           │      └─ OpenClipboard (961行目)
           │             └─ タイムアウト付きループ
           │
           ├─ EmptyClipboard (307行目)
           │      └─ 既存データクリア
           │
           ├─ SetClipboardData (308行目)
           │      └─ CF_UNICODETEXT, hClipMemory
           │
           └─ CloseClipboard (309行目)
                  └─ クリップボード解放
```

### データフロー図

```
[入力]               [処理]                    [出力]

String          value Property Let          クリップボード
"テキスト" ─────────▶                        CF_UNICODETEXT
    │                                           │
    ├─ LenB()       ──▶  サイズ計算       ──▶ size
    │
    ├─ GlobalAlloc  ──▶  メモリ確保       ──▶ hClipMemory
    │
    ├─ GlobalLock   ──▶  ポインタ取得     ──▶ lpClipMemory
    │
    ├─ lstrcpyW     ──▶  文字列コピー
    │
    ├─ GlobalUnlock ──▶  メモリ解放
    │
    └─ SetClipboardData ──▶  クリップボード設定
                               │
                               ▼
                        クリップボードに格納
                        (他アプリから貼り付け可能)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdClipboard.cls | `src/stdClipboard.cls` | ソース | クリップボードクラスメイン |
| user32.dll | Windows System | システムDLL | クリップボードAPI |
| kernel32.dll | Windows System | システムDLL | メモリ管理API |
