# 帳票設計書 11-ファイルリスト

## 概要

本ドキュメントは、stdVBAライブラリにおけるstdClipboardクラスのFilesプロパティを使用したファイルパスリストのクリップボード出力機能について記載する帳票設計書です。

### 本帳票の処理概要

本帳票は、VBAアプリケーションからWindows OSのクリップボードに対して、ファイルパスのリスト（複数ファイルパス）をCF_HDROP形式で出力する機能を提供します。この機能により、VBAプログラムから外部アプリケーション（エクスプローラー等）へのファイルコピー・移動操作の自動化が可能になります。

**業務上の目的・背景**：VBAアプリケーションで処理対象となるファイルリストを、ユーザーがエクスプローラーや他のアプリケーションで即座に利用できるようにするため、クリップボードを介したファイル参照の受け渡しが必要です。従来のテキストベースのパス共有と異なり、CF_HDROP形式を使用することで、OSネイティブの「ファイルのコピー」操作と同等の形式でデータを共有できます。

**帳票の利用シーン**：バッチ処理で生成した複数ファイルを、ユーザーが手動で別フォルダにコピーする場合や、メールへの添付ファイルとして貼り付ける場合、または他のアプリケーションへファイル参照を渡す場合に利用されます。

**主要な出力内容**：
1. ファイルパスのコレクション（複数パス対応）
2. CF_HDROP形式のクリップボードデータ
3. DROPFILES構造体によるファイルリスト情報

**帳票の出力タイミング**：VBAコードからstdClipboard.Filesプロパティへの代入操作時に即座にクリップボードへ出力されます。

**帳票の利用者**：VBA開発者、システム管理者、業務自動化担当者

## 帳票種別

データ出力（クリップボード出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | VBAコード実行環境 | N/A | stdClipboard.Filesプロパティへの代入 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | CF_HDROP（Windowsクリップボード形式） |
| 用紙サイズ | N/A（メモリ出力） |
| 向き | N/A |
| ファイル名 | N/A（クリップボードへの直接出力） |
| 出力方法 | OSクリップボードへの直接書き込み |
| 文字コード | ANSI（vbFromUnicode変換） |

### クリップボード固有設定

| 項目 | 内容 |
|-----|------|
| クリップボード形式 | CF_HDROP (15) |
| データ構造 | DROPFILES構造体 + ファイルパス文字列 |
| Unicode対応 | 32bit版のみ対応（64bit版は未実装） |

## 帳票レイアウト

### レイアウト概要

クリップボードに書き込まれるデータは、DROPFILES構造体とファイルパス文字列の連続データで構成されます。

```
┌─────────────────────────────────────┐
│         DROPFILES構造体              │
│  - pFiles: ファイルデータへのオフセット │
│  - pt: POINTAPI構造体                │
│  - fNC: 0                           │
│  - fWide: 0 (ANSI)                  │
├─────────────────────────────────────┤
│         ファイルパスリスト            │
│  {ファイル1}\0{ファイル2}\0...\0\0    │
└─────────────────────────────────────┘
```

### ヘッダー部（DROPFILES構造体）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | pFiles | ファイルデータへのオフセット | Len(tDropFiles) | Long |
| 2 | pt.x | ドロップ位置X | 0 | Long |
| 3 | pt.y | ドロップ位置Y | 0 | Long |
| 4 | fNC | 非クライアント領域フラグ | 0 | Long |
| 5 | fWide | Unicode使用フラグ | 0 | Long |

### 明細部（ファイルパスリスト）

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | ファイルパス1 | 1番目のファイルパス | Collectionアイテム(1) | String + NullChar | 可変 |
| 2 | ファイルパスN | N番目のファイルパス | Collectionアイテム(N) | String + NullChar | 可変 |
| 3 | 終端 | データ終端マーカー | 固定値 | NullChar | 1byte |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | 終端NullChar | ファイルリスト終端 | 固定値(vbNullChar) | 1byte |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ファイルコレクション | 出力対象のファイルパスを格納したCollectionオブジェクト | Yes |
| 32bit環境 | Win64環境では未実装のため動作不可 | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Collection内の順序 | 入力順（昇順） |

### 改ページ条件

N/A（クリップボード出力のため改ページ概念なし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | データベース参照なし | - |

### データソース

本機能はデータベースを参照せず、VBAコードから直接渡されるCollectionオブジェクトを入力とします。

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| メモリサイズ | Len(tDropFiles) + LenB(sFiles) | なし | グローバルメモリ確保サイズ |
| pFilesオフセット | Len(tDropFiles) | なし | 構造体サイズ（20byte） |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[Set stdClipboard.files = Collection] --> B[Collectionからファイルパス文字列を構築]
    B --> C[sFiles = パス1 + NullChar + パス2 + ... + NullChar + NullChar]
    C --> D[protSetFilesText呼び出し]
    D --> E{Win64?}
    E -->|Yes| F[未実装エラー表示]
    E -->|No| G[GlobalAllocでメモリ確保]
    G --> H[GlobalLockでメモリロック]
    H --> I[DROPFILES構造体をメモリにコピー]
    I --> J[ファイルパス文字列をメモリにコピー]
    J --> K[GlobalUnlockでメモリアンロック]
    K --> L[OpenClipboardでクリップボードを開く]
    L --> M[EmptyClipboardでクリップボードをクリア]
    M --> N[SetClipboardDataでCF_HDROP形式で設定]
    N --> O[CloseClipboardでクリップボードを閉じる]
    O --> P[終了]
    F --> P
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 未実装エラー | Win64環境での実行 | "Not implemented. Current version produces crash for unknown reasons." | 32bit環境で実行 |
| メモリ確保失敗 | GlobalAllocが0を返す | "Unable to allocate global memory" | メモリ不足の解消 |
| メモリロック失敗 | GlobalLockが0を返す | "Unable to lock global memory" | システムリソースの解放 |
| アンロック失敗 | GlobalUnlockでエラー | "Unable to unlock global mem" | システム再起動 |
| クリップボード開放失敗 | OpenClipboardが失敗 | "Unable to open clipboard" | 他アプリのクリップボード解放を待機 |
| クリアエラー | EmptyClipboardが失敗 | "Cannot empty clipboard" | クリップボード所有権の確認 |
| 設定エラー | SetClipboardDataが失敗 | "Unable to set clipboard data" | データ形式の確認 |
| 閉じエラー | CloseClipboardが失敗 | "Unable to close clipboard" | システム状態の確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1〜1000ファイルパス |
| 目標出力時間 | 100ms以下 |
| 同時出力数上限 | 1（シングルスレッド） |

## セキュリティ考慮事項

- クリップボードは他のアプリケーションからもアクセス可能なため、機密性の高いファイルパス情報の取り扱いに注意が必要
- クリップボードの内容は永続的ではなく、他のアプリケーションによって上書きされる可能性がある
- 64bit環境では機能が未実装のため、セキュリティ上の問題は発生しないが機能利用不可

## 備考

- 本機能は32bit VBA環境専用（Win64では未実装）
- 64bit環境ではMsgBoxでエラーメッセージを表示し、処理を中断
- ファイルパスはANSI形式に変換されて出力される（fWide = 0）
- SetFilesArrメソッドを使用することで、配列形式でのファイル指定も可能

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、クリップボードに書き込まれるデータ構造（DROPFILES）を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdClipboard.cls | `src/stdClipboard.cls` | 171-183行目のDROPFILES構造体とPOINTAPI構造体の定義を確認 |

**読解のコツ**: DROPFILES構造体はWindows APIで定義された構造体で、CF_HDROP形式のクリップボードデータの先頭に配置されます。pFilesフィールドがファイルパスデータへのオフセットを示します。

#### Step 2: エントリーポイントを理解する

処理の起点となるFilesプロパティのSet部分を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdClipboard.cls | `src/stdClipboard.cls` | 510-517行目のProperty Set filesを確認 |

**主要処理フロー**:
1. **510行目**: Property Set filesの開始
2. **511行目**: ファイルパス文字列の初期化
3. **512-514行目**: Collectionをループしてファイルパスを連結
4. **515行目**: 終端NullCharの追加
5. **516行目**: protSetFilesTextの呼び出し（ANSI変換付き）

#### Step 3: 内部実装を理解する

protSetFilesTextメソッドの詳細な実装を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdClipboard.cls | `src/stdClipboard.cls` | 534-576行目のprotSetFilesTextメソッドを確認 |

**主要処理フロー**:
- **536-537行目**: Win64環境での未実装チェック
- **549-550行目**: GlobalAllocによるメモリ確保
- **555-556行目**: GlobalLockによるメモリロック
- **561-563行目**: DROPFILES構造体とファイルパスのメモリコピー
- **565行目**: GlobalUnlockによるメモリ解放
- **568-571行目**: クリップボード操作（Open, Empty, SetData, Close）

#### Step 4: ファイル取得処理を理解する

逆方向（クリップボードからの読み取り）の処理も確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdClipboard.cls | `src/stdClipboard.cls` | 503-509行目のProperty Get filesを確認 |
| 4-2 | stdClipboard.cls | `src/stdClipboard.cls` | 581-610行目のprotGetFilesArr関数を確認 |

**主要処理フロー**:
- **594行目**: DragQueryFileでファイル数を取得
- **602-606行目**: 各ファイルパスを取得してコレクションに追加

### プログラム呼び出し階層図

```
Set stdClipboard.files = Collection
    │
    ├─ Property Set files (510-517行目)
    │      │
    │      └─ protSetFilesText (534-576行目)
    │             │
    │             ├─ GlobalAlloc (549行目)
    │             ├─ GlobalLock (555行目)
    │             ├─ CopyMemory (562-563行目)
    │             ├─ GlobalUnlock (565行目)
    │             ├─ OpenClipboardTimeout (568行目)
    │             ├─ EmptyClipboard (569行目)
    │             ├─ SetClipboardData (570行目)
    │             └─ CloseClipboard (571行目)
    │
stdClipboard.files (Get)
    │
    ├─ Property Get files (503-509行目)
    │      │
    │      └─ protGetFilesArr (581-610行目)
    │             │
    │             ├─ OpenClipboardTimeout (591行目)
    │             ├─ IsClipboardFormatAvailable (592行目)
    │             ├─ GetClipboardData (593行目)
    │             ├─ DragQueryFile (594, 604行目)
    │             └─ CloseClipboard (609行目)
```

### データフロー図

```
[入力]               [処理]                    [出力]

Collection ───▶ Property Set files ───▶ クリップボード(CF_HDROP)
  │                    │
  │                    ├─ ファイルパス連結
  │                    │
  │                    └─ protSetFilesText
  │                           │
  │                           ├─ DROPFILES構造体作成
  │                           │
  │                           └─ Windows API呼び出し
  │
  └─ vFile(1), vFile(2), ... ───▶ "path1\0path2\0...\0\0"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdClipboard.cls | `src/stdClipboard.cls` | ソース | クリップボード操作のメインクラス |
| stdClipboardTests.bas | `tests/stdClipboardTests.bas` | テスト | クリップボード機能のテストコード |
