# 帳票設計書 12-画像データ

## 概要

本ドキュメントは、stdVBAライブラリにおけるstdClipboardクラスとstdImageクラスを連携使用した画像データのクリップボード出力機能について記載する帳票設計書です。

### 本帳票の処理概要

本帳票は、VBAアプリケーションからWindows OSのクリップボードに対して、画像データ（ビットマップまたは拡張メタファイル形式）を出力する機能を提供します。stdImageクラスで作成・加工した画像をクリップボード経由で他のアプリケーションへ受け渡すことが可能です。

**業務上の目的・背景**：VBAで生成・加工した画像（スクリーンショット、チャート、図形など）を、Wordドキュメントやメールクライアント、画像編集ソフトウェアなど他のアプリケーションへ即座に貼り付けできるようにするため、クリップボードを介した画像の受け渡し機能が必要です。

**帳票の利用シーン**：Excelで作成したグラフをWordに貼り付ける場合、画面キャプチャを取得してメールに添付する場合、VBAで生成した画像をプレゼンテーションに挿入する場合などに利用されます。

**主要な出力内容**：
1. CF_BITMAP形式のビットマップ画像データ
2. CF_ENHMETAFILE形式の拡張メタファイル画像データ
3. stdole.IPictureオブジェクト形式の画像データ

**帳票の出力タイミング**：VBAコードからstdClipboard.PictureプロパティまたはstdImage.ToClipboard()メソッド呼び出し時に即座にクリップボードへ出力されます。

**帳票の利用者**：VBA開発者、システム管理者、業務自動化担当者、レポート作成者

## 帳票種別

データ出力（クリップボード出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | VBAコード実行環境 | N/A | stdClipboard.Picture設定 / stdImage.ToClipboard() |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | CF_BITMAP / CF_ENHMETAFILE（Windowsクリップボード形式） |
| 用紙サイズ | N/A（メモリ出力） |
| 向き | N/A |
| ファイル名 | N/A（クリップボードへの直接出力） |
| 出力方法 | OSクリップボードへの直接書き込み |
| 文字コード | N/A（バイナリデータ） |

### クリップボード固有設定

| 項目 | 内容 |
|-----|------|
| クリップボード形式（主） | CF_BITMAP (2) |
| クリップボード形式（代替） | CF_ENHMETAFILE (14) |
| クリップボード形式（代替2） | CF_METAFILEPICT (3) |
| データ構造 | HBITMAPハンドル / HENHMETAFILEハンドル |

## 帳票レイアウト

### レイアウト概要

クリップボードに書き込まれる画像データは、ビットマップまたはメタファイル形式のハンドルで管理されます。

```
┌─────────────────────────────────────┐
│       クリップボード画像データ        │
├─────────────────────────────────────┤
│  CF_BITMAP形式:                      │
│    - HBITMAP（ビットマップハンドル）   │
│    - ピクセルデータ（32bit ARGB）     │
├─────────────────────────────────────┤
│  CF_ENHMETAFILE形式:                 │
│    - HENHMETAFILE（メタファイルハンドル）│
│    - ベクターグラフィックデータ        │
└─────────────────────────────────────┘
```

### 画像データ構造（BITMAP形式）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | bmType | ビットマップタイプ | BITMAP構造体 | Long |
| 2 | bmWidth | 画像幅（ピクセル） | BITMAP構造体 | Long |
| 3 | bmHeight | 画像高さ（ピクセル） | BITMAP構造体 | Long |
| 4 | bmWidthBytes | 1行あたりのバイト数 | BITMAP構造体 | Long |
| 5 | bmPlanes | カラープレーン数 | BITMAP構造体 | Integer |
| 6 | bmBitsPixel | 1ピクセルあたりのビット数 | BITMAP構造体 | Integer |
| 7 | bmBits | ピクセルデータへのポインタ | BITMAP構造体 | LongPtr |

### PICTDESC構造体（OLE Picture変換用）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | size | 構造体サイズ | Len(PICTDESC) | Long |
| 2 | type | 画像タイプ | PICTYPE_BITMAP/PICTYPE_ENHMETAFILE | Long |
| 3 | hPic | 画像ハンドル | HBITMAP/HENHMETAFILE | LongPtr |
| 4 | hPal | パレットハンドル | 0またはHPALETTE | LongPtr |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 画像データ | stdole.IPicture/IPictureDisp/stdImageオブジェクト | Yes |
| 対応形式 | CF_BITMAP/CF_ENHMETAFILE/CF_METAFILEPICT | Yes |

### ソート順

N/A（画像データのため順序の概念なし）

### 改ページ条件

N/A（クリップボード出力のため改ページ概念なし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | データベース参照なし | - |

### データソース

本機能はデータベースを参照せず、以下のソースから画像データを取得します：
- stdole.IPicture/IPictureDispオブジェクト
- stdImageオブジェクト
- Excel.IPicture/Shapeオブジェクト
- スクリーンキャプチャ
- ファイル読み込み

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 画像サイズ | bmWidth * bmHeight * (bmBitsPixel / 8) | なし | ピクセルデータサイズ |

## 処理フロー

### 出力フロー（stdClipboard.Picture Set）

```mermaid
flowchart TD
    A[Set stdClipboard.Picture = IPicture] --> B{Application.Name}
    B -->|Microsoft Excel| C[一時ファイルに保存]
    C --> D[Sheet1.Pictures.Insertで読み込み]
    D --> E[CopyPictureでクリップボードにコピー]
    E --> F[挿入した画像を削除]
    F --> G[一時ファイルを削除]
    G --> H[終了]
```

### 出力フロー（stdImage.ToClipboard）

```mermaid
flowchart TD
    A[stdImage.ToClipboard] --> B[HTMLFileオブジェクト作成]
    B --> C{clipboardData使用可能?}
    C -->|Yes| D[clipboardData.SetDataで設定]
    C -->|No| E[ActiveSheet.OLEObjects.addでImageコントロール作成]
    E --> F[コントロールにpicture設定]
    F --> G[CopyPictureでクリップボードにコピー]
    G --> H[コントロール削除]
    D --> I[終了]
    H --> I
```

### 取得フロー（stdClipboard.Picture Get）

```mermaid
flowchart TD
    A[stdClipboard.Picture Get] --> B{CF_BITMAPが使用可能?}
    B -->|Yes| C[GetPictureFromClipboardでBITMAP取得]
    B -->|No| D{CF_ENHMETAFILEが使用可能?}
    D -->|Yes| E[GetPictureFromClipboardでMETAFILE取得]
    D -->|No| F{CF_METAFILEPICTが使用可能?}
    F -->|Yes| G[GetPictureFromClipboardでMETAFILEPICT取得]
    F -->|No| H[エラー: Invalid clipboard format]
    C --> I[IPicture返却]
    E --> I
    G --> I
    H --> J[終了]
    I --> J
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 形式なしエラー | クリップボードに画像がない | "Invalid clipboard format" | 画像をクリップボードにコピー |
| クリップボード開放失敗 | OpenClipboardが失敗 | "Unable to open clipboard" | 他アプリのクリップボード解放を待機 |
| データ取得失敗 | GetClipboardDataが失敗 | "Unable to get clipboard data handle" | クリップボード内容の確認 |
| 画像ハンドル取得失敗 | CopyImage/CopyEnhMetaFileが失敗 | "Unable to obtain image handle" | 画像形式の確認 |
| OLE変換失敗 | OleCreatePictureIndirectが失敗 | "An error occurred in OleCreatePictureIndirect" | 画像データの正当性確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1画像 |
| 目標出力時間 | 500ms以下（画像サイズ依存） |
| 同時出力数上限 | 1（シングルスレッド） |

## セキュリティ考慮事項

- クリップボードは他のアプリケーションからもアクセス可能なため、機密性の高い画像データの取り扱いに注意が必要
- 一時ファイルを使用する場合、ファイルの削除が確実に行われることを確認
- スクリーンキャプチャ機能は画面上の全情報を含む可能性があるため、機密情報の表示に注意

## 備考

- stdClipboard.Picture Setは現在Excel専用の実装
- stdImage.ToClipboardはハック的な実装を含む（OLEObjects使用）
- CF_BITMAP形式が優先され、利用不可の場合にCF_ENHMETAFILE形式を使用
- XLPictureプロパティ、XLShapeAsPictureプロパティを使用することでExcel固有のオブジェクトからも画像を取得可能

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、画像データの管理に使用される構造体を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdClipboard.cls | `src/stdClipboard.cls` | 97-102行目のPICTDESC構造体定義を確認 |
| 1-2 | stdClipboard.cls | `src/stdClipboard.cls` | 204-210行目のGUID構造体定義を確認 |
| 1-3 | stdImage.cls | `src/stdImage.cls` | 295-303行目のBITMAP構造体定義を確認 |
| 1-4 | stdImage.cls | `src/stdImage.cls` | 332-337行目のPICTDESC構造体定義を確認 |

**読解のコツ**: PICTDESC構造体はOLE Picture変換に必要な構造体で、画像のタイプとハンドルを保持します。GUIDはIDispatchインターフェースのIDを格納します。

#### Step 2: クリップボード画像取得を理解する

クリップボードから画像を取得するProperty Get Pictureを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdClipboard.cls | `src/stdClipboard.cls` | 446-458行目のProperty Get Pictureを確認 |
| 2-2 | stdClipboard.cls | `src/stdClipboard.cls` | 807-849行目のGetPictureFromClipboard関数を確認 |
| 2-3 | stdClipboard.cls | `src/stdClipboard.cls` | 857-891行目のCreatePicture関数を確認 |

**主要処理フロー**:
1. **447-452行目**: CF_BITMAP/CF_ENHMETAFILE/CF_METAFILEPICTの順で形式チェック
2. **807-849行目**: クリップボードを開き、データハンドル取得、画像コピー作成
3. **857-891行目**: PICTDESC構造体を設定し、OleCreatePictureIndirectでIPicture生成

#### Step 3: クリップボード画像設定を理解する

クリップボードに画像を設定するProperty Set Pictureを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdClipboard.cls | `src/stdClipboard.cls` | 459-472行目のProperty Set Pictureを確認 |

**主要処理フロー**:
- **461-471行目**: Excel専用の実装で、一時ファイル経由でクリップボードにコピー

#### Step 4: stdImageからのクリップボード出力を理解する

stdImageクラスのToClipboardメソッドを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdImage.cls | `src/stdImage.cls` | 1093-1109行目のToClipboardメソッドを確認 |
| 4-2 | stdImage.cls | `src/stdImage.cls` | 1171-1187行目のToStdPicture関数を確認 |

**主要処理フロー**:
- **1095-1097行目**: HTMLFileのclipboardData経由で設定を試行
- **1101-1107行目**: OLEObjectsを使用したフォールバック処理

#### Step 5: Excel固有の画像コピー機能を理解する

XLPictureとXLShapeAsPictureプロパティを確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | stdClipboard.cls | `src/stdClipboard.cls` | 480-486行目のProperty Set XLPictureを確認 |
| 5-2 | stdClipboard.cls | `src/stdClipboard.cls` | 492-498行目のProperty Set XLShapeAsPictureを確認 |

**主要処理フロー**:
- **481-485行目**: クリップボードをクリアし、CopyPictureを呼び出し、形式が利用可能になるまで待機

### プログラム呼び出し階層図

```
stdClipboard.Picture (Get)
    │
    ├─ Property Get Picture (446-458行目)
    │      │
    │      └─ GetPictureFromClipboard (807-849行目)
    │             │
    │             ├─ OpenClipboardTimeout (822行目)
    │             ├─ GetClipboardData (824行目)
    │             ├─ CopyImage/CopyEnhMetaFile (829-831行目)
    │             ├─ CloseClipboard (835行目)
    │             └─ CreatePicture (839行目)
    │                    │
    │                    ├─ IIDFromString (875行目)
    │                    └─ OleCreatePictureIndirect (886行目)
    │
Set stdClipboard.Picture = IPicture
    │
    └─ Property Set Picture (459-472行目)
           │
           ├─ olePic.SaveAsFile (465行目)
           ├─ Pictures.Insert (466行目)
           ├─ CopyPicture (467行目)
           ├─ Delete (468行目)
           └─ Kill (470行目)

stdImage.ToClipboard
    │
    └─ ToClipboard (1093-1109行目)
           │
           ├─ ToStdPicture (1097, 1103行目)
           │      │
           │      ├─ IIDFromString (1175行目)
           │      └─ OleCreatePictureIndirect (1185行目)
           │
           └─ OLEObjects.add (1101行目) [フォールバック]
```

### データフロー図

```
[入力]               [処理]                    [出力]

stdole.IPicture ───▶ Property Set Picture ───▶ クリップボード(CF_BITMAP)
     │                      │
     │                      ├─ SaveAsFile
     │                      │
     │                      └─ CopyPicture
     │
stdImage ──────────▶ ToClipboard ────────────▶ クリップボード(CF_BITMAP)
     │                      │
     │                      └─ ToStdPicture
     │
クリップボード ────▶ Property Get Picture ───▶ stdole.IPicture
     │                      │
     │                      ├─ GetPictureFromClipboard
     │                      │
     │                      └─ CreatePicture
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdClipboard.cls | `src/stdClipboard.cls` | ソース | クリップボード操作のメインクラス |
| stdImage.cls | `src/stdImage.cls` | ソース | 画像操作のメインクラス |
| stdClipboardTests.bas | `tests/stdClipboardTests.bas` | テスト | クリップボード機能のテストコード |
