# 帳票設計書 13-シート画像

## 概要

本ドキュメントは、stdVBAライブラリにおけるstdImageクラスのToSheet()メソッドを使用したExcelワークシートへの画像追加機能について記載する帳票設計書です。

### 本帳票の処理概要

本帳票は、stdImageオブジェクトで管理している画像データをExcelワークシート上に配置する機能を提供します。一時ファイル経由でワークシートに画像を追加し、圧縮オプションを指定することでファイルサイズの最適化も可能です。

**業務上の目的・背景**：VBAで処理・生成した画像（スクリーンショット、グラフ、図形のキャプチャなど）をExcelシート上にプログラム的に配置する必要があります。従来の手動操作（挿入→画像）をVBAで自動化することで、レポート生成や画像カタログ作成などの業務効率化を実現します。

**帳票の利用シーン**：自動レポート生成システムで画像を含むExcelレポートを作成する場合、画像一覧を含む在庫管理シートを生成する場合、スクリーンショットを含むテスト結果レポートを作成する場合などに利用されます。

**主要な出力内容**：
1. ワークシート上のPictureオブジェクト（Shape）
2. 指定位置（Top, Left座標）への画像配置
3. 圧縮設定による最適化された画像

**帳票の出力タイミング**：VBAコードからstdImage.ToSheet()メソッド呼び出し時に即座にワークシートへ画像が追加されます。

**帳票の利用者**：VBA開発者、レポート作成者、業務自動化担当者

## 帳票種別

データ出力（Excel出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | VBAコード実行環境 | N/A | stdImage.ToSheet(Worksheet, Top, Left, compress) |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | Excelワークシート上のPictureオブジェクト |
| 用紙サイズ | N/A（シート上の任意位置） |
| 向き | 元画像の向きを維持 |
| ファイル名 | 一時ファイル（GUIDベース） |
| 出力方法 | Shapes.AddPicture2メソッド |
| 文字コード | N/A（バイナリデータ） |

### Excel固有設定

| 項目 | 内容 |
|-----|------|
| 挿入メソッド | Shapes.AddPicture2 |
| リンク設定 | False（埋め込み） |
| 元サイズ維持 | True（Width=-1, Height=-1） |
| 圧縮オプション | MsoPictureCompress列挙値 |

### 圧縮オプション（MsoPictureCompress）

| 値 | 定数名 | 説明 |
|----|-------|------|
| 0 | msoPictureCompressDocDefault | ドキュメントのデフォルト設定 |
| 1 | msoPictureCompressFalse | 圧縮なし |
| 2 | msoPictureCompressTrue | 圧縮あり |

## 帳票レイアウト

### レイアウト概要

ワークシート上に配置される画像のレイアウトは、指定されたTop/Left座標を基準に元画像のサイズで配置されます。

```
┌─────────────────────────────────────┐
│          Excelワークシート           │
│                                     │
│    ┌───────────────┐               │
│    │    (Left,Top) │               │
│    │       ↓       │               │
│    │  ┌─────────┐  │               │
│    │  │         │  │               │
│    │  │  画像   │  │               │
│    │  │         │  │               │
│    │  └─────────┘  │               │
│    │     Width     │               │
│    │    Height     │               │
│    └───────────────┘               │
│                                     │
└─────────────────────────────────────┘
```

### 画像配置パラメータ

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Worksheet | 配置先のワークシート | 引数ws | Object |
| 2 | Top | 上端からの距離（ポイント） | 引数Top（デフォルト0） | Double |
| 3 | Left | 左端からの距離（ポイント） | 引数Left（デフォルト0） | Double |
| 4 | Width | 画像幅（ポイント） | -1（元サイズ維持） | Long |
| 5 | Height | 画像高さ（ポイント） | -1（元サイズ維持） | Long |
| 6 | compress | 圧縮設定 | 引数compress | MsoPictureCompress |

### 戻り値（Pictureオブジェクト）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | 画像オブジェクト名 | 自動生成 | String |
| 2 | Width | 配置後の幅 | 元画像サイズ | Single |
| 3 | Height | 配置後の高さ | 元画像サイズ | Single |
| 4 | Top | 上端座標 | 引数Top | Single |
| 5 | Left | 左端座標 | 引数Left | Single |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| stdImageオブジェクト | 有効な画像データを持つstdImageインスタンス | Yes |
| Worksheetオブジェクト | 有効なExcelワークシート | Yes |
| Excel環境 | Microsoft Excelアプリケーション | Yes |

### ソート順

N/A（単一画像の配置のため順序の概念なし）

### 改ページ条件

N/A（ワークシート出力のため改ページ概念なし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | データベース参照なし | - |

### データソース

本機能はデータベースを参照せず、stdImageオブジェクト内のhBitmapデータを入力とします。

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 一時ファイルパス | Environ("Temp") & "\\" & GUID & "." & ext | なし | ランダムGUID生成 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[stdImage.ToSheet呼び出し] --> B[ToTempFile呼び出し]
    B --> C[一時ファイルパス生成]
    C --> D[ToFileで画像をファイル保存]
    D --> E[Shapes.AddPicture2で画像追加]
    E --> F[Pictureオブジェクト返却]
    F --> G[終了]
```

### 一時ファイル生成フロー

```mermaid
flowchart TD
    A[ToTempFile呼び出し] --> B{format指定あり?}
    B -->|Yes| C[指定形式の拡張子を設定]
    B -->|No| D[デフォルト拡張子を設定]
    C --> E[GUID生成]
    D --> E
    E --> F[一時ファイルパス構築]
    F --> G[ToFileで画像保存]
    G --> H[パスを返却]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 一時ファイル作成失敗 | ToFileでエラー | ToFileメソッドのエラーメッセージ | ディスク容量・権限確認 |
| 画像追加失敗 | AddPicture2でエラー | Excelのエラーメッセージ | ファイル形式・パス確認 |
| 無効なワークシート | Worksheetがnull | 実行時エラー | 有効なWorksheetを指定 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1画像/呼び出し |
| 目標出力時間 | 1秒以下（画像サイズ依存） |
| 同時出力数上限 | 1（シングルスレッド） |

## セキュリティ考慮事項

- 一時ファイルは処理後に残存する可能性があるため、機密画像の取り扱いに注意
- 一時フォルダへのアクセス権限が必要
- Tempフォルダのクリーンアップポリシーを確認

## 備考

- 一時ファイルは自動削除されないため、大量の画像処理時にはディスク容量に注意
- Width=-1, Height=-1により元画像サイズが維持される
- AddPicture2メソッドはExcel 2007以降で利用可能
- 圧縮オプションの効果はファイル保存時に反映される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、stdImageクラスの内部状態を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdImage.cls | `src/stdImage.cls` | 400-408行目のTThis型定義を確認 |
| 1-2 | stdImage.cls | `src/stdImage.cls` | 295-303行目のBITMAP構造体定義を確認 |
| 1-3 | stdImage.cls | `src/stdImage.cls` | 137-144行目のstdImgFormat列挙を確認 |

**読解のコツ**: TThis型はクラスの状態を保持し、hBitmapとHBITMAPTYPE（BITMAP構造体）を含みます。stdImgFormatは出力形式を指定する列挙型です。

#### Step 2: エントリーポイントを理解する

ToSheetメソッドの実装を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdImage.cls | `src/stdImage.cls` | 1135-1137行目のToSheetメソッドを確認 |

**主要処理フロー**:
1. **1136行目**: ToTempFile()で一時ファイルを作成
2. **1136行目**: Shapes.AddPicture2で画像をワークシートに追加
3. **1136行目**: Pictureオブジェクトを返却

#### Step 3: 一時ファイル生成を理解する

ToTempFileメソッドの実装を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdImage.cls | `src/stdImage.cls` | 1115-1127行目のToTempFileメソッドを確認 |

**主要処理フロー**:
- **1117-1123行目**: 形式に応じた拡張子の決定
- **1124行目**: GUIDを使用した一意のファイルパス生成
- **1125行目**: ToFileで画像をファイルに保存
- **1126行目**: 生成したファイルパスを返却

#### Step 4: GUID生成を理解する

getGUID関数の実装を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdImage.cls | `src/stdImage.cls` | 1278-1285行目のgetGUID関数を確認 |

**主要処理フロー**:
- **1279行目**: Randomizeで乱数初期化
- **1280行目**: GUID形式のテンプレート設定
- **1281-1284行目**: ランダム文字で置換してGUID生成

#### Step 5: ファイル保存処理を理解する

ToFileメソッドの実装を確認します（詳細はNo.1-6の帳票設計書を参照）。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | stdImage.cls | `src/stdImage.cls` | 1008-1089行目のToFileメソッドを確認 |

**主要処理フロー**:
- **1009-1022行目**: 形式の自動判定
- **1024-1028行目**: GDI+初期化
- **1030-1031行目**: GdipCreateBitmapFromHBITMAPでGDI+ビットマップ作成
- **1033-1073行目**: 形式別エンコーダ設定
- **1076-1080行目**: GdipSaveImageToFileで保存

### プログラム呼び出し階層図

```
stdImage.ToSheet(ws, Top, Left, compress)
    │
    └─ ToSheet (1135-1137行目)
           │
           ├─ ToTempFile (1115-1127行目)
           │      │
           │      ├─ getGUID (1278-1285行目)
           │      │
           │      └─ ToFile (1008-1089行目)
           │             │
           │             ├─ GdiplusStartup
           │             ├─ GdipCreateBitmapFromHBITMAP
           │             ├─ IIDFromString（エンコーダGUID設定）
           │             ├─ GdipSaveImageToFile
           │             └─ GdiplusShutdown
           │
           └─ Shapes.AddPicture2 (Excel API)
                  │
                  └─ Picture (Shape) オブジェクト返却
```

### データフロー図

```
[入力]               [処理]                    [出力]

stdImage ──────────▶ ToSheet ───────────────▶ Excel Picture
     │                   │
     │                   ├─ ToTempFile
     │                   │      │
     │                   │      ├─ getGUID
     │                   │      │
     │                   │      └─ ToFile
     │                   │
     │                   └─ AddPicture2
     │
     └─ hBitmap ───▶ 一時ファイル(PNG等) ───▶ シート上の画像
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdImage.cls | `src/stdImage.cls` | ソース | 画像操作のメインクラス |
| stdClipboard.cls | `src/stdClipboard.cls` | ソース | クリップボード経由での画像取得に使用 |
