# 帳票設計書 14-図形塗りつぶし

## 概要

本ドキュメントは、stdVBAライブラリにおけるstdImageクラスのToShapeFill()メソッドを使用したExcel図形への画像設定機能について記載する帳票設計書です。

### 本帳票の処理概要

本帳票は、stdImageオブジェクトで管理している画像データをExcelの図形（Shape）の塗りつぶしとして設定する機能を提供します。一時ファイル経由でFillFormat.UserPictureメソッドを使用し、図形の背景に画像を適用します。

**業務上の目的・背景**：VBAで処理・生成した画像をExcelの図形（長方形、楕円、自由図形など）の塗りつぶしパターンとして設定する必要があります。これにより、カスタムロゴを含むボタン風の図形や、画像を背景に持つテキストボックスなど、リッチなビジュアル要素を持つExcelドキュメントを自動生成できます。

**帳票の利用シーン**：ダッシュボード作成時にカスタム画像を含む図形を配置する場合、プレゼンテーション用の画像付きボタンを作成する場合、ブランドロゴを含む図形テンプレートを自動生成する場合などに利用されます。

**主要な出力内容**：
1. 図形のFillFormatに設定された画像パターン
2. UserPicture形式での画像適用

**帳票の出力タイミング**：VBAコードからstdImage.ToShapeFill()メソッド呼び出し時に即座に図形の塗りつぶしが更新されます。

**帳票の利用者**：VBA開発者、ダッシュボード作成者、業務自動化担当者

## 帳票種別

データ出力（Excel出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | VBAコード実行環境 | N/A | stdImage.ToShapeFill(Shape) |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | Excel図形のFillFormat |
| 用紙サイズ | N/A（図形サイズに依存） |
| 向き | 元画像の向きを維持 |
| ファイル名 | 一時ファイル（GUIDベース） |
| 出力方法 | FillFormat.UserPictureメソッド |
| 文字コード | N/A（バイナリデータ） |

### Excel固有設定

| 項目 | 内容 |
|-----|------|
| 設定メソッド | Shape.Fill.UserPicture |
| 塗りつぶしタイプ | msoFillPicture |
| 画像配置 | 図形サイズに合わせて伸縮 |
| アプリケーション | Microsoft Excel専用 |

## 帳票レイアウト

### レイアウト概要

図形に適用される画像は、図形の境界に合わせて配置されます。

```
┌─────────────────────────────────────┐
│          Excel図形（Shape）          │
│  ┌─────────────────────────────┐   │
│  │                             │   │
│  │    ┌─────────────────┐      │   │
│  │    │                 │      │   │
│  │    │   塗りつぶし画像  │      │   │
│  │    │   (UserPicture)  │      │   │
│  │    │                 │      │   │
│  │    └─────────────────┘      │   │
│  │         図形境界            │   │
│  └─────────────────────────────┘   │
│                                     │
└─────────────────────────────────────┘
```

### メソッドパラメータ

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | shp | 対象の図形オブジェクト | 引数 | Object (Excel.Shape) |

### FillFormat設定

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Type | 塗りつぶしタイプ | msoFillPicture | MsoFillType |
| 2 | TextureType | テクスチャタイプ | msoTextureUserDefined | MsoTextureType |
| 3 | PictureEffects | 画像効果 | 適用可能 | PictureEffects |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| stdImageオブジェクト | 有効な画像データを持つstdImageインスタンス | Yes |
| Shapeオブジェクト | 有効なExcel図形 | Yes |
| Excel環境 | Microsoft Excelアプリケーション | Yes |

### ソート順

N/A（単一図形への設定のため順序の概念なし）

### 改ページ条件

N/A（図形塗りつぶし設定のため改ページ概念なし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | データベース参照なし | - |

### データソース

本機能はデータベースを参照せず、stdImageオブジェクト内のhBitmapデータを入力とします。

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 一時ファイルパス | Environ("Temp") & "\\" & GUID & "." & ext | なし | ToTempFile経由 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[stdImage.ToShapeFill呼び出し] --> B{Application.Name判定}
    B -->|Microsoft Excel| C[Excel.Shapeにキャスト]
    C --> D[ToTempFile呼び出し]
    D --> E[一時ファイルパス取得]
    E --> F[xlShp.Fill.UserPicture実行]
    F --> G[図形塗りつぶし完了]
    G --> H[終了]
    B -->|その他| H
```

### 内部処理詳細

```mermaid
flowchart TD
    A[ToShapeFill開始] --> B[Application.Name取得]
    B --> C{Excel?}
    C -->|Yes| D[Shape変数へキャスト]
    D --> E[ToTempFileで一時ファイル生成]
    E --> F[Fill.UserPictureに一時ファイルパス渡す]
    F --> G[ExcelがFillFormatを更新]
    G --> H[終了]
    C -->|No| H
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 一時ファイル作成失敗 | ToTempFileでエラー | ToTempFileのエラーメッセージ | ディスク容量・権限確認 |
| 図形塗りつぶし失敗 | UserPictureでエラー | Excelのエラーメッセージ | ファイル形式・パス確認 |
| 無効な図形 | Shapeがnullまたは無効 | 実行時エラー | 有効なShapeを指定 |
| アプリケーション不一致 | Excel以外で実行 | なし（処理スキップ） | Excel環境で実行 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1図形/呼び出し |
| 目標出力時間 | 500ms以下（画像サイズ依存） |
| 同時出力数上限 | 1（シングルスレッド） |

## セキュリティ考慮事項

- 一時ファイルは処理後に残存する可能性があるため、機密画像の取り扱いに注意
- 一時フォルダへのアクセス権限が必要
- 図形の塗りつぶしとして設定された画像はExcelファイル内に埋め込まれる

## 備考

- 本機能はMicrosoft Excel専用の実装
- Word/PowerPointなど他のOfficeアプリケーションでは処理がスキップされる
- 一時ファイルは自動削除されないため、大量処理時にはディスク容量に注意
- 画像は図形サイズに合わせて自動的に伸縮される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、stdImageクラスの内部状態を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdImage.cls | `src/stdImage.cls` | 400-408行目のTThis型定義を確認 |

**読解のコツ**: TThis型はhBitmapとHBITMAPTYPE（BITMAP構造体）を保持し、これらが画像データの本体となります。

#### Step 2: エントリーポイントを理解する

ToShapeFillメソッドの実装を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdImage.cls | `src/stdImage.cls` | 1161-1167行目のToShapeFillメソッドを確認 |

**主要処理フロー**:
1. **1162行目**: Application.Name判定でExcel環境かチェック
2. **1163行目**: Excel環境の場合、引数をExcel.Shapeにキャスト
3. **1164行目**: xlShp.Fill.UserPictureにToTempFile()の結果を渡す

#### Step 3: 一時ファイル生成を理解する

ToTempFileメソッドの実装を確認します（No.13と共通）。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdImage.cls | `src/stdImage.cls` | 1115-1127行目のToTempFileメソッドを確認 |

**主要処理フロー**:
- **1117-1123行目**: 形式に応じた拡張子の決定
- **1124行目**: GUIDを使用した一意のファイルパス生成
- **1125行目**: ToFileで画像をファイルに保存
- **1126行目**: 生成したファイルパスを返却

#### Step 4: FillFormat.UserPictureを理解する

Excel VBAのFillFormat.UserPictureメソッドの挙動を理解します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | N/A | Excel VBA リファレンス | UserPictureメソッドは画像ファイルパスを受け取り、図形の塗りつぶしに設定 |

**主要処理フロー**:
- ファイルパスを引数として受け取る
- 画像をExcelファイル内に埋め込む
- FillFormat.TypeがmsoFillPictureに設定される

### プログラム呼び出し階層図

```
stdImage.ToShapeFill(shp)
    │
    └─ ToShapeFill (1161-1167行目)
           │
           ├─ Application.Name判定 (1162行目)
           │
           ├─ Excel.Shape変数へキャスト (1164行目)
           │
           ├─ ToTempFile (1115-1127行目)
           │      │
           │      ├─ getGUID (1278-1285行目)
           │      │
           │      └─ ToFile (1008-1089行目)
           │
           └─ xlShp.Fill.UserPicture (Excel API)
                  │
                  └─ FillFormat更新
```

### データフロー図

```
[入力]               [処理]                    [出力]

stdImage ──────────▶ ToShapeFill ────────────▶ Shape.Fill
     │                    │
     │                    ├─ Application.Name判定
     │                    │
     │                    ├─ ToTempFile
     │                    │      │
     │                    │      └─ ToFile
     │                    │
     │                    └─ Fill.UserPicture
     │
     └─ hBitmap ───▶ 一時ファイル(PNG等) ───▶ FillFormat.Picture
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdImage.cls | `src/stdImage.cls` | ソース | 画像操作のメインクラス |
