# 帳票設計書 15-コントロール画像

## 概要

本ドキュメントは、stdVBAライブラリにおけるstdImageクラスのToUIControl()メソッドを使用したUIコントロールへの画像設定機能について記載する帳票設計書です。

### 本帳票の処理概要

本帳票は、stdImageオブジェクトで管理している画像データをVBA UserFormのImageコントロールなどのUIコントロールに設定する機能を提供します。stdole.StdPictureに変換した画像をコントロールのPictureプロパティに直接設定します。

**業務上の目的・背景**：VBAで処理・生成した画像（スクリーンショット、ダウンロードした画像、加工済み画像など）をUserFormのUIコントロールに動的に設定する必要があります。これにより、ユーザーインターフェースに画像を含むインタラクティブなフォームを作成できます。

**帳票の利用シーン**：画像プレビュー機能を持つダイアログボックスを作成する場合、動的に画像が変化するダッシュボードを構築する場合、画像選択・編集ツールを実装する場合などに利用されます。

**主要な出力内容**：
1. UIコントロールのPictureプロパティに設定されたstdole.StdPicture
2. Imageコントロール、CommandButtonなどのPictureプロパティ対応コントロール

**帳票の出力タイミング**：VBAコードからstdImage.ToUIControl()メソッド呼び出し時に即座にコントロールの画像が更新されます。

**帳票の利用者**：VBA開発者、UIデザイナー、業務自動化担当者

## 帳票種別

データ出力（UI出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | VBAコード実行環境 | N/A | stdImage.ToUIControl(Control) |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | stdole.StdPicture（OLE Picture） |
| 用紙サイズ | N/A（コントロールサイズに依存） |
| 向き | 元画像の向きを維持 |
| ファイル名 | N/A（メモリ内オブジェクト） |
| 出力方法 | Control.Pictureプロパティ設定 |
| 文字コード | N/A（バイナリデータ） |

### UI固有設定

| 項目 | 内容 |
|-----|------|
| 設定プロパティ | oControl.Picture |
| 画像形式 | stdole.StdPicture |
| 対応コントロール | Image, CommandButton, ToggleButton等 |
| サイズ調整 | PictureSizeModeプロパティで制御 |

### 対応コントロール一覧

| コントロール | Pictureプロパティ | 備考 |
|-------------|------------------|------|
| Image | あり | 最も一般的 |
| CommandButton | あり | ボタン背景画像 |
| ToggleButton | あり | トグルボタン画像 |
| Frame | あり（背景） | フレーム背景 |
| UserForm | あり（背景） | フォーム背景 |

## 帳票レイアウト

### レイアウト概要

コントロールに設定される画像は、コントロールのPictureSizeModeプロパティに応じて配置されます。

```
┌─────────────────────────────────────┐
│         UserForm                     │
│  ┌─────────────────────────────┐   │
│  │      Image コントロール       │   │
│  │  ┌─────────────────────┐    │   │
│  │  │                     │    │   │
│  │  │   stdole.StdPicture │    │   │
│  │  │                     │    │   │
│  │  └─────────────────────┘    │   │
│  │     PictureSizeMode設定     │   │
│  └─────────────────────────────┘   │
│                                     │
└─────────────────────────────────────┘
```

### PictureSizeModeオプション

| 値 | 定数名 | 説明 |
|----|-------|------|
| 0 | fmPictureSizeModeClip | 画像をクリップ（切り取り） |
| 1 | fmPictureSizeModeStretch | 画像を引き伸ばし |
| 3 | fmPictureSizeModeZoom | アスペクト比維持で拡大縮小 |

### メソッドパラメータ

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | oControl | 対象のUIコントロール | 引数 | Object |

### 出力プロパティ

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Picture | 設定される画像 | ToStdPicture() | stdole.StdPicture |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| stdImageオブジェクト | 有効な画像データを持つstdImageインスタンス | Yes |
| Pictureプロパティ対応コントロール | Picture設定可能なUIコントロール | Yes |

### ソート順

N/A（単一コントロールへの設定のため順序の概念なし）

### 改ページ条件

N/A（UI出力のため改ページ概念なし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | データベース参照なし | - |

### データソース

本機能はデータベースを参照せず、stdImageオブジェクト内のhBitmapデータを入力とします。

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| N/A | 計算処理なし | - | - |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[stdImage.ToUIControl呼び出し] --> B[ToStdPicture呼び出し]
    B --> C[IIDFromStringでGUID取得]
    C --> D[PICTDESC構造体設定]
    D --> E[OleCreatePictureIndirect実行]
    E --> F[stdole.StdPicture取得]
    F --> G[oControl.Picture = StdPicture]
    G --> H[コントロール画像更新]
    H --> I[終了]
```

### ToStdPicture内部処理

```mermaid
flowchart TD
    A[ToStdPicture開始] --> B[IID_IDispatch GUID取得]
    B --> C{GUID取得成功?}
    C -->|No| D[エラー発生]
    C -->|Yes| E[PICTDESC構造体初期化]
    E --> F[size = Len設定]
    F --> G[type = PICTYPE_BITMAP設定]
    G --> H[hPic = This.hBitmap設定]
    H --> I[hPal = 0設定]
    I --> J[OleCreatePictureIndirect呼び出し]
    J --> K{変換成功?}
    K -->|No| L[エラー発生]
    K -->|Yes| M[StdPicture返却]
    D --> N[終了]
    L --> N
    M --> N
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| GUID変換失敗 | IIDFromStringでエラー | "Could not convert IID_IDispatch to GUID" | システム環境確認 |
| OLE変換失敗 | OleCreatePictureIndirectでエラー | "Could not create StdPicture" | 画像データの正当性確認 |
| プロパティ設定失敗 | Picture設定でエラー | 実行時エラー | コントロール対応確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1コントロール/呼び出し |
| 目標出力時間 | 100ms以下 |
| 同時出力数上限 | 1（シングルスレッド） |

## セキュリティ考慮事項

- 画像データはメモリ内で処理されるため、一時ファイルは生成されない
- UserFormは同一プロセス内で動作するため、プロセス間のセキュリティリスクは低い
- 外部ソースからの画像読み込み時は、画像ファイルの検証を推奨

## 備考

- 一時ファイルを介さないため、ToFile/ToTempFileより高速
- hBitmapからstdole.StdPictureへの直接変換を実行
- PICTYPE_BITMAP形式で変換（メタファイル非対応）
- コントロールのPictureSizeModeプロパティで表示方法を調整可能

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、stdole.StdPictureへの変換に使用される構造体を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdImage.cls | `src/stdImage.cls` | 332-337行目のPICTDESC構造体定義を確認 |
| 1-2 | stdImage.cls | `src/stdImage.cls` | 347-352行目のGUID構造体定義を確認 |
| 1-3 | stdImage.cls | `src/stdImage.cls` | 400-408行目のTThis型定義を確認 |

**読解のコツ**: PICTDESC構造体はOLE Picture変換に必要な情報（サイズ、タイプ、ハンドル、パレット）を保持します。

#### Step 2: エントリーポイントを理解する

ToUIControlメソッドの実装を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdImage.cls | `src/stdImage.cls` | 1144-1146行目のToUIControlメソッドを確認 |

**主要処理フロー**:
1. **1145行目**: ToStdPicture()でstdole.StdPictureに変換
2. **1145行目**: oControl.Pictureプロパティに設定

#### Step 3: StdPicture変換を理解する

ToStdPictureメソッドの実装を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdImage.cls | `src/stdImage.cls` | 1171-1187行目のToStdPictureメソッドを確認 |

**主要処理フロー**:
- **1175行目**: IIDFromStringでIID_IDispatch GUIDを取得
- **1177-1183行目**: PICTDESC構造体を設定
- **1185行目**: OleCreatePictureIndirectでIPicture生成
- **1186行目**: エラーチェックと例外処理

#### Step 4: 定数とAPI宣言を理解する

使用されている定数とWindows API宣言を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdImage.cls | `src/stdImage.cls` | 192行目のOleCreatePictureIndirect宣言を確認 |
| 4-2 | stdImage.cls | `src/stdImage.cls` | 194行目のIIDFromString宣言を確認 |

**主要処理フロー**:
- PICTYPE_BITMAP = 1（1172行目で定義）
- IID_IDispatch GUID = "{7BF80980-BF32-101A-8BBB-00AA00300CAB}"

### プログラム呼び出し階層図

```
stdImage.ToUIControl(oControl)
    │
    └─ ToUIControl (1144-1146行目)
           │
           └─ ToStdPicture (1171-1187行目)
                  │
                  ├─ IIDFromString (1175行目)
                  │      │
                  │      └─ GUID構造体にIID_IDispatch設定
                  │
                  ├─ PICTDESC構造体設定 (1177-1183行目)
                  │      │
                  │      ├─ size = Len(uPicinfo)
                  │      ├─ type = PICTYPE_BITMAP
                  │      ├─ hPic = This.hBitmap
                  │      └─ hPal = 0
                  │
                  └─ OleCreatePictureIndirect (1185行目)
                         │
                         └─ stdole.StdPicture返却
```

### データフロー図

```
[入力]               [処理]                    [出力]

stdImage ──────────▶ ToUIControl ────────────▶ Control.Picture
     │                    │
     │                    └─ ToStdPicture
     │                          │
     │                          ├─ IIDFromString
     │                          │
     │                          ├─ PICTDESC設定
     │                          │
     │                          └─ OleCreatePictureIndirect
     │
     └─ hBitmap ───▶ stdole.StdPicture ───▶ Image.Picture
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdImage.cls | `src/stdImage.cls` | ソース | 画像操作のメインクラス |
