# 帳票設計書 16-キャンバス描画

## 概要

本ドキュメントは、stdVBAライブラリにおけるstdCanvasクラスを使用したGDI+によるグラフィック描画機能について記載する帳票設計書です。

### 本帳票の処理概要

本帳票は、VBAからGDI+（Graphics Device Interface Plus）を利用してUserFormコントロールやウィンドウ上にグラフィック要素（矩形、楕円、円、円弧、ポリゴンなど）を描画する機能を提供します。ダブルバッファリングをサポートし、ちらつきのないスムーズな描画を実現します。

**業務上の目的・背景**：VBAの標準機能では高度なグラフィック描画が困難です。stdCanvasクラスを使用することで、カスタムチャート、グラフ、図形、UIデコレーションなど、視覚的にリッチなコンテンツをVBAアプリケーションで実現できます。

**帳票の利用シーン**：カスタムグラフやチャートをUserFormに描画する場合、ゲームやインタラクティブなビジュアライゼーションを作成する場合、プログレスインジケータや装飾的なUI要素を実装する場合などに利用されます。

**主要な出力内容**：
1. 矩形（Rectangle）描画
2. 楕円（Ellipse）描画
3. 円（Circle）描画
4. 円弧（Arc）描画
5. ポリゴン（Polygon）描画

**帳票の出力タイミング**：Draw*メソッド呼び出し後、Redrawメソッド呼び出し時にキャンバスに描画されます。

**帳票の利用者**：VBA開発者、UIデザイナー、データビジュアライゼーション担当者

## 帳票種別

グラフィック出力

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | UserForm / ウィンドウ | N/A | stdCanvas.Draw* / Redraw |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | ウィンドウ/コントロールへの直接描画 |
| 用紙サイズ | N/A（描画領域サイズに依存） |
| 向き | N/A |
| ファイル名 | N/A（メモリ内描画） |
| 出力方法 | GDI+ APIによる描画 |
| 文字コード | N/A |

### グラフィック固有設定

| 項目 | 内容 |
|-----|------|
| グラフィックエンジン | GDI+ (gdiplus.dll) |
| バッファリング | ダブルバッファリング対応 |
| 座標系 | ピクセル単位（UnitPixel） |
| カラーモード | ARGB (32bit) |

### ステータス

本クラスはWIP（Work In Progress）ステータスです。将来的な変更の可能性があります。

## 帳票レイアウト

### レイアウト概要

キャンバスは指定されたウィンドウまたはコントロールのクライアント領域に描画を行います。

```
┌─────────────────────────────────────┐
│         UserForm / Window           │
│  ┌─────────────────────────────┐   │
│  │      Canvas描画領域         │   │
│  │  ┌───────┐    ┌───────┐    │   │
│  │  │Rectangle│  │Ellipse │    │   │
│  │  └───────┘    └───────┘    │   │
│  │       ┌─────────┐          │   │
│  │       │ Polygon │          │   │
│  │       └─────────┘          │   │
│  │                             │   │
│  └─────────────────────────────┘   │
│                                     │
└─────────────────────────────────────┘
```

### 描画オブジェクトタイプ

| タイプ | 定数名 | 説明 |
|-------|-------|------|
| 0 | cvtRectangle | 矩形 |
| 1 | cvtEllipse | 楕円 |
| 2 | cvtArc | 円弧 |
| 3 | cvtPolygon | ポリゴン |

### 描画スタイル

| スタイル | 定数名 | 説明 |
|----------|-------|------|
| 0 | cvsFillColor | 塗りつぶし色（ARGB） |
| 1 | cvsLineColor | 線の色（ARGB） |
| 2 | cvsLineWidth | 線の太さ |

### 矩形パラメータ（CanvasRectFields）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 0 | cvfRectLeft | 左端X座標 | 引数 | Long |
| 1 | cvfRectTop | 上端Y座標 | 引数 | Long |
| 2 | cvfRectWidth | 幅 | 引数 | Long |
| 3 | cvfRectHeight | 高さ | 引数 | Long |

### 楕円パラメータ（CanvasEllipseFields）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 0 | cvfEllipseCenterX | 中心X座標 | 引数 | Long |
| 1 | cvfEllipseCenterY | 中心Y座標 | 引数 | Long |
| 2 | cvfEllipseWidth | 幅 | 引数 | Long |
| 3 | cvfEllipseHeight | 高さ | 引数 | Long |

### 円弧パラメータ（CanvasArcFields）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 0 | cvfArcCenterX | 中心X座標 | 引数 | Long |
| 1 | cvfArcCenterY | 中心Y座標 | 引数 | Long |
| 2 | cvfArcWidth | 幅 | 引数 | Long |
| 3 | cvfArcHeight | 高さ | 引数 | Long |
| 4 | cvfArcStartAngle | 開始角度 | 引数 | Single |
| 5 | cvfArcSweepAngle | 描画角度 | 引数 | Single |

### ポリゴンパラメータ（CanvasPolygonFields）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 0 | cvfPolygonPoints | 頂点座標配列 | 引数 | Single() |
| 1 | cvfPolygonCount | 頂点数 | 計算値 | Long |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ウィンドウハンドル | 有効なhWndを持つウィンドウ/コントロール | Yes |
| GDI+環境 | gdiplus.dllが利用可能 | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | 描画順序（objects配列インデックス） | 昇順 |

### 改ページ条件

N/A（グラフィック出力のため改ページ概念なし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | データベース参照なし | - |

### データソース

本機能はデータベースを参照せず、VBAコードから直接描画パラメータを指定します。

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| ARGB色値 | A * 2^24 + R * 2^16 + G * 2^8 + B | なし | オーバーフロー対策あり |
| 楕円位置 | centerX - width/2, centerY - height/2 | なし | 左上座標変換 |
| バウンディングボックス | min/max(x), min/max(y) | 切り上げ | ポリゴン用 |

## 処理フロー

### 描画フロー

```mermaid
flowchart TD
    A[CreateFromControl/CreateFromHwnd] --> B[protInit]
    B --> C[GetDC でデバイスコンテキスト取得]
    C --> D[GdiplusStartup でGDI+初期化]
    D --> E[ResizeBuffer でダブルバッファ初期化]
    E --> F[Draw* メソッドで描画オブジェクト追加]
    F --> G[Redraw 呼び出し]
    G --> H[GdipCreateFromHDC でグラフィックス作成]
    H --> I[GdipGraphicsClear で背景クリア]
    I --> J[RenderObject で各オブジェクト描画]
    J --> K[BitBlt でバッファを画面に転送]
    K --> L[描画完了]
```

### オブジェクト描画詳細

```mermaid
flowchart TD
    A[RenderObject開始] --> B{塗りつぶし表示?}
    B -->|Yes| C[GdipCreateSolidFill でブラシ作成]
    C --> D{オブジェクトタイプ}
    D -->|Rectangle| E[GdipFillRectangle]
    D -->|Ellipse| F[GdipFillEllipse]
    D -->|Arc| G[GdipFillPie]
    D -->|Polygon| H[GdipFillPolygon]
    E --> I[GdipDeleteBrush]
    F --> I
    G --> I
    H --> I
    B -->|No| J{線表示?}
    I --> J
    J -->|Yes| K[GdipCreatePen1 でペン作成]
    K --> L{オブジェクトタイプ}
    L -->|Rectangle| M[GdipDrawRectangle]
    L -->|Ellipse| N[GdipDrawEllipse]
    L -->|Arc| O[GdipDrawArc]
    L -->|Polygon| P[GdipDrawPolygon]
    M --> Q[GdipDeletePen]
    N --> Q
    O --> Q
    P --> Q
    J -->|No| R[終了]
    Q --> R
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| DC取得失敗 | GetDCが0を返す | "Failed to get device context." | 有効なhWnd確認 |
| GDI+初期化失敗 | GdiplusStartupが非0を返す | "Failed to start GDI+" | GDI+環境確認 |
| ポリゴン頂点数不正 | 頂点配列が奇数要素 | "Points array must contain an even number of elements" | 偶数個の座標を指定 |
| ポリゴン頂点不足 | 3点未満のポリゴン | "Polygon must have at least 3 points" | 3点以上を指定 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定オブジェクト数 | 1〜1000個 |
| 目標描画時間 | 16ms以下（60fps相当） |
| バッファサイズ | クライアント領域サイズ |

## セキュリティ考慮事項

- GDI+リソースは適切に解放される必要がある（Class_Terminateで実装済み）
- デバイスコンテキストのリークに注意
- 大量のオブジェクト描画時のメモリ使用量に注意

## 備考

- 本クラスはWIP（Work In Progress）ステータス
- ダブルバッファリングによりちらつき防止
- ARGBカラーは専用のargb関数で生成
- 将来的にテキスト描画、画像描画、イベント処理の追加が予定

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、描画オブジェクトの管理構造を理解することが重要です。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdCanvas.cls | `src/WIP/stdCanvas.cls` | 156-173行目のCanvasObject型定義を確認 |
| 1-2 | stdCanvas.cls | `src/WIP/stdCanvas.cls` | 175-189行目のTThis型定義を確認 |
| 1-3 | stdCanvas.cls | `src/WIP/stdCanvas.cls` | 12-56行目の列挙型定義を確認 |

**読解のコツ**: CanvasObject型は個々の描画オブジェクト（矩形、楕円など）を表し、TThis型はキャンバス全体の状態を管理します。

#### Step 2: 初期化処理を理解する

キャンバスの初期化処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdCanvas.cls | `src/WIP/stdCanvas.cls` | 196-206行目のCreateFromControl/CreateFromFrameを確認 |
| 2-2 | stdCanvas.cls | `src/WIP/stdCanvas.cls` | 222-225行目のCreateFromHwndを確認 |
| 2-3 | stdCanvas.cls | `src/WIP/stdCanvas.cls` | 231-256行目のprotInitを確認 |

**主要処理フロー**:
1. **234行目**: GetDCでデバイスコンテキスト取得
2. **243-248行目**: GdiplusStartupでGDI+初期化
3. **252-255行目**: ResizeBufferでダブルバッファ初期化

#### Step 3: 描画オブジェクト追加を理解する

Draw*メソッドの実装を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdCanvas.cls | `src/WIP/stdCanvas.cls` | 280-296行目のDrawRectangleを確認 |
| 3-2 | stdCanvas.cls | `src/WIP/stdCanvas.cls` | 345-368行目のDrawEllipseを確認 |
| 3-3 | stdCanvas.cls | `src/WIP/stdCanvas.cls` | 309-334行目のDrawArcを確認 |
| 3-4 | stdCanvas.cls | `src/WIP/stdCanvas.cls` | 390-432行目のDrawPolygonを確認 |

**主要処理フロー**:
- getNewObjectで新規オブジェクトハンドル取得
- ObjectType設定
- ObjectParams配列にパラメータ設定
- ObjectStyle配列にスタイル設定

#### Step 4: 描画処理を理解する

Redrawメソッドとオブジェクト描画処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | stdCanvas.cls | `src/WIP/stdCanvas.cls` | 494-537行目のRedrawメソッドを確認 |
| 4-2 | stdCanvas.cls | `src/WIP/stdCanvas.cls` | 590-661行目のRenderObjectを確認 |

**主要処理フロー**:
- **500-503行目**: バッファサイズ確認・リサイズ
- **520行目**: GdipCreateFromHDCでグラフィックス作成
- **523行目**: GdipGraphicsClearで背景クリア
- **527-529行目**: 各オブジェクトをRenderObjectで描画
- **535行目**: BitBltでバッファを画面に転送

#### Step 5: リソース管理を理解する

リソースの解放処理を確認します。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 5-1 | stdCanvas.cls | `src/WIP/stdCanvas.cls` | 259-272行目のClass_Terminateを確認 |

**主要処理フロー**:
- **267行目**: バッファビットマップ削除
- **268行目**: バッファDC削除
- **270行目**: GDI+シャットダウン
- **271行目**: デバイスコンテキスト解放

### プログラム呼び出し階層図

```
stdCanvas.CreateFromControl(Control)
    │
    └─ CreateFromHwnd (222-225行目)
           │
           └─ protInit (231-256行目)
                  │
                  ├─ GetDC (234行目)
                  ├─ GdiplusStartup (247行目)
                  └─ ResizeBuffer (254行目)

stdCanvas.DrawRectangle/DrawEllipse/DrawArc/DrawPolygon
    │
    └─ getNewObject (547-554行目)
           │
           └─ objects配列に追加

stdCanvas.Redraw
    │
    └─ Redraw (494-537行目)
           │
           ├─ GetClientRect (497行目)
           ├─ ResizeBuffer (必要時)
           ├─ GdipCreateFromHDC (520行目)
           ├─ GdipGraphicsClear (523行目)
           ├─ RenderObject (527-529行目ループ)
           │      │
           │      ├─ GdipCreateSolidFill/GdipFill* (塗りつぶし)
           │      └─ GdipCreatePen1/GdipDraw* (線描画)
           │
           └─ BitBlt (535行目)
```

### データフロー図

```
[入力]               [処理]                    [出力]

UserForm/Control ───▶ CreateFromControl ───▶ stdCanvas
     │                      │
     │                      └─ protInit
     │                            │
     │                            ├─ GetDC
     │                            │
     │                            └─ GdiplusStartup
     │
Draw*パラメータ ────▶ Draw*/Redraw ─────────▶ 画面描画
     │                      │
     │                      ├─ objects配列に追加
     │                      │
     │                      ├─ RenderObject
     │                      │
     │                      └─ BitBlt
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdCanvas.cls | `src/WIP/stdCanvas.cls` | ソース | キャンバス描画のメインクラス（WIP） |
| stdImage.cls | `src/stdImage.cls` | ソース | 画像操作（一部のGDI+機能を共有） |
