# 帳票設計書 2-BMP画像ファイル

## 概要

本ドキュメントは、stdImageクラスのToFile()メソッドを使用したBMP形式での画像出力機能について記述した帳票設計書である。

### 本帳票の処理概要

stdImage.ToFile()メソッドによりBMP（ビットマップ）形式で画像ファイルを出力する機能を提供する。この機能により、VBAアプリケーション内で処理された画像データを、Windows標準のBMP形式ファイルとして保存できる。

**業務上の目的・背景**：VBAアプリケーションで画面キャプチャ、クリップボード画像、Excel図形などから取得した画像データを、Windows標準のBMP形式で保存する必要がある。BMP形式は非圧縮であり、画質劣化がなく、Windows環境での互換性が高い。

**帳票の利用シーン**：
- Windows標準形式での画像保存
- 画質劣化を避けたい場合の画像保存
- レガシーシステムとの連携
- VBAのSavePicture関数との互換性が必要な場合
- 高速な読み書きが必要な場合

**主要な出力内容**：
1. BMP形式の画像データ（SavePicture関数使用）
2. 非圧縮形式
3. 32ビット色深度対応

**帳票の出力タイミング**：stdImageオブジェクト生成後、ToFile()メソッドを.bmpファイルパスで呼び出した時点で出力される。

**帳票の利用者**：VBA開発者、Excel/Word/Accessアプリケーションのエンドユーザー

## 帳票種別

画像ファイル出力

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | VBAモジュール | - | stdImage.ToFile("path.bmp")メソッド呼び出し |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | BMP (Windows Bitmap) |
| 用紙サイズ | N/A（画像サイズは元画像に依存） |
| 向き | N/A |
| ファイル名 | 任意（拡張子.bmpで自動判定） |
| 出力方法 | ファイルシステムへの直接書き込み |
| 文字コード | N/A（バイナリファイル） |

### 画像固有設定

| 項目 | 内容 |
|-----|------|
| 出力方法 | VBA SavePicture関数 |
| 圧縮方式 | 非圧縮 |
| ヘッダ | BITMAPFILEHEADER + BITMAPINFOHEADER |

## 帳票レイアウト

### レイアウト概要

BMP画像ファイルは元のビットマップ画像のピクセルデータをそのまま保持する。

```
┌─────────────────────────────────────┐
│      BITMAPFILEHEADER (14 bytes)    │
│      bfType: "BM"                   │
├─────────────────────────────────────┤
│      BITMAPINFOHEADER (40 bytes)    │
│      biWidth, biHeight, etc.        │
├─────────────────────────────────────┤
│         Pixel Data                  │
│   [非圧縮ピクセルデータ]            │
└─────────────────────────────────────┘
```

### ヘッダ部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | bfType | ファイルタイプ識別子 | 固定値 "BM" | 2バイト |
| 2 | bfSize | ファイルサイズ | 計算値 | 4バイト |
| 3 | bfOffBits | データ開始オフセット | 計算値 | 4バイト |
| 4 | biSize | 情報ヘッダサイズ | 固定値 40 | 4バイト |
| 5 | biWidth | 画像幅 | This.HBITMAPTYPE.bmWidth | 4バイト |
| 6 | biHeight | 画像高さ | This.HBITMAPTYPE.bmHeight | 4バイト |
| 7 | biBitCount | ビット深度 | 32 | 2バイト |

### 画像データ部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | PixelData | 画素データ | hBitmap経由 | BGR/BGRA |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 有効なstdImageオブジェクト | hBitmapが設定済みであること | Yes |
| 出力パス | 書き込み可能なファイルパス | Yes |
| フォーマット指定 | 拡張子.bmpまたはstdImgFormatBMP | Yes |

### ソート順

N/A（単一画像出力）

### 改ページ条件

N/A

## データベース参照仕様

### 参照テーブル一覧

N/A（データベース非依存）

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| ファイルサイズ | 54 + (bmWidth * bmHeight * 4) | N/A | ヘッダ+データ |
| 行サイズ | ((bmWidth * 32 + 31) / 32) * 4 | 切り捨て | 4バイト境界調整 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[ToFile呼び出し] --> B{フォーマット判定}
    B -->|拡張子.bmp| C[stdImgFormatBMP設定]
    B -->|明示指定| C
    C --> D[ToStdPicture呼び出し]
    D --> E[SavePicture関数呼び出し]
    E --> F[ファイル出力完了]
    F --> G[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| StdPicture変換失敗 | 無効なビットマップ | "Could not create StdPicture" | 元画像の有効性確認 |
| ファイル保存失敗 | パス無効/権限不足 | VBAランタイムエラー | 出力パスの確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1画像/呼び出し |
| 目標出力時間 | 1920x1080サイズで0.5秒以内 |
| 同時出力数上限 | シングルスレッド処理 |

## セキュリティ考慮事項

- ファイルパスインジェクションの防止：ユーザー入力パスの検証推奨
- BMPファイルは非圧縮のためファイルサイズが大きくなる可能性
- 機密画像の場合は保存先のアクセス制御確認

## 備考

- VBA標準のSavePicture関数を使用
- 他フォーマット（PNG, JPEG等）と異なりGDI+を使用しない
- Mac環境では動作不可（Windows専用）
- 非圧縮のためファイルサイズが大きい

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、stdImageクラスの内部データ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdImage.cls | `src/stdImage.cls` | 305-311行目: BITMAPFILEHEADER構造体定義 |
| 1-2 | stdImage.cls | `src/stdImage.cls` | 313-325行目: BITMAPINFOHEADER構造体定義 |

**読解のコツ**: BMP形式のヘッダ構造はWindows標準仕様に準拠している。

#### Step 2: エントリーポイントを理解する

処理の起点となるToFileメソッドを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdImage.cls | `src/stdImage.cls` | 1070-1072行目: BMP出力のCase文 |

**主要処理フロー**:
1. **1014行目**: 拡張子判定 - .bmpでstdImgFormatBMP設定
2. **1070-1072行目**: BMP固有処理 - SavePicture関数呼び出し
3. **1071行目**: ToStdPicture()でIPictureに変換
4. **SavePicture実行**: VBA標準関数でファイル出力

#### Step 3: ToStdPictureメソッドを理解する

BMP出力の核となるToStdPicture変換処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdImage.cls | `src/stdImage.cls` | 1171-1187行目: ToStdPictureメソッド |
| 3-2 | stdImage.cls | `src/stdImage.cls` | 192行目: OleCreatePictureIndirect宣言 |

**主要処理フロー**:
- **1172行目**: PICTYPE_BITMAP定数（値=1）
- **1174-1175行目**: IID_IDispatch GUID取得
- **1177-1183行目**: PICTDESC構造体設定
- **1185行目**: OleCreatePictureIndirect呼び出し

### プログラム呼び出し階層図

```
stdImage.ToFile(FileName, format=stdImgFormatBMP)
    │
    ├─ フォーマット判定 (1014行目)
    │      └─ 拡張子.bmpでstdImgFormatBMP設定
    │
    ├─ Case stdImgFormatBMP (1070行目)
    │      │
    │      ├─ ToStdPicture() (1071行目)
    │      │      │
    │      │      ├─ IIDFromString (1175行目)
    │      │      │      └─ IID_IDispatch GUID取得
    │      │      │
    │      │      ├─ PICTDESC設定 (1177-1183行目)
    │      │      │      └─ hBitmap設定
    │      │      │
    │      │      └─ OleCreatePictureIndirect (1185行目)
    │      │             └─ IPicture生成
    │      │
    │      └─ SavePicture (1071行目)
    │             └─ VBA標準関数でファイル出力
    │
    └─ Exit Sub (1072行目)
```

### データフロー図

```
[入力]               [処理]                    [出力]

hBitmap         OleCreatePictureIndirect     IPicture
(メモリ内)  ────────────▶  ────────────────────▶
                                                   │
                                                   ▼
                        SavePicture
                   ─────────────────────────▶  BMP File
                        (VBA標準関数)          (ディスク)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdImage.cls | `src/stdImage.cls` | ソース | 画像処理メインクラス |
| oleaut32.dll | Windows System | システムDLL | OleCreatePictureIndirect提供 |
