# 帳票設計書 3-JPEG画像ファイル

## 概要

本ドキュメントは、stdImageクラスのToFile()メソッドを使用したJPEG形式での画像出力機能について記述した帳票設計書である。

### 本帳票の処理概要

stdImage.ToFile()メソッドによりJPEG形式で画像ファイルを出力する機能を提供する。この機能により、VBAアプリケーション内で処理された画像データを、高圧縮率のJPEG形式ファイルとして保存できる。品質パラメータにより圧縮率の調整が可能。

**業務上の目的・背景**：VBAアプリケーションで画面キャプチャ、クリップボード画像、Excel図形などから取得した画像データを、ファイルサイズが小さいJPEG形式で保存する必要がある。JPEG形式は非可逆圧縮だが高い圧縮率を実現し、Web表示や電子メール添付に適している。

**帳票の利用シーン**：
- ファイルサイズを抑えた画像保存
- Web用画像の生成
- メール添付用画像の作成
- 写真・グラデーション画像の保存
- 品質とサイズのトレードオフが必要な場合

**主要な出力内容**：
1. JPEG形式の画像データ（GDI+エンコーディング使用）
2. 品質パラメータによる圧縮率調整（0-100、デフォルト80）
3. 非可逆圧縮による高い圧縮効率

**帳票の出力タイミング**：stdImageオブジェクト生成後、ToFile()メソッドを.jpegまたは.jpgファイルパスで呼び出した時点で出力される。

**帳票の利用者**：VBA開発者、Excel/Word/Accessアプリケーションのエンドユーザー

## 帳票種別

画像ファイル出力

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | VBAモジュール | - | stdImage.ToFile("path.jpeg", Quality:=80)メソッド呼び出し |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JPEG (Joint Photographic Experts Group) |
| 用紙サイズ | N/A（画像サイズは元画像に依存） |
| 向き | N/A |
| ファイル名 | 任意（拡張子.jpeg/.jpgで自動判定） |
| 出力方法 | ファイルシステムへの直接書き込み |
| 文字コード | N/A（バイナリファイル） |

### 画像固有設定

| 項目 | 内容 |
|-----|------|
| エンコーダGUID | {557CF401-1A04-11D3-9A73-0000F81EF32E} |
| 品質パラメータGUID | {1D5BE4B5-FA4A-452D-9CDD-5DB35105E7EB} |
| デフォルト品質 | 80（0-100の範囲） |
| 圧縮方式 | 非可逆圧縮（DCT変換） |
| 透過対応 | 非対応 |

## 帳票レイアウト

### レイアウト概要

JPEG画像ファイルはDCT（離散コサイン変換）を用いて圧縮されたデータを含む。

```
┌─────────────────────────────────────┐
│         JPEG Header (SOI)           │
│         0xFFD8                      │
├─────────────────────────────────────┤
│         APP0 / JFIF Marker          │
├─────────────────────────────────────┤
│         Quantization Tables         │
├─────────────────────────────────────┤
│         Frame Header (SOF)          │
├─────────────────────────────────────┤
│         Huffman Tables              │
├─────────────────────────────────────┤
│         Compressed Image Data       │
│   [DCT変換済み圧縮データ]           │
├─────────────────────────────────────┤
│         JPEG Footer (EOI)           │
│         0xFFD9                      │
└─────────────────────────────────────┘
```

### パラメータ設定

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Quality | 品質（0-100） | ToFileメソッド引数 | Byte |
| 2 | NumberOfValues | パラメータ数 | 固定値 1 | Long |
| 3 | type | パラメータ型 | 固定値 4 | Long |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 有効なstdImageオブジェクト | hBitmapが設定済みであること | Yes |
| 出力パス | 書き込み可能なファイルパス | Yes |
| フォーマット指定 | 拡張子.jpeg/.jpgまたはstdImgFormatJPEG | Yes |
| 品質パラメータ | 0-100の範囲（デフォルト80） | No |

### ソート順

N/A（単一画像出力）

### 改ページ条件

N/A

## データベース参照仕様

### 参照テーブル一覧

N/A（データベース非依存）

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 圧縮率 | 品質パラメータに反比例 | N/A | 100=最高画質、0=最低画質 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[ToFile呼び出し] --> B{フォーマット判定}
    B -->|拡張子.jpeg/.jpg| C[stdImgFormatJPEG設定]
    B -->|明示指定| C
    C --> D[GdiplusStartup]
    D --> E[GdipCreateBitmapFromHBITMAP]
    E --> F[エンコーダGUID設定]
    F --> G[品質パラメータ設定]
    G --> H[EncoderParameters構造体構築]
    H --> I[GdipSaveImageToFile]
    I --> J[GdipDisposeImage]
    J --> K[GdiplusShutdown]
    K --> L[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| GDI+起動失敗 | GDI+初期化エラー | "Could not start GDI+" | GDI+ライブラリの確認 |
| HBITMAP変換失敗 | 無効なビットマップ | "Could not convert HBITMAP to GDI+ image" | 元画像の有効性確認 |
| ファイル保存失敗 | パス無効/権限不足 | "Could not save image to file" | 出力パスの確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1画像/呼び出し |
| 目標出力時間 | 1920x1080サイズで1秒以内 |
| 同時出力数上限 | シングルスレッド処理 |

## セキュリティ考慮事項

- ファイルパスインジェクションの防止：ユーザー入力パスの検証推奨
- JPEG形式は非可逆圧縮のため元画像の完全な復元は不可
- 機密画像の場合は保存先のアクセス制御確認

## 備考

- GDI+ (gdiplus.dll) への依存あり
- Mac環境では動作不可（Windows専用API使用）
- 64ビット/32ビット両対応
- 品質0-100で調整可能（デフォルト80）
- 透過情報は保持されない

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、エンコーダパラメータの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdImage.cls | `src/stdImage.cls` | 354-359行目: EncoderParameter構造体定義 |
| 1-2 | stdImage.cls | `src/stdImage.cls` | 361-364行目: EncoderParameters構造体定義 |

**読解のコツ**: EncoderParametersはGDI+のエンコーダに渡すパラメータを格納する。JPEG品質はこの構造体で指定。

#### Step 2: エントリーポイントを理解する

処理の起点となるToFileメソッドを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdImage.cls | `src/stdImage.cls` | 1035-1046行目: JPEG出力の処理ブロック |

**主要処理フロー**:
1. **1016行目**: 拡張子判定 - .jpeg/.jpgでstdImgFormatJPEG設定
2. **1035-1046行目**: JPEG固有処理
3. **1036行目**: JPEGエンコーダGUID設定
4. **1037-1045行目**: 品質パラメータ設定

#### Step 3: エンコーダパラメータ設定を理解する

JPEG品質パラメータの設定方法を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdImage.cls | `src/stdImage.cls` | 1037-1045行目: tParams設定 |

**主要処理フロー**:
- **1037行目**: tParams.count = 1（パラメータ数）
- **1038行目**: ReDim tParams.Parameter(1 To 1)
- **1040行目**: 品質パラメータGUID設定
- **1041行目**: NumberOfValues = 1
- **1042行目**: type = 4（Long型）
- **1043行目**: Value = VarPtr(Quality)

### プログラム呼び出し階層図

```
stdImage.ToFile(FileName, format, Quality:=80)
    │
    ├─ フォーマット判定 (1016行目)
    │      └─ 拡張子.jpeg/.jpgでstdImgFormatJPEG設定
    │
    ├─ GdiplusStartup (1028行目)
    │      └─ GDI+ライブラリ初期化
    │
    ├─ GdipCreateBitmapFromHBITMAP (1031行目)
    │      └─ HBITMAP→GDI+Bitmap変換
    │
    ├─ Case stdImgFormatJPEG (1035行目)
    │      │
    │      ├─ IIDFromString (1036行目)
    │      │      └─ JPEGエンコーダGUID取得
    │      │
    │      └─ EncoderParameters設定 (1037-1045行目)
    │             ├─ count = 1
    │             ├─ 品質GUID設定
    │             └─ Quality値をポインタ参照
    │
    ├─ GdipSaveImageToFile (1079行目)
    │      └─ ファイル書き込み実行（パラメータ付き）
    │
    ├─ GdipDisposeImage (1083行目)
    │      └─ GDI+画像リソース解放
    │
    └─ GdiplusShutdown (1087行目)
           └─ GDI+ライブラリ終了
```

### データフロー図

```
[入力]               [処理]                    [出力]

hBitmap         GdipCreateBitmapFromHBITMAP    GDI+ Bitmap
(メモリ内)  ────────────▶  ────────────────────▶
                                                   │
Quality(80)                                        │
     │                                             ▼
     └──────▶  EncoderParameters設定  ──────▶
                        │
                        ▼
                GdipSaveImageToFile
           ─────────────────────────▶  JPEG File
                (JPEGエンコーダ)          (ディスク)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdImage.cls | `src/stdImage.cls` | ソース | 画像処理メインクラス |
| gdiplus.dll | Windows System | システムDLL | GDI+ライブラリ |
