# 帳票設計書 4-GIF画像ファイル

## 概要

本ドキュメントは、stdImageクラスのToFile()メソッドを使用したGIF形式での画像出力機能について記述した帳票設計書である。

### 本帳票の処理概要

stdImage.ToFile()メソッドによりGIF形式で画像ファイルを出力する機能を提供する。この機能により、VBAアプリケーション内で処理された画像データを、256色パレットのGIF形式ファイルとして保存できる。

**業務上の目的・背景**：VBAアプリケーションで画面キャプチャ、クリップボード画像、Excel図形などから取得した画像データを、GIF形式で保存する必要がある。GIF形式は256色に制限されるが、可逆圧縮であり、アイコンやロゴなどの単純な画像、アニメーション対応が求められる場面で有用。

**帳票の利用シーン**：
- アイコン・ロゴの保存
- 色数が少ない画像の保存
- Web用の軽量画像生成
- レガシーシステムとの互換性確保
- インデックスカラー画像の作成

**主要な出力内容**：
1. GIF形式の画像データ（GDI+エンコーディング使用）
2. 256色パレット（インデックスカラー）
3. 可逆圧縮（LZW圧縮）

**帳票の出力タイミング**：stdImageオブジェクト生成後、ToFile()メソッドを.gifファイルパスで呼び出した時点で出力される。

**帳票の利用者**：VBA開発者、Excel/Word/Accessアプリケーションのエンドユーザー

## 帳票種別

画像ファイル出力

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | VBAモジュール | - | stdImage.ToFile("path.gif")メソッド呼び出し |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | GIF (Graphics Interchange Format) |
| 用紙サイズ | N/A（画像サイズは元画像に依存） |
| 向き | N/A |
| ファイル名 | 任意（拡張子.gifで自動判定） |
| 出力方法 | ファイルシステムへの直接書き込み |
| 文字コード | N/A（バイナリファイル） |

### 画像固有設定

| 項目 | 内容 |
|-----|------|
| エンコーダGUID | {557CF402-1A04-11D3-9A73-0000F81EF32E} |
| 最大色数 | 256色 |
| 圧縮方式 | LZW圧縮（可逆） |
| 透過対応 | 単一色透過対応 |

## 帳票レイアウト

### レイアウト概要

GIF画像ファイルはパレットベースの色情報とLZW圧縮されたピクセルデータを含む。

```
┌─────────────────────────────────────┐
│         GIF Header                  │
│         "GIF89a" または "GIF87a"    │
├─────────────────────────────────────┤
│         Logical Screen Descriptor   │
│         画面サイズ、背景色等        │
├─────────────────────────────────────┤
│         Global Color Table          │
│         グローバルパレット（256色）  │
├─────────────────────────────────────┤
│         Image Descriptor            │
├─────────────────────────────────────┤
│         Image Data                  │
│   [LZW圧縮済みインデックスデータ]   │
├─────────────────────────────────────┤
│         GIF Trailer                 │
│         0x3B                        │
└─────────────────────────────────────┘
```

### 画像データ部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Width | 画像幅 | This.HBITMAPTYPE.bmWidth | ピクセル |
| 2 | Height | 画像高さ | This.HBITMAPTYPE.bmHeight | ピクセル |
| 3 | ColorTable | カラーテーブル | GDI+で自動生成 | 256エントリ |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 有効なstdImageオブジェクト | hBitmapが設定済みであること | Yes |
| 出力パス | 書き込み可能なファイルパス | Yes |
| フォーマット指定 | 拡張子.gifまたはstdImgFormatGIF | Yes |

### ソート順

N/A（単一画像出力）

### 改ページ条件

N/A

## データベース参照仕様

### 参照テーブル一覧

N/A（データベース非依存）

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| パレットサイズ | 最大256 * 3バイト | N/A | RGB各1バイト |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[ToFile呼び出し] --> B{フォーマット判定}
    B -->|拡張子.gif| C[stdImgFormatGIF設定]
    B -->|明示指定| C
    C --> D[GdiplusStartup]
    D --> E[GdipCreateBitmapFromHBITMAP]
    E --> F[エンコーダGUID設定]
    F --> G[GdipSaveImageToFile]
    G --> H[GdipDisposeImage]
    H --> I[GdiplusShutdown]
    I --> J[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| GDI+起動失敗 | GDI+初期化エラー | "Could not start GDI+" | GDI+ライブラリの確認 |
| HBITMAP変換失敗 | 無効なビットマップ | "Could not convert HBITMAP to GDI+ image" | 元画像の有効性確認 |
| ファイル保存失敗 | パス無効/権限不足 | "Could not save image to file" | 出力パスの確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1画像/呼び出し |
| 目標出力時間 | 1920x1080サイズで1秒以内 |
| 同時出力数上限 | シングルスレッド処理 |

## セキュリティ考慮事項

- ファイルパスインジェクションの防止：ユーザー入力パスの検証推奨
- GIF形式は256色制限があるため、フルカラー画像は劣化する
- 機密画像の場合は保存先のアクセス制御確認

## 備考

- GDI+ (gdiplus.dll) への依存あり
- Mac環境では動作不可（Windows専用API使用）
- 64ビット/32ビット両対応
- 256色を超える画像は自動的にディザリング/減色される
- アニメーションGIF出力は非対応（単一フレームのみ）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、stdImageクラスの内部データ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdImage.cls | `src/stdImage.cls` | 396-408行目: TThis型定義でhBitmap、HBITMAPTYPE構造を確認 |

**読解のコツ**: GIF出力はPNG同様にGDI+のエンコーダを使用するが、追加パラメータなしで出力される。

#### Step 2: エントリーポイントを理解する

処理の起点となるToFileメソッドを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdImage.cls | `src/stdImage.cls` | 1050-1051行目: GIF出力のCase文 |

**主要処理フロー**:
1. **1015行目**: 拡張子判定 - .gifでstdImgFormatGIF設定
2. **1050-1051行目**: GIF固有処理
3. **1051行目**: GIFエンコーダGUID設定

#### Step 3: GDI+ API連携を理解する

GIF出力に使用するGDI+ APIの連携部分を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdImage.cls | `src/stdImage.cls` | 1076-1077行目: パラメータなしでGdipSaveImageToFile呼び出し |

**主要処理フロー**:
- **1076行目**: tParams.count = 0の場合
- **1077行目**: GdipSaveImageToFile(gdipBitmap, StrPtr(FileName), EncoderGUID, ByVal 0)

### プログラム呼び出し階層図

```
stdImage.ToFile(FileName, format=stdImgFormatGIF)
    │
    ├─ フォーマット判定 (1015行目)
    │      └─ 拡張子.gifでstdImgFormatGIF設定
    │
    ├─ GdiplusStartup (1028行目)
    │      └─ GDI+ライブラリ初期化
    │
    ├─ GdipCreateBitmapFromHBITMAP (1031行目)
    │      └─ HBITMAP→GDI+Bitmap変換
    │
    ├─ Case stdImgFormatGIF (1050行目)
    │      └─ IIDFromString (1051行目)
    │             └─ GIFエンコーダGUID取得
    │
    ├─ GdipSaveImageToFile (1077行目)
    │      └─ ファイル書き込み実行（パラメータなし）
    │
    ├─ GdipDisposeImage (1083行目)
    │      └─ GDI+画像リソース解放
    │
    └─ GdiplusShutdown (1087行目)
           └─ GDI+ライブラリ終了
```

### データフロー図

```
[入力]               [処理]                    [出力]

hBitmap         GdipCreateBitmapFromHBITMAP    GDI+ Bitmap
(メモリ内)  ────────────▶  ────────────────────▶
                                                   │
                                                   ▼
                        GdipSaveImageToFile
                   ─────────────────────────▶  GIF File
                        (GIFエンコーダ)         (ディスク)
                        [256色減色]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdImage.cls | `src/stdImage.cls` | ソース | 画像処理メインクラス |
| gdiplus.dll | Windows System | システムDLL | GDI+ライブラリ |
