# 帳票設計書 5-TIFF画像ファイル

## 概要

本ドキュメントは、stdImageクラスのToFile()メソッドを使用したTIFF形式での画像出力機能について記述した帳票設計書である。

### 本帳票の処理概要

stdImage.ToFile()メソッドによりTIFF形式で画像ファイルを出力する機能を提供する。この機能により、VBAアプリケーション内で処理された画像データを、高品質なTIFF形式ファイルとして保存できる。色深度と圧縮方式のカスタマイズが可能。

**業務上の目的・背景**：VBAアプリケーションで画面キャプチャ、クリップボード画像、Excel図形などから取得した画像データを、印刷業界標準のTIFF形式で保存する必要がある。TIFF形式は高品質な画像保存に適しており、複数の圧縮オプションと色深度設定をサポートする。

**帳票の利用シーン**：
- 印刷用高品質画像の保存
- アーカイブ用画像の作成
- スキャン画像の保存
- ドキュメントイメージングシステムとの連携
- 複数圧縮方式から選択が必要な場合

**主要な出力内容**：
1. TIFF形式の画像データ（GDI+エンコーディング使用）
2. 色深度設定可能（デフォルト24ビット）
3. 圧縮方式設定可能（デフォルト6=JPEG圧縮）

**帳票の出力タイミング**：stdImageオブジェクト生成後、ToFile()メソッドを.tiffファイルパスで呼び出した時点で出力される。

**帳票の利用者**：VBA開発者、Excel/Word/Accessアプリケーションのエンドユーザー、印刷・DTP担当者

## 帳票種別

画像ファイル出力

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | VBAモジュール | - | stdImage.ToFile("path.tiff", TIFF_ColorDepth:=24, TIFF_Compression:=6)メソッド呼び出し |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | TIFF (Tagged Image File Format) |
| 用紙サイズ | N/A（画像サイズは元画像に依存） |
| 向き | N/A |
| ファイル名 | 任意（拡張子.tiffで自動判定） |
| 出力方法 | ファイルシステムへの直接書き込み |
| 文字コード | N/A（バイナリファイル） |

### 画像固有設定

| 項目 | 内容 |
|-----|------|
| エンコーダGUID | {557CF405-1A04-11D3-9A73-0000F81EF32E} |
| 圧縮パラメータGUID | {E09D739D-CCD4-44EE-8EBA-3FBF8BE4FC58} |
| 色深度パラメータGUID | {66087055-AD66-4C7C-9A18-38A2310B8337} |
| デフォルト色深度 | 24ビット |
| デフォルト圧縮 | 6（JPEG圧縮） |

### TIFF圧縮方式一覧

| 値 | 圧縮方式 | 説明 |
|---|---------|------|
| 1 | None | 非圧縮 |
| 2 | CCITT3 | FAX Group 3 |
| 3 | CCITT4 | FAX Group 4 |
| 4 | LZW | LZW圧縮 |
| 5 | RLE | Run Length Encoding |
| 6 | JPEG | JPEG圧縮（デフォルト） |

## 帳票レイアウト

### レイアウト概要

TIFF画像ファイルはタグベースの柔軟なフォーマットを持つ。

```
┌─────────────────────────────────────┐
│         TIFF Header                 │
│         "II" or "MM" + Version      │
├─────────────────────────────────────┤
│         Image File Directory (IFD)  │
│         タグ情報（サイズ、圧縮等）  │
├─────────────────────────────────────┤
│         Image Data                  │
│   [圧縮方式に応じたデータ]          │
└─────────────────────────────────────┘
```

### パラメータ設定

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | TIFF_ColorDepth | 色深度 | ToFileメソッド引数 | Long (デフォルト24) |
| 2 | TIFF_Compression | 圧縮方式 | ToFileメソッド引数 | Long (デフォルト6) |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 有効なstdImageオブジェクト | hBitmapが設定済みであること | Yes |
| 出力パス | 書き込み可能なファイルパス | Yes |
| フォーマット指定 | 拡張子.tiffまたはstdImgFormatTIFF | Yes |
| 色深度 | 色深度（デフォルト24） | No |
| 圧縮方式 | 圧縮方式（デフォルト6） | No |

### ソート順

N/A（単一画像出力）

### 改ページ条件

N/A

## データベース参照仕様

### 参照テーブル一覧

N/A（データベース非依存）

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| 非圧縮サイズ | bmWidth * bmHeight * (ColorDepth / 8) | N/A | 圧縮前の概算 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[ToFile呼び出し] --> B{フォーマット判定}
    B -->|拡張子.tiff| C[stdImgFormatTIFF設定]
    B -->|明示指定| C
    C --> D[GdiplusStartup]
    D --> E[GdipCreateBitmapFromHBITMAP]
    E --> F[エンコーダGUID設定]
    F --> G[圧縮パラメータ設定]
    G --> H[色深度パラメータ設定]
    H --> I[EncoderParameters構造体構築]
    I --> J[GdipSaveImageToFile]
    J --> K[GdipDisposeImage]
    K --> L[GdiplusShutdown]
    L --> M[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| GDI+起動失敗 | GDI+初期化エラー | "Could not start GDI+" | GDI+ライブラリの確認 |
| HBITMAP変換失敗 | 無効なビットマップ | "Could not convert HBITMAP to GDI+ image" | 元画像の有効性確認 |
| ファイル保存失敗 | パス無効/権限不足 | "Could not save image to file" | 出力パスの確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1画像/呼び出し |
| 目標出力時間 | 1920x1080サイズで2秒以内 |
| 同時出力数上限 | シングルスレッド処理 |

## セキュリティ考慮事項

- ファイルパスインジェクションの防止：ユーザー入力パスの検証推奨
- TIFFファイルはサイズが大きくなる可能性（特に非圧縮時）
- 機密画像の場合は保存先のアクセス制御確認

## 備考

- GDI+ (gdiplus.dll) への依存あり
- Mac環境では動作不可（Windows専用API使用）
- 64ビット/32ビット両対応
- マルチページTIFF出力は非対応（単一ページのみ）
- 2つのパラメータ（圧縮・色深度）を同時に設定可能

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、エンコーダパラメータの構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdImage.cls | `src/stdImage.cls` | 354-359行目: EncoderParameter構造体定義 |
| 1-2 | stdImage.cls | `src/stdImage.cls` | 361-364行目: EncoderParameters構造体定義 |

**読解のコツ**: TIFFは複数のエンコーダパラメータ（圧縮・色深度）を使用するため、Parameter配列が2要素になる。

#### Step 2: エントリーポイントを理解する

処理の起点となるToFileメソッドを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdImage.cls | `src/stdImage.cls` | 1053-1068行目: TIFF出力の処理ブロック |

**主要処理フロー**:
1. **1017行目**: 拡張子判定 - .tiffでstdImgFormatTIFF設定
2. **1053-1068行目**: TIFF固有処理
3. **1054行目**: TIFFエンコーダGUID設定
4. **1055-1068行目**: 圧縮・色深度パラメータ設定

#### Step 3: 複数パラメータ設定を理解する

TIFF固有の複数パラメータ設定方法を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdImage.cls | `src/stdImage.cls` | 1055-1068行目: tParams設定（2パラメータ） |

**主要処理フロー**:
- **1055行目**: tParams.count = 2（パラメータ数）
- **1056行目**: ReDim tParams.Parameter(1 To 2)
- **1057-1062行目**: 圧縮パラメータ設定
- **1063-1068行目**: 色深度パラメータ設定

### プログラム呼び出し階層図

```
stdImage.ToFile(FileName, format, TIFF_ColorDepth:=24, TIFF_Compression:=6)
    │
    ├─ フォーマット判定 (1017行目)
    │      └─ 拡張子.tiffでstdImgFormatTIFF設定
    │
    ├─ GdiplusStartup (1028行目)
    │      └─ GDI+ライブラリ初期化
    │
    ├─ GdipCreateBitmapFromHBITMAP (1031行目)
    │      └─ HBITMAP→GDI+Bitmap変換
    │
    ├─ Case stdImgFormatTIFF (1053行目)
    │      │
    │      ├─ IIDFromString (1054行目)
    │      │      └─ TIFFエンコーダGUID取得
    │      │
    │      └─ EncoderParameters設定 (1055-1068行目)
    │             ├─ count = 2
    │             ├─ Parameter(1): 圧縮GUID + Compression値
    │             └─ Parameter(2): 色深度GUID + ColorDepth値
    │
    ├─ GdipSaveImageToFile (1079行目)
    │      └─ ファイル書き込み実行（パラメータ付き）
    │
    ├─ GdipDisposeImage (1083行目)
    │      └─ GDI+画像リソース解放
    │
    └─ GdiplusShutdown (1087行目)
           └─ GDI+ライブラリ終了
```

### データフロー図

```
[入力]               [処理]                    [出力]

hBitmap         GdipCreateBitmapFromHBITMAP    GDI+ Bitmap
(メモリ内)  ────────────▶  ────────────────────▶
                                                   │
TIFF_Compression(6)                                │
TIFF_ColorDepth(24)                                ▼
     │
     └──────▶  EncoderParameters設定  ──────▶
                (2パラメータ)
                        │
                        ▼
                GdipSaveImageToFile
           ─────────────────────────▶  TIFF File
                (TIFFエンコーダ)          (ディスク)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdImage.cls | `src/stdImage.cls` | ソース | 画像処理メインクラス |
| gdiplus.dll | Windows System | システムDLL | GDI+ライブラリ |
