# 帳票設計書 6-一時画像ファイル

## 概要

本ドキュメントは、stdImageクラスのToTempFile()メソッドを使用した一時ファイルへの画像出力機能について記述した帳票設計書である。

### 本帳票の処理概要

stdImage.ToTempFile()メソッドにより、システムの一時ディレクトリに一意のファイル名で画像を保存する機能を提供する。この機能により、VBAアプリケーション内で処理された画像データを一時的にファイルとして保存し、そのパスを取得できる。

**業務上の目的・背景**：VBAアプリケーションで画像を一時的にファイルとして保存し、他のアプリケーションやコントロールに渡す必要がある場面で使用する。例えば、図形への画像埋め込み、ワークシートへの画像追加など、ファイルパスを要求するAPIとの連携に有用。

**帳票の利用シーン**：
- ToSheet()メソッドでの内部使用
- ToShapeFill()メソッドでの内部使用
- ToBinary()メソッドでの内部使用
- 外部アプリケーションとの一時的なデータ交換
- 画像処理の中間結果の一時保存

**主要な出力内容**：
1. 一時ディレクトリへの画像ファイル出力
2. GUIDベースの一意なファイル名生成
3. 指定フォーマットでの保存

**帳票の出力タイミング**：stdImageオブジェクト生成後、ToTempFile()メソッド呼び出し時に出力される。

**帳票の利用者**：VBA開発者（内部API経由での間接利用が主）

## 帳票種別

一時画像ファイル出力

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | VBAモジュール | - | stdImage.ToTempFile()メソッド呼び出し |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | 指定フォーマット（デフォルト:PNG） |
| 出力先 | %TEMP%ディレクトリ |
| ファイル名 | {GUID}.{拡張子} |
| 出力方法 | ToFile()メソッドの内部呼び出し |
| 戻り値 | 出力されたファイルのフルパス |

### ファイル名生成

| 項目 | 内容 |
|-----|------|
| 形式 | xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx |
| バージョン | UUID v4（ランダム） |
| 一意性 | Randomize使用で乱数シード初期化 |

## 帳票レイアウト

### レイアウト概要

一時ファイルは指定されたフォーマットに従い、ToFile()と同等の内容で出力される。

```
┌─────────────────────────────────────┐
│       %TEMP% ディレクトリ           │
├─────────────────────────────────────┤
│  {GUID}.bmp / {GUID}.png / etc.     │
│  [ToFile()と同等の画像データ]       │
└─────────────────────────────────────┘
```

### パラメータ設定

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | eFormat | 出力フォーマット | ToTempFile引数 | stdImgFormat |
| 2 | TempPath | 一時ディレクトリ | Environ("Temp") | String |
| 3 | GUID | 一意識別子 | getGUID()関数 | String |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 有効なstdImageオブジェクト | hBitmapが設定済みであること | Yes |
| フォーマット指定 | stdImgFormat値（デフォルトDefault） | No |

### ソート順

N/A（単一画像出力）

### 改ページ条件

N/A

## データベース参照仕様

### 参照テーブル一覧

N/A（データベース非依存）

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| ファイルパス | Environ("Temp") & "\" & getGUID() & "." & sExt | N/A | 文字列連結 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[ToTempFile呼び出し] --> B{フォーマット判定}
    B --> C[拡張子決定]
    C --> D[getGUID呼び出し]
    D --> E[ファイルパス生成]
    E --> F[ToFile呼び出し]
    F --> G[パス文字列返却]
    G --> H[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ToFileエラー | ToFile内部でのエラー | ToFileのエラーメッセージ | 元画像の有効性確認 |
| 一時ディレクトリアクセス不可 | Tempへの書き込み権限なし | VBAランタイムエラー | 権限確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1画像/呼び出し |
| 目標出力時間 | ToFile()と同等 |
| 同時出力数上限 | シングルスレッド処理 |

## セキュリティ考慮事項

- 一時ファイルは使用後に削除されない（呼び出し元の責任）
- Tempディレクトリは他プロセスからアクセス可能
- 機密画像の一時保存は推奨されない

## 備考

- ToSheet()、ToShapeFill()、ToBinary()から内部的に呼び出される
- 呼び出し元が一時ファイルの削除責任を持つ
- GUIDベースのファイル名で衝突を回避
- フォーマットに応じた拡張子が自動付与される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: メインメソッドを理解する

ToTempFileメソッドの実装を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdImage.cls | `src/stdImage.cls` | 1115-1127行目: ToTempFile()メソッド |

**読解のコツ**: ToTempFileは内部でToFileを呼び出すラッパーメソッドである。

#### Step 2: GUID生成を理解する

ファイル名生成に使用されるGUID関数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdImage.cls | `src/stdImage.cls` | 1278-1285行目: getGUID()関数 |

**主要処理フロー**:
1. **1279行目**: Randomize呼び出し（乱数シード初期化）
2. **1280行目**: GUID形式文字列テンプレート
3. **1281行目**: "y"部分をランダム値で置換
4. **1282-1284行目**: "x"部分を順次ランダム値で置換

#### Step 3: 利用箇所を理解する

ToTempFileを内部的に呼び出すメソッドを把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdImage.cls | `src/stdImage.cls` | 995-1003行目: ToBinary()での使用 |
| 3-2 | stdImage.cls | `src/stdImage.cls` | 1135-1137行目: ToSheet()での使用 |
| 3-3 | stdImage.cls | `src/stdImage.cls` | 1161-1167行目: ToShapeFill()での使用 |

### プログラム呼び出し階層図

```
ToTempFile(eFormat)
    │
    ├─ フォーマット判定 (1117-1123行目)
    │      └─ フォーマットから拡張子決定
    │
    ├─ Environ("Temp") (1124行目)
    │      └─ 一時ディレクトリパス取得
    │
    ├─ getGUID() (1124行目)
    │      │
    │      ├─ Randomize (1279行目)
    │      ├─ GUIDテンプレート生成 (1280行目)
    │      └─ ランダム値で置換 (1281-1284行目)
    │
    ├─ ToFile(sPath, eFormat) (1125行目)
    │      └─ 実際のファイル出力
    │
    └─ パス文字列返却 (1126行目)

呼び出し元:
    ├─ ToBinary() ──────▶ ToTempFile()
    ├─ ToSheet() ───────▶ ToTempFile()
    └─ ToShapeFill() ───▶ ToTempFile()
```

### データフロー図

```
[入力]               [処理]                    [出力]

eFormat         フォーマット→拡張子変換        sExt
     │                  │
     ▼                  ▼
                Environ("Temp") + getGUID()
                        │
                        ▼
                   ファイルパス生成
                        │
                        ▼
hBitmap ────▶    ToFile(sPath)  ────▶   一時ファイル
                        │                 (%TEMP%/{GUID}.ext)
                        ▼
                   パス文字列
                  (戻り値として)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdImage.cls | `src/stdImage.cls` | ソース | 画像処理メインクラス |
