# 帳票設計書 7-JSON文字列

## 概要

本ドキュメントは、stdJSONクラスのToString()メソッドを使用したJSON形式文字列出力機能について記述した帳票設計書である。

### 本帳票の処理概要

stdJSON.ToString()メソッドにより、JSONオブジェクト（配列またはオブジェクト）をJSON形式の文字列に変換する機能を提供する。この機能により、VBAアプリケーション内で構築したJSONデータを、文字列として出力・保存・送信できる。

**業務上の目的・背景**：VBAアプリケーションでWeb API連携、設定ファイル出力、データ交換などのためにJSON形式のデータを生成する必要がある。JSONは軽量なデータ交換フォーマットとして広く使用されており、RESTful APIとの連携に不可欠である。

**帳票の利用シーン**：
- Web API呼び出し時のリクエストボディ生成
- 設定ファイルのJSON形式出力
- データのシリアライズ
- ログ出力のJSON形式化
- アプリケーション間のデータ交換

**主要な出力内容**：
1. JSON形式の文字列（Object: {}、Array: []）
2. Pretty Print対応（インデント付きフォーマット）
3. 入れ子構造のサポート

**帳票の出力タイミング**：stdJSONオブジェクト構築後、ToString()メソッド呼び出し時に文字列として出力される。

**帳票の利用者**：VBA開発者

## 帳票種別

データ文字列出力

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | VBAモジュール | - | stdJSON.ToString()メソッド呼び出し |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | JSON文字列 |
| 文字コード | VBA内部文字列（UTF-16LE） |
| Pretty Print | 対応（pretty引数=True） |
| インデント | 設定可能（prettyIndent引数、デフォルト2） |

### JSON型

| 型 | VBAでの表現 | JSON出力 |
|---|------------|---------|
| Object | eJSONObject | {"key": value, ...} |
| Array | eJSONArray | [value1, value2, ...] |
| String | vbString | "value" |
| Number | vbInteger/vbDouble | 123, 3.14 |
| Boolean | vbBoolean | true, false |
| Null | vbNull/vbEmpty | null |
| Date | vbDate | "dd/mm/yyyy" |

## 帳票レイアウト

### レイアウト概要

JSON文字列は標準JSON仕様に準拠した形式で出力される。

**コンパクト形式（pretty=False）**：
```json
{"key1":"value1","key2":123,"array":[1,2,3]}
```

**Pretty形式（pretty=True）**：
```json
{
  "key1": "value1",
  "key2": 123,
  "array": [
    1,
    2,
    3
  ]
}
```

### 出力項目

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | RootOpen | 開始ブラケット | iType | { または [ |
| 2 | Content | 内容 | children | キー:値 または 値 |
| 3 | RootClose | 終了ブラケット | iType | } または ] |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 有効なstdJSONオブジェクト | 初期化済みであること | Yes |
| Pretty Print | インデント付き出力（デフォルトFalse） | No |
| prettyIndent | インデント幅（デフォルト2） | No |

### ソート順

オブジェクト: 追加順（Dictionary順序）
配列: インデックス順

### 改ページ条件

N/A（文字列出力）

## データベース参照仕様

### 参照テーブル一覧

N/A（データベース非依存）

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| インデント | String$(depth * prettyIndent, " ") | N/A | 深さに応じた空白 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[ToString呼び出し] --> B{iType判定}
    B -->|eJSONObject| C[開始 "{"]
    B -->|eJSONArray| D[開始 "["]
    C --> E[children.keysをループ]
    D --> F[childrenをループ]
    E --> G{子がstdJSON?}
    F --> G
    G -->|Yes| H[再帰的にToString]
    G -->|No| I[simpleStringify]
    H --> J[文字列連結]
    I --> J
    J --> K{最後の要素?}
    K -->|No| L[カンマ追加]
    K -->|Yes| M[終了ブラケット]
    L --> E
    L --> F
    M --> N[文字列返却]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 循環参照 | 自己参照構造 | スタックオーバーフロー | 構造の確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 可変 |
| 目標出力時間 | 1000要素で1秒以内 |
| StringBuffer使用 | メモリ効率最適化 |

## セキュリティ考慮事項

- エスケープ処理：ダブルクォート、バックスラッシュ、制御文字を適切にエスケープ
- 大量データの場合メモリ使用量に注意
- 機密データを含む場合は出力先の管理に注意

## 備考

- StringBuffer内部実装で文字列連結を最適化
- 入れ子構造は再帰的に処理
- ToFile()メソッドでファイル出力も可能

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、stdJSONクラスの内部データ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdJSON.cls | `src/stdJSON.cls` | 67-70行目: EStdJsonType列挙型 |
| 1-2 | stdJSON.cls | `src/stdJSON.cls` | 76-81行目: TThis型定義 |
| 1-3 | stdJSON.cls | `src/stdJSON.cls` | 83-88行目: StringBuffer型定義 |

**読解のコツ**: EStdJsonTypeでオブジェクト/配列を判別し、childrenにDictionaryまたはCollectionを保持。

#### Step 2: エントリーポイントを理解する

処理の起点となるToStringメソッドを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdJSON.cls | `src/stdJSON.cls` | 415-473行目: ToString()メソッド |

**主要処理フロー**:
1. **417-421行目**: Pretty Print用インデント設定
2. **423行目**: StringBuffer初期化
3. **424-429行目**: 開始ブラケット追加
4. **433-447行目**: オブジェクト型の処理
5. **448-462行目**: 配列型の処理
6. **465-470行目**: 終了ブラケット追加
7. **472行目**: StringBuffer→文字列変換

#### Step 3: 値のシリアライズを理解する

simpleStringify関数による値変換を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdJSON.cls | `src/stdJSON.cls` | 571-603行目: simpleStringify()関数 |

**主要処理フロー**:
- **573-574行目**: Null/Empty → "null"
- **575-576行目**: Date → "dd/mm/yyyy"
- **577-583行目**: String → エスケープ処理
- **584-585行目**: Boolean → "true"/"false"
- **588-595行目**: Double/Single → 小数点処理

### プログラム呼び出し階層図

```
stdJSON.ToString(pretty, prettyIndent, depth)
    │
    ├─ StringBuffer_Create (423行目)
    │      └─ 初期サイズ64で作成
    │
    ├─ StringBuffer_Append (426,428行目)
    │      └─ 開始ブラケット追加
    │
    ├─ iType分岐
    │      │
    │      ├─ eJSONObject (433-447行目)
    │      │      │
    │      │      ├─ children.items/keys取得
    │      │      │
    │      │      └─ ループ処理
    │      │             │
    │      │             ├─ stdJSON型の場合
    │      │             │      └─ ToString(再帰呼び出し)
    │      │             │
    │      │             └─ 他の型
    │      │                    └─ simpleStringify()
    │      │
    │      └─ eJSONArray (448-462行目)
    │             │
    │             └─ ループ処理（同様）
    │
    ├─ StringBuffer_Append (467,469行目)
    │      └─ 終了ブラケット追加
    │
    └─ StringBuffer_ToString (472行目)
           └─ 文字列返却
```

### データフロー図

```
[入力]               [処理]                    [出力]

stdJSON         ToString()呼び出し           JSON文字列
Object/Array ─────────▶
    │                                           │
    ├─ iType          ──▶  開始ブラケット  ──▶ "{" or "["
    │
    ├─ children       ──▶  キー/値処理
    │   │
    │   ├─ stdJSON子要素 ──▶ 再帰ToString()
    │   │
    │   └─ プリミティブ   ──▶ simpleStringify()
    │                              │
    │                              ├─ vbString → "値"
    │                              ├─ vbBoolean → true/false
    │                              ├─ vbNull → null
    │                              └─ vbDouble → 数値
    │
    └─ iType          ──▶  終了ブラケット  ──▶ "}" or "]"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdJSON.cls | `src/stdJSON.cls` | ソース | JSONクラスメイン |
