# 帳票設計書 8-HTML文字列

## 概要

本ドキュメントは、stdHTMLクラス（WIP: Work In Progress）のToString()メソッドを使用したHTML形式文字列出力機能について記述した帳票設計書である。

### 本帳票の処理概要

stdHTML.ToString()メソッドにより、HTMLドキュメント構造をHTML形式の文字列に変換する機能を提供する。この機能により、VBAアプリケーション内で構築したHTMLデータを、文字列として出力・保存・表示できる。

**業務上の目的・背景**：VBAアプリケーションでHTMLメール生成、レポートのHTML出力、Webコンテンツ生成などのためにHTML形式のデータを生成する必要がある。HTMLは文書構造を表現する標準マークアップ言語として広く使用されている。

**帳票の利用シーン**：
- HTMLメールの本文生成
- レポートのHTML形式出力
- Webコンテンツの動的生成
- データのHTML表形式変換
- ドキュメントテンプレートの生成

**主要な出力内容**：
1. HTML形式の文字列（タグベース構造）
2. 階層的インデント対応
3. 属性のシリアライズ

**帳票の出力タイミング**：stdHTMLオブジェクト構築後、ToString()メソッド呼び出し時に文字列として出力される。

**帳票の利用者**：VBA開発者

**注意**: このクラスはWIP（開発中）であり、機能が完全でない可能性がある。

## 帳票種別

マークアップ文字列出力

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | VBAモジュール | - | stdHTML.ToString()メソッド呼び出し |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | HTML文字列 |
| 文字コード | VBA内部文字列（UTF-16LE） |
| インデント | 2スペース（ネスト毎） |

### 要素型

| 型 | 内部表現 | HTML出力 |
|---|---------|---------|
| Element | EElement | `<tagName attr="value">...children...</tagName>` |
| Literal | ELiteral | 文字列そのまま |
| SelfClosing | isSelfClosing=True | `<tagName attr="value" />` |

## 帳票レイアウト

### レイアウト概要

HTML文字列は標準HTML仕様に準拠した形式で出力される。

**基本形式**：
```html
<html>
  <head>
    <title>Sample</title>
  </head>
  <body>
    <div id="container">
      Content here
    </div>
  </body>
</html>
```

### 出力項目

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | OpenTag | 開始タグ | TagName, Attributes | `<tagName attr>` |
| 2 | Children | 子要素 | Element.Children | 再帰出力 |
| 3 | CloseTag | 終了タグ | TagName | `</tagName>` |
| 4 | Literal | リテラル文字列 | Literal.content | 文字列そのまま |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 有効なstdHTMLオブジェクト | 初期化済みであること | Yes |
| インデント | 出力時のインデント文字列（デフォルト""） | No |

### ソート順

子要素: 追加順

### 改ページ条件

N/A（文字列出力）

## データベース参照仕様

### 参照テーブル一覧

N/A（データベース非依存）

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| インデント | indent & "  " | N/A | 深さに応じた空白 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[ToString呼び出し] --> B{ElementType判定}
    B -->|EElement| C[開始タグ生成]
    B -->|ELiteral| D[リテラル文字列返却]
    C --> E[属性シリアライズ]
    E --> F{自己終了タグ?}
    F -->|Yes| G[" />" で終了]
    F -->|No| H[">" で開始タグ終了]
    H --> I[子要素をループ]
    I --> J[child.ToString再帰]
    J --> K[終了タグ追加]
    K --> L[文字列返却]
    G --> L
    D --> L
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 無効な要素型 | ElementType不正 | "Invalid element type." | 正しい初期化を確認 |
| 非要素コンテキスト | Literal/未初期化に子追加 | "Cannot add child to a non-element context." | 構造確認 |
| 未サポート属性型 | 属性型不正 | "Unsupported attribute type" | 対応型を使用 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 可変 |
| 目標出力時間 | 1000要素で1秒以内 |

## セキュリティ考慮事項

- XSS対策：ユーザー入力を含む場合は適切なエスケープ処理が必要
- 大量データの場合メモリ使用量に注意
- 機密データを含む場合は出力先の管理に注意

## 備考

- WIP（Work In Progress）クラスであり、機能が完全でない可能性がある
- `src/WIP/stdHTML.cls` に配置
- 入れ子構造は再帰的に処理
- 属性は配列形式で管理（key, value, key, value, ...）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、stdHTMLクラスの内部データ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdHTML.cls | `src/WIP/stdHTML.cls` | 12-16行目: EElementType列挙型 |
| 1-2 | stdHTML.cls | `src/WIP/stdHTML.cls` | 17-22行目: TElement型定義 |
| 1-3 | stdHTML.cls | `src/WIP/stdHTML.cls` | 23-25行目: TLiteral型定義 |
| 1-4 | stdHTML.cls | `src/WIP/stdHTML.cls` | 27-32行目: TThis型定義 |

**読解のコツ**: EElementTypeでElement/Literal/Noneを判別し、それぞれTElementまたはTLiteralでデータを保持。

#### Step 2: エントリーポイントを理解する

処理の起点となるToStringメソッドを特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdHTML.cls | `src/WIP/stdHTML.cls` | 191-218行目: ToString()メソッド |

**主要処理フロー**:
1. **192-217行目**: ElementType分岐
2. **193-214行目**: EElement型の処理
3. **194-199行目**: 開始タグと属性の構築
4. **201-212行目**: 子要素の処理と終了タグ
5. **215-216行目**: ELiteral型の処理

#### Step 3: 属性シリアライズを理解する

serializeAttribute関数による属性値変換を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdHTML.cls | `src/WIP/stdHTML.cls` | 223-244行目: serializeAttribute()関数 |

**主要処理フロー**:
- **225-226行目**: Null → ""（空文字）
- **227-228行目**: String → `='value'`
- **229-230行目**: Boolean → `=true/false`
- **231-238行目**: 数値型 → 直接文字列化

### プログラム呼び出し階層図

```
stdHTML.ToString(indent)
    │
    ├─ ElementType分岐 (192行目)
    │      │
    │      ├─ EElement (193-214行目)
    │      │      │
    │      │      ├─ 開始タグ生成 (194行目)
    │      │      │      └─ "<" & TagName
    │      │      │
    │      │      ├─ 属性ループ (196-199行目)
    │      │      │      └─ serializeAttribute()
    │      │      │             │
    │      │      │             ├─ vbNull → ""
    │      │      │             ├─ vbString → "='value'"
    │      │      │             ├─ vbBoolean → "=true/false"
    │      │      │             └─ 数値 → "=数値"
    │      │      │
    │      │      ├─ 自己終了判定 (201-212行目)
    │      │      │      │
    │      │      │      ├─ isSelfClosing=True
    │      │      │      │      └─ " />" で終了
    │      │      │      │
    │      │      │      └─ isSelfClosing=False
    │      │      │             ├─ ">" で開始タグ終了
    │      │      │             ├─ 子要素ループ
    │      │      │             │      └─ child.ToString(再帰)
    │      │      │             └─ 終了タグ追加
    │      │      │
    │      │      └─ 文字列返却 (214行目)
    │      │
    │      └─ ELiteral (215-216行目)
    │             └─ content返却
    │
    └─ 終了
```

### データフロー図

```
[入力]               [処理]                    [出力]

stdHTML         ToString()呼び出し           HTML文字列
Element/Literal ─────────▶
    │                                           │
    ├─ TagName       ──▶  開始タグ       ──▶ "<tagName"
    │
    ├─ Attributes    ──▶  属性処理
    │   │
    │   └─ key/value ──▶ serializeAttribute()
    │                          │
    │                          ├─ vbString → "='値'"
    │                          ├─ vbBoolean → "=true"
    │                          └─ vbNull → ""
    │
    ├─ isSelfClosing ──▶  終了処理      ──▶ " />" or ">"
    │
    ├─ Children      ──▶  子要素処理
    │   │
    │   └─ child     ──▶  再帰ToString()
    │
    └─ TagName       ──▶  終了タグ       ──▶ "</tagName>"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdHTML.cls | `src/WIP/stdHTML.cls` | ソース | HTMLクラスメイン（WIP） |
