# 帳票設計書 9-XML文字列

## 概要

本ドキュメントは、stdXMLクラス（WIP: Work In Progress）のToString()メソッドを使用したXML形式文字列出力機能について記述した帳票設計書である。

### 本帳票の処理概要

stdXML.ToString()メソッドにより、XMLドキュメント構造をXML形式の文字列に変換する機能を提供する（インターフェース定義のみ）。この機能により、VBAアプリケーション内で構築したXMLデータを、文字列として出力・保存・送信できる。

**業務上の目的・背景**：VBAアプリケーションでSOAP通信、設定ファイル出力、SharePoint連携などのためにXML形式のデータを生成する必要がある。XMLは構造化データの標準交換フォーマットとして広く使用されており、エンタープライズシステムとの連携に不可欠である。

**帳票の利用シーン**：
- SharePoint Web Service呼び出し
- SOAP APIリクエスト生成
- 設定ファイルのXML形式出力
- データのシリアライズ
- アプリケーション間のデータ交換

**主要な出力内容**：
1. XML形式の文字列（タグベース構造）
2. 属性のシリアライズ
3. 入れ子構造のサポート

**帳票の出力タイミング**：stdXMLオブジェクト構築後、ToString()メソッド呼び出し時に文字列として出力される。

**帳票の利用者**：VBA開発者

**注意**: このクラスはWIP（開発中）であり、インターフェース定義のみで実装が完了していない。

## 帳票種別

マークアップ文字列出力

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | VBAモジュール | - | stdXML.ToString()メソッド呼び出し |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | XML文字列 |
| 文字コード | VBA内部文字列（UTF-16LE） |
| 想定出力形式 | 標準XML 1.0 |

### 想定要素型（コメントより推定）

| 型 | 使用例 | XML出力 |
|---|--------|---------|
| Element | Create("tagName") | `<tagName>...</tagName>` |
| TextNode | CreateTextNode("text") | テキストそのまま |
| SelfClosing | 属性のみ | `<tagName attr="value"/>` |

## 帳票レイアウト

### レイアウト概要（コメントより）

XML文字列は標準XML仕様に準拠した形式で出力される。

**基本形式（ドキュメントコメントより）**：
```xml
<Query>
  <Where>
    <Eq>
      <FieldRef Name="LinkFilename"/>
      <Value Type="Text">test.txt</Value>
    </Eq>
  </Where>
</Query>
```

**JSONの埋め込み例（ドキュメントコメントより）**：
```xml
<Data>
  <JSON>
    {
      "A":1,
      "B":[1,2,3]
    }
  </JSON>
</Data>
```

### 出力項目（想定）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | OpenTag | 開始タグ | Create()引数 | `<tagName attr>` |
| 2 | Children | 子要素 | pushChild() | 再帰出力 |
| 3 | Value | 値 | setValue() | テキスト |
| 4 | CloseTag | 終了タグ | Create()引数 | `</tagName>` |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 有効なstdXMLオブジェクト | 初期化済みであること | Yes |

### ソート順

子要素: 追加順（pushChild順）

### 改ページ条件

N/A（文字列出力）

## データベース参照仕様

### 参照テーブル一覧

N/A（データベース非依存）

## 計算仕様

### 計算項目一覧

N/A（実装未完了）

## 処理フロー

### 出力フロー（想定）

```mermaid
flowchart TD
    A[ToString呼び出し] --> B[開始タグ生成]
    B --> C[属性シリアライズ]
    C --> D{値あり?}
    D -->|Yes| E[値を出力]
    D -->|No| F{子要素あり?}
    E --> F
    F -->|Yes| G[子要素をループ]
    F -->|No| H[終了タグ]
    G --> I[child.ToString再帰]
    I --> G
    G --> H
    H --> J[文字列返却]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 未実装 | メソッド未実装 | N/A | 実装完了を待つ |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 可変 |
| 目標出力時間 | 未定義 |

## セキュリティ考慮事項

- XXE攻撃対策：外部エンティティ参照の制限が必要
- 大量データの場合メモリ使用量に注意
- 機密データを含む場合は出力先の管理に注意

## 備考

- WIP（Work In Progress）クラスであり、インターフェースのみ定義
- `src/WIP/stdXML.cls` に配置
- 実際の実装は未完了
- SharePoint CAML構文の生成を主な用途として想定
- ISerialisableインターフェースとの連携を想定

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: インターフェース定義を理解する

まず、stdXMLクラスの公開インターフェースを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | stdXML.cls | `src/WIP/stdXML.cls` | 72-74行目: Create()コンストラクタ |
| 1-2 | stdXML.cls | `src/WIP/stdXML.cls` | 75-77行目: CreateTextNode()コンストラクタ |
| 1-3 | stdXML.cls | `src/WIP/stdXML.cls` | 78-80行目: CreateFromString()コンストラクタ |
| 1-4 | stdXML.cls | `src/WIP/stdXML.cls` | 84-86行目: ToString()メソッド |

**読解のコツ**: 関数シグネチャのみ定義されており、実装本体は空。

#### Step 2: ドキュメントコメントから仕様を理解する

ファイル先頭のドキュメントコメントから想定仕様を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | stdXML.cls | `src/WIP/stdXML.cls` | 1-36行目: 使用例コメント |
| 2-2 | stdXML.cls | `src/WIP/stdXML.cls` | 38-71行目: JSON埋め込み例 |

**主要使用パターン（コメントより）**:
1. **1-12行目**: 基本的なXML生成例
2. **14-36行目**: SharePoint Where条件の生成例
3. **38-61行目**: JSON埋め込み例
4. **63-71行目**: カスタムオブジェクト埋め込み例

#### Step 3: 関連インターフェースを理解する

pushChild/pushChildExメソッドのシグネチャを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | stdXML.cls | `src/WIP/stdXML.cls` | 89-91行目: pushChild()メソッド |
| 3-2 | stdXML.cls | `src/WIP/stdXML.cls` | 92-94行目: pushChildEx()メソッド |

**主要処理フロー（想定）**:
- **pushChild**: stdXMLまたはISerialisableを子として追加
- **pushChildEx**: 追加したオブジェクトを返却（チェーン用）

### プログラム呼び出し階層図（想定）

```
stdXML.Create(sTagName)
    │
    └─ stdXML オブジェクト生成

stdXML.pushChild(obj)
    │
    └─ 子要素追加（stdXML or ISerialisable）

stdXML.ToString()
    │
    ├─ 開始タグ生成
    │      └─ "<" & TagName & attributes & ">"
    │
    ├─ 値出力（あれば）
    │
    ├─ 子要素ループ
    │      └─ child.ToString()（再帰）
    │
    └─ 終了タグ生成
           └─ "</" & TagName & ">"

使用例（コメントより）:
    With stdXML.Create("Query")
      With .pushChild(stdXML.Create("Where"))
        With .pushChild(stdXML.Create("Eq"))
          .pushChild(stdXML.Create("FieldRef")).setAttributes("Name","LinkFilename")
          .pushChild(stdXML.Create("Value")).setAttributes("Type","Text").setValue("test.txt")
        End With
      End With
      sXML = .ToString()
    End With
```

### データフロー図（想定）

```
[入力]               [処理]                    [出力]

stdXML          ToString()呼び出し           XML文字列
Create() ──────────▶
    │                                           │
    ├─ TagName      ──▶  開始タグ       ──▶ "<tagName"
    │
    ├─ Attributes   ──▶  属性処理
    │   │
    │   └─ key/value ──▶ attr="value"
    │
    ├─ Value        ──▶  値出力
    │
    ├─ Children     ──▶  子要素処理
    │   │
    │   ├─ stdXML   ──▶  再帰ToString()
    │   │
    │   └─ ISerialisable ──▶ Serialize()
    │
    └─ TagName      ──▶  終了タグ       ──▶ "</tagName>"
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| stdXML.cls | `src/WIP/stdXML.cls` | ソース | XMLクラスメイン（WIP、インターフェースのみ） |
