---
generated_at: 2026-01-15 11:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-テキストデータ（クリップボード出力）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdClipboard.cls` 335-340行目 - textプロパティ
- E-02: `src/stdClipboard.cls` 263-313行目 - value Property Let
- E-03: `src/stdClipboard.cls` 61-90行目 - CLIPFORMAT列挙型
- E-04: `src/stdClipboard.cls` 75行目 - CF_UNICODETEXT = 13
- E-05: `src/stdClipboard.cls` 286行目 - GlobalAlloc呼び出し
- E-06: `src/stdClipboard.cls` 290行目 - GlobalLock呼び出し
- E-07: `src/stdClipboard.cls` 298行目 - lstrcpyW呼び出し
- E-08: `src/stdClipboard.cls` 306行目 - OpenClipboardTimeout呼び出し
- E-09: `src/stdClipboard.cls` 307行目 - EmptyClipboard呼び出し
- E-10: `src/stdClipboard.cls` 308行目 - SetClipboardData呼び出し
- E-11: `src/stdClipboard.cls` 956-971行目 - OpenClipboardTimeout関数
- E-12: `src/stdClipboard.cls` 690-699行目 - CriticalRaise関数
- E-13: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 11行目 - 帳票定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | textプロパティが存在 | E-01 | ○ |
| C-02 | CF_UNICODETEXTフォーマットを使用 | E-01 (336行目), E-04 | ○ |
| C-03 | CF_UNICODETEXT = 13 | E-04 | ○ |
| C-04 | value Property Letで実装 | E-02 | ○ |
| C-05 | サイズ計算: LenB(v) + 2 | E-02 (277-278行目) | ○ |
| C-06 | GlobalAlloc使用 | E-05 | ○ |
| C-07 | GlobalLock使用 | E-06 | ○ |
| C-08 | lstrcpyW使用（Unicode） | E-07 | ○ |
| C-09 | GlobalUnlock使用 | E-02 (303行目) | ○ |
| C-10 | OpenClipboardTimeout使用 | E-08, E-11 | ○ |
| C-11 | EmptyClipboard使用 | E-09 | ○ |
| C-12 | SetClipboardData使用 | E-10 | ○ |
| C-13 | CloseClipboard使用 | E-02 (309行目) | ○ |
| C-14 | タイムアウト5秒 | E-11 (956行目: dwTimeoutMilliseconds = 5000) | ○ |
| C-15 | エラー時CriticalRaise呼び出し | E-02 (287,291,296,306-309行目), E-12 | ○ |
| C-16 | GHND使用（GMEM_MOVEABLE Or GMEM_ZEROINIT） | E-02 (286行目), E-03 (200行目) | ○ |
| C-17 | VBA7/VBA6両対応 | E-02 (264-270行目 条件付きコンパイル) | ○ |
| C-18 | 64ビット/32ビット両対応 | E-03 (93-168行目 条件付きコンパイル) | ○ |
| C-19 | PredeclaredId=True | E-03 (8行目) | ○ |
| C-20 | 帳票一覧に定義がある | E-13 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全主張に根拠があり、コード実装と一致

## 6) レビュアーチェックリスト（最小）
- [ ] CF_UNICODETEXTが正しく設定されることを確認
- [ ] エラーハンドリングが適切か確認
- [ ] タイムアウト処理が正しく動作することを確認
- [ ] 大量テキストでのメモリ使用量を確認
- [ ] 機密データ使用時のセキュリティ考慮事項を確認
