---
generated_at: 2026-01-15 21:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：12-画像データ

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **目標出力時間500ms**：根拠不足（パフォーマンス計測なし）
  2. **Word/PowerPoint対応**：根拠不足（Excel以外の実装が未完成）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdClipboard.cls` 97-102行目 - PICTDESC構造体定義
- E-02: `src/stdClipboard.cls` 204-210行目 - GUID構造体定義
- E-03: `src/stdClipboard.cls` 446-458行目 - Property Get Picture
- E-04: `src/stdClipboard.cls` 459-472行目 - Property Set Picture
- E-05: `src/stdClipboard.cls` 480-486行目 - Property Set XLPicture
- E-06: `src/stdClipboard.cls` 492-498行目 - Property Set XLShapeAsPicture
- E-07: `src/stdClipboard.cls` 807-849行目 - GetPictureFromClipboard関数
- E-08: `src/stdClipboard.cls` 857-891行目 - CreatePicture関数
- E-09: `src/stdClipboard.cls` 61-90行目 - CLIPFORMAT列挙（CF_BITMAP = 2, CF_ENHMETAFILE = 14）
- E-10: `src/stdImage.cls` 295-303行目 - BITMAP構造体定義
- E-11: `src/stdImage.cls` 332-337行目 - PICTDESC構造体定義
- E-12: `src/stdImage.cls` 1093-1109行目 - ToClipboardメソッド
- E-13: `src/stdImage.cls` 1171-1187行目 - ToStdPicture関数
- E-14: `tests/stdClipboardTests.bas` 22-23行目 - Picture取得テスト
- E-15: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 13行目 - 帳票定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CF_BITMAP形式で画像をクリップボードに出力 | E-03, E-09 | ○ |
| C-02 | CF_ENHMETAFILE形式をサポート | E-03, E-09 | ○ |
| C-03 | CF_METAFILEPICT形式をサポート | E-03, E-09 | ○ |
| C-04 | PICTDESC構造体を使用してIPicture生成 | E-01, E-08 | ○ |
| C-05 | GetPictureFromClipboardで画像取得 | E-07 | ○ |
| C-06 | CreatePictureでIPicture変換 | E-08 | ○ |
| C-07 | Property Get Pictureで形式優先度判定 | E-03 (447-452行目) | ○ |
| C-08 | OpenClipboardTimeoutでクリップボード開く | E-07 (822行目) | ○ |
| C-09 | GetClipboardDataでデータハンドル取得 | E-07 (824行目) | ○ |
| C-10 | CopyImage/CopyEnhMetaFileで画像コピー | E-07 (829-831行目) | ○ |
| C-11 | OleCreatePictureIndirectでOLE Picture生成 | E-08 (886行目) | ○ |
| C-12 | IIDFromStringでGUID取得 | E-08 (875行目) | ○ |
| C-13 | Property Set PictureはExcel専用 | E-04 (461行目) | ○ |
| C-14 | 一時ファイル経由でクリップボードにコピー | E-04 (463-470行目) | ○ |
| C-15 | XLPictureでExcel.IPictureをコピー | E-05 | ○ |
| C-16 | XLShapeAsPictureでShapeを画像としてコピー | E-06 | ○ |
| C-17 | クリップボードクリア後にCopyPicture実行 | E-05 (481-482行目), E-06 (493-494行目) | ○ |
| C-18 | 形式が利用可能になるまでDoEventsでループ | E-05 (483-485行目), E-06 (495-497行目) | ○ |
| C-19 | stdImage.ToClipboardでHTMLFile使用 | E-12 (1095行目) | ○ |
| C-20 | clipboardData.SetDataで設定試行 | E-12 (1097行目) | ○ |
| C-21 | OLEObjects.addでフォールバック | E-12 (1101行目) | ○ |
| C-22 | ToStdPictureでIPicture変換 | E-13 | ○ |
| C-23 | BITMAP構造体で画像情報管理 | E-10 | ○ |
| C-24 | テストコードで機能検証済み | E-14 | ○ |
| C-25 | fnOLEErrorでエラーコード変換 | E-08 (889行目), 897-935行目 | ○ |
| C-26 | 5秒タイムアウトでクリップボード開く | E-07 (822行目参照), 956行目 | ○ |
| C-27 | 目標出力時間500ms以下 | **根拠なし** | △ |
| C-28 | Word/PowerPointでも同様に動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（処理時間の実測値）
  - 候補：性能テスト結果 / ベンチマーク
- Excel以外のOfficeアプリケーション対応状況
  - 候補：Word/PowerPoint向けの実装コード / テストケース

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - データ構造の記述（ソースコードで確認可能）
- 0: 低リスク - API呼び出しシーケンス（ソースコードで確認可能）
- 1: 中リスク - Property Set PictureのExcel専用実装（他アプリ非対応）
- 1: 中リスク - ToClipboardのハック的実装（OLEObjects使用）
- 1: 中リスク - パフォーマンス要件（実測値なし）

## 6) レビュアーチェックリスト（最小）
- [ ] CF_BITMAP/CF_ENHMETAFILE/CF_METAFILEPICTの優先度が適切か確認
- [ ] Property Set PictureのExcel以外への拡張可能性を検討
- [ ] ToClipboardのOLEObjects使用によるパフォーマンス影響を評価
- [ ] 一時ファイルの削除が確実に行われることを確認
- [ ] テストケースの網羅性を確認（特にメタファイル形式）
