---
generated_at: 2026-01-15 21:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：15-コントロール画像

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **目標出力時間100ms**：根拠不足（パフォーマンス計測なし）
  2. **対応コントロール一覧の網羅性**：根拠不足（実際のテスト結果なし）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdImage.cls` 332-337行目 - PICTDESC構造体定義
- E-02: `src/stdImage.cls` 347-352行目 - GUID構造体定義
- E-03: `src/stdImage.cls` 400-408行目 - TThis型定義
- E-04: `src/stdImage.cls` 1144-1146行目 - ToUIControlメソッド
- E-05: `src/stdImage.cls` 1171-1187行目 - ToStdPictureメソッド
- E-06: `src/stdImage.cls` 192行目 - OleCreatePictureIndirect宣言
- E-07: `src/stdImage.cls` 194行目 - IIDFromString宣言
- E-08: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 16行目 - 帳票定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ToUIControlでコントロールに画像設定 | E-04 | ○ |
| C-02 | ToStdPictureでstdole.StdPictureに変換 | E-04 (1145行目), E-05 | ○ |
| C-03 | oControl.Pictureに設定 | E-04 (1145行目) | ○ |
| C-04 | IIDFromStringでGUID取得 | E-05 (1175行目), E-07 | ○ |
| C-05 | IID_IDispatch GUID使用 | E-05 (1173行目) | ○ |
| C-06 | PICTDESC構造体設定 | E-05 (1177-1183行目), E-01 | ○ |
| C-07 | size = Len(uPicinfo) | E-05 (1179行目) | ○ |
| C-08 | type = PICTYPE_BITMAP | E-05 (1180行目) | ○ |
| C-09 | hPic = This.hBitmap | E-05 (1181行目) | ○ |
| C-10 | hPal = 0 | E-05 (1182行目) | ○ |
| C-11 | OleCreatePictureIndirectでIPicture生成 | E-05 (1185行目), E-06 | ○ |
| C-12 | GUID構造体で識別子管理 | E-02 | ○ |
| C-13 | hBitmapを内部状態として保持 | E-03 (404-405行目) | ○ |
| C-14 | 一時ファイルを介さない直接変換 | E-04, E-05（ファイル操作なし） | ○ |
| C-15 | PICTYPE_BITMAP = 1 | E-05 (1172行目) | ○ |
| C-16 | エラー時にErr.Raise | E-05 (1175, 1186行目) | ○ |
| C-17 | Imageコントロール対応 | E-04（汎用実装） | ○ |
| C-18 | CommandButton対応 | E-04（汎用実装） | ○ |
| C-19 | 目標出力時間100ms以下 | **根拠なし** | △ |
| C-20 | 全Pictureプロパティ対応コントロールで動作 | **根拠なし（テスト結果なし）** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件の実測値
  - 候補：性能テスト結果 / ベンチマーク
- 対応コントロールの網羅的テスト結果
  - 候補：テストケース / 動作確認結果

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - メソッド実装の記述（ソースコードで確認可能）
- 0: 低リスク - PICTDESC構造体の設定（ソースコードで確認可能）
- 0: 低リスク - 一時ファイル不使用（メモリ内処理のみ）
- 1: 中リスク - パフォーマンス要件（実測値なし）
- 1: 中リスク - コントロール互換性（網羅的テストなし）

## 6) レビュアーチェックリスト（最小）
- [ ] ToUIControlの引数（oControl）が正しく説明されているか確認
- [ ] IID_IDispatch GUIDの正確性を確認
- [ ] PICTYPE_BITMAP = 1の定義を確認
- [ ] 各種コントロール（Image, CommandButton等）での動作確認
- [ ] PictureSizeModeとの連携を確認
