---
generated_at: 2026-01-15 10:35:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-BMP画像ファイル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdImage.cls` 1070-1072行目 - BMP出力Case文
- E-02: `src/stdImage.cls` 1171-1187行目 - ToStdPictureメソッド
- E-03: `src/stdImage.cls` 305-311行目 - BITMAPFILEHEADER構造体
- E-04: `src/stdImage.cls` 313-325行目 - BITMAPINFOHEADER構造体
- E-05: `src/stdImage.cls` 139行目 - stdImgFormatBMP定義
- E-06: `src/stdImage.cls` 192行目 - OleCreatePictureIndirect宣言
- E-07: `src/stdImage.cls` 332-337行目 - PICTDESC構造体
- E-08: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 3行目 - 帳票定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ToFile()メソッドでBMP出力が可能 | E-01, E-05 | ○ |
| C-02 | SavePicture関数を使用して出力 | E-01 (1071行目) | ○ |
| C-03 | 拡張子.bmpで自動フォーマット判定 | E-01より推論(1014行目) | ○ |
| C-04 | ToStdPictureでIPictureに変換 | E-02 | ○ |
| C-05 | OleCreatePictureIndirectを使用 | E-02 (1185行目), E-06 | ○ |
| C-06 | PICTDESC構造体を使用 | E-02 (1177-1183行目), E-07 | ○ |
| C-07 | PICTYPE_BITMAP=1を使用 | E-02 (1172行目) | ○ |
| C-08 | BITMAPFILEHEADER構造体が定義 | E-03 | ○ |
| C-09 | BITMAPINFOHEADER構造体が定義 | E-04 | ○ |
| C-10 | bfType="BM"のファイルタイプ | E-03 (306行目) | ○ |
| C-11 | stdImgFormatBMPが定義されている | E-05 | ○ |
| C-12 | GDI+を使用しない（他フォーマットと異なる） | E-01 (Exit Sub直後) | ○ |
| C-13 | 帳票一覧に定義がある | E-08 | ○ |
| C-14 | hBitmapをPICTDESC.hPicに設定 | E-02 (1181行目) | ○ |
| C-15 | IID_IDispatch GUIDを使用 | E-02 (1173-1175行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全主張に根拠があり、コード実装と一致

## 6) レビュアーチェックリスト（最小）
- [ ] SavePicture関数の呼び出しが正しいことを確認
- [ ] ToStdPictureメソッドの戻り値が正しいことを確認
- [ ] OleCreatePictureIndirectのエラーハンドリングを確認
