---
generated_at: 2026-01-15 10:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-TIFF画像ファイル

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdImage.cls` 1053-1068行目 - TIFF出力Case文
- E-02: `src/stdImage.cls` 1054行目 - TIFFエンコーダGUID
- E-03: `src/stdImage.cls` 1060行目 - 圧縮パラメータGUID
- E-04: `src/stdImage.cls` 1066行目 - 色深度パラメータGUID
- E-05: `src/stdImage.cls` 354-359行目 - EncoderParameter構造体
- E-06: `src/stdImage.cls` 361-364行目 - EncoderParameters構造体
- E-07: `src/stdImage.cls` 1008行目 - TIFF_ColorDepth引数（デフォルト24）
- E-08: `src/stdImage.cls` 1008行目 - TIFF_Compression引数（デフォルト6）
- E-09: `src/stdImage.cls` 143行目 - stdImgFormatTIFF定義
- E-10: `src/stdImage.cls` 1017行目 - 拡張子判定(.tiff)
- E-11: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 6行目 - 帳票定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ToFile()メソッドでTIFF出力が可能 | E-01, E-09 | ○ |
| C-02 | GDI+エンコーディングを使用 | E-01 | ○ |
| C-03 | エンコーダGUIDは{557CF405-1A04-11D3-9A73-0000F81EF32E} | E-02 | ○ |
| C-04 | 圧縮パラメータGUIDは{E09D739D-CCD4-44EE-8EBA-3FBF8BE4FC58} | E-03 | ○ |
| C-05 | 色深度パラメータGUIDは{66087055-AD66-4C7C-9A18-38A2310B8337} | E-04 | ○ |
| C-06 | 拡張子.tiffで自動フォーマット判定 | E-10 | ○ |
| C-07 | デフォルト色深度は24 | E-07 | ○ |
| C-08 | デフォルト圧縮は6（JPEG） | E-08 | ○ |
| C-09 | EncoderParameter構造体を使用 | E-05 | ○ |
| C-10 | EncoderParameters構造体を使用 | E-06 | ○ |
| C-11 | tParams.count = 2を設定 | E-01 (1055行目) | ○ |
| C-12 | 2つのパラメータを配列で設定 | E-01 (1056行目) | ○ |
| C-13 | Parameter(1)で圧縮設定 | E-01 (1057-1062行目) | ○ |
| C-14 | Parameter(2)で色深度設定 | E-01 (1063-1068行目) | ○ |
| C-15 | stdImgFormatTIFFが定義されている | E-09 | ○ |
| C-16 | 帳票一覧に定義がある | E-11 | ○ |
| C-17 | VarPtr使用でポインタ参照 | E-01 (1061,1067行目) | ○ |
| C-18 | type = 4（Long型）を設定 | E-01 (1059,1065行目) | ○ |
| C-19 | NumberOfValues = 1を設定 | E-01 (1058,1064行目) | ○ |
| C-20 | パラメータ付きでGdipSaveImageToFile呼び出し | E-01より推論(1079行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全主張に根拠があり、コード実装と一致

## 6) レビュアーチェックリスト（最小）
- [ ] TIFFエンコーダGUIDが正しいことを確認
- [ ] 圧縮パラメータGUIDが正しいことを確認
- [ ] 色深度パラメータGUIDが正しいことを確認
- [ ] 圧縮値1-6の各オプションが正しく動作することを確認
- [ ] 複数パラメータの配列渡しが正しいことを確認
