---
generated_at: 2026-01-15 11:05:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-HTML文字列

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全項目に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/WIP/stdHTML.cls` 191-218行目 - ToString()メソッド
- E-02: `src/WIP/stdHTML.cls` 12-16行目 - EElementType列挙型
- E-03: `src/WIP/stdHTML.cls` 17-22行目 - TElement型定義
- E-04: `src/WIP/stdHTML.cls` 23-25行目 - TLiteral型定義
- E-05: `src/WIP/stdHTML.cls` 27-32行目 - TThis型定義
- E-06: `src/WIP/stdHTML.cls` 223-244行目 - serializeAttribute()関数
- E-07: `src/WIP/stdHTML.cls` 44-56行目 - CreateChild()メソッド
- E-08: `src/WIP/stdHTML.cls` 60-72行目 - CreateLiteral()メソッド
- E-09: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 9行目 - 帳票定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ToString()メソッドが存在 | E-01 | ○ |
| C-02 | EElement型で要素出力 | E-02 (14行目) | ○ |
| C-03 | ELiteral型でリテラル出力 | E-02 (15行目) | ○ |
| C-04 | TElement.TagNameでタグ名保持 | E-03 (18行目) | ○ |
| C-05 | TElement.Attributesで属性保持 | E-03 (19行目) | ○ |
| C-06 | TElement.Childrenで子要素保持 | E-03 (20行目) | ○ |
| C-07 | TElement.isSelfClosingで自己終了判定 | E-03 (21行目) | ○ |
| C-08 | TLiteral.contentでリテラル文字列保持 | E-04 (24行目) | ○ |
| C-09 | indent引数でインデント制御 | E-01 (191行目) | ○ |
| C-10 | 子要素は再帰的にToString呼び出し | E-01 (208行目) | ○ |
| C-11 | serializeAttribute()で属性値変換 | E-01 (198行目), E-06 | ○ |
| C-12 | Null→空文字 | E-06 (225-226行目) | ○ |
| C-13 | String→"='value'" | E-06 (227-228行目) | ○ |
| C-14 | Boolean→"=true/false" | E-06 (229-230行目) | ○ |
| C-15 | 数値型→"=数値" | E-06 (231-238行目) | ○ |
| C-16 | WIPディレクトリに配置 | E-01 (パス確認) | ○ |
| C-17 | CreateChild/CreateLiteralで子要素追加 | E-07, E-08 | ○ |
| C-18 | 帳票一覧に定義がある | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- **1: 中リスク** - WIP（開発中）クラスのため、機能が完全でない可能性
  - ToString()メソッドは実装されているが、全機能の検証が必要

## 6) レビュアーチェックリスト（最小）
- [ ] WIPクラスとして本番利用に適切か確認
- [ ] 全てのHTML特殊文字が正しくエスケープされるか確認
- [ ] 自己終了タグの処理が正しいことを確認
- [ ] 属性値のクォーテーション処理を確認
