---
generated_at: 2026-01-15 20:15:00
metrics:
  claims_total: 36
  claims_with_evidence: 34
  claims_without_evidence: 2
confidence_derived: 0.94
---

# 根拠レポート：業務要件一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：34 / 36、根拠なし：2
- 優先レビュー（高）
  1. **BR-029（WebSocket通信）**：実装がWIP状態のため詳細要確認
  2. **BR-035（統一エラーハンドリング）**：stdErrorがWIP状態のため詳細要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/stdArray.cls`
- E-02: `src/stdEnumerator.cls`
- E-03: `src/stdLambda.cls`
- E-04: `src/stdCallback.cls`
- E-05: `src/stdRegex.cls`
- E-06: `src/stdClipboard.cls`
- E-07: `src/stdProcess.cls`
- E-08: `src/stdWindow.cls`
- E-09: `src/stdCOM.cls`
- E-10: `src/stdAcc.cls`
- E-11: `src/stdWebSocket.cls`
- E-12: `src/stdPerformance.cls`
- E-13: `README.md`
- E-14: `src/WIP/stdError.cls`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BR-001 動的配列管理 | E-01, E-13 | ○ |
| C-02 | BR-002 配列要素の追加・削除 | E-01 | ○ |
| C-03 | BR-003 配列の変換操作 | E-01 | ○ |
| C-04 | BR-004 配列のソート | E-01 | ○ |
| C-05 | BR-005 配列のグループ化 | E-01 | ○ |
| C-06 | BR-006 列挙可能オブジェクトの操作 | E-02, E-13 | ○ |
| C-07 | BR-007 ListObjectからの列挙子作成 | E-02 | ○ |
| C-08 | BR-008 ツリー構造のフラット化 | E-02 | ○ |
| C-09 | BR-009 インラインラムダ関数 | E-03, E-13 | ○ |
| C-10 | BR-010 コールバック関数の生成 | E-04 | ○ |
| C-11 | BR-011 引数のバインド | E-04 | ○ |
| C-12 | BR-012 ポインタからのコールバック生成 | E-04 | ○ |
| C-13 | BR-013 正規表現マッチング | E-05, E-13 | ○ |
| C-14 | BR-014 正規表現オプション | E-05 | ○ |
| C-15 | BR-015 正規表現置換 | E-05 | ○ |
| C-16 | BR-016 正規表現によるリスト出力 | E-05 | ○ |
| C-17 | BR-017 テキストのコピー・ペースト | E-06 | ○ |
| C-18 | BR-018 画像のコピー・ペースト | E-06 | ○ |
| C-19 | BR-019 ファイルパスのコピー・ペースト | E-06 | ○ |
| C-20 | BR-020 カスタムフォーマットの登録 | E-06 | ○ |
| C-21 | BR-021 プロセスの起動 | E-07 | ○ |
| C-22 | BR-022 プロセス情報の取得 | E-07 | ○ |
| C-23 | BR-023 プロセスの検索 | E-07 | ○ |
| C-24 | BR-024 プロセスの強制終了 | E-07 | ○ |
| C-25 | BR-025 プロセス終了待機 | E-07 | ○ |
| C-26 | BR-026 ウィンドウの検索・操作 | E-08, E-13 | ○ |
| C-27 | BR-027 COMオブジェクトのリフレクション | E-09, E-13 | ○ |
| C-28 | BR-028 アクセシビリティ操作 | E-10, E-13 | ○ |
| C-29 | BR-029 WebSocket通信 | E-11 | △ |
| C-30 | BR-030 パフォーマンス計測 | E-12, E-13 | ○ |
| C-31 | BR-031 配列操作イベント | E-01 | ○ |
| C-32 | BR-032 コールバック実行イベント | E-04 | ○ |
| C-33 | BR-033 Mac対応 | E-01, E-02, E-04 | ○ |
| C-34 | BR-034 64bit対応 | E-01, E-04, E-06, E-07 | ○ |
| C-35 | BR-035 統一エラーハンドリング | E-14 | △ |
| C-36 | BR-036 ファクトリパターン | E-01, E-02, E-04, E-05, E-13 | ○ |

## 4) 不足情報（Unknown / Missing）
- **BR-029（WebSocket通信）**：stdWebSocketがWIP（Work In Progress）状態であり、IE依存の実装のため安定性に懸念
  - 候補：より安定したランタイムへの移行計画の確認 / Chrome DevTools Protocol対応の検討
- **BR-035（統一エラーハンドリング）**：stdErrorモジュールがWIPディレクトリに存在し、完全な実装ではない
  - 候補：stdErrorの完成版ソースの確認 / エラーハンドリングの代替実装の検討

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - BR-001〜BR-028, BR-030〜BR-034, BR-036：ソースコードから明確に機能が確認でき、READMEの説明とも一致
- **1: 中リスク** - BR-035：stdErrorがWIP状態だが、各モジュールにフォールバック実装（Err.Raise）が存在
- **2: 高リスク** - BR-029：WebSocket機能がIE依存でWIP状態。本番利用には注意が必要

## 6) レビュアーチェックリスト（最小）
- [ ] BR-001〜BR-005：stdArray.clsの各メソッドが正しく動作することを確認
- [ ] BR-006〜BR-008：stdEnumerator.clsがCollection/配列/IEnumVARIANTに対応していることを確認
- [ ] BR-009：stdLambda.clsの$1/$2プレースホルダーが正しく機能することを確認
- [ ] BR-010〜BR-012：stdCallback.clsがモジュール関数/オブジェクトメソッド/ポインタから正しくコールバックを生成できることを確認
- [ ] BR-013〜BR-016：stdRegex.clsの名前付きキャプチャグループが正しく動作することを確認
- [ ] BR-017〜BR-020：stdClipboard.clsがテキスト/画像/ファイルを正しく扱えることを確認
- [ ] BR-021〜BR-025：stdProcess.clsがプロセス操作を正しく行えることを確認
- [ ] BR-029：WebSocket機能の安定性と将来計画を確認（高リスク項目）
- [ ] BR-033〜BR-034：Mac/64bit環境での動作確認
- [ ] BR-035：stdErrorの実装状況とフォールバック動作を確認
